/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.AvailabilityStrategy;
import java.time.Duration;

public final class ThresholdBasedAvailabilityStrategy
extends AvailabilityStrategy {
    private static final Duration DEFAULT_THRESHOLD = Duration.ofMillis(500L);
    private static final Duration DEFAULT_THRESHOLD_STEP = Duration.ofMillis(100L);
    private final Duration threshold;
    private final Duration thresholdStep;

    public ThresholdBasedAvailabilityStrategy() {
        this.threshold = DEFAULT_THRESHOLD;
        this.thresholdStep = DEFAULT_THRESHOLD_STEP;
    }

    public ThresholdBasedAvailabilityStrategy(Duration threshold, Duration thresholdStep) {
        ThresholdBasedAvailabilityStrategy.validateDuration(threshold);
        ThresholdBasedAvailabilityStrategy.validateDuration(thresholdStep);
        this.threshold = threshold;
        this.thresholdStep = thresholdStep;
    }

    private static void validateDuration(Duration threshold) {
        if (threshold == null || threshold.isNegative()) {
            throw new IllegalArgumentException("threshold should be a non negative Duration");
        }
    }

    public Duration getThreshold() {
        return this.threshold;
    }

    public Duration getThresholdStep() {
        return this.thresholdStep;
    }
}

