/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.clienttelemetry;

import com.azure.core.util.Context;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosDiagnosticsContext;
import com.azure.cosmos.CosmosDiagnosticsHandler;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.clienttelemetry.ClientTelemetryMetrics;
import com.azure.cosmos.implementation.guava25.base.Preconditions;

public final class ClientMetricsDiagnosticsHandler
implements CosmosDiagnosticsHandler {
    private static final ImplementationBridgeHelpers.CosmosClientTelemetryConfigHelper.CosmosClientTelemetryConfigAccessor clientTelemetryConfigAccessor = ImplementationBridgeHelpers.CosmosClientTelemetryConfigHelper.getCosmosClientTelemetryConfigAccessor();
    private final CosmosAsyncClient client;

    public ClientMetricsDiagnosticsHandler(CosmosAsyncClient client) {
        Preconditions.checkNotNull(client, "Argument 'client' must not be null.");
        this.client = client;
    }

    @Override
    public void handleDiagnostics(CosmosDiagnosticsContext diagnosticsContext, Context traceContext) {
        Preconditions.checkNotNull(traceContext, "Argument 'traceContext' must not be null.");
        ClientTelemetryMetrics.recordOperation(this.client, diagnosticsContext);
    }
}

