/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdObjectMapper;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.guava25.collect.ImmutableList;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;

public final class RequestTimeline
implements Iterable<Event> {
    private static final RequestTimeline EMPTY = new RequestTimeline();
    private final ImmutableList<Event> events;

    private RequestTimeline() {
        this.events = ImmutableList.of();
    }

    private RequestTimeline(ImmutableList<Event> events) {
        Preconditions.checkNotNull(events, "expected non-null events");
        this.events = events;
    }

    public static RequestTimeline empty() {
        return EMPTY;
    }

    @Override
    public Iterator<Event> iterator() {
        return this.events.iterator();
    }

    public static RequestTimeline of() {
        return EMPTY;
    }

    public static RequestTimeline of(Event event) {
        return new RequestTimeline(ImmutableList.of(event));
    }

    public static RequestTimeline of(Event e1, Event e2) {
        return new RequestTimeline(ImmutableList.of(e1, e2));
    }

    public static RequestTimeline of(Event e1, Event e2, Event e3) {
        return new RequestTimeline(ImmutableList.of(e1, e2, e3));
    }

    public static RequestTimeline of(Event e1, Event e2, Event e3, Event e4) {
        return new RequestTimeline(ImmutableList.of(e1, e2, e3, e4));
    }

    public static RequestTimeline of(Event e1, Event e2, Event e3, Event e4, Event e5) {
        return new RequestTimeline(ImmutableList.of(e1, e2, e3, e4, e5));
    }

    public static RequestTimeline of(Event ... events) {
        return new RequestTimeline(ImmutableList.copyOf(events));
    }

    public String toString() {
        return RntbdObjectMapper.toString(this);
    }

    @JsonIgnore
    public Instant getRequestStartTimeUTC() {
        Event firstEvent = this.events.stream().findFirst().orElse(null);
        return firstEvent != null ? firstEvent.getStartTime() : null;
    }

    @JsonPropertyOrder(value={"name", "startTimeUTC", "durationInMilliSecs"})
    public static final class Event {
        @JsonIgnore
        private final Duration duration;
        @JsonProperty
        private final double durationInMilliSecs;
        @JsonProperty(value="eventName")
        private final String name;
        @JsonSerialize(using=ToStringSerializer.class)
        @JsonProperty(value="startTimeUTC")
        private final Instant startTime;

        public Event(String name, Instant from, Instant to) {
            Preconditions.checkNotNull(name, "expected non-null name");
            this.name = name;
            this.startTime = from;
            this.duration = from == null ? null : (to == null ? Duration.ZERO : Duration.between(from, to));
            this.durationInMilliSecs = this.duration != null ? (double)this.duration.toNanos() / 1000000.0 : 0.0;
        }

        public Duration getDuration() {
            return this.duration;
        }

        public String getName() {
            return this.name;
        }

        public Instant getStartTime() {
            return this.startTime;
        }
    }
}

