/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.batch;

import com.azure.cosmos.implementation.batch.PartitionBasedGoneNotifier;
import com.azure.cosmos.implementation.batch.ServerBatchRequest;
import com.azure.cosmos.implementation.batch.ServerOperationBatchRequest;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.CosmosItemOperation;
import java.util.List;

public final class PartitionKeyRangeServerBatchRequest
extends ServerBatchRequest {
    private final String partitionKeyRangeId;
    private PartitionBasedGoneNotifier partitionBasedGoneNotifier;

    private PartitionKeyRangeServerBatchRequest(String partitionKeyRangeId, int maxBodyLength, int maxOperationCount) {
        super(maxBodyLength, maxOperationCount);
        Preconditions.checkNotNull(partitionKeyRangeId, "expected non-null partitionKeyRangeId");
        this.partitionKeyRangeId = partitionKeyRangeId;
    }

    private PartitionKeyRangeServerBatchRequest(String partitionKeyRangeId, int maxBodyLength, int maxOperationCount, PartitionBasedGoneNotifier partitionBasedGoneNotifier) {
        super(maxBodyLength, maxOperationCount);
        Preconditions.checkNotNull(partitionKeyRangeId, "expected non-null partitionKeyRangeId");
        this.partitionKeyRangeId = partitionKeyRangeId;
        this.partitionBasedGoneNotifier = partitionBasedGoneNotifier;
    }

    static ServerOperationBatchRequest createBatchRequest(String partitionKeyRangeId, List<CosmosItemOperation> operations, int maxBodyLength, int maxOperationCount) {
        PartitionKeyRangeServerBatchRequest request = new PartitionKeyRangeServerBatchRequest(partitionKeyRangeId, maxBodyLength, maxOperationCount);
        request.setAtomicBatch(false);
        request.setShouldContinueOnError(true);
        List<CosmosItemOperation> pendingOperations = request.createBodyOfBatchRequest(operations);
        return new ServerOperationBatchRequest(request, pendingOperations);
    }

    static ServerOperationBatchRequest createBatchRequest(String partitionKeyRangeId, List<CosmosItemOperation> operations, int maxBodyLength, int maxOperationCount, PartitionBasedGoneNotifier partitionBasedGoneNotifier) {
        PartitionKeyRangeServerBatchRequest request = new PartitionKeyRangeServerBatchRequest(partitionKeyRangeId, maxBodyLength, maxOperationCount, partitionBasedGoneNotifier);
        request.setAtomicBatch(false);
        request.setShouldContinueOnError(true);
        List<CosmosItemOperation> pendingOperations = request.createBodyOfBatchRequest(operations);
        return new ServerOperationBatchRequest(request, pendingOperations);
    }

    public String getPartitionKeyRangeId() {
        return this.partitionKeyRangeId;
    }

    public PartitionBasedGoneNotifier getPartitionBasedGoneNotifier() {
        return this.partitionBasedGoneNotifier;
    }
}

