/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.batch;

import com.azure.cosmos.models.CosmosBulkOperationResponse;
import com.azure.cosmos.models.CosmosItemOperation;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

class StatusQueue<TContext> {
    private final Queue<CosmosItemOperation> queue = new ConcurrentLinkedQueue<CosmosItemOperation>();
    private Status status;
    private CosmosBulkOperationResponse<TContext> response;

    public void add(CosmosItemOperation cosmosItemOperation) {
        if (!this.queue.contains(cosmosItemOperation)) {
            this.queue.add(cosmosItemOperation);
        }
    }

    public boolean isInitialFailedItem(CosmosItemOperation operation) {
        return operation.equals(this.queue.peek());
    }

    public CosmosItemOperation poll() {
        return this.queue.poll();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public CosmosBulkOperationResponse<TContext> getResponse() {
        return this.response;
    }

    public void setResponse(CosmosBulkOperationResponse<TContext> response) {
        this.response = response;
    }

    public Queue<CosmosItemOperation> getQueue() {
        return this.queue;
    }

    static enum Status {
        Retry,
        PartitionBasedGone,
        NoRetry;

    }
}

