/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.http;

import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.http.HttpTimeoutPolicyControlPlaneHotPath;
import com.azure.cosmos.implementation.http.HttpTimeoutPolicyControlPlaneRead;
import com.azure.cosmos.implementation.http.HttpTimeoutPolicyDefault;
import com.azure.cosmos.implementation.http.ResponseTimeoutAndDelays;
import java.util.List;

public abstract class HttpTimeoutPolicy {
    public List<ResponseTimeoutAndDelays> timeoutAndDelaysList;

    public static final HttpTimeoutPolicy getTimeoutPolicy(RxDocumentServiceRequest request) {
        if (OperationType.QueryPlan.equals((Object)request.getOperationType()) || request.isAddressRefresh() || request.getResourceType() == ResourceType.PartitionKeyRange) {
            return HttpTimeoutPolicyControlPlaneHotPath.INSTANCE;
        }
        if (OperationType.Read.equals((Object)request.getOperationType()) && request.getResourceType() == ResourceType.DatabaseAccount) {
            return HttpTimeoutPolicyControlPlaneRead.INSTANCE;
        }
        return HttpTimeoutPolicyDefault.INSTANCE;
    }

    public int totalRetryCount() {
        return this.timeoutAndDelaysList.size();
    }

    public List<ResponseTimeoutAndDelays> getTimeoutAndDelaysList() {
        return this.timeoutAndDelaysList;
    }
}

