/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.Trigger;
import com.azure.cosmos.models.TriggerOperation;
import com.azure.cosmos.models.TriggerType;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;

public final class CosmosTriggerProperties {
    private Trigger trigger;

    CosmosTriggerProperties() {
        this.trigger = new Trigger();
    }

    public CosmosTriggerProperties(String id, String body) {
        this.trigger = new Trigger();
        this.trigger.setId(id);
        this.trigger.setBody(body);
    }

    CosmosTriggerProperties(String jsonString) {
        this.trigger = new Trigger(jsonString);
    }

    public CosmosTriggerProperties setId(String id) {
        this.trigger.setId(id);
        return this;
    }

    public String getBody() {
        return this.trigger.getBody();
    }

    public CosmosTriggerProperties setBody(String body) {
        this.trigger.setBody(body);
        return this;
    }

    public TriggerType getTriggerType() {
        return this.trigger.getTriggerType();
    }

    public CosmosTriggerProperties setTriggerType(TriggerType triggerType) {
        this.trigger.setTriggerType(triggerType);
        return this;
    }

    public TriggerOperation getTriggerOperation() {
        return this.trigger.getTriggerOperation();
    }

    public CosmosTriggerProperties setTriggerOperation(TriggerOperation triggerOperation) {
        this.trigger.setTriggerOperation(triggerOperation);
        return this;
    }

    Resource getResource() {
        return this.trigger;
    }

    public String getId() {
        return this.trigger.getId();
    }

    String getResourceId() {
        return this.trigger.getResourceId();
    }

    public Instant getTimestamp() {
        return this.trigger.getTimestamp();
    }

    public String getETag() {
        return this.trigger.getETag();
    }

    static List<CosmosTriggerProperties> getFromV2Results(List<Trigger> results) {
        return results.stream().map(trigger -> new CosmosTriggerProperties(trigger.toJson())).collect(Collectors.toList());
    }
}

