/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.ConnectionMode;
import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.DiagnosticsInstantSerializer;
import com.azure.cosmos.implementation.MetadataDiagnosticsContext;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.RequestTimeline;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RetryContext;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.SerializationDiagnosticsContext;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.cpu.CpuMonitor;
import com.azure.cosmos.implementation.directconnectivity.DirectBridgeInternal;
import com.azure.cosmos.implementation.directconnectivity.StoreResponse;
import com.azure.cosmos.implementation.directconnectivity.StoreResult;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=ClientSideRequestStatisticsSerializer.class)
class ClientSideRequestStatistics {
    private static final int MAX_SUPPLEMENTAL_REQUESTS_FOR_TO_STRING = 10;
    private static final DateTimeFormatter RESPONSE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd MMM yyyy HH:mm:ss.SSS").withLocale(Locale.US);
    private ConnectionMode connectionMode;
    private List<StoreResponseStatistics> responseStatisticsList;
    private List<StoreResponseStatistics> supplementalResponseStatisticsList;
    private Map<String, AddressResolutionStatistics> addressResolutionStatistics;
    private List<URI> contactedReplicas;
    private Set<URI> failedReplicas;
    private Instant requestStartTimeUTC = Instant.now();
    private Instant requestEndTimeUTC = Instant.now();
    private Set<URI> regionsContacted;
    private RetryContext retryContext;
    private GatewayStatistics gatewayStatistics;
    private RequestTimeline transportRequestTimeline;
    private MetadataDiagnosticsContext metadataDiagnosticsContext;
    private SerializationDiagnosticsContext serializationDiagnosticsContext;

    ClientSideRequestStatistics() {
        this.responseStatisticsList = new ArrayList<StoreResponseStatistics>();
        this.supplementalResponseStatisticsList = new ArrayList<StoreResponseStatistics>();
        this.addressResolutionStatistics = new HashMap<String, AddressResolutionStatistics>();
        this.contactedReplicas = Collections.synchronizedList(new ArrayList());
        this.failedReplicas = Collections.synchronizedSet(new HashSet());
        this.regionsContacted = Collections.synchronizedSet(new HashSet());
        this.connectionMode = ConnectionMode.DIRECT;
        this.metadataDiagnosticsContext = new MetadataDiagnosticsContext();
        this.serializationDiagnosticsContext = new SerializationDiagnosticsContext();
    }

    Duration getDuration() {
        return Duration.between(this.requestStartTimeUTC, this.requestEndTimeUTC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordResponse(RxDocumentServiceRequest request, StoreResult storeResult) {
        Objects.requireNonNull(request, "request is required and cannot be null.");
        Instant responseTime = Instant.now();
        this.connectionMode = ConnectionMode.DIRECT;
        StoreResponseStatistics storeResponseStatistics = new StoreResponseStatistics();
        storeResponseStatistics.requestResponseTimeUTC = responseTime;
        storeResponseStatistics.storeResult = storeResult;
        storeResponseStatistics.requestOperationType = request.getOperationType();
        storeResponseStatistics.requestResourceType = request.getResourceType();
        URI locationEndPoint = null;
        if (request.requestContext != null) {
            this.retryContext = new RetryContext(request.requestContext.retryContext);
            if (request.requestContext.locationEndpointToRoute != null) {
                locationEndPoint = request.requestContext.locationEndpointToRoute;
            }
        }
        ClientSideRequestStatistics clientSideRequestStatistics = this;
        synchronized (clientSideRequestStatistics) {
            if (responseTime.isAfter(this.requestEndTimeUTC)) {
                this.requestEndTimeUTC = responseTime;
            }
            if (locationEndPoint != null) {
                this.regionsContacted.add(locationEndPoint);
            }
            if (storeResponseStatistics.requestOperationType == OperationType.Head || storeResponseStatistics.requestOperationType == OperationType.HeadFeed) {
                this.supplementalResponseStatisticsList.add(storeResponseStatistics);
            } else {
                this.responseStatisticsList.add(storeResponseStatistics);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordGatewayResponse(RxDocumentServiceRequest rxDocumentServiceRequest, StoreResponse storeResponse, CosmosException exception) {
        Instant responseTime = Instant.now();
        this.connectionMode = ConnectionMode.GATEWAY;
        ClientSideRequestStatistics clientSideRequestStatistics = this;
        synchronized (clientSideRequestStatistics) {
            if (responseTime.isAfter(this.requestEndTimeUTC)) {
                this.requestEndTimeUTC = responseTime;
            }
            if (rxDocumentServiceRequest != null && rxDocumentServiceRequest.requestContext != null && rxDocumentServiceRequest.requestContext.retryContext != null) {
                rxDocumentServiceRequest.requestContext.retryContext.retryEndTime = Instant.now();
                this.retryContext = new RetryContext(rxDocumentServiceRequest.requestContext.retryContext);
            }
            this.gatewayStatistics = new GatewayStatistics();
            if (rxDocumentServiceRequest != null) {
                this.gatewayStatistics.operationType = rxDocumentServiceRequest.getOperationType();
            }
            if (storeResponse != null) {
                this.gatewayStatistics.statusCode = storeResponse.getStatus();
                this.gatewayStatistics.subStatusCode = DirectBridgeInternal.getSubStatusCode(storeResponse);
                this.gatewayStatistics.sessionToken = storeResponse.getHeaderValue("x-ms-session-token");
                this.gatewayStatistics.requestCharge = storeResponse.getHeaderValue("x-ms-request-charge");
                this.gatewayStatistics.requestTimeline = DirectBridgeInternal.getRequestTimeline(storeResponse);
            } else if (exception != null) {
                this.gatewayStatistics.statusCode = exception.getStatusCode();
                this.gatewayStatistics.subStatusCode = exception.getSubStatusCode();
                this.gatewayStatistics.requestTimeline = this.transportRequestTimeline;
            }
        }
    }

    void setTransportClientRequestTimeline(RequestTimeline transportRequestTimeline) {
        this.transportRequestTimeline = transportRequestTimeline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String recordAddressResolutionStart(URI targetEndpoint) {
        String identifier = Utils.randomUUID().toString();
        AddressResolutionStatistics resolutionStatistics = new AddressResolutionStatistics();
        resolutionStatistics.startTimeUTC = Instant.now();
        resolutionStatistics.endTimeUTC = null;
        resolutionStatistics.targetEndpoint = targetEndpoint == null ? "<NULL>" : targetEndpoint.toString();
        ClientSideRequestStatistics clientSideRequestStatistics = this;
        synchronized (clientSideRequestStatistics) {
            this.addressResolutionStatistics.put(identifier, resolutionStatistics);
        }
        return identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordAddressResolutionEnd(String identifier, String errorMessage) {
        if (StringUtils.isEmpty(identifier)) {
            return;
        }
        Instant responseTime = Instant.now();
        ClientSideRequestStatistics clientSideRequestStatistics = this;
        synchronized (clientSideRequestStatistics) {
            if (!this.addressResolutionStatistics.containsKey(identifier)) {
                throw new IllegalArgumentException("Identifier " + identifier + " does not exist. Please call start before calling end");
            }
            if (responseTime.isAfter(this.requestEndTimeUTC)) {
                this.requestEndTimeUTC = responseTime;
            }
            AddressResolutionStatistics resolutionStatistics = this.addressResolutionStatistics.get(identifier);
            resolutionStatistics.endTimeUTC = responseTime;
            resolutionStatistics.errorMessage = errorMessage;
            resolutionStatistics.inflightRequest = false;
        }
    }

    List<URI> getContactedReplicas() {
        return this.contactedReplicas;
    }

    void setContactedReplicas(List<URI> contactedReplicas) {
        this.contactedReplicas = Collections.synchronizedList(contactedReplicas);
    }

    Set<URI> getFailedReplicas() {
        return this.failedReplicas;
    }

    void setFailedReplicas(Set<URI> failedReplicas) {
        this.failedReplicas = Collections.synchronizedSet(failedReplicas);
    }

    Set<URI> getRegionsContacted() {
        return this.regionsContacted;
    }

    void setRegionsContacted(Set<URI> regionsContacted) {
        this.regionsContacted = Collections.synchronizedSet(regionsContacted);
    }

    MetadataDiagnosticsContext getMetadataDiagnosticsContext() {
        return this.metadataDiagnosticsContext;
    }

    SerializationDiagnosticsContext getSerializationDiagnosticsContext() {
        return this.serializationDiagnosticsContext;
    }

    void recordRetryContext(RxDocumentServiceRequest request) {
        if (request.requestContext.retryContext != null) {
            request.requestContext.retryContext.retryEndTime = Instant.now();
            this.retryContext = new RetryContext(request.requestContext.retryContext);
        }
    }

    private static class GatewayStatistics {
        String sessionToken;
        OperationType operationType;
        int statusCode;
        int subStatusCode;
        String requestCharge;
        RequestTimeline requestTimeline;

        private GatewayStatistics() {
        }

        public String getSessionToken() {
            return this.sessionToken;
        }

        public OperationType getOperationType() {
            return this.operationType;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public int getSubStatusCode() {
            return this.subStatusCode;
        }

        public String getRequestCharge() {
            return this.requestCharge;
        }

        public RequestTimeline getRequestTimeline() {
            return this.requestTimeline;
        }
    }

    private static class AddressResolutionStatistics {
        @JsonSerialize(using=DiagnosticsInstantSerializer.class)
        Instant startTimeUTC;
        @JsonSerialize(using=DiagnosticsInstantSerializer.class)
        Instant endTimeUTC;
        @JsonSerialize
        String targetEndpoint;
        @JsonSerialize
        String errorMessage;
        @JsonSerialize
        boolean inflightRequest = true;

        private AddressResolutionStatistics() {
        }
    }

    public static class ClientSideRequestStatisticsSerializer
    extends StdSerializer<ClientSideRequestStatistics> {
        private static final long serialVersionUID = -2746532297176812860L;

        ClientSideRequestStatisticsSerializer() {
            super(ClientSideRequestStatistics.class);
        }

        public void serialize(ClientSideRequestStatistics statistics, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            long requestLatency = statistics.getDuration().toMillis();
            generator.writeStringField("userAgent", CosmosDiagnostics.USER_AGENT);
            generator.writeNumberField("requestLatencyInMs", requestLatency);
            generator.writeStringField("requestStartTimeUTC", DiagnosticsInstantSerializer.formatDateTime(statistics.requestStartTimeUTC));
            generator.writeStringField("requestEndTimeUTC", DiagnosticsInstantSerializer.formatDateTime(statistics.requestEndTimeUTC));
            generator.writeObjectField("connectionMode", (Object)statistics.connectionMode);
            generator.writeObjectField("responseStatisticsList", (Object)statistics.responseStatisticsList);
            int supplementalResponseStatisticsListCount = statistics.supplementalResponseStatisticsList.size();
            int initialIndex = Math.max(supplementalResponseStatisticsListCount - 10, 0);
            if (initialIndex != 0) {
                List subList = statistics.supplementalResponseStatisticsList.subList(initialIndex, supplementalResponseStatisticsListCount);
                generator.writeObjectField("supplementalResponseStatisticsList", subList);
            } else {
                generator.writeObjectField("supplementalResponseStatisticsList", (Object)statistics.supplementalResponseStatisticsList);
            }
            generator.writeObjectField("addressResolutionStatistics", (Object)statistics.addressResolutionStatistics);
            generator.writeObjectField("regionsContacted", (Object)statistics.regionsContacted);
            generator.writeObjectField("retryContext", (Object)statistics.retryContext);
            generator.writeObjectField("metadataDiagnosticsContext", (Object)statistics.getMetadataDiagnosticsContext());
            generator.writeObjectField("serializationDiagnosticsContext", (Object)statistics.getSerializationDiagnosticsContext());
            generator.writeObjectField("gatewayStatistics", (Object)statistics.gatewayStatistics);
            try {
                SystemInformation systemInformation = new SystemInformation();
                long totalMemory = Runtime.getRuntime().totalMemory() / 1024L;
                long freeMemory = Runtime.getRuntime().freeMemory() / 1024L;
                long maxMemory = Runtime.getRuntime().maxMemory() / 1024L;
                systemInformation.usedMemory = totalMemory - freeMemory + " KB";
                systemInformation.availableMemory = maxMemory - (totalMemory - freeMemory) + " KB";
                systemInformation.systemCpuLoad = CpuMonitor.getCpuLoad().toString();
                generator.writeObjectField("systemInformation", (Object)systemInformation);
            }
            catch (Exception exception) {
                // empty catch block
            }
            generator.writeEndObject();
        }
    }

    private static class SystemInformation {
        String usedMemory;
        String availableMemory;
        String systemCpuLoad;

        private SystemInformation() {
        }

        public String getUsedMemory() {
            return this.usedMemory;
        }

        public String getAvailableMemory() {
            return this.availableMemory;
        }

        public String getSystemCpuLoad() {
            return this.systemCpuLoad;
        }
    }

    static class StoreResponseStatistics {
        @JsonSerialize(using=StoreResult.StoreResultSerializer.class)
        StoreResult storeResult;
        @JsonSerialize(using=DiagnosticsInstantSerializer.class)
        Instant requestResponseTimeUTC;
        @JsonSerialize
        ResourceType requestResourceType;
        @JsonSerialize
        OperationType requestOperationType;

        StoreResponseStatistics() {
        }
    }
}

