/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.caches;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.InvalidPartitionException;
import com.azure.cosmos.implementation.MetadataDiagnosticsContext;
import com.azure.cosmos.implementation.NotFoundException;
import com.azure.cosmos.implementation.PathsHelper;
import com.azure.cosmos.implementation.ResourceId;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.caches.AsyncCache;
import com.azure.cosmos.implementation.caches.IEqualityComparer;
import com.azure.cosmos.implementation.routing.PartitionKeyRangeIdentity;
import com.azure.cosmos.models.ModelBridgeInternal;
import java.util.Map;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public abstract class RxCollectionCache {
    private final AsyncCache<String, DocumentCollection> collectionInfoByNameCache = new AsyncCache(new CollectionRidComparer());
    private final AsyncCache<String, DocumentCollection> collectionInfoByIdCache = new AsyncCache(new CollectionRidComparer());

    protected RxCollectionCache() {
    }

    public Mono<Utils.ValueHolder<DocumentCollection>> resolveCollectionAsync(MetadataDiagnosticsContext metaDataDiagnosticsContext, RxDocumentServiceRequest request) {
        Mono init = null;
        if (request.getIsNameBased()) {
            if (request.isForceNameCacheRefresh()) {
                Mono<Void> mono = this.refreshAsync(metaDataDiagnosticsContext, request);
                init = mono.then(Mono.fromRunnable(() -> request.setForceNameCacheRefresh(false)));
            }
            Mono collectionInfoObs = this.resolveByPartitionKeyRangeIdentityAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), request.getPartitionKeyRangeIdentity(), request.properties);
            if (init != null) {
                collectionInfoObs = init.then(collectionInfoObs);
            }
            return collectionInfoObs.flatMap(collectionValueHolder -> {
                if (collectionValueHolder.v != null) {
                    return Mono.just((Object)collectionValueHolder);
                }
                if (request.requestContext.resolvedCollectionRid == null) {
                    Mono<DocumentCollection> collectionInfoRes = this.resolveByNameAsync(metaDataDiagnosticsContext, request.getResourceAddress(), request.properties);
                    return collectionInfoRes.flatMap(collection -> {
                        request.setResourceId(collection.getResourceId());
                        request.requestContext.resolvedCollectionRid = collection.getResourceId();
                        return Mono.just(new Utils.ValueHolder<DocumentCollection>((DocumentCollection)collection));
                    });
                }
                return this.resolveByRidAsync(metaDataDiagnosticsContext, request.requestContext.resolvedCollectionRid, request.properties);
            });
        }
        return this.resolveByPartitionKeyRangeIdentityAsync(metaDataDiagnosticsContext, request.getPartitionKeyRangeIdentity(), request.properties).flatMap(collectionValueHolder -> {
            if (collectionValueHolder.v != null) {
                return Mono.just((Object)collectionValueHolder);
            }
            return this.resolveByRidAsync(metaDataDiagnosticsContext, request.getResourceAddress(), request.properties);
        });
    }

    public void refresh(MetadataDiagnosticsContext metaDataDiagnosticsContext, String resourceAddress, Map<String, Object> properties) {
        if (PathsHelper.isNameBased(resourceAddress)) {
            String resourceFullName = PathsHelper.getCollectionPath(resourceAddress);
            this.collectionInfoByNameCache.refresh(resourceFullName, () -> {
                Mono<DocumentCollection> collectionObs = this.getByNameAsync(metaDataDiagnosticsContext, resourceFullName, properties);
                return collectionObs.doOnSuccess(collection -> this.collectionInfoByIdCache.set(collection.getResourceId(), (DocumentCollection)collection));
            });
        }
    }

    protected abstract Mono<DocumentCollection> getByRidAsync(MetadataDiagnosticsContext var1, String var2, Map<String, Object> var3);

    protected abstract Mono<DocumentCollection> getByNameAsync(MetadataDiagnosticsContext var1, String var2, Map<String, Object> var3);

    private Mono<Utils.ValueHolder<DocumentCollection>> resolveByPartitionKeyRangeIdentityAsync(MetadataDiagnosticsContext metaDataDiagnosticsContext, PartitionKeyRangeIdentity partitionKeyRangeIdentity, Map<String, Object> properties) {
        if (partitionKeyRangeIdentity != null && partitionKeyRangeIdentity.getCollectionRid() != null) {
            return this.resolveByRidAsync(metaDataDiagnosticsContext, partitionKeyRangeIdentity.getCollectionRid(), properties).onErrorResume(e -> {
                Throwable unwrappedException = Exceptions.unwrap((Throwable)e);
                if (unwrappedException instanceof NotFoundException) {
                    return Mono.error((Throwable)((Object)new InvalidPartitionException("The specified document collection is invalid.")));
                }
                return Mono.error((Throwable)unwrappedException);
            });
        }
        return Mono.just(new Utils.ValueHolder<Object>(null));
    }

    private Mono<Utils.ValueHolder<DocumentCollection>> resolveByRidAsync(MetadataDiagnosticsContext metaDataDiagnosticsContext, String resourceId, Map<String, Object> properties) {
        ResourceId resourceIdParsed = ResourceId.parse(resourceId);
        String collectionResourceId = resourceIdParsed.getDocumentCollectionId().toString();
        Mono<Object> async = this.collectionInfoByIdCache.getAsync(collectionResourceId, null, () -> this.getByRidAsync(metaDataDiagnosticsContext, collectionResourceId, properties));
        return async.map(Utils.ValueHolder::new);
    }

    private Mono<DocumentCollection> resolveByNameAsync(MetadataDiagnosticsContext metaDataDiagnosticsContext, String resourceAddress, Map<String, Object> properties) {
        String resourceFullName = PathsHelper.getCollectionPath(resourceAddress);
        return this.collectionInfoByNameCache.getAsync(resourceFullName, null, () -> {
            Mono<DocumentCollection> collectionObs = this.getByNameAsync(metaDataDiagnosticsContext, resourceFullName, properties);
            return collectionObs.doOnSuccess(collection -> this.collectionInfoByIdCache.set(collection.getResourceId(), (DocumentCollection)collection));
        });
    }

    private Mono<Void> refreshAsync(MetadataDiagnosticsContext metaDataDiagnosticsContext, RxDocumentServiceRequest request) {
        Mono mono;
        String resourceFullName = PathsHelper.getCollectionPath(request.getResourceAddress());
        if (request.requestContext.resolvedCollectionRid != null) {
            DocumentCollection obsoleteValue = new DocumentCollection();
            ModelBridgeInternal.setResourceId(obsoleteValue, request.requestContext.resolvedCollectionRid);
            mono = this.collectionInfoByNameCache.getAsync(resourceFullName, obsoleteValue, () -> {
                Mono<DocumentCollection> collectionObs = this.getByNameAsync(metaDataDiagnosticsContext, resourceFullName, request.properties);
                return collectionObs.doOnSuccess(collection -> this.collectionInfoByIdCache.set(collection.getResourceId(), (DocumentCollection)collection));
            }).then();
        } else {
            mono = Mono.fromRunnable(() -> this.refresh(metaDataDiagnosticsContext, request.getResourceAddress(), request.properties));
        }
        return mono.doOnSuccess(aVoid -> {
            request.requestContext.resolvedCollectionRid = null;
        });
    }

    private static class CollectionRidComparer
    implements IEqualityComparer<DocumentCollection> {
        private CollectionRidComparer() {
        }

        @Override
        public boolean areEqual(DocumentCollection left, DocumentCollection right) {
            if (left == null && right == null) {
                return true;
            }
            if (left == null ^ right == null) {
                return false;
            }
            return StringUtils.equals(left.getResourceId(), right.getResourceId());
        }
    }
}

