/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.core.exception.AzureException;
import com.azure.cosmos.implementation.apachecommons.lang.exception.ExceptionUtils;
import java.io.File;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public final class RntbdReporter {
    private static final String codeSource;

    private RntbdReporter() {
    }

    public static void reportIssue(Logger logger, Object subject, String format, Object ... arguments) {
        if (logger.isErrorEnabled()) {
            RntbdReporter.doReportIssue(logger, subject, format, arguments);
        }
    }

    public static void reportIssueUnless(Logger logger, boolean predicate, Object subject, String format, Object ... arguments) {
        if (!predicate && logger.isErrorEnabled()) {
            RntbdReporter.doReportIssue(logger, subject, format, arguments);
        }
    }

    private static void doReportIssue(Logger logger, Object subject, String format, Object[] arguments) {
        FormattingTuple formattingTuple = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
        Throwable throwable = formattingTuple.getThrowable();
        AzureException exception = new AzureException(null, throwable);
        StackTraceElement[] stackTrace = exception.getStackTrace();
        logger.error("Report this {} issue to ensure it is addressed:\n[{}]\n[{}]\n[{}{}]", new Object[]{codeSource, subject, stackTrace[2], formattingTuple.getMessage(), ExceptionUtils.getStackTrace(throwable != null ? throwable : exception)});
    }

    static {
        String value;
        try {
            URL url = RntbdReporter.class.getProtectionDomain().getCodeSource().getLocation();
            File file = new File(url.toURI());
            value = file.getName();
        }
        catch (Throwable error) {
            value = "azure-cosmos";
        }
        codeSource = value;
    }
}

