/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.Exceptions;
import com.azure.cosmos.implementation.IRetryPolicy;
import com.azure.cosmos.implementation.RetryContext;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.ShouldRetryResult;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.time.StopWatch;
import com.azure.cosmos.implementation.directconnectivity.WebExceptionUtility;
import com.azure.cosmos.implementation.http.HttpTimeoutPolicy;
import com.azure.cosmos.implementation.http.HttpTimeoutPolicyDefault;
import com.azure.cosmos.implementation.http.ResponseTimeoutAndDelays;
import java.net.URI;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class WebExceptionRetryPolicy
implements IRetryPolicy {
    private static final Logger logger = LoggerFactory.getLogger(WebExceptionRetryPolicy.class);
    private StopWatch durationTimer = new StopWatch();
    private RetryContext retryContext;
    private int retryDelay;
    private RxDocumentServiceRequest request;
    private HttpTimeoutPolicy timeoutPolicy;
    private boolean isReadRequest;
    private int retryCount = 0;
    private URI locationEndpoint;
    private boolean isOutOfRetries;

    public WebExceptionRetryPolicy() {
        this.durationTimer.start();
    }

    public WebExceptionRetryPolicy(RetryContext retryContext) {
        this.durationTimer.start();
        this.retryContext = retryContext;
        this.timeoutPolicy = HttpTimeoutPolicyDefault.INSTANCE;
    }

    @Override
    public Mono<ShouldRetryResult> shouldRetry(Exception e) {
        if (this.isOutOfRetries) {
            this.durationTimer.stop();
            return Mono.just((Object)ShouldRetryResult.noRetry());
        }
        CosmosException webException = Utils.as(e, CosmosException.class);
        if (WebExceptionUtility.isNetworkFailure(e) && this.isReadRequest && webException != null && WebExceptionUtility.isReadTimeoutException((Exception)((Object)webException)) && Exceptions.isSubStatusCode(webException, 10002)) {
            if (this.request.isAddressRefresh()) {
                return this.shouldRetryAddressRefresh();
            }
            return Mono.just((Object)ShouldRetryResult.retryAfter(Duration.ofSeconds(this.retryDelay)));
        }
        if (!WebExceptionUtility.isWebExceptionRetriable(e)) {
            this.durationTimer.stop();
            return Mono.just((Object)ShouldRetryResult.noRetryOnNonRelatedException());
        }
        logger.warn("Received retriable web exception, will retry", (Throwable)e);
        return Mono.just((Object)ShouldRetryResult.retryAfter(Duration.ofSeconds(this.retryDelay)));
    }

    @Override
    public RetryContext getRetryContext() {
        return this.retryContext;
    }

    public void onBeforeSendRequest(RxDocumentServiceRequest request) {
        this.request = request;
        this.isReadRequest = request.isReadOnlyRequest();
        this.timeoutPolicy = HttpTimeoutPolicy.getTimeoutPolicy(request);
        this.isOutOfRetries = this.isOutOfRetries();
        if (!this.isOutOfRetries) {
            ResponseTimeoutAndDelays current = this.timeoutPolicy.getTimeoutAndDelaysList().get(this.retryCount);
            this.request.setResponseTimeout(current.getResponseTimeout());
            this.retryDelay = current.getDelayForNextRequestInSeconds();
        }
        ++this.retryCount;
        this.locationEndpoint = request.requestContext.locationEndpointToRoute;
    }

    private boolean isOutOfRetries() {
        return this.retryCount >= this.timeoutPolicy.totalRetryCount();
    }

    private Mono<ShouldRetryResult> shouldRetryAddressRefresh() {
        if (this.isOutOfRetries) {
            logger.warn("shouldRetryAddressRefresh() No more retrying on endpoint {}, operationType = {}, count = {}, isAddressRefresh = {}", new Object[]{this.locationEndpoint, this.request.getOperationType(), this.retryCount, this.request.isAddressRefresh()});
            return Mono.just((Object)ShouldRetryResult.noRetry());
        }
        logger.warn("shouldRetryAddressRefresh() Retrying on endpoint {}, operationType = {}, count = {}, isAddressRefresh = {}, shouldForcedAddressRefresh = {}, shouldForceCollectionRoutingMapRefresh = {}", new Object[]{this.locationEndpoint, this.request.getOperationType(), this.retryCount, this.request.isAddressRefresh(), this.request.shouldForceAddressRefresh(), this.request.forceCollectionRoutingMapRefresh});
        return Mono.just((Object)ShouldRetryResult.retryAfter(Duration.ofSeconds(this.retryDelay)));
    }
}

