/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.epkversion;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.ChangeFeedProcessor;
import com.azure.cosmos.ChangeFeedProcessorContext;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosBridgeInternal;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.changefeed.Bootstrapper;
import com.azure.cosmos.implementation.changefeed.ChangeFeedContextClient;
import com.azure.cosmos.implementation.changefeed.ChangeFeedObserverFactory;
import com.azure.cosmos.implementation.changefeed.CheckpointFrequency;
import com.azure.cosmos.implementation.changefeed.HealthMonitor;
import com.azure.cosmos.implementation.changefeed.LeaseStoreManager;
import com.azure.cosmos.implementation.changefeed.PartitionLoadBalancingStrategy;
import com.azure.cosmos.implementation.changefeed.PartitionManager;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedContextClientImpl;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedMode;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedState;
import com.azure.cosmos.implementation.changefeed.common.CheckpointerObserverFactory;
import com.azure.cosmos.implementation.changefeed.common.DefaultObserverFactory;
import com.azure.cosmos.implementation.changefeed.common.EqualPartitionsBalancingStrategy;
import com.azure.cosmos.implementation.changefeed.common.PartitionedByIdCollectionRequestOptionsFactory;
import com.azure.cosmos.implementation.changefeed.common.TraceHealthMonitor;
import com.azure.cosmos.implementation.changefeed.epkversion.BootstrapperImpl;
import com.azure.cosmos.implementation.changefeed.epkversion.HealthMonitoringPartitionControllerDecorator;
import com.azure.cosmos.implementation.changefeed.epkversion.LeaseStoreManagerImpl;
import com.azure.cosmos.implementation.changefeed.epkversion.PartitionControllerImpl;
import com.azure.cosmos.implementation.changefeed.epkversion.PartitionLoadBalancerImpl;
import com.azure.cosmos.implementation.changefeed.epkversion.PartitionManagerImpl;
import com.azure.cosmos.implementation.changefeed.epkversion.PartitionProcessorFactoryImpl;
import com.azure.cosmos.implementation.changefeed.epkversion.PartitionSupervisorFactoryImpl;
import com.azure.cosmos.implementation.changefeed.epkversion.PartitionSynchronizerImpl;
import com.azure.cosmos.implementation.changefeed.epkversion.PkRangeIdVersionLeaseStoreBootstrapperImpl;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.ChangeFeedProcessorItem;
import com.azure.cosmos.models.ChangeFeedProcessorOptions;
import com.azure.cosmos.models.ChangeFeedProcessorState;
import com.azure.cosmos.models.CosmosChangeFeedRequestOptions;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.FeedRange;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public abstract class ChangeFeedProcessorImplBase<T>
implements ChangeFeedProcessor,
AutoCloseable {
    private final Logger logger = LoggerFactory.getLogger(ChangeFeedProcessorImplBase.class);
    private final Duration sleepTime = Duration.ofSeconds(15L);
    private final Duration lockTime = Duration.ofSeconds(30L);
    private static final int DEFAULT_QUERY_PARTITIONS_MAX_BATCH_SIZE = 100;
    private static final int DEFAULT_DEGREE_OF_PARALLELISM = 25;
    private final String hostName;
    private final ChangeFeedContextClient feedContextClient;
    private final ChangeFeedContextClient leaseContextClient;
    private final ChangeFeedProcessorOptions changeFeedProcessorOptions;
    private final ChangeFeedObserverFactory<T> observerFactory;
    private final ChangeFeedMode changeFeedMode;
    private final Scheduler scheduler;
    private volatile String databaseResourceId;
    private volatile String databaseId;
    private volatile String collectionResourceId;
    private volatile String collectionId;
    private PartitionLoadBalancingStrategy loadBalancingStrategy;
    private LeaseStoreManager leaseStoreManager;
    private HealthMonitor healthMonitor;
    private volatile PartitionManager partitionManager;

    public ChangeFeedProcessorImplBase(String hostName, CosmosAsyncContainer feedContainer, CosmosAsyncContainer leaseContainer, ChangeFeedProcessorOptions changeFeedProcessorOptions, Consumer<List<T>> consumer, ChangeFeedMode changeFeedMode) {
        Preconditions.checkNotNull(hostName, "Argument 'hostName' can not be null");
        Preconditions.checkNotNull(feedContainer, "Argument 'feedContainer' can not be null");
        Preconditions.checkNotNull(consumer, "Argument 'consumer' can not be null");
        if (changeFeedProcessorOptions == null) {
            changeFeedProcessorOptions = new ChangeFeedProcessorOptions();
        }
        this.validateChangeFeedProcessorOptions(changeFeedProcessorOptions);
        this.validateLeaseContainer(leaseContainer);
        this.hostName = hostName;
        this.changeFeedProcessorOptions = changeFeedProcessorOptions;
        this.feedContextClient = new ChangeFeedContextClientImpl(feedContainer);
        this.leaseContextClient = new ChangeFeedContextClientImpl(leaseContainer);
        this.scheduler = this.changeFeedProcessorOptions.getScheduler();
        this.feedContextClient.setScheduler(this.scheduler);
        this.leaseContextClient.setScheduler(this.scheduler);
        this.changeFeedMode = changeFeedMode;
        this.observerFactory = new DefaultObserverFactory<T>(consumer);
    }

    public ChangeFeedProcessorImplBase(String hostName, CosmosAsyncContainer feedContainer, CosmosAsyncContainer leaseContainer, ChangeFeedProcessorOptions changeFeedProcessorOptions, BiConsumer<List<T>, ChangeFeedProcessorContext> biConsumer, ChangeFeedMode changeFeedMode) {
        Preconditions.checkNotNull(hostName, "Argument 'hostName' can not be null");
        Preconditions.checkNotNull(feedContainer, "Argument 'feedContainer' can not be null");
        Preconditions.checkNotNull(biConsumer, "Argument 'biConsumer' can not be null");
        if (changeFeedProcessorOptions == null) {
            changeFeedProcessorOptions = new ChangeFeedProcessorOptions();
        }
        this.validateChangeFeedProcessorOptions(changeFeedProcessorOptions);
        this.validateLeaseContainer(leaseContainer);
        this.hostName = hostName;
        this.changeFeedProcessorOptions = changeFeedProcessorOptions;
        this.feedContextClient = new ChangeFeedContextClientImpl(feedContainer);
        this.leaseContextClient = new ChangeFeedContextClientImpl(leaseContainer);
        this.scheduler = this.changeFeedProcessorOptions.getScheduler();
        this.feedContextClient.setScheduler(this.scheduler);
        this.leaseContextClient.setScheduler(this.scheduler);
        this.changeFeedMode = changeFeedMode;
        this.observerFactory = new DefaultObserverFactory<T>(biConsumer);
    }

    abstract CosmosChangeFeedRequestOptions createRequestOptionsForProcessingFromNow(FeedRange var1);

    private void validateChangeFeedProcessorOptions(ChangeFeedProcessorOptions changeFeedProcessorOptions) {
        Preconditions.checkNotNull(changeFeedProcessorOptions, "Argument 'changeFeedProcessorOptions' can not be null");
        if (changeFeedProcessorOptions.getLeaseAcquireInterval().compareTo(ChangeFeedProcessorOptions.DEFAULT_ACQUIRE_INTERVAL) < 0) {
            this.logger.warn("Found lower than expected setting for leaseAcquireInterval");
        }
    }

    private void validateLeaseContainer(CosmosAsyncContainer leaseContainer) {
        Preconditions.checkNotNull(leaseContainer, "Argument 'leaseContainer' can not be null");
        if (!CosmosBridgeInternal.getContextClient(leaseContainer).isContentResponseOnWriteEnabled()) {
            throw new IllegalArgumentException("leaseClient: content response on write setting must be enabled");
        }
        ConsistencyLevel consistencyLevel = CosmosBridgeInternal.getContextClient(leaseContainer).getConsistencyLevel();
        if (consistencyLevel == ConsistencyLevel.CONSISTENT_PREFIX || consistencyLevel == ConsistencyLevel.EVENTUAL) {
            this.logger.warn("leaseClient consistency level setting are less then expected which is SESSION");
        }
    }

    @Override
    public Mono<Void> start() {
        if (this.partitionManager == null) {
            return this.initializeCollectionPropertiesForBuild().flatMap(value -> this.getLeaseStoreManager().flatMap(this::buildPartitionManager)).flatMap(partitionManager1 -> {
                this.partitionManager = partitionManager1;
                return this.partitionManager.start();
            });
        }
        return this.partitionManager.start();
    }

    @Override
    public Mono<Void> stop() {
        if (this.partitionManager == null || !this.partitionManager.isRunning()) {
            throw new IllegalStateException("The ChangeFeedProcessor instance has not fully started");
        }
        return this.partitionManager.stop();
    }

    @Override
    public boolean isStarted() {
        return this.partitionManager != null && this.partitionManager.isRunning();
    }

    @Override
    public Mono<Map<String, Integer>> getEstimatedLag() {
        throw new UnsupportedOperationException("getEstimatedLag() API is not supported. Use getCurrentState() instead");
    }

    @Override
    public Mono<List<ChangeFeedProcessorState>> getCurrentState() {
        if (this.leaseContextClient == null || this.feedContextClient == null) {
            return Mono.just(Collections.unmodifiableList(new ArrayList()));
        }
        return this.initializeCollectionPropertiesForBuild().flatMap(value -> this.getLeaseStoreManager()).flatMap(leaseStoreManager1 -> leaseStoreManager1.getAllLeases().flatMap(lease -> {
            CosmosChangeFeedRequestOptions options = this.createRequestOptionsForProcessingFromNow(lease.getFeedRange());
            return this.feedContextClient.createDocumentChangeFeedQuery(this.feedContextClient.getContainerClient(), options, ChangeFeedProcessorItem.class).take(1L).map(feedResponse -> {
                ChangeFeedProcessorState changeFeedProcessorState = new ChangeFeedProcessorState().setHostName(lease.getOwner()).setLeaseToken(lease.getLeaseToken());
                long estimatedLag = 0L;
                try {
                    long latestLsn = this.getLsnFromEncodedContinuationToken(feedResponse.getContinuationToken());
                    changeFeedProcessorState.setContinuationToken(feedResponse.getContinuationToken());
                    if (Strings.isNullOrWhiteSpace(lease.getContinuationToken())) {
                        estimatedLag = latestLsn - 1L;
                    } else {
                        long currentLsn = this.getLsnFromEncodedContinuationToken(lease.getContinuationToken());
                        estimatedLag = latestLsn - currentLsn;
                    }
                }
                catch (NumberFormatException ex) {
                    this.logger.warn("Unexpected Cosmos LSN found", (Throwable)ex);
                    changeFeedProcessorState.setEstimatedLag(-1);
                }
                changeFeedProcessorState.setEstimatedLag((int)Math.min(estimatedLag, Integer.MAX_VALUE));
                return changeFeedProcessorState;
            });
        }).collectList().map(Collections::unmodifiableList));
    }

    private long getLsnFromEncodedContinuationToken(String continuationToken) {
        ChangeFeedState changeFeedState = ChangeFeedState.fromString(continuationToken);
        String token = changeFeedState.getContinuation().getCurrentContinuationToken().getToken();
        token = token.replace("\"", "");
        long lsn = Long.parseLong(token);
        return lsn;
    }

    private Mono<ChangeFeedProcessor> initializeCollectionPropertiesForBuild() {
        return this.feedContextClient.readDatabase(this.feedContextClient.getDatabaseClient(), null).map(databaseResourceResponse -> {
            this.databaseResourceId = databaseResourceResponse.getProperties().getResourceId();
            this.databaseId = databaseResourceResponse.getProperties().getId();
            return this.databaseResourceId;
        }).flatMap(id -> this.feedContextClient.readContainer(this.feedContextClient.getContainerClient(), null).map(documentCollectionResourceResponse -> {
            this.collectionResourceId = documentCollectionResourceResponse.getProperties().getResourceId();
            this.collectionId = documentCollectionResourceResponse.getProperties().getId();
            return this;
        }));
    }

    private Mono<LeaseStoreManager> getLeaseStoreManager() {
        if (this.leaseStoreManager == null) {
            return this.leaseContextClient.readContainerSettings(this.leaseContextClient.getContainerClient(), null).flatMap(collectionSettings -> {
                if (!this.isContainerPartitionedById((CosmosContainerProperties)collectionSettings)) {
                    return Mono.error((Throwable)new IllegalArgumentException("The lease collection must have partition key equal to id."));
                }
                PartitionedByIdCollectionRequestOptionsFactory requestOptionsFactory = new PartitionedByIdCollectionRequestOptionsFactory();
                String leasePrefix = this.getLeasePrefix();
                this.leaseStoreManager = LeaseStoreManagerImpl.builder().leasePrefix(leasePrefix).leaseCollectionLink(this.leaseContextClient.getContainerClient()).leaseContextClient(this.leaseContextClient).requestOptionsFactory(requestOptionsFactory).hostName(this.hostName).build();
                return Mono.just((Object)this.leaseStoreManager);
            });
        }
        return Mono.just((Object)this.leaseStoreManager);
    }

    private boolean isContainerPartitionedById(CosmosContainerProperties containerProperties) {
        return containerProperties != null && containerProperties.getPartitionKeyDefinition() != null && !containerProperties.getPartitionKeyDefinition().getPaths().isEmpty() && containerProperties.getPartitionKeyDefinition().getPaths().size() == 1 && containerProperties.getPartitionKeyDefinition().getPaths().get(0).equals("/id");
    }

    private String getLeasePrefix() {
        String optionsPrefix = this.changeFeedProcessorOptions.getLeasePrefix();
        if (optionsPrefix == null) {
            optionsPrefix = "";
        }
        URI uri = this.feedContextClient.getServiceEndpoint();
        return String.format("%s%s_%s_%s", optionsPrefix, uri.getHost(), this.databaseResourceId, this.collectionResourceId);
    }

    private String getPkRangeIdVersionLeasePrefix() {
        String optionsPrefix = this.changeFeedProcessorOptions.getLeasePrefix();
        if (optionsPrefix == null) {
            optionsPrefix = "";
        }
        URI uri = this.feedContextClient.getServiceEndpoint();
        return String.format("%s%s_%s_%s", optionsPrefix, uri.getHost(), this.databaseId, this.collectionId);
    }

    abstract Class<T> getPartitionProcessorItemType();

    abstract boolean canBootstrapFromPkRangeIdVersionLeaseStore();

    private Mono<PartitionManager> buildPartitionManager(LeaseStoreManager leaseStoreManager) {
        Bootstrapper bootstrapper;
        CheckpointerObserverFactory<T> factory = new CheckpointerObserverFactory<T>(this.observerFactory, new CheckpointFrequency());
        PartitionSynchronizerImpl synchronizer = new PartitionSynchronizerImpl(this.feedContextClient, BridgeInternal.extractContainerSelfLink(this.feedContextClient.getContainerClient()), leaseStoreManager, leaseStoreManager, 25, 100, this.changeFeedProcessorOptions, this.changeFeedMode);
        if (this.canBootstrapFromPkRangeIdVersionLeaseStore()) {
            String pkRangeIdVersionLeasePrefix = this.getPkRangeIdVersionLeasePrefix();
            PartitionedByIdCollectionRequestOptionsFactory requestOptionsFactory = new PartitionedByIdCollectionRequestOptionsFactory();
            LeaseStoreManager pkRangeIdVersionLeaseStoreManager = com.azure.cosmos.implementation.changefeed.pkversion.LeaseStoreManagerImpl.builder().leasePrefix(pkRangeIdVersionLeasePrefix).leaseCollectionLink(this.leaseContextClient.getContainerClient()).leaseContextClient(this.leaseContextClient).requestOptionsFactory(requestOptionsFactory).hostName(this.hostName).build();
            bootstrapper = new PkRangeIdVersionLeaseStoreBootstrapperImpl(synchronizer, leaseStoreManager, this.lockTime, this.sleepTime, pkRangeIdVersionLeaseStoreManager);
        } else {
            bootstrapper = new BootstrapperImpl(synchronizer, leaseStoreManager, this.lockTime, this.sleepTime);
        }
        PartitionSupervisorFactoryImpl<T> partitionSupervisorFactory = new PartitionSupervisorFactoryImpl<T>(factory, leaseStoreManager, new PartitionProcessorFactoryImpl(this.feedContextClient, this.changeFeedProcessorOptions, leaseStoreManager, this.feedContextClient.getContainerClient(), this.collectionResourceId, this.changeFeedMode), this.changeFeedProcessorOptions, this.scheduler, this.getPartitionProcessorItemType());
        if (this.loadBalancingStrategy == null) {
            this.loadBalancingStrategy = new EqualPartitionsBalancingStrategy(this.hostName, this.changeFeedProcessorOptions.getMinScaleCount(), this.changeFeedProcessorOptions.getMaxScaleCount(), this.changeFeedProcessorOptions.getLeaseExpirationInterval());
        }
        PartitionControllerImpl partitionController = new PartitionControllerImpl(leaseStoreManager, leaseStoreManager, partitionSupervisorFactory, synchronizer, this.scheduler);
        if (this.healthMonitor == null) {
            this.healthMonitor = new TraceHealthMonitor();
        }
        HealthMonitoringPartitionControllerDecorator partitionController2 = new HealthMonitoringPartitionControllerDecorator(partitionController, this.healthMonitor);
        PartitionLoadBalancerImpl partitionLoadBalancer = new PartitionLoadBalancerImpl(partitionController2, leaseStoreManager, this.loadBalancingStrategy, this.changeFeedProcessorOptions.getLeaseAcquireInterval(), this.scheduler);
        PartitionManagerImpl partitionManager = new PartitionManagerImpl(bootstrapper, partitionController, partitionLoadBalancer);
        return Mono.just((Object)partitionManager);
    }

    @Override
    public void close() {
        this.stop().subscribeOn(Schedulers.boundedElastic()).subscribe();
    }
}

