/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosRegionSwitchHint;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import java.time.Duration;

public final class SessionRetryOptions {
    private final CosmosRegionSwitchHint regionSwitchHint;
    private final Duration minInRegionRetryTime;
    private final int maxInRegionRetryCount;

    SessionRetryOptions(CosmosRegionSwitchHint regionSwitchHint, Duration minInRegionRetryTime, int maxInRegionRetryCount) {
        this.regionSwitchHint = regionSwitchHint;
        this.minInRegionRetryTime = minInRegionRetryTime;
        this.maxInRegionRetryCount = maxInRegionRetryCount;
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosSessionRetryOptionsHelper.setCosmosSessionRetryOptionsAccessor(new ImplementationBridgeHelpers.CosmosSessionRetryOptionsHelper.CosmosSessionRetryOptionsAccessor(){

            @Override
            public CosmosRegionSwitchHint getRegionSwitchHint(SessionRetryOptions sessionRetryOptions) {
                return sessionRetryOptions.regionSwitchHint;
            }

            @Override
            public Duration getMinInRegionRetryTime(SessionRetryOptions sessionRetryOptions) {
                return sessionRetryOptions.minInRegionRetryTime;
            }

            @Override
            public int getMaxInRegionRetryCount(SessionRetryOptions sessionRetryOptions) {
                return sessionRetryOptions.maxInRegionRetryCount;
            }
        });
    }

    static {
        SessionRetryOptions.initialize();
    }
}

