/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.apachecommons.collections.list.UnmodifiableList;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.spark.OperationContextAndListenerTuple;
import com.azure.cosmos.models.CosmosBulkExecutionThresholdsState;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CosmosBulkExecutionOptions {
    private int initialMicroBatchSize = 100;
    private int maxMicroBatchConcurrency = 1;
    private int maxMicroBatchSize = 100;
    private double maxMicroBatchRetryRate = 0.2;
    private double minMicroBatchRetryRate = 0.1;
    private int maxMicroBatchPayloadSizeInBytes = 220201;
    private Duration maxMicroBatchInterval = Duration.ofMillis(1000L);
    private final Object legacyBatchScopedContext;
    private final CosmosBulkExecutionThresholdsState thresholds;
    private Integer maxConcurrentCosmosPartitions = null;
    private OperationContextAndListenerTuple operationContextAndListenerTuple;
    private Map<String, String> customOptions;
    private String throughputControlGroupName;
    private List<String> excludeRegions;

    CosmosBulkExecutionOptions(Object legacyBatchScopedContext, CosmosBulkExecutionThresholdsState thresholdsState, Map<String, String> customOptions) {
        this.legacyBatchScopedContext = legacyBatchScopedContext;
        this.thresholds = thresholdsState == null ? new CosmosBulkExecutionThresholdsState() : thresholdsState;
        this.customOptions = customOptions == null ? new HashMap<String, String>() : customOptions;
    }

    public CosmosBulkExecutionOptions(CosmosBulkExecutionThresholdsState thresholdsState) {
        this(null, thresholdsState, null);
    }

    public CosmosBulkExecutionOptions() {
        this(null, null, null);
    }

    public int getInitialMicroBatchSize() {
        return this.initialMicroBatchSize;
    }

    public CosmosBulkExecutionOptions setInitialMicroBatchSize(int initialMicroBatchSize) {
        Preconditions.checkArgument(initialMicroBatchSize > 0, "The argument 'initialMicroBatchSize' must be a positive integer.");
        this.initialMicroBatchSize = initialMicroBatchSize;
        return this;
    }

    int getMaxMicroBatchPayloadSizeInBytes() {
        return this.maxMicroBatchPayloadSizeInBytes;
    }

    CosmosBulkExecutionOptions setMaxMicroBatchPayloadSizeInBytes(int maxMicroBatchPayloadSizeInBytes) {
        this.maxMicroBatchPayloadSizeInBytes = maxMicroBatchPayloadSizeInBytes;
        return this;
    }

    int getMaxMicroBatchSize() {
        return this.maxMicroBatchSize;
    }

    CosmosBulkExecutionOptions setMaxMicroBatchSize(int maxMicroBatchSize) {
        this.maxMicroBatchSize = maxMicroBatchSize;
        return this;
    }

    Integer getMaxConcurrentCosmosPartitions() {
        return this.maxConcurrentCosmosPartitions;
    }

    CosmosBulkExecutionOptions setMaxConcurrentCosmosPartitions(int maxConcurrentCosmosPartitions) {
        this.maxConcurrentCosmosPartitions = maxConcurrentCosmosPartitions;
        return this;
    }

    public int getMaxMicroBatchConcurrency() {
        return this.maxMicroBatchConcurrency;
    }

    public CosmosBulkExecutionOptions setMaxMicroBatchConcurrency(int maxMicroBatchConcurrency) {
        Preconditions.checkArgument(maxMicroBatchConcurrency >= 1 && maxMicroBatchConcurrency <= 5, "maxMicroBatchConcurrency should be between [1, 5]");
        this.maxMicroBatchConcurrency = maxMicroBatchConcurrency;
        return this;
    }

    Duration getMaxMicroBatchInterval() {
        return this.maxMicroBatchInterval;
    }

    double getMaxTargetedMicroBatchRetryRate() {
        return this.maxMicroBatchRetryRate;
    }

    CosmosBulkExecutionOptions setTargetedMicroBatchRetryRate(double minRetryRate, double maxRetryRate) {
        if (minRetryRate < 0.0) {
            throw new IllegalArgumentException("The maxRetryRate must not be a negative value");
        }
        if (minRetryRate > maxRetryRate) {
            throw new IllegalArgumentException("The minRetryRate must not exceed the maxRetryRate");
        }
        this.maxMicroBatchRetryRate = maxRetryRate;
        this.minMicroBatchRetryRate = minRetryRate;
        return this;
    }

    double getMinTargetedMicroBatchRetryRate() {
        return this.minMicroBatchRetryRate;
    }

    Object getLegacyBatchScopedContext() {
        return this.legacyBatchScopedContext;
    }

    public CosmosBulkExecutionThresholdsState getThresholdsState() {
        return this.thresholds;
    }

    OperationContextAndListenerTuple getOperationContextAndListenerTuple() {
        return this.operationContextAndListenerTuple;
    }

    void setOperationContextAndListenerTuple(OperationContextAndListenerTuple operationContextAndListenerTuple) {
        this.operationContextAndListenerTuple = operationContextAndListenerTuple;
    }

    CosmosBulkExecutionOptions setHeader(String name, String value) {
        if (this.customOptions == null) {
            this.customOptions = new HashMap<String, String>();
        }
        this.customOptions.put(name, value);
        return this;
    }

    Map<String, String> getHeaders() {
        return this.customOptions;
    }

    public String getThroughputControlGroupName() {
        return this.throughputControlGroupName;
    }

    public CosmosBulkExecutionOptions setThroughputControlGroupName(String throughputControlGroupName) {
        this.throughputControlGroupName = throughputControlGroupName;
        return this;
    }

    public CosmosBulkExecutionOptions setExcludedRegions(List<String> excludeRegions) {
        this.excludeRegions = excludeRegions;
        return this;
    }

    public List<String> getExcludedRegions() {
        if (this.excludeRegions == null) {
            return null;
        }
        return UnmodifiableList.unmodifiableList(this.excludeRegions);
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosBulkExecutionOptionsHelper.setCosmosBulkExecutionOptionsAccessor(new ImplementationBridgeHelpers.CosmosBulkExecutionOptionsHelper.CosmosBulkExecutionOptionsAccessor(){

            @Override
            public void setOperationContext(CosmosBulkExecutionOptions options, OperationContextAndListenerTuple operationContextAndListenerTuple) {
                options.setOperationContextAndListenerTuple(operationContextAndListenerTuple);
            }

            @Override
            public OperationContextAndListenerTuple getOperationContext(CosmosBulkExecutionOptions options) {
                return options.getOperationContextAndListenerTuple();
            }

            @Override
            public <T> T getLegacyBatchScopedContext(CosmosBulkExecutionOptions options) {
                return (T)options.getLegacyBatchScopedContext();
            }

            @Override
            public double getMinTargetedMicroBatchRetryRate(CosmosBulkExecutionOptions options) {
                return options.getMinTargetedMicroBatchRetryRate();
            }

            @Override
            public double getMaxTargetedMicroBatchRetryRate(CosmosBulkExecutionOptions options) {
                return options.getMaxTargetedMicroBatchRetryRate();
            }

            @Override
            public int getMaxMicroBatchPayloadSizeInBytes(CosmosBulkExecutionOptions options) {
                return options.getMaxMicroBatchPayloadSizeInBytes();
            }

            @Override
            public CosmosBulkExecutionOptions setMaxMicroBatchPayloadSizeInBytes(CosmosBulkExecutionOptions options, int maxMicroBatchPayloadSizeInBytes) {
                return options.setMaxMicroBatchPayloadSizeInBytes(maxMicroBatchPayloadSizeInBytes);
            }

            @Override
            public int getMaxMicroBatchConcurrency(CosmosBulkExecutionOptions options) {
                return options.getMaxMicroBatchConcurrency();
            }

            @Override
            public Integer getMaxConcurrentCosmosPartitions(CosmosBulkExecutionOptions options) {
                return options.getMaxConcurrentCosmosPartitions();
            }

            @Override
            public CosmosBulkExecutionOptions setMaxConcurrentCosmosPartitions(CosmosBulkExecutionOptions options, int maxConcurrentCosmosPartitions) {
                return options.setMaxConcurrentCosmosPartitions(maxConcurrentCosmosPartitions);
            }

            @Override
            public Duration getMaxMicroBatchInterval(CosmosBulkExecutionOptions options) {
                return options.getMaxMicroBatchInterval();
            }

            @Override
            public CosmosBulkExecutionOptions setTargetedMicroBatchRetryRate(CosmosBulkExecutionOptions options, double minRetryRate, double maxRetryRate) {
                return options.setTargetedMicroBatchRetryRate(minRetryRate, maxRetryRate);
            }

            @Override
            public CosmosBulkExecutionOptions setHeader(CosmosBulkExecutionOptions cosmosBulkExecutionOptions, String name, String value) {
                return cosmosBulkExecutionOptions.setHeader(name, value);
            }

            @Override
            public Map<String, String> getHeader(CosmosBulkExecutionOptions cosmosBulkExecutionOptions) {
                return cosmosBulkExecutionOptions.getHeaders();
            }

            @Override
            public Map<String, String> getCustomOptions(CosmosBulkExecutionOptions cosmosBulkExecutionOptions) {
                return cosmosBulkExecutionOptions.customOptions;
            }

            @Override
            public List<String> getExcludeRegions(CosmosBulkExecutionOptions cosmosBulkExecutionOptions) {
                return cosmosBulkExecutionOptions.excludeRegions;
            }

            @Override
            public int getMaxMicroBatchSize(CosmosBulkExecutionOptions cosmosBulkExecutionOptions) {
                if (cosmosBulkExecutionOptions == null) {
                    return 100;
                }
                return cosmosBulkExecutionOptions.getMaxMicroBatchSize();
            }

            @Override
            public void setMaxMicroBatchSize(CosmosBulkExecutionOptions cosmosBulkExecutionOptions, int maxMicroBatchSize) {
                cosmosBulkExecutionOptions.setMaxMicroBatchSize(maxMicroBatchSize);
            }
        });
    }

    static {
        CosmosBulkExecutionOptions.initialize();
    }
}

