/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.epkversion.feedRangeGoneHandler;

import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.changefeed.Lease;
import com.azure.cosmos.implementation.changefeed.LeaseManager;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedState;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedStateV1;
import com.azure.cosmos.implementation.changefeed.epkversion.feedRangeGoneHandler.FeedRangeGoneHandler;
import com.azure.cosmos.implementation.feedranges.FeedRangeContinuation;
import com.azure.cosmos.implementation.feedranges.FeedRangeEpkImpl;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.routing.Range;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class FeedRangeGoneSplitHandler
implements FeedRangeGoneHandler {
    private static final Logger logger = LoggerFactory.getLogger(FeedRangeGoneSplitHandler.class);
    private final Lease lease;
    private final List<PartitionKeyRange> overlappingRanges;
    private final LeaseManager leaseManager;
    private final boolean removeCurrentLease;
    private final boolean shouldSkipDirectLeaseAssignment;

    public FeedRangeGoneSplitHandler(Lease lease, List<PartitionKeyRange> overlappingRanges, LeaseManager leaseManager, int maxScaleCount) {
        Preconditions.checkNotNull(lease, "Argument 'lease' can not be null");
        Preconditions.checkNotNull(overlappingRanges, "Argument 'overlappingRanges' can not be null");
        Preconditions.checkNotNull(leaseManager, "Argument 'leaseManager' can not be null");
        this.lease = lease;
        this.overlappingRanges = overlappingRanges;
        this.leaseManager = leaseManager;
        this.removeCurrentLease = true;
        this.shouldSkipDirectLeaseAssignment = maxScaleCount > 0;
    }

    @Override
    public Flux<Lease> handlePartitionGone() {
        FeedRangeEpkImpl splitRange = (FeedRangeEpkImpl)this.lease.getFeedRange();
        AtomicReference<String> min = new AtomicReference<String>(splitRange.getRange().getMin());
        AtomicReference<String> max = new AtomicReference<String>(splitRange.getRange().getMax());
        ArrayList leaseTokens = new ArrayList();
        return Flux.just(this.overlappingRanges).flatMapIterable(pkRanges -> {
            ArrayList<FeedRangeEpkImpl> epkRanges = new ArrayList<FeedRangeEpkImpl>();
            for (int i = 0; i < pkRanges.size() - 1; ++i) {
                Range<String> range = ((PartitionKeyRange)pkRanges.get(i)).toRange();
                epkRanges.add(new FeedRangeEpkImpl(new Range<String>((String)min.get(), range.getMax(), true, false)));
                min.set(((PartitionKeyRange)pkRanges.get(i)).getMaxExclusive());
            }
            epkRanges.add(new FeedRangeEpkImpl(new Range<String>((String)min.get(), (String)max.get(), true, false)));
            return epkRanges;
        }).flatMap(newEpkRange -> {
            String effectiveChildLeaseContinuationToken = this.getEffectiveChildLeaseContinuationToken((FeedRangeEpkImpl)newEpkRange, this.lease.getContinuationToken());
            return this.leaseManager.createLeaseIfNotExist((FeedRangeEpkImpl)newEpkRange, effectiveChildLeaseContinuationToken).map(newLease -> {
                leaseTokens.add(newLease.getLeaseToken());
                return newLease;
            });
        }).doOnComplete(() -> logger.info("Lease with token {} split into {}", (Object)this.lease.getLeaseToken(), (Object)StringUtils.join(leaseTokens, ",")));
    }

    private String getEffectiveChildLeaseContinuationToken(FeedRangeEpkImpl childLeaseFeedRange, String parentLeaseCT) {
        String childLeaseCT = parentLeaseCT;
        if (StringUtils.isNotEmpty(parentLeaseCT)) {
            ChangeFeedState changeFeedState = ChangeFeedStateV1.fromString(parentLeaseCT);
            FeedRangeContinuation effectiveFeedRangeContinuation = FeedRangeContinuation.create(changeFeedState.getContainerRid(), (FeedRangeInternal)childLeaseFeedRange, childLeaseFeedRange.getRange());
            effectiveFeedRangeContinuation.replaceContinuation(changeFeedState.getContinuation().getCurrentContinuationToken().getToken());
            changeFeedState.setContinuation(effectiveFeedRangeContinuation);
            childLeaseCT = changeFeedState.toString();
        }
        return childLeaseCT;
    }

    @Override
    public boolean shouldDeleteCurrentLease() {
        return this.removeCurrentLease;
    }

    @Override
    public boolean shouldSkipDirectLeaseAssignment() {
        return this.shouldSkipDirectLeaseAssignment;
    }
}

