/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query.orderbyquery;

import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.query.orderbyquery.ComparisonFilters;

public class ComparisonWithDefinedFilters
implements ComparisonFilters {
    private final String expression;
    private final String orderByItemToString;

    public ComparisonWithDefinedFilters(String expression, String orderByItemToString) {
        Preconditions.checkArgument(StringUtils.isNotEmpty(expression), "Expression can not be null or empty");
        Preconditions.checkArgument(StringUtils.isNotEmpty(orderByItemToString), "orderByItemToString can not be null or empty");
        this.expression = expression;
        this.orderByItemToString = orderByItemToString;
    }

    @Override
    public String lessThan() {
        return this.getFilterString("<");
    }

    @Override
    public String lessThanOrEqualTo() {
        return this.getFilterString("<=");
    }

    @Override
    public String equalTo() {
        return this.getFilterString("=");
    }

    @Override
    public String greaterThan() {
        return this.getFilterString(">");
    }

    @Override
    public String greaterThanOrEqualTo() {
        return this.getFilterString(">=");
    }

    private String getFilterString(String operator) {
        return String.format("%s %s %s", this.expression, operator, this.orderByItemToString);
    }
}

