/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.Trigger;
import com.azure.cosmos.models.CosmosTriggerProperties;
import com.azure.cosmos.models.CosmosTriggerResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import reactor.core.publisher.Mono;

public class CosmosAsyncTrigger {
    private final CosmosAsyncContainer container;
    private String id;

    CosmosAsyncTrigger(String id, CosmosAsyncContainer container) {
        this.id = id;
        this.container = container;
    }

    public String getId() {
        return this.id;
    }

    CosmosAsyncTrigger setId(String id) {
        this.id = id;
        return this;
    }

    public Mono<CosmosTriggerResponse> read() {
        return FluxUtil.withContext(this::readInternal);
    }

    public Mono<CosmosTriggerResponse> replace(CosmosTriggerProperties triggerProperties) {
        return FluxUtil.withContext(context -> this.replaceInternal(triggerProperties, (Context)context));
    }

    public Mono<CosmosTriggerResponse> delete() {
        return FluxUtil.withContext(this::deleteInternal);
    }

    String getURIPathSegment() {
        return "triggers";
    }

    String getParentLink() {
        return this.container.getLink();
    }

    String getLink() {
        return this.getParentLink() + "/" + this.getURIPathSegment() + "/" + this.getId();
    }

    private Mono<CosmosTriggerResponse> readInternal(Context context) {
        String spanName = "readTrigger." + this.container.getId();
        Mono responseMono = this.container.getDatabase().getDocClientWrapper().readTrigger(this.getLink(), null).map(ModelBridgeInternal::createCosmosTriggerResponse).single();
        CosmosAsyncClient client = this.container.getDatabase().getClient();
        return client.getDiagnosticsProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.container.getDatabase().getId(), this.container.getId(), client, null, OperationType.Read, ResourceType.Trigger, null);
    }

    private Mono<CosmosTriggerResponse> replaceInternal(CosmosTriggerProperties triggerSettings, Context context) {
        String spanName = "replaceTrigger." + this.container.getId();
        Mono responseMono = this.container.getDatabase().getDocClientWrapper().replaceTrigger(new Trigger(ModelBridgeInternal.toJsonFromJsonSerializable(ModelBridgeInternal.getResource(triggerSettings))), null).map(ModelBridgeInternal::createCosmosTriggerResponse).single();
        CosmosAsyncClient client = this.container.getDatabase().getClient();
        return client.getDiagnosticsProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.container.getDatabase().getId(), this.container.getId(), client, null, OperationType.Replace, ResourceType.Trigger, null);
    }

    private Mono<CosmosTriggerResponse> deleteInternal(Context context) {
        String spanName = "deleteTrigger." + this.container.getId();
        Mono responseMono = this.container.getDatabase().getDocClientWrapper().deleteTrigger(this.getLink(), null).map(ModelBridgeInternal::createCosmosTriggerResponse).single();
        CosmosAsyncClient client = this.container.getDatabase().getClient();
        return client.getDiagnosticsProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.container.getDatabase().getId(), this.container.getId(), client, null, OperationType.Delete, ResourceType.Trigger, null);
    }
}

