/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.BadRequestException;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.ConflictException;
import com.azure.cosmos.implementation.ConnectionPolicy;
import com.azure.cosmos.implementation.ForbiddenException;
import com.azure.cosmos.implementation.GlobalEndpointManager;
import com.azure.cosmos.implementation.GoneException;
import com.azure.cosmos.implementation.HttpConstants;
import com.azure.cosmos.implementation.Integers;
import com.azure.cosmos.implementation.InternalServerErrorException;
import com.azure.cosmos.implementation.InvalidPartitionException;
import com.azure.cosmos.implementation.Lists;
import com.azure.cosmos.implementation.LockedException;
import com.azure.cosmos.implementation.Longs;
import com.azure.cosmos.implementation.MethodNotAllowedException;
import com.azure.cosmos.implementation.MutableVolatile;
import com.azure.cosmos.implementation.NotFoundException;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.PartitionIsMigratingException;
import com.azure.cosmos.implementation.PartitionKeyRangeGoneException;
import com.azure.cosmos.implementation.PartitionKeyRangeIsSplittingException;
import com.azure.cosmos.implementation.PathsHelper;
import com.azure.cosmos.implementation.PreconditionFailedException;
import com.azure.cosmos.implementation.RequestEntityTooLargeException;
import com.azure.cosmos.implementation.RequestRateTooLargeException;
import com.azure.cosmos.implementation.RequestTimeoutException;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RetryWithException;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.ServiceUnavailableException;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.UnauthorizedException;
import com.azure.cosmos.implementation.UserAgentContainer;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.NotImplementedException;
import com.azure.cosmos.implementation.directconnectivity.ErrorUtils;
import com.azure.cosmos.implementation.directconnectivity.HttpUtils;
import com.azure.cosmos.implementation.directconnectivity.ResourceOperation;
import com.azure.cosmos.implementation.directconnectivity.ResponseUtils;
import com.azure.cosmos.implementation.directconnectivity.StoreResponse;
import com.azure.cosmos.implementation.directconnectivity.TransportClient;
import com.azure.cosmos.implementation.directconnectivity.Uri;
import com.azure.cosmos.implementation.directconnectivity.WebExceptionUtility;
import com.azure.cosmos.implementation.directconnectivity.rntbd.ProactiveOpenConnectionsProcessor;
import com.azure.cosmos.implementation.faultinjection.IFaultInjectorProvider;
import com.azure.cosmos.implementation.http.HttpClient;
import com.azure.cosmos.implementation.http.HttpClientConfig;
import com.azure.cosmos.implementation.http.HttpHeaders;
import com.azure.cosmos.implementation.http.HttpRequest;
import com.azure.cosmos.implementation.http.HttpResponse;
import com.azure.cosmos.models.CosmosContainerIdentity;
import io.netty.handler.codec.http.HttpMethod;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class HttpTransportClient
extends TransportClient {
    private final Logger logger = LoggerFactory.getLogger(HttpTransportClient.class);
    private final HttpClient httpClient;
    private final Map<String, String> defaultHeaders;
    private final Configs configs;
    private final GlobalEndpointManager globalEndpointManager;

    HttpClient createHttpClient(ConnectionPolicy connectionPolicy) {
        HttpClientConfig httpClientConfig = new HttpClientConfig(this.configs);
        httpClientConfig.withNetworkRequestTimeout(connectionPolicy.getHttpNetworkRequestTimeout());
        httpClientConfig.withPoolSize(this.configs.getDirectHttpsMaxConnectionLimit());
        return HttpClient.createFixed(httpClientConfig);
    }

    public HttpTransportClient(Configs configs, ConnectionPolicy connectionPolicy, UserAgentContainer userAgent, GlobalEndpointManager globalEndpointManager) {
        this.configs = configs;
        this.httpClient = this.createHttpClient(connectionPolicy);
        this.defaultHeaders = new HashMap<String, String>();
        this.defaultHeaders.put("x-ms-version", "2020-07-15");
        this.defaultHeaders.put("Cache-Control", "no-cache");
        this.defaultHeaders.put("x-ms-cosmos-sdk-supportedcapabilities", HttpConstants.SDKSupportedCapabilities.SUPPORTED_CAPABILITIES);
        if (userAgent == null) {
            userAgent = new UserAgentContainer();
        }
        this.defaultHeaders.put("User-Agent", userAgent.getUserAgent());
        this.defaultHeaders.put("Accept", "application/json");
        this.globalEndpointManager = globalEndpointManager;
    }

    @Override
    public void close() {
        this.httpClient.shutdown();
    }

    @Override
    public Mono<StoreResponse> invokeStoreAsync(Uri physicalAddressUri, RxDocumentServiceRequest request) {
        try {
            URI physicalAddress = physicalAddressUri.getURI();
            ResourceOperation resourceOperation = new ResourceOperation(request.getOperationType(), request.getResourceType());
            String activityId = request.getActivityId().toString();
            if (resourceOperation.operationType == OperationType.Recreate) {
                HashMap<String, String> errorResponseHeaders = new HashMap<String, String>();
                errorResponseHeaders.put("x-ms-request-validation-failure", "1");
                this.logger.error("Received Recreate request on Http client");
                throw new InternalServerErrorException("Unknown server error occurred when processing this request. If the issue persists, please contact Azure Support: http://aka.ms/azure-support", null, errorResponseHeaders, null);
            }
            HttpRequest httpRequest = this.prepareHttpMessage(activityId, physicalAddressUri, resourceOperation, request);
            MutableVolatile sendTimeUtc = new MutableVolatile();
            Duration responseTimeout = Duration.ofSeconds(Configs.getHttpResponseTimeoutInSeconds());
            if (OperationType.QueryPlan.equals((Object)request.getOperationType())) {
                responseTimeout = Duration.ofSeconds(Configs.getQueryPlanResponseTimeoutInSeconds());
            } else if (request.isAddressRefresh()) {
                responseTimeout = Duration.ofSeconds(Configs.getAddressRefreshResponseTimeoutInSeconds());
            }
            Mono httpResponseMono = this.httpClient.send(httpRequest, responseTimeout).doOnSubscribe(subscription -> {
                sendTimeUtc.v = Instant.now();
                this.beforeRequest(activityId, httpRequest.uri(), request.getResourceType(), httpRequest.headers());
            }).onErrorResume(t -> {
                Exception exception = Utils.as(t, Exception.class);
                if (exception == null) {
                    this.logger.error("critical failure", t);
                    t.printStackTrace();
                    assert (false) : "critical failure";
                    return Mono.error((Throwable)t);
                }
                if (WebExceptionUtility.isWebExceptionRetriable(exception)) {
                    this.logger.debug("Received retriable exception {} sending the request to {}, will re-resolve the address send time UTC: {}", new Object[]{exception, physicalAddress, sendTimeUtc});
                    GoneException goneException = new GoneException(String.format("Message: %s", "The requested resource is no longer available at the server."), exception, null, physicalAddress, 20001);
                    return Mono.error((Throwable)((Object)goneException));
                }
                if (request.isReadOnlyRequest()) {
                    this.logger.trace("Received exception {} on readonly requestsending the request to {}, will reresolve the address send time UTC: {}", new Object[]{exception, physicalAddress, sendTimeUtc});
                    GoneException goneException = new GoneException(String.format("Message: %s", "The requested resource is no longer available at the server."), exception, null, physicalAddress, 20001);
                    return Mono.error((Throwable)((Object)goneException));
                }
                ServiceUnavailableException serviceUnavailableException = new ServiceUnavailableException(exception.getMessage(), exception, null, physicalAddress.toString(), 0);
                serviceUnavailableException.getResponseHeaders().put("x-ms-request-validation-failure", "1");
                serviceUnavailableException.getResponseHeaders().put("x-ms-write-request-trigger-refresh", "1");
                return Mono.error((Throwable)((Object)serviceUnavailableException));
            }).doOnSuccess(httpClientResponse -> {
                Instant receivedTimeUtc = Instant.now();
                double durationInMilliSeconds = receivedTimeUtc.toEpochMilli() - ((Instant)sendTimeUtc.v).toEpochMilli();
                this.afterRequest(activityId, httpClientResponse.statusCode(), durationInMilliSeconds, httpClientResponse.headers());
            }).doOnError(e -> {
                Instant receivedTimeUtc = Instant.now();
                double durationInMilliSeconds = receivedTimeUtc.toEpochMilli() - ((Instant)sendTimeUtc.v).toEpochMilli();
                this.afterRequest(activityId, 0, durationInMilliSeconds, null);
            });
            return httpResponseMono.flatMap(rsp -> this.processHttpResponse(request.requestContext.resourcePhysicalAddress, httpRequest, activityId, (HttpResponse)rsp, physicalAddress));
        }
        catch (Exception e2) {
            return Mono.error((Throwable)e2);
        }
    }

    @Override
    public void configureFaultInjectorProvider(IFaultInjectorProvider injectorProvider) {
        throw new NotImplementedException("configureFaultInjectorProvider is not supported in httpTransportClient");
    }

    @Override
    protected GlobalEndpointManager getGlobalEndpointManager() {
        return this.globalEndpointManager;
    }

    @Override
    public ProactiveOpenConnectionsProcessor getProactiveOpenConnectionsProcessor() {
        return null;
    }

    @Override
    public void recordOpenConnectionsAndInitCachesCompleted(List<CosmosContainerIdentity> cosmosContainerIdentities) {
        throw new NotImplementedException("recordOpenConnectionsAndInitCachesComplete is not supported in httpTransportClient");
    }

    @Override
    public void recordOpenConnectionsAndInitCachesStarted(List<CosmosContainerIdentity> cosmosContainerIdentities) {
        throw new NotImplementedException("recordOpenConnectionsAndInitCachesStarted is not supported in httpTransportClient");
    }

    private void beforeRequest(String activityId, URI uri, ResourceType resourceType, HttpHeaders requestHeaders) {
    }

    private void afterRequest(String activityId, int statusCode, double durationInMilliSeconds, HttpHeaders responseHeaders) {
    }

    private static void addHeader(HttpHeaders requestHeaders, String headerName, RxDocumentServiceRequest request) {
        String headerValue = request.getHeaders().get(headerName);
        if (!Strings.isNullOrEmpty(headerValue)) {
            requestHeaders.set(headerName, headerValue);
        }
    }

    private static void addHeader(HttpHeaders requestHeaders, String headerName, String headerValue) {
        if (!Strings.isNullOrEmpty(headerValue)) {
            requestHeaders.set(headerName, headerValue);
        }
    }

    private String getMatch(RxDocumentServiceRequest request, ResourceOperation resourceOperation) {
        switch (resourceOperation.operationType) {
            case Delete: 
            case ExecuteJavaScript: 
            case Replace: 
            case Patch: 
            case Upsert: {
                return request.getHeaders().get("If-Match");
            }
            case Read: 
            case ReadFeed: {
                return request.getHeaders().get("If-None-Match");
            }
        }
        return null;
    }

    private HttpRequest prepareHttpMessage(String activityId, Uri physicalAddress, ResourceOperation resourceOperation, RxDocumentServiceRequest request) throws Exception {
        HttpRequest httpRequestMessage;
        switch (resourceOperation.operationType) {
            case Create: 
            case Batch: {
                String requestUri = HttpTransportClient.getResourceFeedUri(resourceOperation.resourceType, physicalAddress.getURIAsString(), request);
                HttpMethod method = HttpMethod.POST;
                assert (request.getContentAsByteArrayFlux() != null);
                httpRequestMessage = new HttpRequest(method, requestUri, physicalAddress.getURI().getPort());
                httpRequestMessage.withBody(request.getContentAsByteArrayFlux());
                break;
            }
            case ExecuteJavaScript: {
                String requestUri = HttpTransportClient.getResourceEntryUri(resourceOperation.resourceType, physicalAddress.getURIAsString(), request);
                HttpMethod method = HttpMethod.POST;
                assert (request.getContentAsByteArrayFlux() != null);
                httpRequestMessage = new HttpRequest(method, requestUri, physicalAddress.getURI().getPort());
                httpRequestMessage.withBody(request.getContentAsByteArrayFlux());
                break;
            }
            case Delete: {
                String requestUri = HttpTransportClient.getResourceEntryUri(resourceOperation.resourceType, physicalAddress.getURIAsString(), request);
                HttpMethod method = HttpMethod.DELETE;
                httpRequestMessage = new HttpRequest(method, requestUri, physicalAddress.getURI().getPort());
                break;
            }
            case Read: {
                String requestUri = HttpTransportClient.getResourceEntryUri(resourceOperation.resourceType, physicalAddress.getURIAsString(), request);
                HttpMethod method = HttpMethod.GET;
                httpRequestMessage = new HttpRequest(method, requestUri, physicalAddress.getURI().getPort());
                break;
            }
            case ReadFeed: {
                String requestUri = HttpTransportClient.getResourceFeedUri(resourceOperation.resourceType, physicalAddress.getURIAsString(), request);
                HttpMethod method = HttpMethod.GET;
                httpRequestMessage = new HttpRequest(method, requestUri, physicalAddress.getURI().getPort());
                break;
            }
            case Replace: {
                String requestUri = HttpTransportClient.getResourceEntryUri(resourceOperation.resourceType, physicalAddress.getURIAsString(), request);
                HttpMethod method = HttpMethod.PUT;
                assert (request.getContentAsByteArrayFlux() != null);
                httpRequestMessage = new HttpRequest(method, requestUri, physicalAddress.getURI().getPort());
                httpRequestMessage.withBody(request.getContentAsByteArrayFlux());
                break;
            }
            case Patch: {
                String requestUri = HttpTransportClient.getResourceEntryUri(resourceOperation.resourceType, physicalAddress.getURIAsString(), request);
                HttpMethod method = HttpMethod.PATCH;
                assert (request.getContentAsByteArrayFlux() != null);
                httpRequestMessage = new HttpRequest(method, requestUri, physicalAddress.getURI().getPort());
                httpRequestMessage.withBody(request.getContentAsByteArrayFlux());
                break;
            }
            case Query: 
            case SqlQuery: {
                String requestUri = HttpTransportClient.getResourceFeedUri(resourceOperation.resourceType, physicalAddress.getURIAsString(), request);
                HttpMethod method = HttpMethod.POST;
                assert (request.getContentAsByteArrayFlux() != null);
                httpRequestMessage = new HttpRequest(method, requestUri, physicalAddress.getURI().getPort());
                httpRequestMessage.withBody(request.getContentAsByteArrayFlux());
                HttpTransportClient.addHeader(httpRequestMessage.headers(), "Content-Type", request);
                break;
            }
            case Upsert: {
                String requestUri = HttpTransportClient.getResourceFeedUri(resourceOperation.resourceType, physicalAddress.getURIAsString(), request);
                HttpMethod method = HttpMethod.POST;
                assert (request.getContentAsByteArrayFlux() != null);
                httpRequestMessage = new HttpRequest(method, requestUri, physicalAddress.getURI().getPort());
                httpRequestMessage.withBody(request.getContentAsByteArrayFlux());
                break;
            }
            case Head: {
                String requestUri = HttpTransportClient.getResourceEntryUri(resourceOperation.resourceType, physicalAddress.getURIAsString(), request);
                HttpMethod method = HttpMethod.HEAD;
                httpRequestMessage = new HttpRequest(method, requestUri, physicalAddress.getURI().getPort());
                break;
            }
            case HeadFeed: {
                String requestUri = HttpTransportClient.getResourceFeedUri(resourceOperation.resourceType, physicalAddress.getURIAsString(), request);
                HttpMethod method = HttpMethod.HEAD;
                httpRequestMessage = new HttpRequest(method, requestUri, physicalAddress.getURI().getPort());
                break;
            }
            default: {
                assert (false) : "Unsupported operation type";
                throw new IllegalStateException();
            }
        }
        Map<String, String> documentServiceRequestHeaders = request.getHeaders();
        HttpHeaders httpRequestHeaders = httpRequestMessage.headers();
        for (Map.Entry<String, String> entry : this.defaultHeaders.entrySet()) {
            HttpTransportClient.addHeader(httpRequestHeaders, entry.getKey(), entry.getValue());
        }
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-version", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "User-Agent", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-max-item-count", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-pre-trigger-include", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-pre-trigger-exclude", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-post-trigger-include", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-post-trigger-exclude", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "authorization", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-indexing-directive", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-migratecollection-directive", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-consistency-level", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-session-token", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "Prefer", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-expiry-seconds", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-query-enable-scan", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-query-emit-traces", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-cancharge", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-canthrottle", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-query-enable-low-precision-order-by", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-script-enable-logging", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-is-readonly-script", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-content-serialization-format", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-continuation", request.getContinuation());
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-activity-id", activityId);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-partitionkey", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-partitionkeyrangeid", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-read-key-type", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-start-epk", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-end-epk", request);
        String dateHeader = HttpUtils.getDateHeader(documentServiceRequestHeaders);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-date", dateHeader);
        HttpTransportClient.addHeader(httpRequestHeaders, "Match", this.getMatch(request, resourceOperation));
        HttpTransportClient.addHeader(httpRequestHeaders, "If-Modified-Since", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "A-IM", request);
        if (!request.getIsNameBased()) {
            HttpTransportClient.addHeader(httpRequestHeaders, "x-docdb-resource-id", request.getResourceId());
        }
        HttpTransportClient.addHeader(httpRequestHeaders, "x-docdb-entity-id", request.entityId);
        String fanoutRequestHeader = request.getHeaders().get("x-ms-is-fanout-request");
        HttpTransportClient.addHeader(httpRequestMessage.headers(), "x-ms-is-fanout-request", fanoutRequestHeader);
        if (request.getResourceType() == ResourceType.DocumentCollection) {
            HttpTransportClient.addHeader(httpRequestHeaders, "collection-partition-index", documentServiceRequestHeaders.get("collection-partition-index"));
            HttpTransportClient.addHeader(httpRequestHeaders, "collection-service-index", documentServiceRequestHeaders.get("collection-service-index"));
        }
        if (documentServiceRequestHeaders.get("x-ms-bind-replica") != null) {
            HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-bind-replica", documentServiceRequestHeaders.get("x-ms-bind-replica"));
            HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-primary-master-key", documentServiceRequestHeaders.get("x-ms-primary-master-key"));
            HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-secondary-master-key", documentServiceRequestHeaders.get("x-ms-secondary-master-key"));
            HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-primary-readonly-key", documentServiceRequestHeaders.get("x-ms-primary-readonly-key"));
            HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-secondary-readonly-key", documentServiceRequestHeaders.get("x-ms-secondary-readonly-key"));
        }
        if (documentServiceRequestHeaders.get("x-ms-can-offer-replace-complete") != null) {
            HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-can-offer-replace-complete", documentServiceRequestHeaders.get("x-ms-can-offer-replace-complete"));
        }
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-isquery", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-query", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-is-upsert", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-supportspatiallegacycoordinates", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-partitioncount", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-collection-rid", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-filterby-schema-rid", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-usepolygonssmallerthanahemisphere", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-gateway-signature", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-populatequotainfo", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-populatequerymetrics", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-force-query-scan", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-responsecontinuationtokenlimitinkb", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-remote-storage-type", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-share-throughput", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-populatepartitionstatistics", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-populatecollectionthroughputinfo", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-remaining-time-in-ms-on-client", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-client-retry-attempt-count", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-target-lsn", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-target-global-committed-lsn", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-federation-for-auth", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-fanout-operation-state", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-cosmos-allow-tentative-writes", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-exclude-system-properties", request);
        if (resourceOperation.operationType == OperationType.Batch) {
            HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-cosmos-is-batch-request", request);
            HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-cosmos-batch-continue-on-error", request);
            HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-cosmos-batch-ordered", request);
            HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-cosmos-batch-atomic", request);
        }
        return httpRequestMessage;
    }

    static String getResourceFeedUri(ResourceType resourceType, String physicalAddress, RxDocumentServiceRequest request) throws Exception {
        switch (resourceType) {
            case Attachment: {
                return HttpTransportClient.getAttachmentFeedUri(physicalAddress, request);
            }
            case DocumentCollection: {
                return HttpTransportClient.getCollectionFeedUri(physicalAddress, request);
            }
            case Conflict: {
                return HttpTransportClient.getConflictFeedUri(physicalAddress, request);
            }
            case Database: {
                return HttpTransportClient.getDatabaseFeedUri(physicalAddress);
            }
            case Document: {
                return HttpTransportClient.getDocumentFeedUri(physicalAddress, request);
            }
            case Permission: {
                return HttpTransportClient.getPermissionFeedUri(physicalAddress, request);
            }
            case StoredProcedure: {
                return HttpTransportClient.getStoredProcedureFeedUri(physicalAddress, request);
            }
            case Trigger: {
                return HttpTransportClient.getTriggerFeedUri(physicalAddress, request);
            }
            case User: {
                return HttpTransportClient.getUserFeedUri(physicalAddress, request);
            }
            case UserDefinedFunction: {
                return HttpTransportClient.getUserDefinedFunctionFeedUri(physicalAddress, request);
            }
            case Schema: {
                return HttpTransportClient.getSchemaFeedUri(physicalAddress, request);
            }
            case Offer: {
                return HttpTransportClient.getOfferFeedUri(physicalAddress, request);
            }
        }
        assert (false) : "Unexpected resource type: " + (Object)((Object)resourceType);
        throw new NotFoundException();
    }

    private static String getResourceEntryUri(ResourceType resourceType, String physicalAddress, RxDocumentServiceRequest request) throws Exception {
        switch (resourceType) {
            case Attachment: {
                return HttpTransportClient.getAttachmentEntryUri(physicalAddress, request);
            }
            case DocumentCollection: {
                return HttpTransportClient.getCollectionEntryUri(physicalAddress, request);
            }
            case Conflict: {
                return HttpTransportClient.getConflictEntryUri(physicalAddress, request);
            }
            case Database: {
                return HttpTransportClient.getDatabaseEntryUri(physicalAddress, request);
            }
            case Document: {
                return HttpTransportClient.getDocumentEntryUri(physicalAddress, request);
            }
            case Permission: {
                return HttpTransportClient.getPermissionEntryUri(physicalAddress, request);
            }
            case StoredProcedure: {
                return HttpTransportClient.getStoredProcedureEntryUri(physicalAddress, request);
            }
            case Trigger: {
                return HttpTransportClient.getTriggerEntryUri(physicalAddress, request);
            }
            case User: {
                return HttpTransportClient.getUserEntryUri(physicalAddress, request);
            }
            case UserDefinedFunction: {
                return HttpTransportClient.getUserDefinedFunctionEntryUri(physicalAddress, request);
            }
            case Schema: {
                return HttpTransportClient.getSchemaEntryUri(physicalAddress, request);
            }
            case Offer: {
                return HttpTransportClient.getOfferEntryUri(physicalAddress, request);
            }
        }
        assert (false) : "Unexpected resource type: " + (Object)((Object)resourceType);
        throw new IllegalStateException();
    }

    static String createURI(String baseAddress, String resourcePath) {
        if (baseAddress.charAt(baseAddress.length() - 1) == '/') {
            return baseAddress + HttpUtils.urlEncode(Utils.trimBeginningAndEndingSlashes(resourcePath));
        }
        return baseAddress + '/' + HttpUtils.urlEncode(Utils.trimBeginningAndEndingSlashes(resourcePath));
    }

    static String getRootFeedUri(String baseAddress) {
        return baseAddress;
    }

    private static String getDatabaseFeedUri(String baseAddress) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.Database, "", true));
    }

    private static String getDatabaseEntryUri(String baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.Database, request, false));
    }

    private static String getCollectionFeedUri(String baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.DocumentCollection, request, true));
    }

    private static String getStoredProcedureFeedUri(String baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.StoredProcedure, request, true));
    }

    private static String getTriggerFeedUri(String baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.Trigger, request, true));
    }

    private static String getUserDefinedFunctionFeedUri(String baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.UserDefinedFunction, request, true));
    }

    private static String getCollectionEntryUri(String baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.DocumentCollection, request, false));
    }

    private static String getStoredProcedureEntryUri(String baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.StoredProcedure, request, false));
    }

    private static String getTriggerEntryUri(String baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.Trigger, request, false));
    }

    private static String getUserDefinedFunctionEntryUri(String baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.UserDefinedFunction, request, false));
    }

    private static String getDocumentFeedUri(String baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.Document, request, true));
    }

    private static String getDocumentEntryUri(String baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.Document, request, false));
    }

    private static String getConflictFeedUri(String baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.Conflict, request, true));
    }

    private static String getConflictEntryUri(String baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.Conflict, request, false));
    }

    private static String getAttachmentFeedUri(String baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.Attachment, request, true));
    }

    private static String getAttachmentEntryUri(String baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.Attachment, request, false));
    }

    private static String getUserFeedUri(String baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.User, request, true));
    }

    private static String getUserEntryUri(String baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.User, request, false));
    }

    private static String getPermissionFeedUri(String baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.Permission, request, true));
    }

    private static String getPermissionEntryUri(String baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.Permission, request, false));
    }

    private static String getOfferFeedUri(String baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.Offer, request, true));
    }

    private static String getSchemaFeedUri(String baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.Schema, request, true));
    }

    private static String getSchemaEntryUri(String baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.Schema, request, false));
    }

    private static String getOfferEntryUri(String baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.Offer, request, false));
    }

    static String getHeader(String[] names, String[] values, String name) {
        for (int idx = 0; idx < names.length; ++idx) {
            if (!Strings.areEqual(names[idx], name)) continue;
            return values[idx];
        }
        return null;
    }

    private Mono<StoreResponse> processHttpResponse(String resourceAddress, HttpRequest httpRequest, String activityId, HttpResponse response, URI physicalAddress) {
        if (response == null) {
            InternalServerErrorException exception = new InternalServerErrorException(String.format("Message: %s", "The backend response was not in the correct format."), null, physicalAddress);
            exception.getResponseHeaders().put("x-ms-activity-id", activityId);
            exception.getResponseHeaders().put("x-ms-request-validation-failure", "1");
            return Mono.error((Throwable)((Object)exception));
        }
        if (response.statusCode() < 400 || response.statusCode() == 304) {
            return ResponseUtils.toStoreResponse(response, httpRequest);
        }
        return this.createErrorResponseFromHttpResponse(resourceAddress, activityId, httpRequest, response);
    }

    private Mono<StoreResponse> createErrorResponseFromHttpResponse(String resourceAddress, String activityId, HttpRequest request, HttpResponse response) {
        int statusCode = response.statusCode();
        Mono<String> errorMessageObs = ErrorUtils.getErrorResponseAsync(response, request);
        return errorMessageObs.flatMap(errorMessage -> {
            CosmosException exception;
            long responseLSN = -1L;
            ArrayList<String> lsnValues = null;
            String[] headerValues = response.headers().values("lsn");
            if (headerValues != null) {
                lsnValues = com.azure.cosmos.implementation.guava25.collect.Lists.newArrayList(headerValues);
            }
            if (lsnValues != null) {
                String temp = lsnValues.isEmpty() ? null : (String)lsnValues.get(0);
                responseLSN = Longs.tryParse(temp, responseLSN);
            }
            String responsePartitionKeyRangeId = null;
            ArrayList<String> partitionKeyRangeIdValues = null;
            headerValues = response.headers().values("x-ms-documentdb-partitionkeyrangeid");
            if (headerValues != null) {
                partitionKeyRangeIdValues = com.azure.cosmos.implementation.guava25.collect.Lists.newArrayList(headerValues);
            }
            if (partitionKeyRangeIdValues != null) {
                responsePartitionKeyRangeId = Lists.firstOrDefault(partitionKeyRangeIdValues, null);
            }
            switch (statusCode) {
                case 401: {
                    exception = new UnauthorizedException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "Unable to authenticate the request. The request requires valid user authentication." : errorMessage), response.headers(), request.uri());
                    break;
                }
                case 403: {
                    exception = new ForbiddenException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "Unable to proceed with the request. Please check the authorization claims to ensure the required permissions to process the request." : errorMessage), response.headers(), request.uri());
                    break;
                }
                case 404: {
                    if (response.body() != null && response.headers() != null && response.headers().value("Content-Type") != null && !Strings.isNullOrEmpty(response.headers().value("Content-Type")) && Strings.containsIgnoreCase(response.headers().value("Content-Type"), "text/html")) {
                        exception = new GoneException(String.format("Message: %s", "The requested resource is no longer available at the server."), request.uri().toString(), 0);
                        exception.getResponseHeaders().put("x-ms-activity-id", activityId);
                        break;
                    }
                    exception = new NotFoundException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "Entity with the specified id does not exist in the system. More info: https://aka.ms/cosmosdb-tsg-not-found-java" : errorMessage), response.headers(), request.uri());
                    break;
                }
                case 400: {
                    exception = new BadRequestException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "One of the input values is invalid." : errorMessage), response.headers(), request.uri());
                    break;
                }
                case 405: {
                    exception = new MethodNotAllowedException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "The requested verb is not supported." : errorMessage), null, response.headers(), request.uri().toString());
                    break;
                }
                case 410: {
                    ErrorUtils.logGoneException(request.uri(), activityId);
                    Integer nSubStatus = this.getSubStatusCodeFromHeader(response);
                    if (nSubStatus == 1000) {
                        exception = new InvalidPartitionException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "The requested resource is no longer available at the server." : errorMessage), response.headers(), request.uri().toString());
                        break;
                    }
                    if (nSubStatus == 1002) {
                        exception = new PartitionKeyRangeGoneException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "The requested resource is no longer available at the server." : errorMessage), response.headers(), request.uri().toString());
                        break;
                    }
                    if (nSubStatus == 1007) {
                        exception = new PartitionKeyRangeIsSplittingException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "The requested resource is no longer available at the server." : errorMessage), response.headers(), request.uri().toString());
                        break;
                    }
                    if (nSubStatus == 1008) {
                        exception = new PartitionIsMigratingException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "The requested resource is no longer available at the server." : errorMessage), response.headers(), request.uri().toString());
                        break;
                    }
                    GoneException goneExceptionFromService = new GoneException(String.format("Message: %s", "The requested resource is no longer available at the server."), response.headers(), request.uri(), nSubStatus == 0 ? 20001 : 0);
                    goneExceptionFromService.setIsBasedOn410ResponseFromService();
                    goneExceptionFromService.getResponseHeaders().put("x-ms-activity-id", activityId);
                    exception = goneExceptionFromService;
                    break;
                }
                case 409: {
                    exception = new ConflictException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "Entity with the specified id already exists in the system." : errorMessage), response.headers(), request.uri().toString());
                    break;
                }
                case 412: {
                    exception = new PreconditionFailedException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "Operation cannot be performed because one of the specified precondition is not met." : errorMessage), response.headers(), request.uri().toString());
                    break;
                }
                case 413: {
                    exception = new RequestEntityTooLargeException(String.format("Message: %s", String.format("The size of the response exceeded the maximum allowed size, limit the  response size by specifying smaller value for '%s' header.", "x-ms-max-item-count")), response.headers(), request.uri().toString());
                    break;
                }
                case 423: {
                    exception = new LockedException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "" : errorMessage), response.headers(), request.uri().toString());
                    break;
                }
                case 503: {
                    int subStatusCode = this.getSubStatusCodeFromHeader(response);
                    exception = new ServiceUnavailableException((String)errorMessage, response.headers(), request.uri(), subStatusCode == 0 ? 21008 : 0);
                    break;
                }
                case 408: {
                    exception = new RequestTimeoutException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "Request timed out. More info: https://aka.ms/cosmosdb-tsg-request-timeout-java" : errorMessage), response.headers(), request.uri());
                    break;
                }
                case 449: {
                    exception = new RetryWithException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "Retry the request." : errorMessage), response.headers(), request.uri());
                    break;
                }
                case 429: {
                    exception = new RequestRateTooLargeException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "The request rate is too large. More Request Units may be needed, so no changes were made. Please retry after sometime. Learn more: http://aka.ms/cosmosdb-error-429" : errorMessage), response.headers(), request.uri());
                    ArrayList<String> values = null;
                    headerValues = response.headers().values("x-ms-retry-after-ms");
                    if (headerValues != null) {
                        values = com.azure.cosmos.implementation.guava25.collect.Lists.newArrayList(headerValues);
                    }
                    if (values == null || values.isEmpty()) {
                        this.logger.warn("RequestRateTooLargeException being thrown without RetryAfter.");
                        break;
                    }
                    exception.getResponseHeaders().put("x-ms-retry-after-ms", (String)values.get(0));
                    break;
                }
                case 500: {
                    exception = new InternalServerErrorException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "Unknown server error occurred when processing this request. If the issue persists, please contact Azure Support: http://aka.ms/azure-support" : errorMessage), response.headers(), request.uri());
                    break;
                }
                default: {
                    this.logger.error("Unrecognized status code {} returned by backend. ActivityId {}", (Object)statusCode, (Object)activityId);
                    ErrorUtils.logException(request.uri(), activityId);
                    exception = new InternalServerErrorException(String.format("Message: %s", "The backend response was not in the correct format."), response.headers(), request.uri());
                }
            }
            BridgeInternal.setLSN(exception, responseLSN);
            BridgeInternal.setPartitionKeyRangeId(exception, responsePartitionKeyRangeId);
            BridgeInternal.setResourceAddress(exception, resourceAddress);
            BridgeInternal.setRequestHeaders(exception, HttpUtils.asMap(request.headers()));
            return Mono.error((Throwable)((Object)exception));
        });
    }

    private int getSubStatusCodeFromHeader(HttpResponse response) {
        Integer nSubStatus = 0;
        String valueSubStatus = response.headers().value("x-ms-substatus");
        if (!Strings.isNullOrEmpty(valueSubStatus) && (nSubStatus = Integers.tryParse(valueSubStatus)) == null) {
            throw new InternalServerErrorException(String.format("Message: %s", "The backend response was not in the correct format."), response.headers(), response.request().uri());
        }
        return nSubStatus;
    }
}

