/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LimitContinuationToken
extends JsonSerializable {
    private static final String LIMIT_PROPERTY_NAME = "limit";
    private static final String SOURCE_TOKEN_PROPERTY_NAME = "sourceToken";
    private static final Logger logger = LoggerFactory.getLogger(LimitContinuationToken.class);

    public LimitContinuationToken(int limitCount, String sourceToken) {
        if (limitCount < 0) {
            throw new IllegalArgumentException("limitCount must be a non negative number.");
        }
        this.setLimitCount(limitCount);
        this.setSourceToken(sourceToken);
    }

    private LimitContinuationToken(String serializedTakeContinuationToken) {
        super(serializedTakeContinuationToken);
    }

    public static boolean tryParse(String serializedTakeContinuationToken, Utils.ValueHolder<LimitContinuationToken> outTakeContinuationToken) {
        boolean parsed;
        try {
            LimitContinuationToken takeContinuationToken = new LimitContinuationToken(serializedTakeContinuationToken);
            takeContinuationToken.getSourceToken();
            takeContinuationToken.getLimitCount();
            outTakeContinuationToken.v = takeContinuationToken;
            parsed = true;
        }
        catch (Exception ex) {
            logger.debug("Received exception {} when trying to parse: {}", (Object)ex.getMessage(), (Object)serializedTakeContinuationToken);
            parsed = false;
            outTakeContinuationToken.v = null;
        }
        return parsed;
    }

    public int getLimitCount() {
        return super.getInt(LIMIT_PROPERTY_NAME);
    }

    public String getSourceToken() {
        return super.getString(SOURCE_TOKEN_PROPERTY_NAME);
    }

    private void setLimitCount(int limitCount) {
        BridgeInternal.setProperty(this, LIMIT_PROPERTY_NAME, limitCount);
    }

    private void setSourceToken(String sourceToken) {
        BridgeInternal.setProperty(this, SOURCE_TOKEN_PROPERTY_NAME, sourceToken);
    }

    @Override
    public String toJson() {
        return super.toJson();
    }
}

