/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosDiagnosticsThresholds;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.implementation.apachecommons.collections.list.UnmodifiableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CosmosBatchRequestOptions {
    private ConsistencyLevel consistencyLevel;
    private String sessionToken;
    private Map<String, String> customOptions;
    private CosmosDiagnosticsThresholds thresholds = new CosmosDiagnosticsThresholds();
    private List<String> excludeRegions;

    ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    CosmosBatchRequestOptions setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public CosmosBatchRequestOptions setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
        return this;
    }

    public CosmosBatchRequestOptions setDiagnosticsThresholds(CosmosDiagnosticsThresholds operationSpecificThresholds) {
        this.thresholds = operationSpecificThresholds;
        return this;
    }

    RequestOptions toRequestOptions() {
        RequestOptions requestOptions = new RequestOptions();
        requestOptions.setConsistencyLevel(this.getConsistencyLevel());
        requestOptions.setSessionToken(this.sessionToken);
        requestOptions.setDiagnosticsThresholds(this.thresholds);
        if (this.customOptions != null) {
            for (Map.Entry<String, String> entry : this.customOptions.entrySet()) {
                requestOptions.setHeader(entry.getKey(), entry.getValue());
            }
        }
        requestOptions.setExcludeRegions(this.excludeRegions);
        return requestOptions;
    }

    CosmosBatchRequestOptions setHeader(String name, String value) {
        if (this.customOptions == null) {
            this.customOptions = new HashMap<String, String>();
        }
        this.customOptions.put(name, value);
        return this;
    }

    public CosmosBatchRequestOptions setExcludedRegions(List<String> excludeRegions) {
        this.excludeRegions = excludeRegions;
        return this;
    }

    public List<String> getExcludedRegions() {
        if (this.excludeRegions == null) {
            return null;
        }
        return UnmodifiableList.unmodifiableList(this.excludeRegions);
    }

    Map<String, String> getHeaders() {
        return this.customOptions;
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosBatchRequestOptionsHelper.setCosmosBatchRequestOptionsAccessor(new ImplementationBridgeHelpers.CosmosBatchRequestOptionsHelper.CosmosBatchRequestOptionsAccessor(){

            @Override
            public ConsistencyLevel getConsistencyLevel(CosmosBatchRequestOptions cosmosBatchRequestOptions) {
                return cosmosBatchRequestOptions.getConsistencyLevel();
            }

            @Override
            public CosmosBatchRequestOptions setConsistencyLevel(CosmosBatchRequestOptions cosmosBatchRequestOptions, ConsistencyLevel consistencyLevel) {
                return cosmosBatchRequestOptions.setConsistencyLevel(consistencyLevel);
            }

            @Override
            public CosmosBatchRequestOptions setHeader(CosmosBatchRequestOptions cosmosItemRequestOptions, String name, String value) {
                return cosmosItemRequestOptions.setHeader(name, value);
            }

            @Override
            public Map<String, String> getHeader(CosmosBatchRequestOptions cosmosItemRequestOptions) {
                return cosmosItemRequestOptions.getHeaders();
            }

            @Override
            public List<String> getExcludeRegions(CosmosBatchRequestOptions cosmosBatchRequestOptions) {
                return cosmosBatchRequestOptions.excludeRegions;
            }
        });
    }

    static {
        CosmosBatchRequestOptions.initialize();
    }
}

