/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.InternalObjectNode;
import com.azure.cosmos.implementation.ItemDeserializer;
import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.implementation.SerializationDiagnosticsContext;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class CosmosItemResponse<T> {
    private final Class<T> itemClassType;
    private final ItemDeserializer itemDeserializer;
    byte[] responseBodyAsByteArray;
    private volatile T item;
    final ResourceResponse<Document> resourceResponse;
    private InternalObjectNode props;
    private AtomicBoolean hasTrackingIdCalculated = new AtomicBoolean(false);
    private boolean hasTrackingId;

    CosmosItemResponse(ResourceResponse<Document> response, Class<T> classType, ItemDeserializer itemDeserializer) {
        this(response, response.getBodyAsByteArray(), classType, itemDeserializer);
    }

    CosmosItemResponse(ResourceResponse<Document> response, byte[] responseBodyAsByteArray, Class<T> classType, ItemDeserializer itemDeserializer) {
        this.itemClassType = classType;
        this.responseBodyAsByteArray = responseBodyAsByteArray;
        this.resourceResponse = response;
        this.itemDeserializer = itemDeserializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getItem() {
        if (this.item != null) {
            return this.item;
        }
        SerializationDiagnosticsContext serializationDiagnosticsContext = BridgeInternal.getSerializationDiagnosticsContext(this.getDiagnostics());
        if (this.item == null && this.itemClassType == InternalObjectNode.class) {
            Instant serializationStartTime = Instant.now();
            this.item = this.getProperties();
            Instant serializationEndTime = Instant.now();
            SerializationDiagnosticsContext.SerializationDiagnostics diagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTime, serializationEndTime, SerializationDiagnosticsContext.SerializationType.ITEM_DESERIALIZATION);
            serializationDiagnosticsContext.addSerializationDiagnostics(diagnostics);
            return this.item;
        }
        if (this.item == null) {
            CosmosItemResponse cosmosItemResponse = this;
            synchronized (cosmosItemResponse) {
                if (this.item == null && !Utils.isEmpty(this.responseBodyAsByteArray)) {
                    Instant serializationStartTime = Instant.now();
                    this.item = Utils.parse(this.responseBodyAsByteArray, this.itemClassType, this.itemDeserializer);
                    Instant serializationEndTime = Instant.now();
                    SerializationDiagnosticsContext.SerializationDiagnostics diagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTime, serializationEndTime, SerializationDiagnosticsContext.SerializationType.ITEM_DESERIALIZATION);
                    serializationDiagnosticsContext.addSerializationDiagnostics(diagnostics);
                }
            }
        }
        return this.item;
    }

    InternalObjectNode getProperties() {
        this.ensureInternalObjectNodeInitialized();
        return this.props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInternalObjectNodeInitialized() {
        CosmosItemResponse cosmosItemResponse = this;
        synchronized (cosmosItemResponse) {
            this.props = Utils.isEmpty(this.responseBodyAsByteArray) ? null : new InternalObjectNode(this.responseBodyAsByteArray);
        }
    }

    public String getMaxResourceQuota() {
        return this.resourceResponse.getMaxResourceQuota();
    }

    public String getCurrentResourceQuotaUsage() {
        return this.resourceResponse.getCurrentResourceQuotaUsage();
    }

    public String getActivityId() {
        return this.resourceResponse.getActivityId();
    }

    public double getRequestCharge() {
        return this.resourceResponse.getRequestCharge();
    }

    public int getStatusCode() {
        return this.resourceResponse.getStatusCode();
    }

    public String getSessionToken() {
        return this.resourceResponse.getSessionToken();
    }

    public Map<String, String> getResponseHeaders() {
        return this.resourceResponse.getResponseHeaders();
    }

    public CosmosDiagnostics getDiagnostics() {
        return this.resourceResponse.getDiagnostics();
    }

    public Duration getDuration() {
        return this.resourceResponse.getDuration();
    }

    public String getETag() {
        return this.resourceResponse.getETag();
    }

    CosmosItemResponse<T> withRemappedStatusCode(int statusCode, double additionalRequestCharge, boolean isContentResponseOnWriteEnabled) {
        ResourceResponse<Document> mappedResourceResponse = this.resourceResponse.withRemappedStatusCode(statusCode, additionalRequestCharge);
        byte[] payload = null;
        if (isContentResponseOnWriteEnabled) {
            payload = this.responseBodyAsByteArray;
        }
        return new CosmosItemResponse<T>(mappedResourceResponse, payload, this.itemClassType, this.itemDeserializer);
    }

    boolean hasTrackingId(String candidate) {
        if (this.hasTrackingIdCalculated.compareAndSet(false, true)) {
            SerializationDiagnosticsContext serializationDiagnosticsContext = BridgeInternal.getSerializationDiagnosticsContext(this.getDiagnostics());
            Instant serializationStartTime = Instant.now();
            InternalObjectNode itemNode = this.getProperties();
            Instant serializationEndTime = Instant.now();
            SerializationDiagnosticsContext.SerializationDiagnostics diagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTime, serializationEndTime, SerializationDiagnosticsContext.SerializationType.ITEM_DESERIALIZATION);
            serializationDiagnosticsContext.addSerializationDiagnostics(diagnostics);
            this.hasTrackingId = itemNode != null && candidate.equals(itemNode.get("_trackingId"));
            return this.hasTrackingId;
        }
        return this.hasTrackingId;
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosItemResponseHelper.setCosmosItemResponseBuilderAccessor(new ImplementationBridgeHelpers.CosmosItemResponseHelper.CosmosItemResponseBuilderAccessor(){

            @Override
            public <T> CosmosItemResponse<T> createCosmosItemResponse(ResourceResponse<Document> response, byte[] contentAsByteArray, Class<T> classType, ItemDeserializer itemDeserializer) {
                return new CosmosItemResponse<T>(response, contentAsByteArray, classType, itemDeserializer);
            }

            @Override
            public <T> CosmosItemResponse<T> withRemappedStatusCode(CosmosItemResponse<T> originalResponse, int newStatusCode, double additionalRequestCharge, boolean isContentResponseOnWriteEnabled) {
                CosmosItemResponse<T> mappedItemResponse = originalResponse.withRemappedStatusCode(newStatusCode, additionalRequestCharge, isContentResponseOnWriteEnabled);
                return mappedItemResponse;
            }

            @Override
            public byte[] getByteArrayContent(CosmosItemResponse<byte[]> response) {
                return response.responseBodyAsByteArray;
            }

            @Override
            public void setByteArrayContent(CosmosItemResponse<byte[]> response, byte[] content) {
                response.responseBodyAsByteArray = content;
            }

            @Override
            public ResourceResponse<Document> getResourceResponse(CosmosItemResponse<byte[]> response) {
                return response.resourceResponse;
            }

            @Override
            public boolean hasTrackingId(CosmosItemResponse<?> response, String candidate) {
                Preconditions.checkNotNull(response, "Argument 'response' must not be null.");
                Preconditions.checkNotNull(candidate, "Argument 'candidate' must not be null.");
                return response.hasTrackingId(candidate);
            }
        });
    }

    static {
        CosmosItemResponse.initialize();
    }
}

