/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.util;

import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.IterableStream;
import com.azure.core.util.paging.ContinuablePagedFlux;
import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.CosmosDiagnosticsContext;
import com.azure.cosmos.implementation.CosmosPagedFluxOptions;
import com.azure.cosmos.implementation.DiagnosticsProvider;
import com.azure.cosmos.implementation.FeedOperationState;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.models.FeedResponse;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.util.context.ContextView;

public final class CosmosPagedFlux<T>
extends ContinuablePagedFlux<String, T, FeedResponse<T>> {
    private static final ImplementationBridgeHelpers.CosmosDiagnosticsHelper.CosmosDiagnosticsAccessor cosmosDiagnosticsAccessor = ImplementationBridgeHelpers.CosmosDiagnosticsHelper.getCosmosDiagnosticsAccessor();
    private static final ImplementationBridgeHelpers.CosmosDiagnosticsContextHelper.CosmosDiagnosticsContextAccessor ctxAccessor = ImplementationBridgeHelpers.CosmosDiagnosticsContextHelper.getCosmosDiagnosticsContextAccessor();
    private final Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> optionsFluxFunction;
    private final Consumer<FeedResponse<T>> feedResponseConsumer;
    private final int defaultPageSize;

    CosmosPagedFlux(Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> optionsFluxFunction) {
        this(optionsFluxFunction, null, -1);
    }

    CosmosPagedFlux(Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> optionsFluxFunction, Consumer<FeedResponse<T>> feedResponseConsumer) {
        this(optionsFluxFunction, feedResponseConsumer, -1);
    }

    CosmosPagedFlux(Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> optionsFluxFunction, Consumer<FeedResponse<T>> feedResponseConsumer, int defaultPageSize) {
        this.optionsFluxFunction = optionsFluxFunction;
        this.feedResponseConsumer = feedResponseConsumer;
        this.defaultPageSize = defaultPageSize;
    }

    public CosmosPagedFlux<T> handle(Consumer<FeedResponse<T>> newFeedResponseConsumer) {
        if (this.feedResponseConsumer != null) {
            return new CosmosPagedFlux<T>(this.optionsFluxFunction, this.feedResponseConsumer.andThen(newFeedResponseConsumer));
        }
        return new CosmosPagedFlux<T>(this.optionsFluxFunction, newFeedResponseConsumer);
    }

    public Flux<FeedResponse<T>> byPage() {
        CosmosPagedFluxOptions cosmosPagedFluxOptions = this.createCosmosPagedFluxOptions();
        return FluxUtil.fluxContext(context -> this.byPage(cosmosPagedFluxOptions, (Context)context));
    }

    public Flux<FeedResponse<T>> byPage(String continuationToken) {
        CosmosPagedFluxOptions cosmosPagedFluxOptions = this.createCosmosPagedFluxOptions();
        cosmosPagedFluxOptions.setRequestContinuation(continuationToken);
        return FluxUtil.fluxContext(context -> this.byPage(cosmosPagedFluxOptions, (Context)context));
    }

    public Flux<FeedResponse<T>> byPage(int preferredPageSize) {
        CosmosPagedFluxOptions cosmosPagedFluxOptions = this.createCosmosPagedFluxOptions();
        cosmosPagedFluxOptions.setMaxItemCount(preferredPageSize);
        return FluxUtil.fluxContext(context -> this.byPage(cosmosPagedFluxOptions, (Context)context));
    }

    public Flux<FeedResponse<T>> byPage(String continuationToken, int preferredPageSize) {
        CosmosPagedFluxOptions cosmosPagedFluxOptions = this.createCosmosPagedFluxOptions();
        cosmosPagedFluxOptions.setRequestContinuation(continuationToken);
        cosmosPagedFluxOptions.setMaxItemCount(preferredPageSize);
        return FluxUtil.fluxContext(context -> this.byPage(cosmosPagedFluxOptions, (Context)context));
    }

    public void subscribe(CoreSubscriber<? super T> coreSubscriber) {
        Flux<FeedResponse<T>> pagedResponse = this.byPage();
        pagedResponse.flatMap(tFeedResponse -> {
            IterableStream elements = tFeedResponse.getElements();
            if (elements == null) {
                return Flux.empty();
            }
            return Flux.fromIterable(elements);
        }).subscribe(coreSubscriber);
    }

    CosmosPagedFlux<T> withDefaultPageSize(int pageSize) {
        return new CosmosPagedFlux<T>(this.optionsFluxFunction, this.feedResponseConsumer, pageSize);
    }

    private CosmosPagedFluxOptions createCosmosPagedFluxOptions() {
        CosmosPagedFluxOptions cosmosPagedFluxOptions = new CosmosPagedFluxOptions();
        if (this.defaultPageSize > 0) {
            cosmosPagedFluxOptions.setMaxItemCount(this.defaultPageSize);
        }
        return cosmosPagedFluxOptions;
    }

    private Flux<FeedResponse<T>> wrapWithTracingIfEnabled(CosmosPagedFluxOptions pagedFluxOptions, Flux<FeedResponse<T>> publisher, AtomicLong feedResponseConsumerLatencyInNanos, Context context) {
        FeedOperationState state = pagedFluxOptions.getFeedOperationState();
        DiagnosticsProvider tracerProvider = state != null ? state.getDiagnosticsProvider() : null;
        Object lockHolder = new Object();
        if (tracerProvider == null || !tracerProvider.isEnabled() || tracerProvider.shouldSampleOutOperation(pagedFluxOptions)) {
            return publisher.doOnEach(signal -> {
                FeedResponse response = (FeedResponse)signal.get();
                Object object = lockHolder;
                synchronized (object) {
                    switch (signal.getType()) {
                        case ON_COMPLETE: 
                        case ON_NEXT: {
                            this.recordFeedResponse(pagedFluxOptions, tracerProvider, response, feedResponseConsumerLatencyInNanos);
                            break;
                        }
                    }
                }
            });
        }
        Flux result = tracerProvider.runUnderSpanInContext(publisher).doOnEach(signal -> {
            FeedResponse response = (FeedResponse)signal.get();
            Context traceCtx = DiagnosticsProvider.getContextFromReactorOrNull(signal.getContextView());
            Object object = lockHolder;
            synchronized (object) {
                switch (signal.getType()) {
                    case ON_COMPLETE: {
                        if (response != null) {
                            this.recordFeedResponse(pagedFluxOptions, tracerProvider, response, feedResponseConsumerLatencyInNanos);
                        }
                        state.mergeDiagnosticsContext();
                        CosmosDiagnosticsContext ctxSnapshot = state.getDiagnosticsContextSnapshot();
                        tracerProvider.recordFeedResponseConsumerLatency(signal, ctxSnapshot, Duration.ofNanos(feedResponseConsumerLatencyInNanos.get()));
                        tracerProvider.endSpan(ctxSnapshot, traceCtx, ctxAccessor.isEmptyCompletion(ctxSnapshot));
                        break;
                    }
                    case ON_NEXT: {
                        this.recordFeedResponse(pagedFluxOptions, tracerProvider, response, feedResponseConsumerLatencyInNanos);
                        state.mergeDiagnosticsContext();
                        tracerProvider.endSpan(state.getDiagnosticsContextSnapshot(), traceCtx, false);
                        state.resetDiagnosticsContext();
                        DiagnosticsProvider.setContextInReactor(tracerProvider.startSpan(state.getSpanName(), state.getDiagnosticsContextSnapshot(), traceCtx));
                        break;
                    }
                    case ON_ERROR: {
                        state.mergeDiagnosticsContext();
                        tracerProvider.recordFeedResponseConsumerLatency(signal, state.getDiagnosticsContextSnapshot(), Duration.ofNanos(feedResponseConsumerLatencyInNanos.get()));
                        tracerProvider.endSpan(state.getDiagnosticsContextSnapshot(), traceCtx, signal.getThrowable());
                        break;
                    }
                }
            }
        });
        return Flux.deferContextual(reactorCtx -> result.doOnCancel(() -> {
            Context traceCtx = DiagnosticsProvider.getContextFromReactorOrNull(reactorCtx);
            Object object = lockHolder;
            synchronized (object) {
                state.mergeDiagnosticsContext();
                tracerProvider.endSpan(state.getDiagnosticsContextSnapshot(), traceCtx, false);
            }
        }).doOnComplete(() -> {
            Context traceCtx = DiagnosticsProvider.getContextFromReactorOrNull(reactorCtx);
            Object object = lockHolder;
            synchronized (object) {
                state.mergeDiagnosticsContext();
                CosmosDiagnosticsContext ctxSnapshot = state.getDiagnosticsContextSnapshot();
                tracerProvider.endSpan(ctxSnapshot, traceCtx, ctxAccessor.isEmptyCompletion(ctxSnapshot));
            }
        })).contextWrite((ContextView)DiagnosticsProvider.setContextInReactor(tracerProvider.startSpan(state.getSpanName(), state.getDiagnosticsContextSnapshot(), context)));
    }

    private void recordFeedResponse(CosmosPagedFluxOptions pagedFluxOptions, DiagnosticsProvider tracerProvider, FeedResponse<T> response, AtomicLong feedResponseConsumerLatencyInNanos) {
        Integer actualItemCount;
        CosmosDiagnostics diagnostics = response != null ? response.getCosmosDiagnostics() : null;
        Integer n = actualItemCount = response != null && response.getResults() != null ? Integer.valueOf(response.getResults().size()) : null;
        if (diagnostics != null && cosmosDiagnosticsAccessor.isDiagnosticsCapturedInPagedFlux(diagnostics).compareAndSet(false, true)) {
            if (pagedFluxOptions.getSamplingRateSnapshot() < 1.0) {
                cosmosDiagnosticsAccessor.setSamplingRateSnapshot(diagnostics, pagedFluxOptions.getSamplingRateSnapshot());
            }
            if (this.isTracerEnabled(tracerProvider)) {
                tracerProvider.recordPage(pagedFluxOptions.getFeedOperationState().getDiagnosticsContextSnapshot(), diagnostics, actualItemCount, response.getRequestCharge());
            }
            if (this.feedResponseConsumer != null) {
                Instant feedResponseConsumerStart = Instant.now();
                this.feedResponseConsumer.accept(response);
                feedResponseConsumerLatencyInNanos.addAndGet(Duration.between(Instant.now(), feedResponseConsumerStart).toNanos());
            }
        }
    }

    private Flux<FeedResponse<T>> byPage(CosmosPagedFluxOptions pagedFluxOptions, Context context) {
        AtomicReference startTime = new AtomicReference();
        AtomicLong feedResponseConsumerLatencyInNanos = new AtomicLong(0L);
        Flux result = this.wrapWithTracingIfEnabled(pagedFluxOptions, this.optionsFluxFunction.apply(pagedFluxOptions), feedResponseConsumerLatencyInNanos, context).doOnSubscribe(ignoredValue -> {
            startTime.set(Instant.now());
            feedResponseConsumerLatencyInNanos.set(0L);
        });
        return result;
    }

    private boolean isTracerEnabled(DiagnosticsProvider tracerProvider) {
        return tracerProvider != null;
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosPageFluxHelper.setCosmosPageFluxAccessor(CosmosPagedFlux::new);
    }

    static {
        CosmosPagedFlux.initialize();
    }
}

