/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.epkversion;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.changefeed.ChangeFeedContextClient;
import com.azure.cosmos.implementation.changefeed.ChangeFeedObserver;
import com.azure.cosmos.implementation.changefeed.Lease;
import com.azure.cosmos.implementation.changefeed.LeaseCheckpointer;
import com.azure.cosmos.implementation.changefeed.ProcessorSettings;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedMode;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedState;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedStateV1;
import com.azure.cosmos.implementation.changefeed.epkversion.PartitionCheckpointerImpl;
import com.azure.cosmos.implementation.changefeed.epkversion.PartitionProcessor;
import com.azure.cosmos.implementation.changefeed.epkversion.PartitionProcessorFactory;
import com.azure.cosmos.implementation.changefeed.epkversion.PartitionProcessorHelper;
import com.azure.cosmos.implementation.changefeed.epkversion.PartitionProcessorImpl;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.ChangeFeedProcessorOptions;

class PartitionProcessorFactoryImpl<T>
implements PartitionProcessorFactory<T> {
    private final ChangeFeedContextClient documentClient;
    private final ChangeFeedProcessorOptions changeFeedProcessorOptions;
    private final LeaseCheckpointer leaseCheckpointer;
    private final CosmosAsyncContainer collectionSelfLink;
    private final String collectionResourceId;
    private final ChangeFeedMode changeFeedMode;

    public PartitionProcessorFactoryImpl(ChangeFeedContextClient documentClient, ChangeFeedProcessorOptions changeFeedProcessorOptions, LeaseCheckpointer leaseCheckpointer, CosmosAsyncContainer collectionSelfLink, String collectionResourceId, ChangeFeedMode changeFeedMode) {
        Preconditions.checkNotNull(documentClient, "Argument 'documentClient' can not be null");
        Preconditions.checkNotNull(changeFeedProcessorOptions, "Argument 'changeFeedProcessorOptions' can not be null");
        Preconditions.checkNotNull(leaseCheckpointer, "Argument 'leaseCheckpointer' can not be null");
        Preconditions.checkNotNull(collectionSelfLink, "Argument 'collectionSelfLink' can not be null");
        Preconditions.checkNotNull(collectionResourceId, "Argument 'collectionResourceId' can not be null");
        this.documentClient = documentClient;
        this.changeFeedProcessorOptions = changeFeedProcessorOptions;
        this.leaseCheckpointer = leaseCheckpointer;
        this.collectionSelfLink = collectionSelfLink;
        this.collectionResourceId = collectionResourceId;
        this.changeFeedMode = changeFeedMode;
    }

    @Override
    public PartitionProcessor create(Lease lease, ChangeFeedObserver<T> observer, Class<T> classType) {
        Preconditions.checkNotNull(observer, "Argument 'observer' can not be null");
        Preconditions.checkNotNull(lease, "Argument 'lease' can not be null");
        ChangeFeedState state = Strings.isNullOrWhiteSpace(lease.getContinuationToken()) ? new ChangeFeedStateV1(BridgeInternal.extractContainerSelfLink(this.collectionSelfLink), lease.getFeedRange(), this.changeFeedMode, PartitionProcessorHelper.getStartFromSettings(lease.getFeedRange(), this.changeFeedProcessorOptions, this.changeFeedMode), null) : lease.getContinuationState(this.collectionResourceId, this.changeFeedMode);
        ProcessorSettings settings = new ProcessorSettings(state, this.collectionSelfLink).withFeedPollDelay(this.changeFeedProcessorOptions.getFeedPollDelay()).withMaxItemCount(this.changeFeedProcessorOptions.getMaxItemCount());
        PartitionCheckpointerImpl checkpointer = new PartitionCheckpointerImpl(this.leaseCheckpointer, lease);
        return new PartitionProcessorImpl<T>(observer, this.documentClient, settings, checkpointer, lease, classType, this.changeFeedMode);
    }
}

