/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.AzureKeyCredentialTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosClient;
import com.azure.cosmos.CosmosContainerProactiveInitConfig;
import com.azure.cosmos.CosmosEndToEndOperationLatencyPolicyConfig;
import com.azure.cosmos.CosmosExcludedRegions;
import com.azure.cosmos.DirectConnectionConfig;
import com.azure.cosmos.GatewayConnectionConfig;
import com.azure.cosmos.SessionRetryOptions;
import com.azure.cosmos.ThrottlingRetryOptions;
import com.azure.cosmos.implementation.ApiType;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.ConnectionPolicy;
import com.azure.cosmos.implementation.CosmosClientMetadataCachesSnapshot;
import com.azure.cosmos.implementation.DiagnosticsProvider;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.WriteRetryPolicy;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.apachecommons.lang.time.StopWatch;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.routing.LocationHelper;
import com.azure.cosmos.models.CosmosAuthorizationTokenResolver;
import com.azure.cosmos.models.CosmosClientTelemetryConfig;
import com.azure.cosmos.models.CosmosContainerIdentity;
import com.azure.cosmos.models.CosmosPermissionProperties;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceClientBuilder(serviceClients={CosmosClient.class, CosmosAsyncClient.class})
public class CosmosClientBuilder
implements TokenCredentialTrait<CosmosClientBuilder>,
AzureKeyCredentialTrait<CosmosClientBuilder>,
EndpointTrait<CosmosClientBuilder> {
    private static final Logger logger = LoggerFactory.getLogger(CosmosClientBuilder.class);
    private Configs configs = new Configs();
    private String serviceEndpoint;
    private String keyOrResourceToken;
    private CosmosClientMetadataCachesSnapshot state;
    private TokenCredential tokenCredential;
    private ConnectionPolicy connectionPolicy;
    private GatewayConnectionConfig gatewayConnectionConfig;
    private DirectConnectionConfig directConnectionConfig;
    private ConsistencyLevel desiredConsistencyLevel;
    private List<CosmosPermissionProperties> permissions;
    private CosmosAuthorizationTokenResolver cosmosAuthorizationTokenResolver;
    private AzureKeyCredential credential;
    private boolean sessionCapturingOverrideEnabled;
    private boolean connectionSharingAcrossClientsEnabled;
    private boolean contentResponseOnWriteEnabled;
    private String userAgentSuffix = "";
    private ThrottlingRetryOptions throttlingRetryOptions;
    private List<String> preferredRegions;
    private boolean endpointDiscoveryEnabled = true;
    private boolean multipleWriteRegionsEnabled = true;
    private boolean readRequestsFallbackEnabled = true;
    private WriteRetryPolicy writeRetryPolicy = WriteRetryPolicy.DISABLED;
    private CosmosClientTelemetryConfig clientTelemetryConfig;
    private ApiType apiType = null;
    private Boolean clientTelemetryEnabledOverride = null;
    private CosmosContainerProactiveInitConfig proactiveContainerInitConfig;
    private CosmosEndToEndOperationLatencyPolicyConfig cosmosEndToEndOperationLatencyPolicyConfig;
    private SessionRetryOptions sessionRetryOptions;
    private Supplier<CosmosExcludedRegions> cosmosExcludedRegionsSupplier;

    public CosmosClientBuilder() {
        this.connectionPolicy = new ConnectionPolicy(DirectConnectionConfig.getDefaultConfig());
        this.throttlingRetryOptions = new ThrottlingRetryOptions();
        this.clientTelemetryConfig = new CosmosClientTelemetryConfig();
        this.resetNonIdempotentWriteRetryPolicy();
    }

    CosmosClientBuilder metadataCaches(CosmosClientMetadataCachesSnapshot metadataCachesSnapshot) {
        this.state = metadataCachesSnapshot;
        return this;
    }

    CosmosClientMetadataCachesSnapshot metadataCaches() {
        return this.state;
    }

    CosmosClientBuilder setApiType(ApiType apiType) {
        this.apiType = apiType;
        return this;
    }

    ApiType apiType() {
        return this.apiType;
    }

    public CosmosClientBuilder sessionCapturingOverrideEnabled(boolean sessionCapturingOverrideEnabled) {
        this.sessionCapturingOverrideEnabled = sessionCapturingOverrideEnabled;
        return this;
    }

    boolean isSessionCapturingOverrideEnabled() {
        return this.sessionCapturingOverrideEnabled;
    }

    public CosmosClientBuilder connectionSharingAcrossClientsEnabled(boolean connectionSharingAcrossClientsEnabled) {
        this.connectionSharingAcrossClientsEnabled = connectionSharingAcrossClientsEnabled;
        return this;
    }

    boolean isConnectionSharingAcrossClientsEnabled() {
        return this.connectionSharingAcrossClientsEnabled;
    }

    CosmosAuthorizationTokenResolver getAuthorizationTokenResolver() {
        return this.cosmosAuthorizationTokenResolver;
    }

    public CosmosClientBuilder authorizationTokenResolver(CosmosAuthorizationTokenResolver cosmosAuthorizationTokenResolver) {
        this.cosmosAuthorizationTokenResolver = Objects.requireNonNull(cosmosAuthorizationTokenResolver, "'cosmosAuthorizationTokenResolver' cannot be null.");
        this.keyOrResourceToken = null;
        this.credential = null;
        this.permissions = null;
        this.tokenCredential = null;
        return this;
    }

    String getEndpoint() {
        return this.serviceEndpoint;
    }

    public CosmosClientBuilder endpoint(String endpoint) {
        this.serviceEndpoint = Objects.requireNonNull(endpoint, "'endpoint' cannot be null.");
        return this;
    }

    String getKey() {
        return this.keyOrResourceToken;
    }

    public CosmosClientBuilder key(String key) {
        this.keyOrResourceToken = Objects.requireNonNull(key, "'key' cannot be null.");
        this.cosmosAuthorizationTokenResolver = null;
        this.credential = null;
        this.permissions = null;
        this.tokenCredential = null;
        return this;
    }

    String getResourceToken() {
        return this.keyOrResourceToken;
    }

    public CosmosClientBuilder resourceToken(String resourceToken) {
        this.keyOrResourceToken = Objects.requireNonNull(resourceToken, "'resourceToken' cannot be null.");
        this.cosmosAuthorizationTokenResolver = null;
        this.credential = null;
        this.permissions = null;
        this.tokenCredential = null;
        return this;
    }

    TokenCredential getTokenCredential() {
        return this.tokenCredential;
    }

    public CosmosClientBuilder credential(TokenCredential credential) {
        this.tokenCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.keyOrResourceToken = null;
        this.cosmosAuthorizationTokenResolver = null;
        this.credential = null;
        this.permissions = null;
        return this;
    }

    List<CosmosPermissionProperties> getPermissions() {
        return this.permissions;
    }

    public CosmosClientBuilder permissions(List<CosmosPermissionProperties> permissions) {
        this.permissions = Objects.requireNonNull(permissions, "'permissions' cannot be null.");
        this.keyOrResourceToken = null;
        this.cosmosAuthorizationTokenResolver = null;
        this.credential = null;
        this.tokenCredential = null;
        return this;
    }

    ConsistencyLevel getConsistencyLevel() {
        return this.desiredConsistencyLevel;
    }

    public CosmosClientBuilder consistencyLevel(ConsistencyLevel desiredConsistencyLevel) {
        this.desiredConsistencyLevel = desiredConsistencyLevel;
        return this;
    }

    ConnectionPolicy getConnectionPolicy() {
        return this.connectionPolicy;
    }

    AzureKeyCredential getCredential() {
        return this.credential;
    }

    CosmosContainerProactiveInitConfig getProactiveContainerInitConfig() {
        return this.proactiveContainerInitConfig;
    }

    public CosmosClientBuilder credential(AzureKeyCredential credential) {
        this.credential = Objects.requireNonNull(credential, "'cosmosKeyCredential' cannot be null.");
        this.keyOrResourceToken = null;
        this.cosmosAuthorizationTokenResolver = null;
        this.permissions = null;
        this.tokenCredential = null;
        return this;
    }

    boolean isContentResponseOnWriteEnabled() {
        return this.contentResponseOnWriteEnabled;
    }

    public CosmosClientBuilder contentResponseOnWriteEnabled(boolean contentResponseOnWriteEnabled) {
        this.contentResponseOnWriteEnabled = contentResponseOnWriteEnabled;
        return this;
    }

    public CosmosClientBuilder gatewayMode() {
        this.gatewayConnectionConfig = GatewayConnectionConfig.getDefaultConfig();
        return this;
    }

    public CosmosClientBuilder gatewayMode(GatewayConnectionConfig gatewayConnectionConfig) {
        this.gatewayConnectionConfig = gatewayConnectionConfig;
        return this;
    }

    public CosmosClientBuilder directMode() {
        this.directConnectionConfig = DirectConnectionConfig.getDefaultConfig();
        return this;
    }

    public CosmosClientBuilder directMode(DirectConnectionConfig directConnectionConfig) {
        this.directConnectionConfig = directConnectionConfig;
        return this;
    }

    public CosmosClientBuilder directMode(DirectConnectionConfig directConnectionConfig, GatewayConnectionConfig gatewayConnectionConfig) {
        this.directConnectionConfig = directConnectionConfig;
        this.gatewayConnectionConfig = gatewayConnectionConfig;
        return this;
    }

    public CosmosClientBuilder userAgentSuffix(String userAgentSuffix) {
        this.userAgentSuffix = userAgentSuffix;
        return this;
    }

    public CosmosClientBuilder throttlingRetryOptions(ThrottlingRetryOptions throttlingRetryOptions) {
        this.throttlingRetryOptions = throttlingRetryOptions;
        return this;
    }

    public CosmosClientBuilder preferredRegions(List<String> preferredRegions) {
        this.preferredRegions = preferredRegions;
        return this;
    }

    public CosmosClientBuilder endpointDiscoveryEnabled(boolean endpointDiscoveryEnabled) {
        this.endpointDiscoveryEnabled = endpointDiscoveryEnabled;
        return this;
    }

    public CosmosClientBuilder multipleWriteRegionsEnabled(boolean multipleWriteRegionsEnabled) {
        this.multipleWriteRegionsEnabled = multipleWriteRegionsEnabled;
        return this;
    }

    public CosmosClientBuilder clientTelemetryEnabled(boolean clientTelemetryEnabled) {
        this.clientTelemetryEnabledOverride = clientTelemetryEnabled;
        return this;
    }

    public CosmosClientBuilder readRequestsFallbackEnabled(boolean readRequestsFallbackEnabled) {
        this.readRequestsFallbackEnabled = readRequestsFallbackEnabled;
        return this;
    }

    CosmosClientBuilder setNonIdempotentWriteRetryPolicy(boolean nonIdempotentWriteRetriesEnabled, boolean useTrackingIdPropertyForCreateAndReplace) {
        this.writeRetryPolicy = nonIdempotentWriteRetriesEnabled ? (useTrackingIdPropertyForCreateAndReplace ? WriteRetryPolicy.WITH_TRACKING_ID : WriteRetryPolicy.WITH_RETRIES) : WriteRetryPolicy.DISABLED;
        return this;
    }

    WriteRetryPolicy getNonIdempotentWriteRetryPolicy() {
        return this.writeRetryPolicy;
    }

    void resetNonIdempotentWriteRetryPolicy() {
        String writePolicyName = Configs.getNonIdempotentWriteRetryPolicy();
        if (writePolicyName != null) {
            if (writePolicyName.equalsIgnoreCase("NO_RETRIES")) {
                this.writeRetryPolicy = WriteRetryPolicy.DISABLED;
                return;
            }
            if (writePolicyName.equalsIgnoreCase("WITH_TRACKING_ID")) {
                this.writeRetryPolicy = WriteRetryPolicy.WITH_TRACKING_ID;
                return;
            }
            if (writePolicyName.equalsIgnoreCase("WITH_RETRIES")) {
                this.writeRetryPolicy = WriteRetryPolicy.WITH_RETRIES;
                return;
            }
        }
        this.writeRetryPolicy = WriteRetryPolicy.DISABLED;
    }

    public CosmosClientBuilder openConnectionsAndInitCaches(CosmosContainerProactiveInitConfig proactiveContainerInitConfig) {
        this.proactiveContainerInitConfig = proactiveContainerInitConfig;
        return this;
    }

    public CosmosClientBuilder endToEndOperationLatencyPolicyConfig(CosmosEndToEndOperationLatencyPolicyConfig cosmosEndToEndOperationLatencyPolicyConfig) {
        this.cosmosEndToEndOperationLatencyPolicyConfig = cosmosEndToEndOperationLatencyPolicyConfig;
        return this;
    }

    public CosmosClientBuilder sessionRetryOptions(SessionRetryOptions sessionRetryOptions) {
        this.sessionRetryOptions = sessionRetryOptions;
        return this;
    }

    public CosmosClientBuilder excludedRegionsSupplier(Supplier<CosmosExcludedRegions> excludedRegionsSupplier) {
        this.cosmosExcludedRegionsSupplier = excludedRegionsSupplier;
        return this;
    }

    Set<String> getExcludedRegions() {
        if (this.cosmosExcludedRegionsSupplier != null && this.cosmosExcludedRegionsSupplier.get() != null) {
            return this.cosmosExcludedRegionsSupplier.get().getExcludedRegions();
        }
        return new HashSet<String>();
    }

    SessionRetryOptions getSessionRetryOptions() {
        return this.sessionRetryOptions;
    }

    CosmosEndToEndOperationLatencyPolicyConfig getEndToEndOperationConfig() {
        return this.cosmosEndToEndOperationLatencyPolicyConfig;
    }

    GatewayConnectionConfig getGatewayConnectionConfig() {
        return this.gatewayConnectionConfig;
    }

    DirectConnectionConfig getDirectConnectionConfig() {
        return this.directConnectionConfig;
    }

    String getUserAgentSuffix() {
        return this.userAgentSuffix;
    }

    ThrottlingRetryOptions getThrottlingRetryOptions() {
        return this.throttlingRetryOptions;
    }

    List<String> getPreferredRegions() {
        return this.preferredRegions != null ? this.preferredRegions : Collections.emptyList();
    }

    boolean isEndpointDiscoveryEnabled() {
        return this.endpointDiscoveryEnabled;
    }

    boolean isMultipleWriteRegionsEnabled() {
        return this.multipleWriteRegionsEnabled;
    }

    boolean isClientTelemetryEnabled() {
        Boolean explicitlySetInConfig = ImplementationBridgeHelpers.CosmosClientTelemetryConfigHelper.getCosmosClientTelemetryConfigAccessor().isSendClientTelemetryToServiceEnabled(this.clientTelemetryConfig);
        if (this.clientTelemetryEnabledOverride != null) {
            return this.clientTelemetryEnabledOverride;
        }
        if (explicitlySetInConfig != null) {
            return explicitlySetInConfig;
        }
        return false;
    }

    boolean isReadRequestsFallbackEnabled() {
        return this.readRequestsFallbackEnabled;
    }

    CosmosClientTelemetryConfig getClientTelemetryConfig() {
        return this.clientTelemetryConfig;
    }

    public CosmosClientBuilder clientTelemetryConfig(CosmosClientTelemetryConfig telemetryConfig) {
        this.ifThrowIllegalArgException(telemetryConfig == null, "Parameter 'telemetryConfig' must not be null.");
        Boolean explicitValueFromConfig = ImplementationBridgeHelpers.CosmosClientTelemetryConfigHelper.getCosmosClientTelemetryConfigAccessor().isSendClientTelemetryToServiceEnabled(telemetryConfig);
        if (explicitValueFromConfig != null) {
            this.clientTelemetryEnabledOverride = null;
        }
        this.clientTelemetryConfig = telemetryConfig;
        return this;
    }

    public CosmosAsyncClient buildAsyncClient() {
        return this.buildAsyncClient(true);
    }

    CosmosAsyncClient buildAsyncClient(boolean logStartupInfo) {
        StopWatch stopwatch = new StopWatch();
        stopwatch.start();
        this.validateConfig();
        this.buildConnectionPolicy();
        CosmosAsyncClient cosmosAsyncClient = new CosmosAsyncClient(this);
        if (this.proactiveContainerInitConfig != null) {
            cosmosAsyncClient.recordOpenConnectionsAndInitCachesStarted(this.proactiveContainerInitConfig.getCosmosContainerIdentities());
            Duration aggressiveWarmupDuration = this.proactiveContainerInitConfig.getAggressiveWarmupDuration();
            if (aggressiveWarmupDuration != null) {
                cosmosAsyncClient.openConnectionsAndInitCaches(aggressiveWarmupDuration);
            } else {
                cosmosAsyncClient.openConnectionsAndInitCaches();
            }
            cosmosAsyncClient.recordOpenConnectionsAndInitCachesCompleted(this.proactiveContainerInitConfig.getCosmosContainerIdentities());
        } else {
            cosmosAsyncClient.recordOpenConnectionsAndInitCachesCompleted(new ArrayList<CosmosContainerIdentity>());
        }
        if (logStartupInfo) {
            this.logStartupInfo(stopwatch, cosmosAsyncClient);
        }
        return cosmosAsyncClient;
    }

    public CosmosClient buildClient() {
        StopWatch stopwatch = new StopWatch();
        stopwatch.start();
        this.validateConfig();
        this.buildConnectionPolicy();
        CosmosClient cosmosClient = new CosmosClient(this);
        if (this.proactiveContainerInitConfig != null) {
            cosmosClient.recordOpenConnectionsAndInitCachesStarted(this.proactiveContainerInitConfig.getCosmosContainerIdentities());
            Duration aggressiveWarmupDuration = this.proactiveContainerInitConfig.getAggressiveWarmupDuration();
            if (aggressiveWarmupDuration != null) {
                cosmosClient.openConnectionsAndInitCaches(aggressiveWarmupDuration);
            } else {
                cosmosClient.openConnectionsAndInitCaches();
            }
            cosmosClient.recordOpenConnectionsAndInitCachesCompleted(this.proactiveContainerInitConfig.getCosmosContainerIdentities());
        }
        this.logStartupInfo(stopwatch, cosmosClient.asyncClient());
        return cosmosClient;
    }

    ConnectionPolicy buildConnectionPolicy() {
        if (this.directConnectionConfig != null) {
            if (this.gatewayConnectionConfig == null) {
                this.gatewayConnectionConfig = GatewayConnectionConfig.getDefaultConfig();
            }
            this.connectionPolicy = new ConnectionPolicy(this.directConnectionConfig, this.gatewayConnectionConfig);
        } else if (this.gatewayConnectionConfig != null) {
            this.connectionPolicy = new ConnectionPolicy(this.gatewayConnectionConfig);
        }
        this.connectionPolicy.setPreferredRegions(this.preferredRegions);
        this.connectionPolicy.setExcludedRegionsSupplier(this.cosmosExcludedRegionsSupplier);
        this.connectionPolicy.setUserAgentSuffix(this.userAgentSuffix);
        this.connectionPolicy.setThrottlingRetryOptions(this.throttlingRetryOptions);
        this.connectionPolicy.setEndpointDiscoveryEnabled(this.endpointDiscoveryEnabled);
        this.connectionPolicy.setMultipleWriteRegionsEnabled(this.multipleWriteRegionsEnabled);
        this.connectionPolicy.setReadRequestsFallbackEnabled(this.readRequestsFallbackEnabled);
        return this.connectionPolicy;
    }

    private void validateConfig() {
        URI uri;
        try {
            uri = new URI(this.serviceEndpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("invalid serviceEndpoint", e);
        }
        if (this.preferredRegions != null) {
            this.preferredRegions.forEach(preferredRegion -> {
                Preconditions.checkArgument(StringUtils.trimToNull(preferredRegion) != null, "preferredRegion can't be empty");
                String trimmedPreferredRegion = preferredRegion.toLowerCase(Locale.ROOT).replace(" ", "");
                LocationHelper.getLocationEndpoint(uri, trimmedPreferredRegion);
            });
        }
        if (this.proactiveContainerInitConfig != null) {
            Preconditions.checkArgument(this.preferredRegions != null, "preferredRegions cannot be null when proactiveContainerInitConfig has been set");
            Preconditions.checkArgument(this.proactiveContainerInitConfig.getProactiveConnectionRegionsCount() <= this.preferredRegions.size(), "no. of regions to proactively connect to cannot be greater than the no.of preferred regions");
            if (this.proactiveContainerInitConfig.getProactiveConnectionRegionsCount() > 1) {
                Preconditions.checkArgument(this.isEndpointDiscoveryEnabled(), "endpoint discovery should be enabled when no. of proactive regions is greater than 1");
            }
        }
        this.ifThrowIllegalArgException(this.serviceEndpoint == null, "cannot buildAsyncClient client without service endpoint");
        this.ifThrowIllegalArgException(this.keyOrResourceToken == null && (this.permissions == null || this.permissions.isEmpty()) && this.credential == null && this.tokenCredential == null && this.cosmosAuthorizationTokenResolver == null, "cannot buildAsyncClient client without any one of key, resource token, permissions, and azure key credential");
        this.ifThrowIllegalArgException(this.credential != null && StringUtils.isEmpty(this.credential.getKey()), "cannot buildAsyncClient client without key credential");
    }

    Configs configs() {
        return this.configs;
    }

    CosmosClientBuilder configs(Configs configs) {
        this.configs = configs;
        return this;
    }

    private void ifThrowIllegalArgException(boolean value, String error) {
        if (value) {
            throw new IllegalArgumentException(error);
        }
    }

    private void logStartupInfo(StopWatch stopwatch, CosmosAsyncClient client) {
        stopwatch.stop();
        if (logger.isInfoEnabled()) {
            DiagnosticsProvider provider;
            long time = stopwatch.getTime();
            String diagnosticsCfg = "";
            String tracingCfg = "";
            if (client.getClientTelemetryConfig() != null) {
                diagnosticsCfg = client.getClientTelemetryConfig().toString();
            }
            if ((provider = client.getDiagnosticsProvider()) != null) {
                tracingCfg = provider.getTraceConfigLog();
            }
            logger.info("Cosmos Client with (Correlation) ID [{}] started up in [{}] ms with the following configuration: serviceEndpoint [{}], preferredRegions [{}], excludedRegions [{}], connectionPolicy [{}], consistencyLevel [{}], contentResponseOnWriteEnabled [{}], sessionCapturingOverride [{}], connectionSharingAcrossClients [{}], clientTelemetryEnabled [{}], proactiveContainerInit [{}], diagnostics [{}], tracing [{}]", new Object[]{client.getContextClient().getClientCorrelationId(), time, this.getEndpoint(), this.getPreferredRegions(), this.getExcludedRegions(), this.getConnectionPolicy(), this.getConsistencyLevel(), this.isContentResponseOnWriteEnabled(), this.isSessionCapturingOverrideEnabled(), this.isConnectionSharingAcrossClientsEnabled(), this.isClientTelemetryEnabled(), this.getProactiveContainerInitConfig(), diagnosticsCfg, tracingCfg});
        }
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosClientBuilderHelper.setCosmosClientBuilderAccessor(new ImplementationBridgeHelpers.CosmosClientBuilderHelper.CosmosClientBuilderAccessor(){

            @Override
            public void setCosmosClientMetadataCachesSnapshot(CosmosClientBuilder builder, CosmosClientMetadataCachesSnapshot metadataCache) {
                builder.metadataCaches(metadataCache);
            }

            @Override
            public CosmosClientMetadataCachesSnapshot getCosmosClientMetadataCachesSnapshot(CosmosClientBuilder builder) {
                return builder.metadataCaches();
            }

            @Override
            public void setCosmosClientApiType(CosmosClientBuilder builder, ApiType apiType) {
                builder.setApiType(apiType);
            }

            @Override
            public ApiType getCosmosClientApiType(CosmosClientBuilder builder) {
                return builder.apiType();
            }

            @Override
            public ConnectionPolicy getConnectionPolicy(CosmosClientBuilder builder) {
                return builder.getConnectionPolicy();
            }

            @Override
            public ConnectionPolicy buildConnectionPolicy(CosmosClientBuilder builder) {
                return builder.buildConnectionPolicy();
            }

            @Override
            public Configs getConfigs(CosmosClientBuilder builder) {
                return builder.configs();
            }

            @Override
            public ConsistencyLevel getConsistencyLevel(CosmosClientBuilder builder) {
                return builder.getConsistencyLevel();
            }

            @Override
            public String getEndpoint(CosmosClientBuilder builder) {
                return builder.getEndpoint();
            }
        });
    }

    static {
        CosmosClientBuilder.initialize();
    }
}

