/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.patch;

import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.patch.PatchOperation;
import com.azure.cosmos.implementation.patch.PatchOperationType;

public final class PatchOperationCore<T>
extends PatchOperation {
    private final String path;
    private final String from;
    private final T resource;

    public PatchOperationCore(PatchOperationType operationType, String path, T value) {
        super(operationType);
        Preconditions.checkArgument(StringUtils.isNotEmpty(path), "path empty %s", (Object)path);
        if (operationType == PatchOperationType.MOVE) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("Parameter 'value' is not of type 'String'");
            }
            Preconditions.checkArgument(StringUtils.isNotEmpty((String)value), "Parameter 'value' cannot be empty %s", (Object)((String)value));
            this.path = path;
            this.from = (String)value;
            this.resource = null;
        } else {
            this.path = path;
            this.resource = value;
            this.from = null;
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getFrom() {
        return this.from;
    }

    public T getResource() {
        return this.resource;
    }
}

