/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.RequestTimeline;
import com.azure.cosmos.implementation.query.QueryInfo;
import com.azure.cosmos.implementation.routing.Range;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;

public final class PartitionedQueryExecutionInfo
extends JsonSerializable {
    private static final Class<Range<String>> QUERY_RANGES_CLASS = Range.getEmptyRange(null).getClass();
    private QueryInfo queryInfo;
    private List<Range<String>> queryRanges;
    private RequestTimeline queryPlanRequestTimeline;

    PartitionedQueryExecutionInfo(QueryInfo queryInfo, List<Range<String>> queryRanges) {
        this.queryInfo = queryInfo;
        this.queryRanges = queryRanges;
        BridgeInternal.setProperty(this, "partitionedQueryExecutionInfoVersion", 1);
    }

    public PartitionedQueryExecutionInfo(ObjectNode content, RequestTimeline queryPlanRequestTimeline) {
        super(content);
        this.queryPlanRequestTimeline = queryPlanRequestTimeline;
    }

    public PartitionedQueryExecutionInfo(String jsonString) {
        super(jsonString);
    }

    public int getVersion() {
        return super.getInt("partitionedQueryExecutionInfoVersion");
    }

    public QueryInfo getQueryInfo() {
        return this.queryInfo != null ? this.queryInfo : (this.queryInfo = super.getObject("queryInfo", QueryInfo.class, new boolean[0]));
    }

    public List<Range<String>> getQueryRanges() {
        return this.queryRanges != null ? this.queryRanges : (this.queryRanges = super.getList("queryRanges", QUERY_RANGES_CLASS, new boolean[0]));
    }

    public RequestTimeline getQueryPlanRequestTimeline() {
        return this.queryPlanRequestTimeline;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

