/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.PartitionKeyHelper;
import com.azure.cosmos.implementation.Undefined;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.models.PartitionKey;
import java.util.ArrayList;
import java.util.List;

public final class PartitionKeyBuilder {
    private final List<Object> partitionKeyValues = new ArrayList<Object>();

    public PartitionKeyBuilder add(String value) {
        this.partitionKeyValues.add(value);
        return this;
    }

    public PartitionKeyBuilder add(double value) {
        this.partitionKeyValues.add(value);
        return this;
    }

    public PartitionKeyBuilder add(boolean value) {
        this.partitionKeyValues.add(value);
        return this;
    }

    @Deprecated
    public PartitionKeyBuilder addNullValue() {
        this.partitionKeyValues.add(null);
        return this;
    }

    @Deprecated
    public PartitionKeyBuilder addNoneValue() {
        this.partitionKeyValues.add(PartitionKey.NONE);
        return this;
    }

    public PartitionKey build() {
        if (this.partitionKeyValues.size() == 0) {
            throw new IllegalArgumentException("No partition key value has been specified");
        }
        if (this.partitionKeyValues.size() == 1 && PartitionKey.NONE.equals(this.partitionKeyValues.get(0))) {
            return PartitionKey.NONE;
        }
        if (this.partitionKeyValues.size() > 1 && this.partitionKeyValues.contains(PartitionKey.NONE)) {
            throw new IllegalStateException("PartitionKey.None can't be used with multiple paths");
        }
        Object[] valueArray = new Object[this.partitionKeyValues.size()];
        for (int i = 0; i < this.partitionKeyValues.size(); ++i) {
            Object val = this.partitionKeyValues.get(i);
            valueArray[i] = PartitionKey.NONE.equals(val) ? Undefined.value() : val;
        }
        PartitionKeyInternal partitionKeyInternal = PartitionKeyInternal.fromObjectArray(valueArray, true);
        return new PartitionKey(PartitionKeyHelper.getPartitionKeyObjectKey(valueArray), partitionKeyInternal);
    }
}

