/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.IRetryPolicy;
import com.azure.cosmos.implementation.RetryContext;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.ShouldRetryResult;
import com.azure.cosmos.implementation.apachecommons.lang.time.StopWatch;
import com.azure.cosmos.implementation.directconnectivity.WebExceptionUtility;
import com.azure.cosmos.implementation.http.HttpTimeoutPolicy;
import com.azure.cosmos.implementation.http.HttpTimeoutPolicyDefault;
import java.net.URI;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class WebExceptionRetryPolicy
implements IRetryPolicy {
    private static final Logger logger = LoggerFactory.getLogger(WebExceptionRetryPolicy.class);
    private StopWatch durationTimer = new StopWatch();
    private RetryContext retryContext;
    private RxDocumentServiceRequest request;
    private HttpTimeoutPolicy timeoutPolicy;
    private boolean isReadRequest;
    private int retryCount = 0;
    private URI locationEndpoint;

    public WebExceptionRetryPolicy() {
        this.durationTimer.start();
    }

    public WebExceptionRetryPolicy(RetryContext retryContext) {
        this.durationTimer.start();
        this.retryContext = retryContext;
        this.timeoutPolicy = HttpTimeoutPolicyDefault.INSTANCE;
    }

    @Override
    public Mono<ShouldRetryResult> shouldRetry(Exception e) {
        if (this.isOutOfRetries()) {
            logger.warn("WebExceptionRetryPolicy() No more retrying on endpoint {}, operationType = {}, count = {}, isAddressRefresh = {}", new Object[]{this.locationEndpoint, this.request.getOperationType(), this.retryCount, this.request.isAddressRefresh()});
            this.durationTimer.stop();
            return Mono.just((Object)ShouldRetryResult.noRetry());
        }
        if (WebExceptionUtility.isNetworkFailure(e) && (this.isReadRequest || this.request.isAddressRefresh() || WebExceptionUtility.isWebExceptionRetriable(e))) {
            int delayInSeconds = this.timeoutPolicy.getTimeoutAndDelaysList().get(this.retryCount).getDelayForNextRequestInSeconds();
            ++this.retryCount;
            logger.debug("WebExceptionRetryPolicy() Retrying on endpoint {}, operationType = {}, resourceType = {}, count = {}, isAddressRefresh = {}, shouldForcedAddressRefresh = {}, shouldForceCollectionRoutingMapRefresh = {}", new Object[]{this.locationEndpoint, this.request.getOperationType(), this.request.getResourceType(), this.retryCount, this.request.isAddressRefresh(), this.request.shouldForceAddressRefresh(), this.request.forceCollectionRoutingMapRefresh});
            this.request.setResponseTimeout(this.timeoutPolicy.getTimeoutAndDelaysList().get(this.retryCount).getResponseTimeout());
            return Mono.just((Object)ShouldRetryResult.retryAfter(Duration.ofSeconds(delayInSeconds)));
        }
        logger.debug("WebExceptionRetryPolicy() No retrying on un-retryable exceptions on endpoint {}, operationType = {}, resourceType = {}, count = {}, isAddressRefresh = {}", new Object[]{this.locationEndpoint, this.request.getOperationType(), this.request.getResourceType(), this.retryCount, this.request.isAddressRefresh()});
        this.durationTimer.stop();
        return Mono.just((Object)ShouldRetryResult.noRetryOnNonRelatedException());
    }

    @Override
    public RetryContext getRetryContext() {
        return this.retryContext;
    }

    public void onBeforeSendRequest(RxDocumentServiceRequest request) {
        this.request = request;
        this.isReadRequest = request.isReadOnlyRequest();
        this.timeoutPolicy = HttpTimeoutPolicy.getTimeoutPolicy(request);
        this.request.setResponseTimeout(this.timeoutPolicy.getTimeoutAndDelaysList().get(0).getResponseTimeout());
        this.locationEndpoint = request.requestContext.locationEndpointToRoute;
    }

    private boolean isOutOfRetries() {
        return this.retryCount >= this.timeoutPolicy.totalRetryCount();
    }
}

