/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.CosmosDiagnosticsThresholds;
import com.azure.cosmos.implementation.CosmosPagedFluxOptions;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.apachecommons.collections.list.UnmodifiableList;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedMode;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedStartFromInternal;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedState;
import com.azure.cosmos.implementation.feedranges.FeedRangeContinuation;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.query.CompositeContinuationToken;
import com.azure.cosmos.implementation.spark.OperationContextAndListenerTuple;
import com.azure.cosmos.models.FeedRange;
import com.azure.cosmos.util.Beta;
import com.fasterxml.jackson.databind.JsonNode;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public final class CosmosChangeFeedRequestOptions {
    private static final int DEFAULT_MAX_ITEM_COUNT = 100;
    private static final int DEFAULT_MAX_PREFETCH_PAGE_COUNT = 1;
    private final ChangeFeedState continuationState;
    private final FeedRangeInternal feedRangeInternal;
    private final Map<String, Object> properties;
    private int maxItemCount;
    private int maxPrefetchPageCount;
    private ChangeFeedMode mode;
    private ChangeFeedStartFromInternal startFromInternal;
    private boolean isSplitHandlingDisabled;
    private boolean quotaInfoEnabled;
    private String throughputControlGroupName;
    private Map<String, String> customOptions;
    private OperationContextAndListenerTuple operationContextAndListenerTuple;
    private Function<JsonNode, ?> itemFactoryMethod;
    private CosmosDiagnosticsThresholds thresholds;
    private List<String> excludeRegions;

    private CosmosChangeFeedRequestOptions(FeedRangeInternal feedRange, ChangeFeedStartFromInternal startFromInternal, ChangeFeedMode mode, ChangeFeedState continuationState) {
        if (feedRange == null) {
            throw new NullPointerException("feedRange");
        }
        if (startFromInternal == null) {
            throw new NullPointerException("startFromInternal");
        }
        this.maxItemCount = 100;
        this.maxPrefetchPageCount = 1;
        this.feedRangeInternal = feedRange;
        this.startFromInternal = startFromInternal;
        this.continuationState = continuationState;
        if (mode != ChangeFeedMode.INCREMENTAL && mode != ChangeFeedMode.FULL_FIDELITY) {
            throw new IllegalArgumentException(String.format("Argument 'mode' has unsupported change feed mode %s", mode.toString()));
        }
        this.mode = mode;
        if (this.mode == ChangeFeedMode.FULL_FIDELITY) {
            this.addCustomOptionsForFullFidelityMode();
        }
        this.properties = new HashMap<String, Object>();
        this.isSplitHandlingDisabled = false;
    }

    ChangeFeedState getContinuation() {
        return this.continuationState;
    }

    public FeedRange getFeedRange() {
        return this.feedRangeInternal;
    }

    public int getMaxItemCount() {
        return this.maxItemCount;
    }

    public CosmosChangeFeedRequestOptions setMaxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public int getMaxPrefetchPageCount() {
        return this.maxPrefetchPageCount;
    }

    public CosmosChangeFeedRequestOptions setMaxPrefetchPageCount(int maxPrefetchPageCount) {
        Preconditions.checkArgument(maxPrefetchPageCount > 0, "Argument 'maxPrefetchCount' must be larger than 0.");
        this.maxPrefetchPageCount = maxPrefetchPageCount;
        return this;
    }

    public boolean isQuotaInfoEnabled() {
        return this.quotaInfoEnabled;
    }

    public void setQuotaInfoEnabled(boolean quotaInfoEnabled) {
        this.quotaInfoEnabled = quotaInfoEnabled;
    }

    public CosmosChangeFeedRequestOptions setDiagnosticsThresholds(CosmosDiagnosticsThresholds operationSpecificThresholds) {
        this.thresholds = operationSpecificThresholds;
        return this;
    }

    public CosmosDiagnosticsThresholds getDiagnosticsThresholds() {
        return this.thresholds;
    }

    boolean isSplitHandlingDisabled() {
        return this.isSplitHandlingDisabled;
    }

    CosmosChangeFeedRequestOptions disableSplitHandling() {
        this.isSplitHandlingDisabled = true;
        return this;
    }

    ChangeFeedMode getMode() {
        return this.mode;
    }

    Map<String, Object> getProperties() {
        return this.properties;
    }

    ChangeFeedStartFromInternal getStartFromSettings() {
        return this.startFromInternal;
    }

    public static CosmosChangeFeedRequestOptions createForProcessingFromBeginning(FeedRange feedRange) {
        Preconditions.checkNotNull(feedRange, "Argument 'feedRange' must not be null.");
        return new CosmosChangeFeedRequestOptions(FeedRangeInternal.convert(feedRange), ChangeFeedStartFromInternal.createFromBeginning(), ChangeFeedMode.INCREMENTAL, null);
    }

    public static CosmosChangeFeedRequestOptions createForProcessingFromContinuation(String continuation) {
        ChangeFeedState changeFeedState = ChangeFeedState.fromString(continuation);
        return CosmosChangeFeedRequestOptions.createForProcessingFromContinuation(changeFeedState);
    }

    static CosmosChangeFeedRequestOptions createForProcessingFromContinuation(ChangeFeedState changeFeedState) {
        FeedRangeInternal feedRange = changeFeedState.getFeedRange();
        FeedRangeContinuation continuation = changeFeedState.getContinuation();
        ChangeFeedMode mode = changeFeedState.getMode();
        if (continuation != null) {
            CompositeContinuationToken continuationToken = continuation.getCurrentContinuationToken();
            if (continuationToken != null) {
                String etag = continuationToken.getToken();
                return new CosmosChangeFeedRequestOptions(feedRange, ChangeFeedStartFromInternal.createFromETagAndFeedRange(etag, feedRange), mode, changeFeedState);
            }
            return new CosmosChangeFeedRequestOptions(feedRange, ChangeFeedStartFromInternal.createFromBeginning(), mode, changeFeedState);
        }
        return new CosmosChangeFeedRequestOptions(feedRange, changeFeedState.getStartFromSettings(), mode, changeFeedState);
    }

    public static CosmosChangeFeedRequestOptions createForProcessingFromNow(FeedRange feedRange) {
        if (feedRange == null) {
            throw new NullPointerException("feedRange");
        }
        return new CosmosChangeFeedRequestOptions(FeedRangeInternal.convert(feedRange), ChangeFeedStartFromInternal.createFromNow(), ChangeFeedMode.INCREMENTAL, null);
    }

    public static CosmosChangeFeedRequestOptions createForProcessingFromPointInTime(Instant pointInTime, FeedRange feedRange) {
        if (pointInTime == null) {
            throw new NullPointerException("pointInTime");
        }
        if (feedRange == null) {
            throw new NullPointerException("feedRange");
        }
        return new CosmosChangeFeedRequestOptions(FeedRangeInternal.convert(feedRange), ChangeFeedStartFromInternal.createFromPointInTime(pointInTime), ChangeFeedMode.INCREMENTAL, null);
    }

    void setRequestContinuation(String etag) {
        this.startFromInternal = ChangeFeedStartFromInternal.createFromETagAndFeedRange(etag, this.feedRangeInternal);
    }

    CosmosChangeFeedRequestOptions withCosmosPagedFluxOptions(CosmosPagedFluxOptions pagedFluxOptions) {
        if (pagedFluxOptions == null) {
            return this;
        }
        CosmosChangeFeedRequestOptions effectiveRequestOptions = this;
        if (pagedFluxOptions.getRequestContinuation() != null) {
            effectiveRequestOptions = CosmosChangeFeedRequestOptions.createForProcessingFromContinuation(pagedFluxOptions.getRequestContinuation());
            effectiveRequestOptions.setMaxPrefetchPageCount(this.getMaxPrefetchPageCount());
            effectiveRequestOptions.setThroughputControlGroupName(this.getThroughputControlGroupName());
        }
        if (pagedFluxOptions.getMaxItemCount() != null) {
            effectiveRequestOptions.setMaxItemCount(pagedFluxOptions.getMaxItemCount());
        }
        return effectiveRequestOptions;
    }

    @Deprecated
    @Beta(value=Beta.SinceVersion.V4_12_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosChangeFeedRequestOptions fullFidelity() {
        if (!this.startFromInternal.supportsFullFidelityRetention()) {
            throw new IllegalStateException("Full fidelity retention is not supported for the chosen change feed start from option. Use CosmosChangeFeedRequestOptions.createForProcessingFromNow or CosmosChangeFeedRequestOptions.createFromContinuation instead.");
        }
        this.mode = ChangeFeedMode.FULL_FIDELITY;
        this.addCustomOptionsForFullFidelityMode();
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_37_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosChangeFeedRequestOptions allVersionsAndDeletes() {
        if (!this.startFromInternal.supportsFullFidelityRetention()) {
            throw new IllegalStateException("All Versions and Deletes mode is not supported for the chosen change feed start from option. Use CosmosChangeFeedRequestOptions.createForProcessingFromNow or CosmosChangeFeedRequestOptions.createFromContinuation instead.");
        }
        this.mode = ChangeFeedMode.FULL_FIDELITY;
        this.addCustomOptionsForFullFidelityMode();
        return this;
    }

    public String getThroughputControlGroupName() {
        return this.throughputControlGroupName;
    }

    public CosmosChangeFeedRequestOptions setThroughputControlGroupName(String throughputControlGroupName) {
        this.throughputControlGroupName = throughputControlGroupName;
        return this;
    }

    public CosmosChangeFeedRequestOptions setExcludedRegions(List<String> excludeRegions) {
        this.excludeRegions = excludeRegions;
        return this;
    }

    public List<String> getExcludedRegions() {
        if (this.excludeRegions == null) {
            return null;
        }
        return UnmodifiableList.unmodifiableList(this.excludeRegions);
    }

    CosmosChangeFeedRequestOptions setHeader(String name, String value) {
        if (this.customOptions == null) {
            this.customOptions = new HashMap<String, String>();
        }
        this.customOptions.put(name, value);
        return this;
    }

    Map<String, String> getHeaders() {
        return this.customOptions;
    }

    void setOperationContextAndListenerTuple(OperationContextAndListenerTuple operationContextAndListenerTuple) {
        this.operationContextAndListenerTuple = operationContextAndListenerTuple;
    }

    OperationContextAndListenerTuple getOperationContextAndListenerTuple() {
        return this.operationContextAndListenerTuple;
    }

    Function<JsonNode, ?> getItemFactoryMethod() {
        return this.itemFactoryMethod;
    }

    CosmosChangeFeedRequestOptions setItemFactoryMethod(Function<JsonNode, ?> factoryMethod) {
        this.itemFactoryMethod = factoryMethod;
        return this;
    }

    private void addCustomOptionsForFullFidelityMode() {
        this.setHeader("x-ms-cosmos-changefeed-wire-format-version", "2021-09-15");
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosChangeFeedRequestOptionsHelper.setCosmosChangeFeedRequestOptionsAccessor(new ImplementationBridgeHelpers.CosmosChangeFeedRequestOptionsHelper.CosmosChangeFeedRequestOptionsAccessor(){

            @Override
            public CosmosChangeFeedRequestOptions setHeader(CosmosChangeFeedRequestOptions changeFeedRequestOptions, String name, String value) {
                return changeFeedRequestOptions.setHeader(name, value);
            }

            @Override
            public Map<String, String> getHeader(CosmosChangeFeedRequestOptions changeFeedRequestOptions) {
                return changeFeedRequestOptions.getHeaders();
            }

            @Override
            public void setOperationContext(CosmosChangeFeedRequestOptions changeFeedRequestOptions, OperationContextAndListenerTuple operationContextAndListenerTuple) {
                changeFeedRequestOptions.setOperationContextAndListenerTuple(operationContextAndListenerTuple);
            }

            @Override
            public OperationContextAndListenerTuple getOperationContext(CosmosChangeFeedRequestOptions changeFeedRequestOptions) {
                return changeFeedRequestOptions.getOperationContextAndListenerTuple();
            }

            @Override
            public <T> Function<JsonNode, T> getItemFactoryMethod(CosmosChangeFeedRequestOptions options, Class<T> classOfT) {
                return options.getItemFactoryMethod();
            }

            @Override
            public CosmosChangeFeedRequestOptions setItemFactoryMethod(CosmosChangeFeedRequestOptions options, Function<JsonNode, ?> factoryMethod) {
                return options.setItemFactoryMethod(factoryMethod);
            }

            @Override
            public CosmosDiagnosticsThresholds getDiagnosticsThresholds(CosmosChangeFeedRequestOptions options) {
                return options.thresholds;
            }

            @Override
            public List<String> getExcludeRegions(CosmosChangeFeedRequestOptions cosmosChangeFeedRequestOptions) {
                return cosmosChangeFeedRequestOptions.excludeRegions;
            }
        });
    }

    static {
        CosmosChangeFeedRequestOptions.initialize();
    }
}

