/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.JsonSerializable;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class ReplicationPolicy
extends JsonSerializable {
    private static final int DEFAULT_MAX_REPLICA_SET_SIZE = 4;
    private static final int DEFAULT_MIN_REPLICA_SET_SIZE = 3;
    private int maxReplicaSetSize;
    private int minReplicaSetSize;

    public ReplicationPolicy() {
    }

    public ReplicationPolicy(ObjectNode objectNode) {
        super(objectNode);
    }

    public ReplicationPolicy(String jsonString) {
        super(jsonString);
    }

    public int getMaxReplicaSetSize() {
        if (this.maxReplicaSetSize == 0) {
            Integer maxReplicaSetSizeFromJsonPayload = super.getInt("maxReplicasetSize");
            if (maxReplicaSetSizeFromJsonPayload == null) {
                maxReplicaSetSizeFromJsonPayload = 4;
            }
            this.maxReplicaSetSize = maxReplicaSetSizeFromJsonPayload;
        }
        return this.maxReplicaSetSize;
    }

    public void setMaxReplicaSetSize(int value) {
        BridgeInternal.setProperty(this, "maxReplicasetSize", value);
        this.maxReplicaSetSize = value;
    }

    public int getMinReplicaSetSize() {
        if (this.minReplicaSetSize == 0) {
            Integer minReplicaSetSizeFromJsonPayload = super.getInt("minReplicaSetSize");
            if (minReplicaSetSizeFromJsonPayload == null) {
                minReplicaSetSizeFromJsonPayload = 3;
            }
            this.minReplicaSetSize = minReplicaSetSizeFromJsonPayload;
        }
        return this.minReplicaSetSize;
    }
}

