/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.BackoffRetryUtility;
import com.azure.cosmos.implementation.IRetryPolicy;
import com.azure.cosmos.implementation.Quadruple;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.time.StopWatch;
import java.time.Duration;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RetryUtils {
    private static final Logger logger = LoggerFactory.getLogger(BackoffRetryUtility.class);

    static Function<Flux<Throwable>, Flux<Long>> toRetryWhenFunc(IRetryPolicy policy) {
        return throwableFlux -> throwableFlux.flatMap(t -> {
            Exception e = Utils.as(t, Exception.class);
            if (e == null) {
                return Flux.error((Throwable)t);
            }
            policy.captureStartTimeIfNotSet();
            Flux shouldRetryResultFlux = policy.shouldRetry(e).flux();
            return shouldRetryResultFlux.flatMap(s -> {
                CosmosException clientException = Utils.as(e, CosmosException.class);
                if (clientException != null) {
                    policy.addStatusAndSubStatusCode(null, clientException.getStatusCode(), clientException.getSubStatusCode());
                }
                if (s.backOffTime != null) {
                    policy.incrementRetry();
                    return Mono.delay((Duration)Duration.ofMillis(s.backOffTime.toMillis())).flux();
                }
                if (s.exception != null) {
                    return Flux.error((Throwable)s.exception);
                }
                return Flux.error((Throwable)t);
            });
        });
    }

    public static <T> Function<Throwable, Mono<T>> toRetryWithAlternateFunc(Function<Quadruple<Boolean, Boolean, Duration, Integer>, Mono<T>> callbackMethod, IRetryPolicy retryPolicy, Function<Quadruple<Boolean, Boolean, Duration, Integer>, Mono<T>> inBackoffAlternateCallbackMethod, Duration minBackoffForInBackoffCallback, RxDocumentServiceRequest rxDocumentServiceRequest) {
        return throwable -> {
            Exception e;
            if (rxDocumentServiceRequest.requestContext != null && retryPolicy.getRetryCount() > 0) {
                retryPolicy.updateEndTime();
                rxDocumentServiceRequest.requestContext.updateRetryContext(retryPolicy, false);
            }
            if ((e = Utils.as(throwable, Exception.class)) == null) {
                return Mono.error((Throwable)throwable);
            }
            retryPolicy.captureStartTimeIfNotSet();
            Mono<IRetryPolicy.ShouldRetryResult> shouldRetryResultFlux = retryPolicy.shouldRetry(e);
            return shouldRetryResultFlux.flatMap(shouldRetryResult -> {
                CosmosException clientException = Utils.as(e, CosmosException.class);
                if (clientException != null) {
                    retryPolicy.addStatusAndSubStatusCode(null, clientException.getStatusCode(), clientException.getSubStatusCode());
                }
                if (!shouldRetryResult.shouldRetry) {
                    retryPolicy.updateEndTime();
                    if (shouldRetryResult.exception == null) {
                        return Mono.error((Throwable)e);
                    }
                    return Mono.error((Throwable)shouldRetryResult.exception);
                }
                retryPolicy.incrementRetry();
                if (rxDocumentServiceRequest.requestContext != null && retryPolicy.getRetryCount() > 0) {
                    retryPolicy.updateEndTime();
                    rxDocumentServiceRequest.requestContext.updateRetryContext(retryPolicy, false);
                }
                if (inBackoffAlternateCallbackMethod != null && shouldRetryResult.backOffTime.compareTo(minBackoffForInBackoffCallback) > 0) {
                    StopWatch stopwatch = new StopWatch();
                    RetryUtils.startStopWatch(stopwatch);
                    return ((Mono)inBackoffAlternateCallbackMethod.apply(shouldRetryResult.policyArg)).onErrorResume(RetryUtils.recurrsiveWithAlternateFunc(callbackMethod, retryPolicy, inBackoffAlternateCallbackMethod, shouldRetryResult, stopwatch, minBackoffForInBackoffCallback, rxDocumentServiceRequest));
                }
                return RetryUtils.recurrsiveFunc(callbackMethod, retryPolicy, inBackoffAlternateCallbackMethod, shouldRetryResult, minBackoffForInBackoffCallback, rxDocumentServiceRequest).delaySubscription(Duration.ofMillis(shouldRetryResult.backOffTime.toMillis()));
            });
        };
    }

    private static <T> Mono<T> recurrsiveFunc(Function<Quadruple<Boolean, Boolean, Duration, Integer>, Mono<T>> callbackMethod, IRetryPolicy retryPolicy, Function<Quadruple<Boolean, Boolean, Duration, Integer>, Mono<T>> inBackoffAlternateCallbackMethod, IRetryPolicy.ShouldRetryResult shouldRetryResult, Duration minBackoffForInBackoffCallback, RxDocumentServiceRequest rxDocumentServiceRequest) {
        return callbackMethod.apply(shouldRetryResult.policyArg).onErrorResume(RetryUtils.toRetryWithAlternateFunc(callbackMethod, retryPolicy, inBackoffAlternateCallbackMethod, minBackoffForInBackoffCallback, rxDocumentServiceRequest));
    }

    private static <T> Function<Throwable, Mono<T>> recurrsiveWithAlternateFunc(Function<Quadruple<Boolean, Boolean, Duration, Integer>, Mono<T>> callbackMethod, IRetryPolicy retryPolicy, Function<Quadruple<Boolean, Boolean, Duration, Integer>, Mono<T>> inBackoffAlternateCallbackMethod, IRetryPolicy.ShouldRetryResult shouldRetryResult, StopWatch stopwatch, Duration minBackoffForInBackoffCallback, RxDocumentServiceRequest rxDocumentServiceRequest) {
        return throwable -> {
            Exception e = Utils.as(throwable, Exception.class);
            if (e == null) {
                return Mono.error((Throwable)throwable);
            }
            RetryUtils.stopStopWatch(stopwatch);
            logger.info("Failed inBackoffAlternateCallback with {}, proceeding with retry. Time taken: {}ms", (Object)e.toString(), (Object)stopwatch.getTime());
            Duration backoffTime = shouldRetryResult.backOffTime.toMillis() > stopwatch.getTime() ? Duration.ofMillis(shouldRetryResult.backOffTime.toMillis() - stopwatch.getTime()) : Duration.ZERO;
            return RetryUtils.recurrsiveFunc(callbackMethod, retryPolicy, inBackoffAlternateCallbackMethod, shouldRetryResult, minBackoffForInBackoffCallback, rxDocumentServiceRequest).delaySubscription((Publisher)Flux.just((Object)0L).delayElements(Duration.ofMillis(backoffTime.toMillis())));
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopStopWatch(StopWatch stopwatch) {
        StopWatch stopWatch = stopwatch;
        synchronized (stopWatch) {
            stopwatch.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startStopWatch(StopWatch stopwatch) {
        StopWatch stopWatch = stopwatch;
        synchronized (stopWatch) {
            stopwatch.start();
        }
    }
}

