/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.http;

import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.http.HttpClient;
import com.azure.cosmos.implementation.http.HttpClientConfig;
import com.azure.cosmos.implementation.http.HttpHeader;
import com.azure.cosmos.implementation.http.HttpHeaders;
import com.azure.cosmos.implementation.http.HttpRequest;
import com.azure.cosmos.implementation.http.HttpResponse;
import com.azure.cosmos.implementation.http.ReactorNettyRequestRecord;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelOption;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.logging.LogLevel;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufFlux;
import reactor.netty.Connection;
import reactor.netty.NettyOutbound;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientRequest;
import reactor.netty.http.client.HttpClientResponse;
import reactor.netty.http.client.HttpClientState;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.tcp.ProxyProvider;

class ReactorNettyClient
implements HttpClient {
    private static final Logger logger = LoggerFactory.getLogger((String)ReactorNettyClient.class.getSimpleName());
    private HttpClientConfig httpClientConfig;
    private reactor.netty.http.client.HttpClient httpClient;
    private ConnectionProvider connectionProvider;

    private ReactorNettyClient() {
    }

    public static ReactorNettyClient create(HttpClientConfig httpClientConfig) {
        ReactorNettyClient reactorNettyClient = new ReactorNettyClient();
        reactorNettyClient.httpClientConfig = httpClientConfig;
        reactorNettyClient.httpClient = reactor.netty.http.client.HttpClient.newConnection();
        reactorNettyClient.configureChannelPipelineHandlers();
        return reactorNettyClient;
    }

    public static ReactorNettyClient createWithConnectionProvider(ConnectionProvider connectionProvider, HttpClientConfig httpClientConfig) {
        ReactorNettyClient reactorNettyClient = new ReactorNettyClient();
        reactorNettyClient.connectionProvider = connectionProvider;
        reactorNettyClient.httpClientConfig = httpClientConfig;
        reactorNettyClient.httpClient = reactor.netty.http.client.HttpClient.create((ConnectionProvider)connectionProvider);
        reactorNettyClient.configureChannelPipelineHandlers();
        return reactorNettyClient;
    }

    private void configureChannelPipelineHandlers() {
        Configs configs = this.httpClientConfig.getConfigs();
        this.httpClient = this.httpClient.tcpConfiguration(tcpClient -> {
            if (this.httpClientConfig.getProxy() != null) {
                tcpClient = tcpClient.proxy(typeSpec -> typeSpec.type(ProxyProvider.Proxy.HTTP).address(this.httpClientConfig.getProxy().getAddress()));
            }
            tcpClient = tcpClient.secure(sslContextSpec -> sslContextSpec.sslContext(configs.getSslContext()));
            if (LoggerFactory.getLogger((String)"com.azure.cosmos.netty-network").isTraceEnabled()) {
                tcpClient = tcpClient.wiretap("com.azure.cosmos.netty-network", LogLevel.INFO);
            }
            tcpClient = tcpClient.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)configs.getConnectionAcquireTimeout().toMillis()));
            return tcpClient;
        }).httpResponseDecoder(httpResponseDecoderSpec -> {
            httpResponseDecoderSpec.maxInitialLineLength(configs.getMaxHttpInitialLineLength());
            httpResponseDecoderSpec.maxHeaderSize(configs.getMaxHttpHeaderSize());
            httpResponseDecoderSpec.maxChunkSize(configs.getMaxHttpChunkSize());
            httpResponseDecoderSpec.validateHeaders(true);
            return httpResponseDecoderSpec;
        });
    }

    @Override
    public Mono<HttpResponse> send(HttpRequest request) {
        return this.send(request, Duration.ofSeconds(Configs.getHttpResponseTimeoutInSeconds()));
    }

    @Override
    public Mono<HttpResponse> send(HttpRequest request, Duration responseTimeout) {
        Objects.requireNonNull(request.httpMethod());
        Objects.requireNonNull(request.uri());
        Objects.requireNonNull(this.httpClientConfig);
        if (request.reactorNettyRequestRecord() == null) {
            ReactorNettyRequestRecord reactorNettyRequestRecord = new ReactorNettyRequestRecord();
            reactorNettyRequestRecord.setTimeCreated(Instant.now());
            request.withReactorNettyRequestRecord(reactorNettyRequestRecord);
        }
        AtomicReference responseReference = new AtomicReference();
        return ((HttpClient.RequestSender)this.httpClient.observe((connection, state) -> {
            Instant time = Instant.now();
            if (state.equals(HttpClientState.CONNECTED) || state.equals(HttpClientState.ACQUIRED)) {
                request.reactorNettyRequestRecord().setTimeConnected(time);
            } else if (state.equals(HttpClientState.CONFIGURED)) {
                request.reactorNettyRequestRecord().setTimeConfigured(time);
            } else if (state.equals(HttpClientState.REQUEST_SENT)) {
                request.reactorNettyRequestRecord().setTimeSent(time);
            } else if (state.equals(HttpClientState.RESPONSE_RECEIVED)) {
                request.reactorNettyRequestRecord().setTimeReceived(time);
            }
        }).keepAlive(this.httpClientConfig.isConnectionKeepAlive()).port(request.port()).responseTimeout(responseTimeout).request(HttpMethod.valueOf((String)request.httpMethod().toString())).uri(request.uri().toString())).send(ReactorNettyClient.bodySendDelegate(request)).responseConnection((reactorNettyResponse, reactorNettyConnection) -> {
            HttpResponse httpResponse = new ReactorNettyHttpResponse((HttpClientResponse)reactorNettyResponse, (Connection)reactorNettyConnection).withRequest(request);
            responseReference.set((ReactorNettyHttpResponse)httpResponse);
            return Mono.just((Object)httpResponse);
        }).doOnCancel(() -> {
            ReactorNettyHttpResponse reactorNettyHttpResponse = (ReactorNettyHttpResponse)responseReference.get();
            if (reactorNettyHttpResponse != null) {
                reactorNettyHttpResponse.releaseOnNotSubscribedResponse(ReactorNettyResponseState.CANCELLED);
            }
        }).onErrorMap(throwable -> {
            ReactorNettyHttpResponse reactorNettyHttpResponse = (ReactorNettyHttpResponse)responseReference.get();
            if (reactorNettyHttpResponse != null) {
                reactorNettyHttpResponse.releaseOnNotSubscribedResponse(ReactorNettyResponseState.ERROR);
            }
            return throwable;
        }).single();
    }

    private static BiFunction<HttpClientRequest, NettyOutbound, Publisher<Void>> bodySendDelegate(HttpRequest restRequest) {
        return (reactorNettyRequest, reactorNettyOutbound) -> {
            for (HttpHeader header : restRequest.headers()) {
                reactorNettyRequest.header((CharSequence)header.name(), (CharSequence)header.value());
            }
            if (restRequest.body() != null) {
                return reactorNettyOutbound.sendByteArray(restRequest.body());
            }
            return reactorNettyOutbound;
        };
    }

    @Override
    public void shutdown() {
        if (this.connectionProvider != null) {
            this.connectionProvider.dispose();
        }
    }

    private static enum ReactorNettyResponseState {
        NOT_SUBSCRIBED,
        SUBSCRIBED,
        CANCELLED,
        ERROR;

    }

    private static class ReactorNettyHttpResponse
    extends HttpResponse {
        private final AtomicReference<ReactorNettyResponseState> state = new AtomicReference<ReactorNettyResponseState>(ReactorNettyResponseState.NOT_SUBSCRIBED);
        private final HttpClientResponse reactorNettyResponse;
        private final Connection reactorNettyConnection;

        ReactorNettyHttpResponse(HttpClientResponse reactorNettyResponse, Connection reactorNettyConnection) {
            this.reactorNettyResponse = reactorNettyResponse;
            this.reactorNettyConnection = reactorNettyConnection;
        }

        @Override
        public int statusCode() {
            return this.reactorNettyResponse.status().code();
        }

        @Override
        public String headerValue(String name) {
            return this.reactorNettyResponse.responseHeaders().get(name);
        }

        @Override
        public HttpHeaders headers() {
            HttpHeaders headers = new HttpHeaders(this.reactorNettyResponse.responseHeaders().size());
            this.reactorNettyResponse.responseHeaders().forEach(e -> headers.set((String)e.getKey(), (String)e.getValue()));
            return headers;
        }

        @Override
        public Flux<ByteBuf> body() {
            return this.bodyIntern().doOnSubscribe(this::updateSubscriptionState);
        }

        @Override
        public Mono<byte[]> bodyAsByteArray() {
            return this.bodyIntern().aggregate().asByteArray().doOnSubscribe(this::updateSubscriptionState);
        }

        @Override
        public Mono<String> bodyAsString() {
            return this.bodyIntern().aggregate().asString().doOnSubscribe(this::updateSubscriptionState);
        }

        @Override
        public Mono<String> bodyAsString(Charset charset) {
            return this.bodyIntern().aggregate().asString(charset).doOnSubscribe(this::updateSubscriptionState);
        }

        private ByteBufFlux bodyIntern() {
            return this.reactorNettyConnection.inbound().receive();
        }

        @Override
        Connection internConnection() {
            return this.reactorNettyConnection;
        }

        private void updateSubscriptionState(Subscription subscription) {
            if (this.state.compareAndSet(ReactorNettyResponseState.NOT_SUBSCRIBED, ReactorNettyResponseState.SUBSCRIBED)) {
                return;
            }
            if (this.state.get() == ReactorNettyResponseState.CANCELLED) {
                throw new IllegalStateException("The client response body has been released already due to cancellation.");
            }
        }

        private void releaseOnNotSubscribedResponse(ReactorNettyResponseState reactorNettyResponseState) {
            if (this.state.compareAndSet(ReactorNettyResponseState.NOT_SUBSCRIBED, reactorNettyResponseState)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Releasing body, not yet subscribed");
                }
                this.bodyIntern().doOnNext(byteBuf -> {}).subscribe(byteBuf -> {}, ex -> {});
            }
        }
    }
}

