/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.DocumentClientRetryPolicy;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.QueryMetrics;
import com.azure.cosmos.implementation.RequestChargeTracker;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.tuple.ImmutablePair;
import com.azure.cosmos.implementation.query.CompositeContinuationToken;
import com.azure.cosmos.implementation.query.DocumentProducer;
import com.azure.cosmos.implementation.query.IDocumentQueryClient;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionComponent;
import com.azure.cosmos.implementation.query.ParallelDocumentQueryExecutionContextBase;
import com.azure.cosmos.implementation.query.PipelinedDocumentQueryParams;
import com.azure.cosmos.implementation.query.TriFunction;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.SqlQuerySpec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.concurrent.Queues;

public class ParallelDocumentQueryExecutionContext<T extends Resource>
extends ParallelDocumentQueryExecutionContextBase<T> {
    private CosmosQueryRequestOptions cosmosQueryRequestOptions;

    private ParallelDocumentQueryExecutionContext(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient client, List<PartitionKeyRange> partitionKeyRanges, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, CosmosQueryRequestOptions cosmosQueryRequestOptions, String resourceLink, String rewrittenQuery, String collectionRid, boolean isContinuationExpected, boolean getLazyFeedResponse, UUID correlatedActivityId) {
        super(diagnosticsClientContext, client, partitionKeyRanges, resourceTypeEnum, resourceType, query, cosmosQueryRequestOptions, resourceLink, rewrittenQuery, isContinuationExpected, getLazyFeedResponse, correlatedActivityId);
        this.cosmosQueryRequestOptions = cosmosQueryRequestOptions;
    }

    public static <T extends Resource> Flux<IDocumentQueryExecutionComponent<T>> createAsync(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient client, PipelinedDocumentQueryParams<T> initParams) {
        ParallelDocumentQueryExecutionContext<T> context = new ParallelDocumentQueryExecutionContext<T>(diagnosticsClientContext, client, initParams.getPartitionKeyRanges(), initParams.getResourceTypeEnum(), initParams.getResourceType(), initParams.getQuery(), initParams.getCosmosQueryRequestOptions(), initParams.getResourceLink(), initParams.getQueryInfo().getRewrittenQuery(), initParams.getCollectionRid(), initParams.isContinuationExpected(), initParams.isGetLazyResponseFeed(), initParams.getCorrelatedActivityId());
        context.setTop(initParams.getTop());
        try {
            super.initialize(initParams.getCollectionRid(), initParams.getPartitionKeyRanges(), initParams.getInitialPageSize(), ModelBridgeInternal.getRequestContinuationFromQueryRequestOptions(initParams.getCosmosQueryRequestOptions()));
            return Flux.just(context);
        }
        catch (CosmosException dce) {
            return Flux.error((Throwable)((Object)dce));
        }
    }

    public static <T extends Resource> Flux<IDocumentQueryExecutionComponent<T>> createReadManyQueryAsync(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient queryClient, String collectionResourceId, SqlQuerySpec sqlQuery, Map<PartitionKeyRange, SqlQuerySpec> rangeQueryMap, CosmosQueryRequestOptions cosmosQueryRequestOptions, String collectionRid, String collectionLink, UUID activityId, Class<T> klass, ResourceType resourceTypeEnum) {
        ArrayList<PartitionKeyRange> ranges = new ArrayList<PartitionKeyRange>();
        ranges.addAll(rangeQueryMap.keySet());
        ParallelDocumentQueryExecutionContext<T> context = new ParallelDocumentQueryExecutionContext<T>(diagnosticsClientContext, queryClient, ranges, resourceTypeEnum, klass, sqlQuery, cosmosQueryRequestOptions, collectionLink, sqlQuery.getQueryText(), collectionRid, false, false, activityId);
        context.initializeReadMany(queryClient, collectionResourceId, sqlQuery, rangeQueryMap, cosmosQueryRequestOptions, activityId, collectionRid);
        return Flux.just(context);
    }

    private void initialize(String collectionRid, List<PartitionKeyRange> targetRanges, int initialPageSize, String continuationToken) {
        HashMap<PartitionKeyRange, String> partitionKeyRangeToContinuationTokenMap = new HashMap<PartitionKeyRange, String>();
        if (continuationToken == null) {
            for (PartitionKeyRange targetRange : targetRanges) {
                partitionKeyRangeToContinuationTokenMap.put(targetRange, null);
            }
        } else {
            Utils.ValueHolder<CompositeContinuationToken> outCompositeContinuationToken = new Utils.ValueHolder<CompositeContinuationToken>();
            if (!CompositeContinuationToken.tryParse(continuationToken, outCompositeContinuationToken)) {
                String message = String.format("INVALID JSON in continuation token %s for Parallel~Context", continuationToken);
                throw BridgeInternal.createCosmosException(400, message);
            }
            CompositeContinuationToken compositeContinuationToken = (CompositeContinuationToken)outCompositeContinuationToken.v;
            List<PartitionKeyRange> filteredPartitionKeyRanges = this.getPartitionKeyRangesForContinuation(compositeContinuationToken, targetRanges);
            partitionKeyRangeToContinuationTokenMap.put(filteredPartitionKeyRanges.get(0), compositeContinuationToken.getToken());
            for (int i = 1; i < filteredPartitionKeyRanges.size(); ++i) {
                partitionKeyRangeToContinuationTokenMap.put(filteredPartitionKeyRanges.get(i), null);
            }
        }
        super.initialize(collectionRid, partitionKeyRangeToContinuationTokenMap, initialPageSize, this.querySpec);
    }

    private List<PartitionKeyRange> getPartitionKeyRangesForContinuation(CompositeContinuationToken compositeContinuationToken, List<PartitionKeyRange> partitionKeyRanges) {
        int startIndex = this.findTargetRangeAndExtractContinuationTokens(partitionKeyRanges, compositeContinuationToken.getRange());
        ArrayList<PartitionKeyRange> rightHandSideRanges = new ArrayList<PartitionKeyRange>();
        for (int i = startIndex; i < partitionKeyRanges.size(); ++i) {
            rightHandSideRanges.add(partitionKeyRanges.get(i));
        }
        return rightHandSideRanges;
    }

    @Override
    public Flux<FeedResponse<T>> drainAsync(int maxPageSize) {
        List obs = this.documentProducers.stream().sorted(Comparator.comparing(dp -> dp.targetRange.getMinInclusive())).map(DocumentProducer::produceAsync).collect(Collectors.toList());
        int fluxConcurrency = this.fluxSequentialMergeConcurrency(this.cosmosQueryRequestOptions, obs.size());
        int fluxPrefetch = this.fluxSequentialMergePrefetch(this.cosmosQueryRequestOptions, obs.size(), maxPageSize, fluxConcurrency);
        this.logger.debug("ParallelQuery: flux mergeSequential concurrency {}, prefetch {}", (Object)fluxConcurrency, (Object)fluxPrefetch);
        return Flux.mergeSequential(obs, (int)fluxConcurrency, (int)fluxPrefetch).compose(new EmptyPagesFilterTransformer(new RequestChargeTracker(), this.cosmosQueryRequestOptions));
    }

    @Override
    public Flux<FeedResponse<T>> executeAsync() {
        return this.drainAsync(ModelBridgeInternal.getMaxItemCountFromQueryRequestOptions(this.cosmosQueryRequestOptions));
    }

    @Override
    protected DocumentProducer<T> createDocumentProducer(String collectionRid, PartitionKeyRange targetRange, String initialContinuationToken, int initialPageSize, CosmosQueryRequestOptions cosmosQueryRequestOptions, SqlQuerySpec querySpecForInit, Map<String, String> commonRequestHeaders, TriFunction<PartitionKeyRange, String, Integer, RxDocumentServiceRequest> createRequestFunc, Function<RxDocumentServiceRequest, Mono<FeedResponse<T>>> executeFunc, Callable<DocumentClientRetryPolicy> createRetryPolicyFunc) {
        return new DocumentProducer<T>(this.client, collectionRid, cosmosQueryRequestOptions, createRequestFunc, executeFunc, targetRange, collectionRid, () -> this.client.getResetSessionTokenRetryPolicy().getRequestPolicy(), this.resourceType, this.correlatedActivityId, initialPageSize, initialContinuationToken, this.top);
    }

    private int fluxSequentialMergeConcurrency(CosmosQueryRequestOptions options, int numberOfPartitions) {
        int parallelism = options.getMaxDegreeOfParallelism();
        if (parallelism < 0) {
            parallelism = Configs.getCPUCnt();
        } else if (parallelism == 0) {
            parallelism = 1;
        }
        return Math.min(numberOfPartitions, parallelism);
    }

    private int fluxSequentialMergePrefetch(CosmosQueryRequestOptions options, int numberOfPartitions, int pageSize, int fluxConcurrency) {
        int maxBufferedItemCount = options.getMaxBufferedItemCount();
        if (maxBufferedItemCount <= 0) {
            maxBufferedItemCount = Math.min(Configs.getCPUCnt() * numberOfPartitions * pageSize, 100000);
        }
        int fluxPrefetch = Math.max(maxBufferedItemCount / Math.max(fluxConcurrency * pageSize, 1), 1);
        return Math.min(fluxPrefetch, Queues.XS_BUFFER_SIZE);
    }

    private static class EmptyPagesFilterTransformer<T extends Resource>
    implements Function<Flux<DocumentProducer.DocumentProducerFeedResponse>, Flux<FeedResponse<T>>> {
        private final RequestChargeTracker tracker;
        private DocumentProducer.DocumentProducerFeedResponse previousPage;
        private final CosmosQueryRequestOptions cosmosQueryRequestOptions;
        private ConcurrentMap<String, QueryMetrics> emptyPageQueryMetricsMap = new ConcurrentHashMap<String, QueryMetrics>();

        public EmptyPagesFilterTransformer(RequestChargeTracker tracker, CosmosQueryRequestOptions options) {
            if (tracker == null) {
                throw new IllegalArgumentException("Request Charge Tracker must not be null.");
            }
            this.tracker = tracker;
            this.previousPage = null;
            this.cosmosQueryRequestOptions = options;
        }

        private DocumentProducer.DocumentProducerFeedResponse plusCharge(DocumentProducer.DocumentProducerFeedResponse documentProducerFeedResponse, double charge) {
            FeedResponse page = documentProducerFeedResponse.pageResult;
            HashMap<String, String> headers = new HashMap<String, String>(page.getResponseHeaders());
            double pageCharge = page.getRequestCharge();
            headers.put("x-ms-request-charge", String.valueOf(pageCharge += charge));
            FeedResponse newPage = BridgeInternal.createFeedResponseWithQueryMetrics(page.getResults(), headers, BridgeInternal.queryMetricsFromFeedResponse(page), ModelBridgeInternal.getQueryPlanDiagnosticsContext(page));
            documentProducerFeedResponse.pageResult = newPage;
            return documentProducerFeedResponse;
        }

        private DocumentProducer.DocumentProducerFeedResponse addCompositeContinuationToken(DocumentProducer.DocumentProducerFeedResponse documentProducerFeedResponse, String compositeContinuationToken) {
            FeedResponse page = documentProducerFeedResponse.pageResult;
            HashMap<String, String> headers = new HashMap<String, String>(page.getResponseHeaders());
            headers.put("x-ms-continuation", compositeContinuationToken);
            FeedResponse newPage = BridgeInternal.createFeedResponseWithQueryMetrics(page.getResults(), headers, BridgeInternal.queryMetricsFromFeedResponse(page), ModelBridgeInternal.getQueryPlanDiagnosticsContext(page));
            documentProducerFeedResponse.pageResult = newPage;
            return documentProducerFeedResponse;
        }

        private static Map<String, String> headerResponse(double requestCharge) {
            return Utils.immutableMapOf("x-ms-request-charge", String.valueOf(requestCharge));
        }

        @Override
        public Flux<FeedResponse<T>> apply(Flux<DocumentProducer.DocumentProducerFeedResponse> source) {
            return source.filter(documentProducerFeedResponse -> {
                if (documentProducerFeedResponse.pageResult.getResults().isEmpty() && !ModelBridgeInternal.getEmptyPagesAllowedFromQueryRequestOptions(this.cosmosQueryRequestOptions)) {
                    this.tracker.addCharge(documentProducerFeedResponse.pageResult.getRequestCharge());
                    ConcurrentMap<String, QueryMetrics> currentQueryMetrics = BridgeInternal.queryMetricsFromFeedResponse(documentProducerFeedResponse.pageResult);
                    QueryMetrics.mergeQueryMetricsMap(this.emptyPageQueryMetricsMap, currentQueryMetrics);
                    return false;
                }
                return true;
            }).map(documentProducerFeedResponse -> {
                double charge;
                if (!this.emptyPageQueryMetricsMap.isEmpty()) {
                    ConcurrentMap<String, QueryMetrics> currentQueryMetrics = BridgeInternal.queryMetricsFromFeedResponse(documentProducerFeedResponse.pageResult);
                    QueryMetrics.mergeQueryMetricsMap(currentQueryMetrics, this.emptyPageQueryMetricsMap);
                    this.emptyPageQueryMetricsMap.clear();
                }
                if ((charge = this.tracker.getAndResetCharge()) > 0.0) {
                    return new Utils.ValueHolder<DocumentProducer.DocumentProducerFeedResponse>(this.plusCharge((DocumentProducer.DocumentProducerFeedResponse)documentProducerFeedResponse, charge));
                }
                return new Utils.ValueHolder<DocumentProducer.DocumentProducerFeedResponse>((DocumentProducer.DocumentProducerFeedResponse)documentProducerFeedResponse);
            }).concatWith((Publisher)Flux.just(new Utils.ValueHolder<Object>(null))).map(heldValue -> {
                DocumentProducer.DocumentProducerFeedResponse documentProducerFeedResponse = (DocumentProducer.DocumentProducerFeedResponse)heldValue.v;
                ImmutablePair<DocumentProducer.DocumentProducerFeedResponse, DocumentProducer.DocumentProducerFeedResponse> previousCurrent = new ImmutablePair<DocumentProducer.DocumentProducerFeedResponse, DocumentProducer.DocumentProducerFeedResponse>(this.previousPage, documentProducerFeedResponse);
                this.previousPage = documentProducerFeedResponse;
                return previousCurrent;
            }).skip(1L).map(currentNext -> {
                CompositeContinuationToken compositeContinuationTokenDom;
                String compositeContinuationToken;
                DocumentProducer.DocumentProducerFeedResponse current = (DocumentProducer.DocumentProducerFeedResponse)currentNext.left;
                DocumentProducer.DocumentProducerFeedResponse next = (DocumentProducer.DocumentProducerFeedResponse)currentNext.right;
                String backendContinuationToken = current.pageResult.getContinuationToken();
                if (backendContinuationToken == null) {
                    if (next == null) {
                        compositeContinuationToken = null;
                    } else {
                        compositeContinuationTokenDom = new CompositeContinuationToken(null, next.sourcePartitionKeyRange.toRange());
                        compositeContinuationToken = compositeContinuationTokenDom.toJson();
                    }
                } else {
                    compositeContinuationTokenDom = new CompositeContinuationToken(backendContinuationToken, current.sourcePartitionKeyRange.toRange());
                    compositeContinuationToken = compositeContinuationTokenDom.toJson();
                }
                DocumentProducer.DocumentProducerFeedResponse page = current;
                page = this.addCompositeContinuationToken(page, compositeContinuationToken);
                return page;
            }).map(documentProducerFeedResponse -> documentProducerFeedResponse.pageResult).switchIfEmpty((Publisher)Flux.defer(() -> Flux.just(BridgeInternal.createFeedResponseWithQueryMetrics(Utils.immutableListOf(), EmptyPagesFilterTransformer.headerResponse(this.tracker.getAndResetCharge()), this.emptyPageQueryMetricsMap, null))));
        }
    }
}

