/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.ConsistencyPolicy;
import com.azure.cosmos.implementation.Database;
import com.azure.cosmos.implementation.DatabaseAccount;
import com.azure.cosmos.implementation.DatabaseAccountLocation;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.InternalObjectNode;
import com.azure.cosmos.implementation.ObjectNodeMap;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.PrimitiveJsonNodeMap;
import com.azure.cosmos.implementation.ReplicationPolicy;
import com.azure.cosmos.implementation.SerializationFormattingPolicy;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.directconnectivity.Address;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.query.PartitionedQueryExecutionInfoInternal;
import com.azure.cosmos.implementation.query.QueryInfo;
import com.azure.cosmos.implementation.query.QueryItem;
import com.azure.cosmos.implementation.routing.Range;
import com.azure.cosmos.models.ChangeFeedPolicy;
import com.azure.cosmos.models.CompositePath;
import com.azure.cosmos.models.ConflictResolutionPolicy;
import com.azure.cosmos.models.ExcludedPath;
import com.azure.cosmos.models.IncludedPath;
import com.azure.cosmos.models.IndexingPolicy;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.PartitionKeyDefinition;
import com.azure.cosmos.models.SpatialSpec;
import com.azure.cosmos.models.SqlParameter;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.cosmos.models.UniqueKey;
import com.azure.cosmos.models.UniqueKeyPolicy;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.util.annotation.Nullable;

public class JsonSerializable {
    private static final ObjectMapper OBJECT_MAPPER = Utils.getSimpleObjectMapper();
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonSerializable.class);
    transient ObjectNode propertyBag = null;
    private ObjectMapper om;

    public JsonSerializable() {
        this.propertyBag = OBJECT_MAPPER.createObjectNode();
    }

    protected JsonSerializable(String jsonString, ObjectMapper objectMapper) {
        this.propertyBag = this.fromJson(jsonString);
        this.om = objectMapper;
    }

    public JsonSerializable(String jsonString) {
        this.propertyBag = this.fromJson(jsonString);
    }

    public JsonSerializable(ObjectNode objectNode) {
        this.propertyBag = objectNode;
    }

    protected JsonSerializable(ByteBuffer byteBuffer) {
        this.propertyBag = this.fromJson(byteBuffer);
    }

    protected JsonSerializable(byte[] bytes) {
        this.propertyBag = this.fromJson(bytes);
    }

    public static JsonSerializable instantiateFromObjectNodeAndType(ObjectNode objectNode, Class<?> klassType) {
        if (klassType.equals(Document.class)) {
            return new Document(objectNode);
        }
        if (klassType.equals(InternalObjectNode.class)) {
            return new InternalObjectNode(objectNode);
        }
        if (klassType.equals(PartitionKeyRange.class)) {
            return new PartitionKeyRange(objectNode);
        }
        if (klassType.equals(Range.class)) {
            return new Range(objectNode);
        }
        if (klassType.equals(QueryInfo.class)) {
            return new QueryInfo(objectNode);
        }
        if (klassType.equals(PartitionedQueryExecutionInfoInternal.class)) {
            return new PartitionedQueryExecutionInfoInternal(objectNode);
        }
        if (klassType.equals(QueryItem.class)) {
            return new QueryItem(objectNode);
        }
        if (klassType.equals(Address.class)) {
            return new Address(objectNode);
        }
        if (klassType.equals(DatabaseAccount.class)) {
            return new DatabaseAccount(objectNode);
        }
        if (klassType.equals(DatabaseAccountLocation.class)) {
            return new DatabaseAccountLocation(objectNode);
        }
        if (klassType.equals(ReplicationPolicy.class)) {
            return new ReplicationPolicy(objectNode);
        }
        if (klassType.equals(ConsistencyPolicy.class)) {
            return new ConsistencyPolicy(objectNode);
        }
        if (klassType.equals(DocumentCollection.class)) {
            return new DocumentCollection(objectNode);
        }
        if (klassType.equals(Database.class)) {
            return new Database(objectNode);
        }
        try {
            return (JsonSerializable)klassType.getDeclaredConstructor(ObjectNode.class).newInstance(objectNode);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static void checkForValidPOJO(Class<?> c) {
        if (c.isAnonymousClass() || c.isLocalClass()) {
            throw new IllegalArgumentException(String.format("%s can't be an anonymous or local class.", c.getName()));
        }
        if (c.isMemberClass() && !Modifier.isStatic(c.getModifiers())) {
            throw new IllegalArgumentException(String.format("%s must be static if it's a member class.", c.getName()));
        }
    }

    public static Object getValue(JsonNode value) {
        if (value.isValueNode()) {
            switch (value.getNodeType()) {
                case BOOLEAN: {
                    return value.asBoolean();
                }
                case NUMBER: {
                    if (value.isInt()) {
                        return value.asInt();
                    }
                    if (value.isLong()) {
                        return value.asLong();
                    }
                    if (value.isDouble()) {
                        return value.asDouble();
                    }
                    return value;
                }
                case STRING: {
                    return value.asText();
                }
            }
            return value;
        }
        return value;
    }

    @JsonIgnore
    public Logger getLogger() {
        return LOGGER;
    }

    public void populatePropertyBag() {
    }

    public Map<String, Object> getMap() {
        return (Map)OBJECT_MAPPER.convertValue((Object)this.propertyBag, HashMap.class);
    }

    public <T> Map<String, T> getMap(String propertyKey) {
        if (this.propertyBag.has(propertyKey)) {
            Object value = this.get(propertyKey);
            return (Map)OBJECT_MAPPER.convertValue(value, HashMap.class);
        }
        return null;
    }

    public boolean has(String propertyName) {
        return this.propertyBag.has(propertyName);
    }

    public void remove(String propertyName) {
        this.propertyBag.remove(propertyName);
    }

    public <T> void set(String propertyName, T value, CosmosItemSerializer itemSerializer) {
        Preconditions.checkNotNull(itemSerializer, "Argument 'itemSerializer' must not be null.");
        Preconditions.checkArgument(itemSerializer == CosmosItemSerializer.DEFAULT_SERIALIZER, "Argument 'itemSerializer' must be the DEFAULT_SERIALIZER when using this method.");
        this.set(propertyName, value, itemSerializer, false);
    }

    public <T> void set(String propertyName, T value, CosmosItemSerializer itemSerializer, boolean forceSerialization) {
        Preconditions.checkNotNull(itemSerializer, "Argument 'itemSerializer' must not be null.");
        if (value == null) {
            this.propertyBag.putNull(propertyName);
        } else if (!forceSerialization && value instanceof Collection) {
            ArrayNode jsonArray = this.propertyBag.arrayNode();
            this.internalSetCollection(propertyName, (Collection)value, jsonArray);
            this.propertyBag.set(propertyName, (JsonNode)jsonArray);
        } else if (!forceSerialization && value instanceof JsonNode) {
            this.propertyBag.set(propertyName, (JsonNode)value);
        } else if (!forceSerialization && value instanceof JsonSerializable) {
            JsonSerializable castedValue = (JsonSerializable)value;
            castedValue.populatePropertyBag();
            this.propertyBag.set(propertyName, (JsonNode)castedValue.propertyBag);
        } else if (!forceSerialization && JsonSerializable.containsJsonSerializable(value.getClass())) {
            ModelBridgeInternal.populatePropertyBag(value);
            this.propertyBag.set(propertyName, (JsonNode)ModelBridgeInternal.getJsonSerializable(value).propertyBag);
        } else {
            Map<String, Object> jsonTreeMap = itemSerializer.serialize(value);
            if (jsonTreeMap instanceof ObjectNodeMap) {
                this.propertyBag.set(propertyName, (JsonNode)((ObjectNodeMap)jsonTreeMap).getObjectNode());
            } else if (jsonTreeMap instanceof PrimitiveJsonNodeMap) {
                this.propertyBag.set(propertyName, ((PrimitiveJsonNodeMap)jsonTreeMap).getPrimitiveJsonNode());
            } else if (jsonTreeMap.size() == 1 && jsonTreeMap.get("__primitive_json-node_value__") != null) {
                this.propertyBag.set(propertyName, (JsonNode)OBJECT_MAPPER.convertValue(jsonTreeMap.get("__primitive_json-node_value__"), JsonNode.class));
            } else {
                this.propertyBag.set(propertyName, (JsonNode)OBJECT_MAPPER.convertValue(jsonTreeMap, ObjectNode.class));
            }
        }
    }

    private <T> void internalSetCollection(String propertyName, Collection<T> collection, ArrayNode targetArray) {
        for (T childValue : collection) {
            if (childValue == null) {
                targetArray.addNull();
                continue;
            }
            if (childValue instanceof Collection) {
                ArrayNode childArray = targetArray.addArray();
                this.internalSetCollection(propertyName, (Collection)childValue, childArray);
                continue;
            }
            if (childValue instanceof JsonNode) {
                targetArray.add((JsonNode)childValue);
                continue;
            }
            if (childValue instanceof JsonSerializable) {
                JsonSerializable castedValue = (JsonSerializable)childValue;
                castedValue.populatePropertyBag();
                targetArray.add((JsonNode)(castedValue.propertyBag != null ? castedValue.propertyBag : OBJECT_MAPPER.createObjectNode()));
                continue;
            }
            if (JsonSerializable.containsJsonSerializable(childValue.getClass())) {
                ModelBridgeInternal.populatePropertyBag(childValue);
                targetArray.add((JsonNode)(ModelBridgeInternal.getJsonSerializable(childValue).propertyBag != null ? ModelBridgeInternal.getJsonSerializable(childValue).propertyBag : OBJECT_MAPPER.createObjectNode()));
                continue;
            }
            targetArray.add(OBJECT_MAPPER.valueToTree(childValue));
        }
    }

    public Object get(String propertyName) {
        if (this.has(propertyName) && this.propertyBag.hasNonNull(propertyName)) {
            return JsonSerializable.getValue(this.propertyBag.get(propertyName));
        }
        return null;
    }

    public String getString(String propertyName) {
        if (this.has(propertyName) && this.propertyBag.hasNonNull(propertyName)) {
            return this.propertyBag.get(propertyName).asText();
        }
        return null;
    }

    @Nullable
    public Boolean getBoolean(String propertyName) {
        if (this.has(propertyName) && this.propertyBag.hasNonNull(propertyName)) {
            return this.propertyBag.get(propertyName).asBoolean();
        }
        return null;
    }

    public Integer getInt(String propertyName) {
        if (this.has(propertyName) && this.propertyBag.hasNonNull(propertyName)) {
            return this.propertyBag.get(propertyName).asInt();
        }
        return null;
    }

    protected Long getLong(String propertyName) {
        if (this.has(propertyName) && this.propertyBag.hasNonNull(propertyName)) {
            return this.propertyBag.get(propertyName).asLong();
        }
        return null;
    }

    public Double getDouble(String propertyName) {
        if (this.has(propertyName) && this.propertyBag.hasNonNull(propertyName)) {
            return this.propertyBag.get(propertyName).asDouble();
        }
        return null;
    }

    public <T> T getObject(String propertyName, Class<T> c, boolean ... convertFromCamelCase) {
        if (this.propertyBag.has(propertyName) && this.propertyBag.hasNonNull(propertyName)) {
            JsonNode jsonObj = this.propertyBag.get(propertyName);
            if (Number.class.isAssignableFrom(c) || String.class.isAssignableFrom(c) || Boolean.class.isAssignableFrom(c) || Object.class == c) {
                return c.cast(JsonSerializable.getValue(jsonObj));
            }
            if (Enum.class.isAssignableFrom(c)) {
                try {
                    String value = (String)String.class.cast(JsonSerializable.getValue(jsonObj));
                    value = convertFromCamelCase.length > 0 && convertFromCamelCase[0] ? Strings.fromCamelCaseToUpperCase(value) : value;
                    return c.cast(c.getMethod("valueOf", String.class).invoke(null, value));
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new IllegalStateException("Failed to create enum.", e);
                }
            }
            if (JsonSerializable.class.isAssignableFrom(c)) {
                return (T)JsonSerializable.instantiateFromObjectNodeAndType((ObjectNode)jsonObj, c);
            }
            if (JsonSerializable.containsJsonSerializable(c)) {
                return ModelBridgeInternal.instantiateByObjectNode((ObjectNode)jsonObj, c);
            }
            JsonSerializable.checkForValidPOJO(c);
            try {
                return (T)OBJECT_MAPPER.treeToValue((TreeNode)jsonObj, c);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to get POJO.", e);
            }
        }
        return null;
    }

    public <T> List<T> getList(String propertyName, Class<T> c, boolean ... convertFromCamelCase) {
        if (this.propertyBag.has(propertyName) && this.propertyBag.hasNonNull(propertyName)) {
            JsonNode jsonArray = this.propertyBag.get(propertyName);
            ArrayList<Object> result = new ArrayList<Object>();
            boolean isBaseClass = false;
            boolean isEnumClass = false;
            boolean isJsonSerializable = false;
            boolean containsJsonSerializable = false;
            if (Number.class.isAssignableFrom(c) || String.class.isAssignableFrom(c) || Boolean.class.isAssignableFrom(c) || Object.class == c) {
                isBaseClass = true;
            } else if (Enum.class.isAssignableFrom(c)) {
                isEnumClass = true;
            } else if (JsonSerializable.class.isAssignableFrom(c)) {
                isJsonSerializable = true;
            } else if (JsonSerializable.containsJsonSerializable(c)) {
                containsJsonSerializable = true;
            } else {
                JsonSerializable.checkForValidPOJO(c);
            }
            for (JsonNode n : jsonArray) {
                JsonSerializable t;
                if (isBaseClass) {
                    result.add(c.cast(JsonSerializable.getValue(n)));
                    continue;
                }
                if (isEnumClass) {
                    try {
                        String value = (String)String.class.cast(JsonSerializable.getValue(n));
                        value = convertFromCamelCase.length > 0 && convertFromCamelCase[0] ? Strings.fromCamelCaseToUpperCase(value) : value;
                        result.add(c.cast(c.getMethod("valueOf", String.class).invoke(null, value)));
                        continue;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        throw new IllegalStateException("Failed to create enum.", e);
                    }
                }
                if (isJsonSerializable) {
                    t = JsonSerializable.instantiateFromObjectNodeAndType((ObjectNode)n, c);
                    result.add(t);
                    continue;
                }
                if (containsJsonSerializable) {
                    t = ModelBridgeInternal.instantiateByObjectNode((ObjectNode)n, c);
                    result.add(t);
                    continue;
                }
                try {
                    result.add(OBJECT_MAPPER.treeToValue((TreeNode)n, c));
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to get POJO.", e);
                }
            }
            return result;
        }
        return null;
    }

    public <T> Collection<T> getCollection(String propertyName, Class<T> c, boolean ... convertFromCamelCase) {
        return this.getList(propertyName, c, convertFromCamelCase);
    }

    public ObjectNode getObject(String propertyName) {
        if (this.propertyBag.has(propertyName) && this.propertyBag.hasNonNull(propertyName)) {
            return (ObjectNode)this.propertyBag.get(propertyName);
        }
        return null;
    }

    Collection<ObjectNode> getCollection(String propertyName) {
        ArrayList<ObjectNode> result = null;
        if (this.propertyBag.has(propertyName) && this.propertyBag.hasNonNull(propertyName)) {
            result = new ArrayList<ObjectNode>();
            for (JsonNode n : this.propertyBag.findValues(propertyName)) {
                result.add((ObjectNode)n);
            }
        }
        return result;
    }

    public Object getObjectByPath(List<String> propertyNames) {
        ObjectNode propBag = this.propertyBag;
        JsonNode value = null;
        String propertyName = null;
        int matchedProperties = 0;
        Iterator<String> iterator = propertyNames.iterator();
        if (iterator.hasNext()) {
            while (propBag.has(propertyName = iterator.next())) {
                ++matchedProperties;
                value = propBag.get(propertyName);
                if (!value.isObject()) break;
                propBag = (ObjectNode)value;
                if (iterator.hasNext()) continue;
            }
            if (value != null && matchedProperties == propertyNames.size()) {
                return JsonSerializable.getValue(value);
            }
        }
        return null;
    }

    private ObjectNode fromJson(byte[] bytes) {
        try {
            return (ObjectNode)OBJECT_MAPPER.readTree(bytes);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Unable to parse JSON %s", Arrays.toString(bytes)), e);
        }
    }

    private ObjectNode fromJson(String json) {
        try {
            return (ObjectNode)OBJECT_MAPPER.readTree(json);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Unable to parse JSON %s", json), e);
        }
    }

    private ObjectNode fromJson(ByteBuffer json) {
        try {
            return (ObjectNode)OBJECT_MAPPER.readTree((InputStream)new ByteBufferBackedInputStream(json));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to parse JSON from ByteBuffer", e);
        }
    }

    public ByteBuffer serializeJsonToByteBuffer(CosmosItemSerializer itemSerializer, Consumer<Map<String, Object>> onAfterSerialization) {
        this.populatePropertyBag();
        return Utils.serializeJsonToByteBuffer(itemSerializer, this.propertyBag, onAfterSerialization);
    }

    private String toJson(Object object) {
        return JsonSerializable.toJson(OBJECT_MAPPER, object);
    }

    private static String toJson(ObjectMapper mapper, Object object) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Unable to convert JSON to STRING", e);
        }
    }

    private String toPrettyJson(Object object) {
        try {
            return OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Unable to convert JSON to STRING", e);
        }
    }

    public <T> T toObject(Class<T> c) {
        if (InternalObjectNode.class.isAssignableFrom(c)) {
            return (T)new InternalObjectNode(this.propertyBag);
        }
        if (JsonSerializable.class.isAssignableFrom(c) || String.class.isAssignableFrom(c) || Number.class.isAssignableFrom(c) || Boolean.class.isAssignableFrom(c) || JsonSerializable.containsJsonSerializable(c)) {
            return c.cast(this.get("_value"));
        }
        if (List.class.isAssignableFrom(c)) {
            Object o = this.get("_value");
            try {
                return (T)OBJECT_MAPPER.readValue(o.toString(), c);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to convert to collection.", e);
            }
        }
        if (JsonNode.class.isAssignableFrom(c) || ObjectNode.class.isAssignableFrom(c)) {
            if (JsonNode.class != c && ObjectNode.class != c) {
                throw new IllegalArgumentException("We support JsonNode but not its sub-classes.");
            }
            return c.cast(this.propertyBag);
        }
        JsonSerializable.checkForValidPOJO(c);
        try {
            return (T)OBJECT_MAPPER.treeToValue((TreeNode)this.propertyBag, c);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to get POJO.", e);
        }
    }

    public static <T> T toObjectFromObjectNode(JsonNode node, boolean isValueQuery, Class<T> c) {
        if (isValueQuery && node.has("_value")) {
            return (T)OBJECT_MAPPER.convertValue((Object)node.get("_value"), c);
        }
        if (InternalObjectNode.class.isAssignableFrom(c)) {
            return (T)new InternalObjectNode((ObjectNode)node);
        }
        if (node instanceof ObjectNode && (JsonSerializable.class.isAssignableFrom(c) || JsonSerializable.containsJsonSerializable(c))) {
            return c.cast(JsonSerializable.instantiateFromObjectNodeAndType((ObjectNode)node, c));
        }
        if (List.class.isAssignableFrom(c)) {
            try {
                return (T)OBJECT_MAPPER.readValue(node.toString(), c);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to convert to collection.", e);
            }
        }
        if (JsonNode.class.isAssignableFrom(c) || ObjectNode.class.isAssignableFrom(c)) {
            if (JsonNode.class != c && ObjectNode.class != c) {
                throw new IllegalArgumentException("We support JsonNode but not its sub-classes.");
            }
            return c.cast(node);
        }
        JsonSerializable.checkForValidPOJO(c);
        try {
            return (T)OBJECT_MAPPER.treeToValue((TreeNode)node, c);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Failed to get POJO of type '%s' for json '%s'.", c.getName(), JsonSerializable.toJson(OBJECT_MAPPER, node)), e);
        }
    }

    public String toJson() {
        return this.toJson(SerializationFormattingPolicy.NONE);
    }

    protected String toJson(SerializationFormattingPolicy formattingPolicy) {
        this.populatePropertyBag();
        if (SerializationFormattingPolicy.INDENTED.equals((Object)formattingPolicy)) {
            return this.toPrettyJson(this.propertyBag);
        }
        return this.toJson(this.propertyBag);
    }

    public String toString() {
        return this.toJson(this.propertyBag);
    }

    public ObjectNode getPropertyBag() {
        return this.propertyBag;
    }

    static <T> boolean containsJsonSerializable(Class<T> c) {
        return CompositePath.class.equals(c) || ConflictResolutionPolicy.class.equals(c) || ChangeFeedPolicy.class.equals(c) || ExcludedPath.class.equals(c) || IncludedPath.class.equals(c) || IndexingPolicy.class.equals(c) || PartitionKeyDefinition.class.equals(c) || SpatialSpec.class.equals(c) || SqlParameter.class.equals(c) || SqlQuerySpec.class.equals(c) || UniqueKey.class.equals(c) || UniqueKeyPolicy.class.equals(c);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonSerializable that = (JsonSerializable)o;
        return Objects.equals(this.propertyBag, that.propertyBag);
    }

    public int hashCode() {
        return Objects.hash(this.propertyBag);
    }
}

