/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.AuthorizationTokenType;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.DocumentServiceRequestContext;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.PathInfo;
import com.azure.cosmos.implementation.PathsHelper;
import com.azure.cosmos.implementation.QueryCompatibilityMode;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.ResourceId;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.faultinjection.FaultInjectionRequestContext;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.implementation.routing.PartitionKeyRangeIdentity;
import com.azure.cosmos.implementation.routing.Range;
import com.azure.cosmos.models.CosmosChangeFeedRequestOptions;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.PartitionKeyDefinition;
import com.azure.cosmos.models.PriorityLevel;
import com.azure.cosmos.models.SqlQuerySpec;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import reactor.core.publisher.Flux;

public class RxDocumentServiceRequest
implements Cloneable {
    private final DiagnosticsClientContext clientContext;
    public volatile boolean forcePartitionKeyRangeRefresh;
    public volatile boolean forceCollectionRoutingMapRefresh;
    private String resourceId;
    private final ResourceType resourceType;
    private final Map<String, String> headers;
    private volatile String continuation;
    private boolean isMedia = false;
    private final boolean isNameBased;
    private final OperationType operationType;
    private String resourceAddress;
    public volatile boolean forceNameCacheRefresh;
    private volatile URI endpointOverride = null;
    private final UUID activityId;
    private volatile String originalSessionToken;
    private volatile PartitionKeyRangeIdentity partitionKeyRangeIdentity;
    private volatile Integer defaultReplicaIndex;
    private boolean isAddressRefresh;
    private boolean isForcedAddressRefresh;
    public DocumentServiceRequestContext requestContext;
    public FaultInjectionRequestContext faultInjectionRequestContext;
    private PartitionKeyInternal partitionKeyInternal;
    private PartitionKeyDefinition partitionKeyDefinition;
    private String effectivePartitionKey;
    private FeedRangeInternal feedRange;
    private Range<String> effectiveRange;
    private int numberOfItemsInBatchRequest;
    private byte[] contentAsByteArray;
    public boolean useGatewayMode;
    private volatile boolean isDisposed = false;
    public volatile String entityId;
    public volatile boolean isFeed;
    public volatile AuthorizationTokenType authorizationTokenType;
    public volatile Map<String, Object> properties;
    public String throughputControlGroupName;
    public volatile boolean intendedCollectionRidPassedIntoSDK = false;
    private volatile Duration responseTimeout;
    private volatile boolean nonIdempotentWriteRetriesEnabled = false;

    public boolean isReadOnlyRequest() {
        return this.operationType.isReadOnlyOperation();
    }

    public void setResourceAddress(String newAddress) {
        this.resourceAddress = newAddress;
    }

    public boolean isReadOnlyScript() {
        String isReadOnlyScript = this.headers.get("x-ms-is-readonly-script");
        if (StringUtils.isEmpty(isReadOnlyScript)) {
            return false;
        }
        return this.operationType.equals((Object)OperationType.ExecuteJavaScript) && isReadOnlyScript.equalsIgnoreCase(Boolean.TRUE.toString());
    }

    public boolean isMetadataRequest() {
        return this.getOperationType() != OperationType.ExecuteJavaScript && this.getResourceType() == ResourceType.StoredProcedure || this.getResourceType() != ResourceType.Document;
    }

    public RxDocumentServiceRequest setNonIdempotentWriteRetriesEnabled(boolean enabled) {
        this.nonIdempotentWriteRetriesEnabled = enabled;
        return this;
    }

    public boolean getNonIdempotentWriteRetriesEnabled() {
        return this.nonIdempotentWriteRetriesEnabled;
    }

    public boolean isReadOnly() {
        return this.isReadOnlyRequest() || this.isReadOnlyScript();
    }

    private RxDocumentServiceRequest(DiagnosticsClientContext clientContext, OperationType operationType, String resourceIdOrFullName, ResourceType resourceType, byte[] byteContent, Map<String, String> headers, boolean isNameBased, AuthorizationTokenType authorizationTokenType) {
        this(clientContext, operationType, resourceIdOrFullName, resourceType, RxDocumentServiceRequest.wrapByteBuffer(byteContent), headers, isNameBased, authorizationTokenType);
    }

    private RxDocumentServiceRequest(DiagnosticsClientContext clientContext, OperationType operationType, String resourceIdOrFullName, ResourceType resourceType, ByteBuffer byteBuffer, Map<String, String> headers, boolean isNameBased, AuthorizationTokenType authorizationTokenType) {
        this.clientContext = clientContext;
        this.operationType = operationType;
        this.forceNameCacheRefresh = false;
        this.resourceType = resourceType;
        this.contentAsByteArray = RxDocumentServiceRequest.toByteArray(byteBuffer);
        this.headers = headers != null ? headers : new HashMap();
        this.activityId = UUID.randomUUID();
        this.isFeed = false;
        this.isNameBased = isNameBased;
        if (!isNameBased) {
            this.resourceId = resourceIdOrFullName;
        }
        this.resourceAddress = resourceIdOrFullName;
        this.authorizationTokenType = authorizationTokenType;
        this.requestContext = new DocumentServiceRequestContext();
        this.faultInjectionRequestContext = new FaultInjectionRequestContext();
        if (StringUtils.isNotEmpty(this.headers.get("x-ms-documentdb-partitionkeyrangeid"))) {
            this.partitionKeyRangeIdentity = PartitionKeyRangeIdentity.fromHeader(this.headers.get("x-ms-documentdb-partitionkeyrangeid"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RxDocumentServiceRequest(DiagnosticsClientContext clientContext, OperationType operationType, ResourceType resourceType, String path, Map<String, String> headers) {
        this.clientContext = clientContext;
        this.requestContext = new DocumentServiceRequestContext();
        this.faultInjectionRequestContext = new FaultInjectionRequestContext();
        this.operationType = operationType;
        this.resourceType = resourceType;
        this.requestContext.sessionToken = null;
        this.headers = headers != null ? headers : new HashMap();
        this.activityId = UUID.randomUUID();
        this.isFeed = false;
        if (StringUtils.isNotEmpty(path)) {
            PathInfo pathInfo = new PathInfo(false, null, null, false);
            if (!PathsHelper.tryParsePathSegments(path, pathInfo, null)) throw new IllegalArgumentException("Entity with the specified id does not exist in the system. More info: https://aka.ms/cosmosdb-tsg-not-found-java, - Path: " + path);
            this.isNameBased = pathInfo.isNameBased;
            this.isFeed = pathInfo.isFeed;
            String resourceIdOrFullName = pathInfo.resourceIdOrFullName;
            if (!this.isNameBased) {
                this.resourceId = resourceType == ResourceType.Media ? RxDocumentServiceRequest.getAttachmentIdFromMediaId(resourceIdOrFullName) : resourceIdOrFullName;
                this.resourceAddress = resourceIdOrFullName;
                if (!(!StringUtils.isNotEmpty(this.resourceId) || ResourceId.tryParse(this.resourceId).getLeft().booleanValue() || resourceType.equals((Object)ResourceType.Offer) || resourceType.equals((Object)ResourceType.Media) || resourceType.equals((Object)ResourceType.MasterPartition) || resourceType.equals((Object)ResourceType.ServerPartition) || resourceType.equals((Object)ResourceType.DatabaseAccount) || resourceType.equals((Object)ResourceType.RidRange))) {
                    throw new IllegalArgumentException(String.format("The value %s specified  for query %s is invalid.", path, "$resolveFor"));
                }
            } else {
                this.resourceAddress = resourceIdOrFullName;
                this.resourceId = null;
            }
        } else {
            this.isNameBased = false;
            this.resourceAddress = path;
        }
        if (!StringUtils.isNotEmpty(this.headers.get("x-ms-documentdb-partitionkeyrangeid"))) return;
        this.partitionKeyRangeIdentity = PartitionKeyRangeIdentity.fromHeader(this.headers.get("x-ms-documentdb-partitionkeyrangeid"));
    }

    private RxDocumentServiceRequest(DiagnosticsClientContext clientContext, OperationType operationType, ResourceType resourceType, ByteBuffer byteBuffer, String path, Map<String, String> headers, AuthorizationTokenType authorizationTokenType) {
        this(clientContext, operationType, resourceType, path, headers);
        this.authorizationTokenType = authorizationTokenType;
        this.contentAsByteArray = RxDocumentServiceRequest.toByteArray(byteBuffer);
    }

    private RxDocumentServiceRequest(DiagnosticsClientContext clientContext, OperationType operationType, ResourceType resourceType, byte[] content, String path, Map<String, String> headers, AuthorizationTokenType authorizationTokenType) {
        this(clientContext, operationType, resourceType, RxDocumentServiceRequest.wrapByteBuffer(content), path, headers, authorizationTokenType);
    }

    private RxDocumentServiceRequest(DiagnosticsClientContext clientContext, OperationType operationType, ResourceType resourceType, String path, ByteBuffer byteBuffer, Map<String, String> headers, AuthorizationTokenType authorizationTokenType) {
        this(clientContext, operationType, resourceType, byteBuffer, path, headers, authorizationTokenType);
    }

    private RxDocumentServiceRequest(DiagnosticsClientContext clientContext, OperationType operationType, ResourceType resourceType, String path, byte[] byteContent, Map<String, String> headers, AuthorizationTokenType authorizationTokenType) {
        this(clientContext, operationType, resourceType, byteContent, path, headers, authorizationTokenType);
    }

    private RxDocumentServiceRequest(DiagnosticsClientContext clientContext, OperationType operationType, ResourceType resourceType, String relativeUriPath, Map<String, String> headers, AuthorizationTokenType authorizationTokenType) {
        this(clientContext, operationType, resourceType, (byte[])null, relativeUriPath, headers, authorizationTokenType);
    }

    public void setContentBytes(byte[] contentBytes) {
        this.contentAsByteArray = contentBytes;
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.contentAsByteArray = RxDocumentServiceRequest.toByteArray(byteBuffer);
    }

    public static RxDocumentServiceRequest create(DiagnosticsClientContext clientContext, OperationType operation, ResourceType resourceType, String relativePath, byte[] bytes, Map<String, String> headers) {
        return new RxDocumentServiceRequest(clientContext, operation, resourceType, relativePath, bytes, headers, AuthorizationTokenType.PrimaryMasterKey);
    }

    public static RxDocumentServiceRequest create(DiagnosticsClientContext clientContext, OperationType operation, ResourceType resourceType, String relativePath, byte[] bytes, Map<String, String> headers, AuthorizationTokenType authorizationTokenType) {
        return new RxDocumentServiceRequest(clientContext, operation, resourceType, relativePath, bytes, headers, authorizationTokenType);
    }

    public static RxDocumentServiceRequest create(DiagnosticsClientContext clientContext, OperationType operation, ResourceType resourceType, String relativePath, Resource resource, Map<String, String> headers) {
        return RxDocumentServiceRequest.create(clientContext, operation, resourceType, relativePath, resource, headers, (Object)null);
    }

    public static RxDocumentServiceRequest create(DiagnosticsClientContext clientContext, OperationType operation, ResourceType resourceType, String relativePath, Resource resource, Map<String, String> headers, Object options) {
        RxDocumentServiceRequest request = new RxDocumentServiceRequest(clientContext, operation, resourceType, relativePath, resource.serializeJsonToByteBuffer(CosmosItemSerializer.DEFAULT_SERIALIZER, null), headers, AuthorizationTokenType.PrimaryMasterKey);
        request.properties = RxDocumentServiceRequest.getProperties(options);
        request.throughputControlGroupName = RxDocumentServiceRequest.getThroughputControlGroupName(options);
        return request;
    }

    public static RxDocumentServiceRequest create(DiagnosticsClientContext clientContext, OperationType operation, ResourceType resourceType, String relativePath, ByteBuffer byteBuffer, Map<String, String> headers, Object options) {
        RxDocumentServiceRequest request = new RxDocumentServiceRequest(clientContext, operation, resourceType, relativePath, byteBuffer, headers, AuthorizationTokenType.PrimaryMasterKey);
        request.properties = RxDocumentServiceRequest.getProperties(options);
        request.throughputControlGroupName = RxDocumentServiceRequest.getThroughputControlGroupName(options);
        return request;
    }

    public static RxDocumentServiceRequest create(DiagnosticsClientContext clientContext, OperationType operation, ResourceType resourceType, String relativePath, Map<String, String> headers, Object options, ByteBuffer byteBuffer) {
        RxDocumentServiceRequest request = new RxDocumentServiceRequest(clientContext, operation, resourceType, relativePath, byteBuffer, headers, AuthorizationTokenType.PrimaryMasterKey);
        request.properties = RxDocumentServiceRequest.getProperties(options);
        request.throughputControlGroupName = RxDocumentServiceRequest.getThroughputControlGroupName(options);
        return request;
    }

    public static RxDocumentServiceRequest create(DiagnosticsClientContext clientContext, OperationType operation, ResourceType resourceType, String relativePath, String body, Map<String, String> headers, Object options) {
        RxDocumentServiceRequest request = new RxDocumentServiceRequest(clientContext, operation, resourceType, relativePath, body.getBytes(StandardCharsets.UTF_8), headers, AuthorizationTokenType.PrimaryMasterKey);
        request.properties = RxDocumentServiceRequest.getProperties(options);
        request.throughputControlGroupName = RxDocumentServiceRequest.getThroughputControlGroupName(options);
        return request;
    }

    public static RxDocumentServiceRequest create(DiagnosticsClientContext clientContext, ResourceType resourceType, String relativePath, SqlQuerySpec querySpec, QueryCompatibilityMode queryCompatibilityMode, Map<String, String> headers) {
        switch (queryCompatibilityMode) {
            case SqlQuery: {
                if (querySpec.getParameters().size() > 0) {
                    throw new IllegalArgumentException(String.format("Unsupported argument in query compatibility mode '{%s}'", queryCompatibilityMode.toString()));
                }
                OperationType operation = OperationType.SqlQuery;
                return new RxDocumentServiceRequest(clientContext, operation, resourceType, relativePath, Utils.getUTF8Bytes(querySpec.getQueryText()), headers, AuthorizationTokenType.PrimaryMasterKey);
            }
        }
        OperationType operation = OperationType.Query;
        return new RxDocumentServiceRequest(clientContext, operation, resourceType, relativePath, ModelBridgeInternal.serializeJsonToByteBuffer(querySpec), headers, AuthorizationTokenType.PrimaryMasterKey);
    }

    public static RxDocumentServiceRequest create(DiagnosticsClientContext clientContext, OperationType operation, ResourceType resourceType, String relativePath, Map<String, String> headers) {
        return RxDocumentServiceRequest.create(clientContext, operation, resourceType, relativePath, headers, (Object)null);
    }

    public static RxDocumentServiceRequest create(DiagnosticsClientContext clientContext, OperationType operation, ResourceType resourceType, String relativePath, Map<String, String> headers, Object options) {
        RxDocumentServiceRequest request = new RxDocumentServiceRequest(clientContext, operation, resourceType, relativePath, headers, AuthorizationTokenType.PrimaryMasterKey);
        request.properties = RxDocumentServiceRequest.getProperties(options);
        request.throughputControlGroupName = RxDocumentServiceRequest.getThroughputControlGroupName(options);
        return request;
    }

    public static RxDocumentServiceRequest create(DiagnosticsClientContext clientContext, OperationType operation, ResourceType resourceType, String relativePath, Map<String, String> headers, AuthorizationTokenType authorizationTokenType) {
        return new RxDocumentServiceRequest(clientContext, operation, resourceType, relativePath, headers, authorizationTokenType);
    }

    public static RxDocumentServiceRequest create(DiagnosticsClientContext clientContext, OperationType operation, Resource resource, ResourceType resourceType, String relativePath, Map<String, String> headers) {
        ByteBuffer resourceContent = resource.serializeJsonToByteBuffer(CosmosItemSerializer.DEFAULT_SERIALIZER, null);
        return new RxDocumentServiceRequest(clientContext, operation, resourceType, relativePath, resourceContent, headers, AuthorizationTokenType.PrimaryMasterKey);
    }

    public static RxDocumentServiceRequest create(DiagnosticsClientContext clientContext, OperationType operation, Resource resource, ResourceType resourceType, String relativePath, Map<String, String> headers, AuthorizationTokenType authorizationTokenType) {
        ByteBuffer resourceContent = resource.serializeJsonToByteBuffer(CosmosItemSerializer.DEFAULT_SERIALIZER, null);
        return new RxDocumentServiceRequest(clientContext, operation, resourceType, relativePath, resourceContent, headers, authorizationTokenType);
    }

    public static RxDocumentServiceRequest create(DiagnosticsClientContext clientContext, OperationType operation, String resourceId, ResourceType resourceType, Map<String, String> headers) {
        return new RxDocumentServiceRequest(clientContext, operation, resourceId, resourceType, (ByteBuffer)null, headers, false, AuthorizationTokenType.PrimaryMasterKey);
    }

    public static RxDocumentServiceRequest create(DiagnosticsClientContext clientContext, OperationType operation, String resourceId, ResourceType resourceType, Map<String, String> headers, AuthorizationTokenType authorizationTokenType) {
        return new RxDocumentServiceRequest(clientContext, operation, resourceId, resourceType, (ByteBuffer)null, headers, false, authorizationTokenType);
    }

    public static RxDocumentServiceRequest create(DiagnosticsClientContext clientContext, OperationType operation, String resourceId, ResourceType resourceType, Resource resource, Map<String, String> headers) {
        ByteBuffer resourceContent = resource.serializeJsonToByteBuffer(CosmosItemSerializer.DEFAULT_SERIALIZER, null);
        return new RxDocumentServiceRequest(clientContext, operation, resourceId, resourceType, resourceContent, headers, false, AuthorizationTokenType.PrimaryMasterKey);
    }

    public static RxDocumentServiceRequest create(DiagnosticsClientContext clientContext, OperationType operation, String resourceId, ResourceType resourceType, Resource resource, Map<String, String> headers, AuthorizationTokenType authorizationTokenType) {
        ByteBuffer resourceContent = resource.serializeJsonToByteBuffer(CosmosItemSerializer.DEFAULT_SERIALIZER, null);
        return new RxDocumentServiceRequest(clientContext, operation, resourceId, resourceType, resourceContent, headers, false, authorizationTokenType);
    }

    public static RxDocumentServiceRequest create(DiagnosticsClientContext clientContext, OperationType operation, ResourceType resourceType) {
        return new RxDocumentServiceRequest(clientContext, operation, resourceType, null, null);
    }

    public static RxDocumentServiceRequest createFromName(DiagnosticsClientContext clientContext, OperationType operationType, String resourceFullName, ResourceType resourceType) {
        return new RxDocumentServiceRequest(clientContext, operationType, resourceFullName, resourceType, (ByteBuffer)null, new HashMap<String, String>(), true, AuthorizationTokenType.PrimaryMasterKey);
    }

    public static RxDocumentServiceRequest createFromName(DiagnosticsClientContext clientContext, OperationType operationType, String resourceFullName, ResourceType resourceType, AuthorizationTokenType authorizationTokenType) {
        return new RxDocumentServiceRequest(clientContext, operationType, resourceFullName, resourceType, (ByteBuffer)null, new HashMap<String, String>(), true, authorizationTokenType);
    }

    public static RxDocumentServiceRequest createFromName(DiagnosticsClientContext clientContext, OperationType operationType, Resource resource, String resourceFullName, ResourceType resourceType) {
        ByteBuffer resourceContent = resource.serializeJsonToByteBuffer(CosmosItemSerializer.DEFAULT_SERIALIZER, null);
        return new RxDocumentServiceRequest(clientContext, operationType, resourceFullName, resourceType, resourceContent, new HashMap<String, String>(), true, AuthorizationTokenType.PrimaryMasterKey);
    }

    public static RxDocumentServiceRequest createFromName(DiagnosticsClientContext clientContext, OperationType operationType, Resource resource, String resourceFullName, ResourceType resourceType, AuthorizationTokenType authorizationTokenType) {
        ByteBuffer resourceContent = resource.serializeJsonToByteBuffer(CosmosItemSerializer.DEFAULT_SERIALIZER, null);
        return new RxDocumentServiceRequest(clientContext, operationType, resourceFullName, resourceType, resourceContent, new HashMap<String, String>(), true, authorizationTokenType);
    }

    static String getAttachmentIdFromMediaId(String mediaId) {
        String attachmentId;
        byte[] buffer = Utils.Base64Decoder.decode(mediaId.replace('-', '/').getBytes(StandardCharsets.UTF_8));
        int resoureIdLength = 20;
        if (buffer.length > 20) {
            byte[] newBuffer = new byte[20];
            System.arraycopy(buffer, 0, newBuffer, 0, 20);
            attachmentId = Utils.encodeBase64String(newBuffer).replace('/', '-');
        } else {
            attachmentId = mediaId;
        }
        return attachmentId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getContinuation() {
        return this.continuation;
    }

    public void setContinuation(String continuation) {
        this.continuation = continuation;
    }

    public boolean getIsMedia() {
        return this.isMedia;
    }

    public void setIsMedia(boolean isMedia) {
        this.isMedia = isMedia;
    }

    public boolean getIsNameBased() {
        return this.isNameBased;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public String getResourceAddress() {
        return this.resourceAddress;
    }

    public boolean isForceNameCacheRefresh() {
        return this.forceNameCacheRefresh;
    }

    public void setForceNameCacheRefresh(boolean forceNameCacheRefresh) {
        this.forceNameCacheRefresh = forceNameCacheRefresh;
    }

    public URI getEndpointOverride() {
        return this.endpointOverride;
    }

    public void setEndpointOverride(URI endpointOverride) {
        this.endpointOverride = endpointOverride;
    }

    public UUID getActivityId() {
        return this.activityId;
    }

    public PartitionKeyRangeIdentity getPartitionKeyRangeIdentity() {
        return this.partitionKeyRangeIdentity;
    }

    public void routeTo(PartitionKeyRangeIdentity partitionKeyRangeIdentity) {
        this.setPartitionKeyRangeIdentity(partitionKeyRangeIdentity);
    }

    public FeedRangeInternal getFeedRange() {
        return this.feedRange;
    }

    public void applyFeedRangeFilter(FeedRangeInternal feedRange) {
        this.feedRange = feedRange;
    }

    public Range<String> getEffectiveRange() {
        return this.effectiveRange;
    }

    public void setEffectiveRange(Range<String> range) {
        this.effectiveRange = range;
    }

    public void setPartitionKeyRangeIdentity(PartitionKeyRangeIdentity partitionKeyRangeIdentity) {
        this.partitionKeyRangeIdentity = partitionKeyRangeIdentity;
        if (partitionKeyRangeIdentity != null) {
            this.headers.put("x-ms-documentdb-partitionkeyrangeid", partitionKeyRangeIdentity.toHeader());
        } else {
            this.headers.remove("x-ms-documentdb-partitionkeyrangeid");
        }
    }

    public String getOriginalSessionToken() {
        return this.originalSessionToken;
    }

    public void setOriginalSessionToken(String originalSessionToken) {
        this.originalSessionToken = originalSessionToken;
    }

    public void setDefaultReplicaIndex(Integer defaultReplicaIndex) {
        this.defaultReplicaIndex = defaultReplicaIndex;
    }

    public Integer getDefaultReplicaIndex() {
        return this.defaultReplicaIndex;
    }

    public void setPartitionKeyInternal(PartitionKeyInternal partitionKeyInternal) {
        this.partitionKeyInternal = partitionKeyInternal;
    }

    public PartitionKeyInternal getPartitionKeyInternal() {
        return this.partitionKeyInternal;
    }

    public void setPartitionKeyDefinition(PartitionKeyDefinition partitionKeyDefinition) {
        this.partitionKeyDefinition = partitionKeyDefinition;
    }

    public PartitionKeyDefinition getPartitionKeyDefinition() {
        return this.partitionKeyDefinition;
    }

    public boolean isChangeFeedRequest() {
        return this.headers.containsKey("A-IM");
    }

    public boolean isWritingToMaster() {
        return this.operationType.isWriteOperation() && this.resourceType.isMasterResource();
    }

    public boolean isReadingFromMaster() {
        return this.resourceType == ResourceType.Offer || this.resourceType == ResourceType.Database || this.resourceType == ResourceType.User || this.resourceType == ResourceType.Permission || this.resourceType == ResourceType.Topology || this.resourceType == ResourceType.DatabaseAccount || this.resourceType == ResourceType.PartitionKeyRange || this.resourceType == ResourceType.DocumentCollection && (this.operationType == OperationType.ReadFeed || this.operationType == OperationType.Query || this.operationType == OperationType.SqlQuery);
    }

    public boolean isValidAddress(ResourceType resourceType) {
        ResourceType resourceTypeToValidate = ResourceType.Unknown;
        if (resourceType != ResourceType.Unknown) {
            resourceTypeToValidate = resourceType;
        } else if (!this.isFeed) {
            resourceTypeToValidate = this.resourceType;
        } else {
            if (this.resourceType == ResourceType.Database) {
                return true;
            }
            if (this.resourceType == ResourceType.DocumentCollection || this.resourceType == ResourceType.User) {
                resourceTypeToValidate = ResourceType.Database;
            } else if (this.resourceType == ResourceType.Permission) {
                resourceTypeToValidate = ResourceType.User;
            } else if (this.resourceType == ResourceType.Document || this.resourceType == ResourceType.StoredProcedure || this.resourceType == ResourceType.UserDefinedFunction || this.resourceType == ResourceType.Trigger || this.resourceType == ResourceType.Conflict || this.resourceType == ResourceType.PartitionKeyRange) {
                resourceTypeToValidate = ResourceType.DocumentCollection;
            } else if (this.resourceType == ResourceType.Attachment) {
                resourceTypeToValidate = ResourceType.Document;
            } else {
                return false;
            }
        }
        if (this.isNameBased) {
            return PathsHelper.validateResourceFullName(resourceType != ResourceType.Unknown ? resourceType : resourceTypeToValidate, this.resourceAddress);
        }
        return PathsHelper.validateResourceId(resourceTypeToValidate, this.resourceId);
    }

    public static RxDocumentServiceRequest createFromResource(RxDocumentServiceRequest request, Resource modifiedResource) {
        RxDocumentServiceRequest modifiedRequest = !request.getIsNameBased() ? RxDocumentServiceRequest.create(request.clientContext, request.getOperationType(), request.getResourceId(), request.getResourceType(), modifiedResource, request.headers) : RxDocumentServiceRequest.createFromName(request.clientContext, request.getOperationType(), modifiedResource, request.getResourceAddress(), request.getResourceType());
        return modifiedRequest;
    }

    public void clearRoutingHints() {
        this.partitionKeyRangeIdentity = null;
        this.requestContext.resolvedPartitionKeyRange = null;
    }

    public synchronized Flux<ByteBuf> getContentAsByteBufFlux() {
        if (this.contentAsByteArray == null) {
            return Flux.empty();
        }
        return Flux.just((Object)Unpooled.wrappedBuffer((byte[])this.contentAsByteArray));
    }

    public synchronized Flux<byte[]> getContentAsByteArrayFlux() {
        if (this.contentAsByteArray == null) {
            return Flux.empty();
        }
        return Flux.just((Object)this.contentAsByteArray);
    }

    public int getContentLength() {
        return this.contentAsByteArray != null ? this.contentAsByteArray.length : 0;
    }

    public byte[] getContentAsByteArray() {
        return this.contentAsByteArray;
    }

    public RxDocumentServiceRequest clone() {
        RxDocumentServiceRequest rxDocumentServiceRequest = RxDocumentServiceRequest.create(this.clientContext, this.getOperationType(), this.resourceId, this.isNameBased, this.getResourceType(), this.getHeaders());
        rxDocumentServiceRequest.setPartitionKeyInternal(this.getPartitionKeyInternal());
        rxDocumentServiceRequest.setContentBytes(this.contentAsByteArray);
        rxDocumentServiceRequest.setContinuation(this.getContinuation());
        rxDocumentServiceRequest.setDefaultReplicaIndex(this.getDefaultReplicaIndex());
        rxDocumentServiceRequest.setEndpointOverride(this.getEndpointOverride());
        rxDocumentServiceRequest.setForceNameCacheRefresh(this.isForceNameCacheRefresh());
        rxDocumentServiceRequest.setIsMedia(this.getIsMedia());
        rxDocumentServiceRequest.setOriginalSessionToken(this.getOriginalSessionToken());
        rxDocumentServiceRequest.setPartitionKeyRangeIdentity(this.getPartitionKeyRangeIdentity());
        rxDocumentServiceRequest.forceCollectionRoutingMapRefresh = this.forceCollectionRoutingMapRefresh;
        rxDocumentServiceRequest.forcePartitionKeyRangeRefresh = this.forcePartitionKeyRangeRefresh;
        rxDocumentServiceRequest.useGatewayMode = this.useGatewayMode;
        rxDocumentServiceRequest.requestContext = this.requestContext;
        rxDocumentServiceRequest.faultInjectionRequestContext = new FaultInjectionRequestContext(this.faultInjectionRequestContext);
        rxDocumentServiceRequest.nonIdempotentWriteRetriesEnabled = this.nonIdempotentWriteRetriesEnabled;
        rxDocumentServiceRequest.setResourceAddress(this.resourceAddress);
        rxDocumentServiceRequest.requestContext = this.requestContext.clone();
        rxDocumentServiceRequest.feedRange = this.feedRange;
        rxDocumentServiceRequest.effectiveRange = this.effectiveRange;
        rxDocumentServiceRequest.isFeed = this.isFeed;
        return rxDocumentServiceRequest;
    }

    private static RxDocumentServiceRequest create(DiagnosticsClientContext clientContext, OperationType operationType, String resourceId, boolean isNameBased, ResourceType resourceType, Map<String, String> headers) {
        return new RxDocumentServiceRequest(clientContext, operationType, resourceId, resourceType, (ByteBuffer)null, headers, isNameBased, AuthorizationTokenType.PrimaryMasterKey);
    }

    public void dispose() {
        if (this.isDisposed) {
            return;
        }
        if (this.contentAsByteArray != null) {
            this.contentAsByteArray = null;
        }
        this.isDisposed = true;
    }

    private static Map<String, Object> getProperties(Object options) {
        if (options == null) {
            return null;
        }
        if (options instanceof RequestOptions) {
            return ((RequestOptions)options).getProperties();
        }
        if (options instanceof CosmosQueryRequestOptions) {
            return ModelBridgeInternal.getPropertiesFromQueryRequestOptions((CosmosQueryRequestOptions)options);
        }
        if (options instanceof CosmosChangeFeedRequestOptions) {
            return ModelBridgeInternal.getPropertiesFromChangeFeedRequestOptions((CosmosChangeFeedRequestOptions)options);
        }
        return null;
    }

    private static String getThroughputControlGroupName(Object options) {
        if (options == null) {
            return null;
        }
        if (options instanceof RequestOptions) {
            return ((RequestOptions)options).getThroughputControlGroupName();
        }
        if (options instanceof CosmosQueryRequestOptions) {
            return ((CosmosQueryRequestOptions)options).getThroughputControlGroupName();
        }
        if (options instanceof CosmosChangeFeedRequestOptions) {
            return ((CosmosChangeFeedRequestOptions)options).getThroughputControlGroupName();
        }
        return null;
    }

    public static byte[] toByteArray(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        byteBuffer.rewind();
        byte[] arr = new byte[byteBuffer.limit()];
        byteBuffer.get(arr);
        return arr;
    }

    private static ByteBuffer wrapByteBuffer(byte[] bytes) {
        return bytes != null ? ByteBuffer.wrap(bytes) : null;
    }

    public CosmosDiagnostics createCosmosDiagnostics() {
        return this.clientContext.createDiagnostics();
    }

    public boolean isAddressRefresh() {
        return this.isAddressRefresh;
    }

    public boolean shouldForceAddressRefresh() {
        return this.isForcedAddressRefresh;
    }

    public void setAddressRefresh(boolean addressRefresh, boolean shouldForceAddressRefresh) {
        this.isAddressRefresh = addressRefresh;
        this.isForcedAddressRefresh = shouldForceAddressRefresh;
    }

    public String getThroughputControlGroupName() {
        return this.throughputControlGroupName;
    }

    public int getNumberOfItemsInBatchRequest() {
        return this.numberOfItemsInBatchRequest;
    }

    public void setNumberOfItemsInBatchRequest(int numberOfItemsInBatchRequest) {
        this.numberOfItemsInBatchRequest = numberOfItemsInBatchRequest;
    }

    public void setPriorityLevel(PriorityLevel priorityLevel) {
        if (priorityLevel != null) {
            this.headers.put("x-ms-cosmos-priority-level", priorityLevel.toString());
        }
    }

    public Duration getResponseTimeout() {
        return this.responseTimeout;
    }

    public void setResponseTimeout(Duration responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public String getEffectivePartitionKey() {
        return this.effectivePartitionKey;
    }

    public void setEffectivePartitionKey(String effectivePartitionKey) {
        this.effectivePartitionKey = effectivePartitionKey;
    }
}

