/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import java.net.URI;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Uri {
    private static final Logger logger = LoggerFactory.getLogger(Uri.class);
    private static long DEFAULT_NON_HEALTHY_RESET_TIME_IN_MILLISECONDS = 60000L;
    private final String uriAsString;
    private final URI uri;
    private final AtomicReference<HealthStatusAndDiagnosticStringTuple> healthStatusTuple;
    private volatile Instant lastUnknownTimestamp;
    private volatile Instant lastUnhealthyPendingTimestamp;
    private volatile Instant lastTransitionToUnhealthyTimestamp;
    private volatile boolean isPrimary;

    public static Uri create(String uriAsString) {
        return new Uri(uriAsString);
    }

    public Uri(String uri) {
        this.uriAsString = uri;
        URI uriValue = null;
        try {
            uriValue = URI.create(uri);
        }
        catch (IllegalArgumentException e) {
            uriValue = null;
        }
        this.uri = uriValue;
        this.healthStatusTuple = new AtomicReference<HealthStatusAndDiagnosticStringTuple>(new HealthStatusAndDiagnosticStringTuple(uriValue, HealthStatus.Unknown));
        this.lastUnknownTimestamp = Instant.now();
        this.lastUnhealthyPendingTimestamp = null;
        this.lastTransitionToUnhealthyTimestamp = null;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getURIAsString() {
        return this.uriAsString;
    }

    public void setPrimary(boolean primary) {
        this.isPrimary = primary;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public void setConnected() {
        this.setHealthStatus(HealthStatus.Connected);
    }

    public void setUnhealthy() {
        this.setHealthStatus(HealthStatus.Unhealthy);
    }

    public void setRefreshed() {
        if (this.healthStatusTuple.get().status == HealthStatus.Unhealthy) {
            this.setHealthStatus(HealthStatus.UnhealthyPending);
        }
    }

    public void setHealthStatus(HealthStatus status) {
        this.healthStatusTuple.updateAndGet(previousStatusTuple -> {
            HealthStatus newStatus = ((HealthStatusAndDiagnosticStringTuple)previousStatusTuple).status;
            switch (status) {
                case Unhealthy: {
                    if (((HealthStatusAndDiagnosticStringTuple)previousStatusTuple).status != HealthStatus.Unhealthy || this.lastTransitionToUnhealthyTimestamp == null) {
                        this.lastTransitionToUnhealthyTimestamp = Instant.now();
                    }
                    newStatus = status;
                    break;
                }
                case UnhealthyPending: {
                    if (((HealthStatusAndDiagnosticStringTuple)previousStatusTuple).status != HealthStatus.Unhealthy && ((HealthStatusAndDiagnosticStringTuple)previousStatusTuple).status != HealthStatus.UnhealthyPending) break;
                    this.lastUnhealthyPendingTimestamp = Instant.now();
                    newStatus = status;
                    break;
                }
                case Connected: {
                    if (((HealthStatusAndDiagnosticStringTuple)previousStatusTuple).status == HealthStatus.Unhealthy && (((HealthStatusAndDiagnosticStringTuple)previousStatusTuple).status != HealthStatus.Unhealthy || Instant.now().compareTo(this.lastTransitionToUnhealthyTimestamp.plusMillis(DEFAULT_NON_HEALTHY_RESET_TIME_IN_MILLISECONDS)) <= 0)) break;
                    newStatus = status;
                    break;
                }
                case Unknown: {
                    throw new IllegalStateException("It is impossible to set to unknown status");
                }
                default: {
                    throw new IllegalStateException("Unsupported health status: " + (Object)((Object)status));
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Called setHealthStatus with status [{}]. Result: previousStatus [{}], newStatus [{}]", new Object[]{status, previousStatusTuple, newStatus});
            }
            return new HealthStatusAndDiagnosticStringTuple(this.uri, newStatus);
        });
    }

    public HealthStatus getHealthStatus() {
        return this.healthStatusTuple.get().status;
    }

    public HealthStatus getEffectiveHealthStatus() {
        HealthStatus snapshot = this.healthStatusTuple.get().status;
        switch (snapshot) {
            case Connected: 
            case Unhealthy: {
                return snapshot;
            }
            case Unknown: {
                if (Instant.now().compareTo(this.lastUnknownTimestamp.plusMillis(DEFAULT_NON_HEALTHY_RESET_TIME_IN_MILLISECONDS)) > 0) {
                    return HealthStatus.Connected;
                }
                return snapshot;
            }
            case UnhealthyPending: {
                if (Instant.now().compareTo(this.lastUnhealthyPendingTimestamp.plusMillis(DEFAULT_NON_HEALTHY_RESET_TIME_IN_MILLISECONDS)) > 0) {
                    return HealthStatus.Connected;
                }
                return snapshot;
            }
        }
        throw new IllegalStateException("Unknown status " + (Object)((Object)snapshot));
    }

    public boolean shouldRefreshHealthStatus() {
        return this.healthStatusTuple.get().status == HealthStatus.Unhealthy && Instant.now().compareTo(this.lastTransitionToUnhealthyTimestamp.plusMillis(DEFAULT_NON_HEALTHY_RESET_TIME_IN_MILLISECONDS)) >= 0;
    }

    public String getHealthStatusDiagnosticString() {
        return this.healthStatusTuple.get().diagnsoticString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Uri uri1 = (Uri)o;
        return this.uriAsString.equals(uri1.uriAsString) && this.uri.equals(uri1.uri);
    }

    public int hashCode() {
        return Objects.hash(this.uriAsString, this.uri);
    }

    public String toString() {
        return this.uriAsString;
    }

    static class HealthStatusAndDiagnosticStringTuple {
        private final String diagnsoticString;
        private final HealthStatus status;

        public HealthStatusAndDiagnosticStringTuple(URI uri, HealthStatus status) {
            this.diagnsoticString = uri.getPort() + ":" + (Object)((Object)status);
            this.status = status;
        }
    }

    public static enum HealthStatus {
        Connected(100),
        Unknown(200),
        UnhealthyPending(300),
        Unhealthy(400);

        private int priority;

        private HealthStatus(int priority) {
            this.priority = priority;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

