/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.Database;
import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.implementation.SerializationDiagnosticsContext;
import com.azure.cosmos.models.CosmosDatabaseProperties;
import com.azure.cosmos.models.CosmosResponse;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Instant;

public class CosmosDatabaseResponse
extends CosmosResponse<CosmosDatabaseProperties> {
    CosmosDatabaseResponse(ResourceResponse<Database> response) {
        super(response);
        ObjectNode bodyAsJson = (ObjectNode)response.getBody();
        if (bodyAsJson == null) {
            super.setProperties(null);
        } else {
            SerializationDiagnosticsContext serializationDiagnosticsContext = BridgeInternal.getSerializationDiagnosticsContext(this.getDiagnostics());
            Instant serializationStartTime = Instant.now();
            CosmosDatabaseProperties props = new CosmosDatabaseProperties(bodyAsJson, null);
            Instant serializationEndTime = Instant.now();
            SerializationDiagnosticsContext.SerializationDiagnostics diagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTime, serializationEndTime, SerializationDiagnosticsContext.SerializationType.DATABASE_DESERIALIZATION);
            serializationDiagnosticsContext.addSerializationDiagnostics(diagnostics);
            super.setProperties(props);
        }
    }

    @Override
    public CosmosDatabaseProperties getProperties() {
        return (CosmosDatabaseProperties)super.getProperties();
    }

    public long getDatabaseQuota() {
        return this.resourceResponseWrapper.getDatabaseQuota();
    }

    public long getDatabaseUsage() {
        return this.resourceResponseWrapper.getDatabaseUsage();
    }
}

