/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosAsyncClientEncryptionKey;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosAsyncUser;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.AsyncDocumentClient;
import com.azure.cosmos.implementation.CosmosPagedFluxOptions;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.Offer;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.QueryFeedOperationState;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.models.CosmosClientEncryptionKeyProperties;
import com.azure.cosmos.models.CosmosClientEncryptionKeyResponse;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.CosmosContainerRequestOptions;
import com.azure.cosmos.models.CosmosContainerResponse;
import com.azure.cosmos.models.CosmosDatabaseRequestOptions;
import com.azure.cosmos.models.CosmosDatabaseResponse;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.CosmosUserProperties;
import com.azure.cosmos.models.CosmosUserResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.SqlParameter;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.cosmos.models.ThroughputProperties;
import com.azure.cosmos.models.ThroughputResponse;
import com.azure.cosmos.util.CosmosPagedFlux;
import com.azure.cosmos.util.UtilBridgeInternal;
import java.util.Collections;
import java.util.List;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public class CosmosAsyncDatabase {
    private static final ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.CosmosQueryRequestOptionsAccessor queryOptionsAccessor = ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor();
    private static final ImplementationBridgeHelpers.FeedResponseHelper.FeedResponseAccessor feedResponseAccessor = ImplementationBridgeHelpers.FeedResponseHelper.getFeedResponseAccessor();
    private final CosmosAsyncClient client;
    private final String id;
    private final String link;

    CosmosAsyncDatabase(String id, CosmosAsyncClient client) {
        this.id = id;
        this.client = client;
        this.link = this.getParentLink() + "/" + this.getURIPathSegment() + "/" + this.getId();
    }

    public String getId() {
        return this.id;
    }

    public Mono<CosmosDatabaseResponse> read() {
        return this.read(new CosmosDatabaseRequestOptions());
    }

    public Mono<CosmosDatabaseResponse> read(CosmosDatabaseRequestOptions options) {
        CosmosDatabaseRequestOptions requestOptions = options == null ? new CosmosDatabaseRequestOptions() : options;
        return FluxUtil.withContext(context -> this.readInternal(requestOptions, (Context)context));
    }

    public Mono<CosmosDatabaseResponse> delete() {
        return this.delete(new CosmosDatabaseRequestOptions());
    }

    public Mono<CosmosDatabaseResponse> delete(CosmosDatabaseRequestOptions options) {
        CosmosDatabaseRequestOptions requestOptions = options == null ? new CosmosDatabaseRequestOptions() : options;
        return FluxUtil.withContext(context -> this.deleteInternal(requestOptions, (Context)context));
    }

    public Mono<CosmosContainerResponse> createContainer(CosmosContainerProperties containerProperties) {
        return this.createContainer(containerProperties, new CosmosContainerRequestOptions());
    }

    public Mono<CosmosContainerResponse> createContainer(CosmosContainerProperties containerProperties, ThroughputProperties throughputProperties) {
        if (containerProperties == null) {
            throw new IllegalArgumentException("containerProperties");
        }
        CosmosContainerRequestOptions options = new CosmosContainerRequestOptions();
        ModelBridgeInternal.setThroughputProperties(options, throughputProperties);
        return this.createContainer(containerProperties, options);
    }

    public Mono<CosmosContainerResponse> createContainer(CosmosContainerProperties containerProperties, ThroughputProperties throughputProperties, CosmosContainerRequestOptions options) {
        ModelBridgeInternal.setThroughputProperties(options, throughputProperties);
        return this.createContainer(containerProperties, options);
    }

    public Mono<CosmosContainerResponse> createContainer(CosmosContainerProperties containerProperties, CosmosContainerRequestOptions options) {
        if (containerProperties == null) {
            throw new IllegalArgumentException("containerProperties");
        }
        CosmosContainerRequestOptions requestOptions = options == null ? new CosmosContainerRequestOptions() : options;
        return FluxUtil.withContext(context -> this.createContainerInternal(containerProperties, requestOptions, (Context)context));
    }

    Mono<CosmosContainerResponse> createContainer(CosmosContainerProperties containerProperties, int throughput, CosmosContainerRequestOptions options) {
        if (options == null) {
            options = new CosmosContainerRequestOptions();
        }
        ModelBridgeInternal.setThroughputProperties(options, ThroughputProperties.createManualThroughput(throughput));
        return this.createContainer(containerProperties, options);
    }

    public Mono<CosmosContainerResponse> createContainer(String id, String partitionKeyPath) {
        return this.createContainer(new CosmosContainerProperties(id, partitionKeyPath));
    }

    public Mono<CosmosContainerResponse> createContainer(String id, String partitionKeyPath, ThroughputProperties throughputProperties) {
        CosmosContainerRequestOptions options = new CosmosContainerRequestOptions();
        ModelBridgeInternal.setThroughputProperties(options, throughputProperties);
        return this.createContainer(new CosmosContainerProperties(id, partitionKeyPath), options);
    }

    public Mono<CosmosContainerResponse> createContainerIfNotExists(CosmosContainerProperties containerProperties) {
        CosmosAsyncContainer container = this.getContainer(containerProperties.getId());
        return FluxUtil.withContext(context -> this.createContainerIfNotExistsInternal(containerProperties, container, null, (Context)context));
    }

    Mono<CosmosContainerResponse> createContainerIfNotExists(CosmosContainerProperties containerProperties, int throughput) {
        CosmosContainerRequestOptions options = new CosmosContainerRequestOptions();
        ModelBridgeInternal.setThroughputProperties(options, ThroughputProperties.createManualThroughput(throughput));
        CosmosAsyncContainer container = this.getContainer(containerProperties.getId());
        return FluxUtil.withContext(context -> this.createContainerIfNotExistsInternal(containerProperties, container, options, (Context)context));
    }

    public Mono<CosmosContainerResponse> createContainerIfNotExists(CosmosContainerProperties containerProperties, ThroughputProperties throughputProperties) {
        CosmosContainerRequestOptions options = new CosmosContainerRequestOptions();
        ModelBridgeInternal.setThroughputProperties(options, throughputProperties);
        CosmosAsyncContainer container = this.getContainer(containerProperties.getId());
        return FluxUtil.withContext(context -> this.createContainerIfNotExistsInternal(containerProperties, container, options, (Context)context));
    }

    public Mono<CosmosContainerResponse> createContainerIfNotExists(String id, String partitionKeyPath) {
        CosmosAsyncContainer container = this.getContainer(id);
        return FluxUtil.withContext(context -> this.createContainerIfNotExistsInternal(new CosmosContainerProperties(id, partitionKeyPath), container, null, (Context)context));
    }

    public Mono<CosmosContainerResponse> createContainerIfNotExists(String id, String partitionKeyPath, ThroughputProperties throughputProperties) {
        CosmosContainerRequestOptions options = new CosmosContainerRequestOptions();
        ModelBridgeInternal.setThroughputProperties(options, throughputProperties);
        CosmosAsyncContainer container = this.getContainer(id);
        return FluxUtil.withContext(context -> this.createContainerIfNotExistsInternal(new CosmosContainerProperties(id, partitionKeyPath), container, options, (Context)context));
    }

    Mono<CosmosContainerResponse> createContainerIfNotExists(String id, String partitionKeyPath, int throughput) {
        CosmosContainerRequestOptions options = new CosmosContainerRequestOptions();
        ModelBridgeInternal.setThroughputProperties(options, ThroughputProperties.createManualThroughput(throughput));
        CosmosAsyncContainer container = this.getContainer(id);
        return FluxUtil.withContext(context -> this.createContainerIfNotExistsInternal(new CosmosContainerProperties(id, partitionKeyPath), container, options, (Context)context));
    }

    public CosmosPagedFlux<CosmosContainerProperties> readAllContainers(CosmosQueryRequestOptions options) {
        CosmosQueryRequestOptions requestOptions = options == null ? new CosmosQueryRequestOptions() : options;
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            String spanName = "readAllContainers." + this.getId();
            CosmosAsyncClient client = this.getClient();
            String operationId = ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor().getQueryNameOrDefault(requestOptions, spanName);
            QueryFeedOperationState state = new QueryFeedOperationState(client, spanName, this.getId(), null, ResourceType.DocumentCollection, OperationType.ReadFeed, queryOptionsAccessor.getQueryNameOrDefault(requestOptions, spanName), requestOptions, (CosmosPagedFluxOptions)pagedFluxOptions);
            pagedFluxOptions.setFeedOperationState(state);
            return this.getDocClientWrapper().readCollections(this.getLink(), state).map(response -> feedResponseAccessor.createFeedResponse(ModelBridgeInternal.getCosmosContainerPropertiesFromV2Results(response.getResults()), response.getResponseHeaders(), response.getCosmosDiagnostics()));
        });
    }

    public CosmosPagedFlux<CosmosContainerProperties> readAllContainers() {
        return this.readAllContainers(new CosmosQueryRequestOptions());
    }

    public CosmosPagedFlux<CosmosContainerProperties> queryContainers(String query) {
        return this.queryContainersInternal(new SqlQuerySpec(query), new CosmosQueryRequestOptions());
    }

    public CosmosPagedFlux<CosmosContainerProperties> queryContainers(String query, CosmosQueryRequestOptions options) {
        if (options == null) {
            options = new CosmosQueryRequestOptions();
        }
        return this.queryContainersInternal(new SqlQuerySpec(query), options);
    }

    public CosmosPagedFlux<CosmosContainerProperties> queryContainers(SqlQuerySpec querySpec) {
        return this.queryContainersInternal(querySpec, new CosmosQueryRequestOptions());
    }

    public CosmosPagedFlux<CosmosContainerProperties> queryContainers(SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        if (options == null) {
            options = new CosmosQueryRequestOptions();
        }
        return this.queryContainersInternal(querySpec, options);
    }

    public CosmosAsyncContainer getContainer(String id) {
        return new CosmosAsyncContainer(id, this);
    }

    public Mono<CosmosUserResponse> createUser(CosmosUserProperties userProperties) {
        return FluxUtil.withContext(context -> this.createUserInternal(userProperties, (Context)context));
    }

    public Mono<CosmosClientEncryptionKeyResponse> createClientEncryptionKey(CosmosClientEncryptionKeyProperties keyProperties) {
        return FluxUtil.withContext(context -> this.createClientEncryptionKeyInternal(keyProperties, (Context)context));
    }

    public Mono<CosmosUserResponse> upsertUser(CosmosUserProperties userProperties) {
        return FluxUtil.withContext(context -> this.upsertUserInternal(userProperties, (Context)context));
    }

    public CosmosPagedFlux<CosmosUserProperties> readAllUsers() {
        return this.readAllUsers(new CosmosQueryRequestOptions());
    }

    CosmosPagedFlux<CosmosUserProperties> readAllUsers(CosmosQueryRequestOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            String spanName = "readAllUsers." + this.getId();
            CosmosAsyncClient client = this.getClient();
            CosmosQueryRequestOptions nonNullOptions = options != null ? options : new CosmosQueryRequestOptions();
            QueryFeedOperationState state = new QueryFeedOperationState(client, spanName, this.getId(), null, ResourceType.User, OperationType.ReadFeed, queryOptionsAccessor.getQueryNameOrDefault(nonNullOptions, spanName), nonNullOptions, (CosmosPagedFluxOptions)pagedFluxOptions);
            pagedFluxOptions.setFeedOperationState(state);
            return this.getDocClientWrapper().readUsers(this.getLink(), state).map(response -> feedResponseAccessor.createFeedResponse(ModelBridgeInternal.getCosmosUserPropertiesFromV2Results(response.getResults()), response.getResponseHeaders(), response.getCosmosDiagnostics()));
        });
    }

    public CosmosAsyncClientEncryptionKey getClientEncryptionKey(String id) {
        return new CosmosAsyncClientEncryptionKey(id, this);
    }

    public CosmosPagedFlux<CosmosClientEncryptionKeyProperties> readAllClientEncryptionKeys() {
        return this.readAllClientEncryptionKeys(new CosmosQueryRequestOptions());
    }

    public CosmosPagedFlux<CosmosClientEncryptionKeyProperties> readAllClientEncryptionKeys(CosmosQueryRequestOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            String spanName = "readAllClientEncryptionKeys." + this.getId();
            CosmosAsyncClient client = this.getClient();
            CosmosQueryRequestOptions nonNullOptions = options != null ? options : new CosmosQueryRequestOptions();
            QueryFeedOperationState state = new QueryFeedOperationState(client, spanName, this.getId(), null, ResourceType.ClientEncryptionKey, OperationType.ReadFeed, queryOptionsAccessor.getQueryNameOrDefault(nonNullOptions, spanName), nonNullOptions, (CosmosPagedFluxOptions)pagedFluxOptions);
            pagedFluxOptions.setFeedOperationState(state);
            return this.getDocClientWrapper().readClientEncryptionKeys(this.getLink(), state).map(response -> feedResponseAccessor.createFeedResponse(ModelBridgeInternal.getClientEncryptionKeyPropertiesList(response.getResults()), response.getResponseHeaders(), response.getCosmosDiagnostics()));
        });
    }

    public CosmosPagedFlux<CosmosClientEncryptionKeyProperties> queryClientEncryptionKeys(String query) {
        return this.queryClientEncryptionKeys(query, new CosmosQueryRequestOptions());
    }

    public CosmosPagedFlux<CosmosClientEncryptionKeyProperties> queryClientEncryptionKeys(String query, CosmosQueryRequestOptions options) {
        if (options == null) {
            options = new CosmosQueryRequestOptions();
        }
        return this.queryClientEncryptionKeysInternal(new SqlQuerySpec(query), options);
    }

    public CosmosPagedFlux<CosmosClientEncryptionKeyProperties> queryClientEncryptionKeys(SqlQuerySpec querySpec) {
        return this.queryClientEncryptionKeysInternal(querySpec, new CosmosQueryRequestOptions());
    }

    public CosmosPagedFlux<CosmosClientEncryptionKeyProperties> queryClientEncryptionKeys(SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        if (options == null) {
            options = new CosmosQueryRequestOptions();
        }
        return this.queryClientEncryptionKeysInternal(querySpec, options);
    }

    private CosmosPagedFlux<CosmosClientEncryptionKeyProperties> queryClientEncryptionKeysInternal(SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            String spanName = "queryClientEncryptionKeys." + this.getId();
            CosmosAsyncClient client = this.getClient();
            CosmosQueryRequestOptions nonNullOptions = options != null ? options : new CosmosQueryRequestOptions();
            QueryFeedOperationState state = new QueryFeedOperationState(client, spanName, this.getId(), null, ResourceType.ClientEncryptionKey, OperationType.Query, queryOptionsAccessor.getQueryNameOrDefault(nonNullOptions, spanName), nonNullOptions, (CosmosPagedFluxOptions)pagedFluxOptions);
            pagedFluxOptions.setFeedOperationState(state);
            return this.getDocClientWrapper().queryClientEncryptionKeys(this.getLink(), querySpec, state).map(response -> BridgeInternal.createFeedResponseWithQueryMetrics(ModelBridgeInternal.getClientEncryptionKeyPropertiesList(response.getResults()), response.getResponseHeaders(), ModelBridgeInternal.queryMetrics(response), ModelBridgeInternal.getQueryPlanDiagnosticsContext(response), false, false, response.getCosmosDiagnostics()));
        });
    }

    public CosmosPagedFlux<CosmosUserProperties> queryUsers(String query) {
        return this.queryUsers(query, new CosmosQueryRequestOptions());
    }

    public CosmosPagedFlux<CosmosUserProperties> queryUsers(String query, CosmosQueryRequestOptions options) {
        if (options == null) {
            options = new CosmosQueryRequestOptions();
        }
        return this.queryUsersInternal(new SqlQuerySpec(query), options);
    }

    public CosmosPagedFlux<CosmosUserProperties> queryUsers(SqlQuerySpec querySpec) {
        return this.queryUsersInternal(querySpec, new CosmosQueryRequestOptions());
    }

    public CosmosPagedFlux<CosmosUserProperties> queryUsers(SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        if (options == null) {
            options = new CosmosQueryRequestOptions();
        }
        return this.queryUsersInternal(querySpec, options);
    }

    public CosmosAsyncUser getUser(String id) {
        return new CosmosAsyncUser(id, this);
    }

    public Mono<ThroughputResponse> replaceThroughput(ThroughputProperties throughputProperties) {
        return FluxUtil.withContext(context -> this.replaceThroughputInternal(throughputProperties, (Context)context));
    }

    public Mono<ThroughputResponse> readThroughput() {
        return FluxUtil.withContext(this::readThroughputInternal);
    }

    SqlQuerySpec getOfferQuerySpecFromResourceId(String resourceId) {
        String queryText = "select * from c where c.offerResourceId = @resourceId";
        SqlQuerySpec querySpec = new SqlQuerySpec(queryText);
        List<SqlParameter> parameters = Collections.singletonList(new SqlParameter("@resourceId", resourceId));
        querySpec.setParameters(parameters);
        return querySpec;
    }

    CosmosAsyncClient getClient() {
        return this.client;
    }

    AsyncDocumentClient getDocClientWrapper() {
        return this.client.getDocClientWrapper();
    }

    String getURIPathSegment() {
        return "dbs";
    }

    String getParentLink() {
        return "";
    }

    String getLink() {
        return this.link;
    }

    private CosmosPagedFlux<CosmosContainerProperties> queryContainersInternal(SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            String spanName = "queryContainers." + this.getId();
            CosmosAsyncClient client = this.getClient();
            CosmosQueryRequestOptions nonNullOptions = options != null ? options : new CosmosQueryRequestOptions();
            QueryFeedOperationState state = new QueryFeedOperationState(client, spanName, this.getId(), null, ResourceType.DocumentCollection, OperationType.Query, queryOptionsAccessor.getQueryNameOrDefault(nonNullOptions, spanName), nonNullOptions, (CosmosPagedFluxOptions)pagedFluxOptions);
            pagedFluxOptions.setFeedOperationState(state);
            return this.getDocClientWrapper().queryCollections(this.getLink(), querySpec, state).map(response -> feedResponseAccessor.createFeedResponse(ModelBridgeInternal.getCosmosContainerPropertiesFromV2Results(response.getResults()), response.getResponseHeaders(), response.getCosmosDiagnostics()));
        });
    }

    private CosmosPagedFlux<CosmosUserProperties> queryUsersInternal(SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            String spanName = "queryUsers." + this.getId();
            CosmosAsyncClient client = this.getClient();
            CosmosQueryRequestOptions nonNullOptions = options != null ? options : new CosmosQueryRequestOptions();
            QueryFeedOperationState state = new QueryFeedOperationState(client, spanName, this.getId(), null, ResourceType.User, OperationType.Query, queryOptionsAccessor.getQueryNameOrDefault(nonNullOptions, spanName), nonNullOptions, (CosmosPagedFluxOptions)pagedFluxOptions);
            pagedFluxOptions.setFeedOperationState(state);
            return this.getDocClientWrapper().queryUsers(this.getLink(), querySpec, state).map(response -> BridgeInternal.createFeedResponseWithQueryMetrics(ModelBridgeInternal.getCosmosUserPropertiesFromV2Results(response.getResults()), response.getResponseHeaders(), ModelBridgeInternal.queryMetrics(response), ModelBridgeInternal.getQueryPlanDiagnosticsContext(response), false, false, response.getCosmosDiagnostics()));
        });
    }

    private Mono<CosmosContainerResponse> createContainerIfNotExistsInternal(CosmosContainerProperties containerProperties, CosmosAsyncContainer container, CosmosContainerRequestOptions options, Context context) {
        String spanName = "createContainerIfNotExists." + containerProperties.getId();
        Context nestedContext = context.addData((Object)"cosmosCallDepth", (Object)"nested");
        CosmosContainerRequestOptions requestOptions = options == null ? new CosmosContainerRequestOptions() : options;
        Mono responseMono = container.read(requestOptions, nestedContext).onErrorResume(exception -> {
            CosmosException cosmosException;
            Throwable unwrappedException = Exceptions.unwrap((Throwable)exception);
            if (unwrappedException instanceof CosmosException && (cosmosException = (CosmosException)((Object)((Object)unwrappedException))).getStatusCode() == 404) {
                return this.createContainerInternal(containerProperties, requestOptions, nestedContext);
            }
            return Mono.error((Throwable)unwrappedException);
        });
        return this.client.getDiagnosticsProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.getId(), containerProperties.getId(), this.client, null, OperationType.Create, ResourceType.DocumentCollection, ModelBridgeInternal.toRequestOptions(requestOptions));
    }

    private Mono<CosmosContainerResponse> createContainerInternal(CosmosContainerProperties containerProperties, CosmosContainerRequestOptions options, Context context) {
        String spanName = "createContainer." + containerProperties.getId();
        RequestOptions nonNullRequestOptions = options != null ? ModelBridgeInternal.toRequestOptions(options) : new RequestOptions();
        Mono responseMono = this.getDocClientWrapper().createCollection(this.getLink(), ModelBridgeInternal.getV2Collection(containerProperties), nonNullRequestOptions).map(ModelBridgeInternal::createCosmosContainerResponse).single();
        return this.client.getDiagnosticsProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.getId(), containerProperties.getId(), this.client, null, OperationType.Create, ResourceType.DocumentCollection, nonNullRequestOptions);
    }

    Mono<CosmosDatabaseResponse> readInternal(CosmosDatabaseRequestOptions options, Context context) {
        String spanName = "readDatabase." + this.getId();
        RequestOptions nonNullRequestOptions = options != null ? ModelBridgeInternal.toRequestOptions(options) : new RequestOptions();
        Mono responseMono = this.getDocClientWrapper().readDatabase(this.getLink(), nonNullRequestOptions).map(ModelBridgeInternal::createCosmosDatabaseResponse).single();
        return this.client.getDiagnosticsProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.getId(), null, this.client, null, OperationType.Read, ResourceType.Database, nonNullRequestOptions);
    }

    private Mono<CosmosDatabaseResponse> deleteInternal(CosmosDatabaseRequestOptions options, Context context) {
        String spanName = "deleteDatabase." + this.getId();
        RequestOptions nonNullRequestOptions = options != null ? ModelBridgeInternal.toRequestOptions(options) : new RequestOptions();
        Mono responseMono = this.getDocClientWrapper().deleteDatabase(this.getLink(), nonNullRequestOptions).map(ModelBridgeInternal::createCosmosDatabaseResponse).single();
        return this.client.getDiagnosticsProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.getId(), null, this.client, null, OperationType.Delete, ResourceType.Database, nonNullRequestOptions);
    }

    private Mono<CosmosUserResponse> createUserInternal(CosmosUserProperties userProperties, Context context) {
        String spanName = "createUser." + this.getId();
        Mono responseMono = this.getDocClientWrapper().createUser(this.getLink(), ModelBridgeInternal.getV2User(userProperties), null).map(ModelBridgeInternal::createCosmosUserResponse).single();
        return this.client.getDiagnosticsProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.getId(), null, this.client, null, OperationType.Create, ResourceType.User, null);
    }

    private Mono<CosmosUserResponse> upsertUserInternal(CosmosUserProperties userProperties, Context context) {
        String spanName = "upsertUser." + this.getId();
        Mono responseMono = this.getDocClientWrapper().upsertUser(this.getLink(), ModelBridgeInternal.getV2User(userProperties), null).map(ModelBridgeInternal::createCosmosUserResponse).single();
        return this.client.getDiagnosticsProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.getId(), null, this.client, null, OperationType.Upsert, ResourceType.User, null);
    }

    private Mono<CosmosClientEncryptionKeyResponse> createClientEncryptionKeyInternal(CosmosClientEncryptionKeyProperties keyProperties, Context context) {
        String spanName = "createClientEncryptionKey." + this.getId();
        Mono responseMono = this.getDocClientWrapper().createClientEncryptionKey(this.getLink(), ModelBridgeInternal.getClientEncryptionKey(keyProperties), null).map(ModelBridgeInternal::createCosmosClientEncryptionKeyResponse).single();
        return this.client.getDiagnosticsProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.getId(), null, this.client, null, OperationType.Create, ResourceType.ClientEncryptionKey, null);
    }

    private Mono<ThroughputResponse> replaceThroughputInternal(ThroughputProperties throughputProperties, Context context) {
        String spanName = "replaceThroughput." + this.getId();
        Context nestedContext = context.addData((Object)"cosmosCallDepth", (Object)"nested");
        Mono<ThroughputResponse> responseMono = this.replaceThroughputInternal(this.readInternal(new CosmosDatabaseRequestOptions(), nestedContext), throughputProperties);
        return this.client.getDiagnosticsProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.getId(), null, this.client, null, OperationType.Replace, ResourceType.Offer, null);
    }

    private Mono<ThroughputResponse> replaceThroughputInternal(Mono<CosmosDatabaseResponse> responseMono, ThroughputProperties throughputProperties) {
        QueryFeedOperationState state = new QueryFeedOperationState(this.getClient(), "replaceThroughputInternal", this.getId(), null, ResourceType.Offer, OperationType.Query, null, new CosmosQueryRequestOptions(), new CosmosPagedFluxOptions());
        return responseMono.flatMap(response -> this.getDocClientWrapper().queryOffers(this.getOfferQuerySpecFromResourceId(response.getProperties().getResourceId()), state).single().flatMap(offerFeedResponse -> {
            if (offerFeedResponse.getResults().isEmpty()) {
                return Mono.error((Throwable)((Object)BridgeInternal.createCosmosException(400, "No offers found for the resource " + this.getId())));
            }
            Offer existingOffer = (Offer)offerFeedResponse.getResults().get(0);
            Offer updatedOffer = ModelBridgeInternal.updateOfferFromProperties(existingOffer, throughputProperties);
            return this.getDocClientWrapper().replaceOffer(updatedOffer).single();
        }).map(ModelBridgeInternal::createThroughputRespose));
    }

    private Mono<ThroughputResponse> readThroughputInternal(Context context) {
        String spanName = "readThroughput." + this.getId();
        Context nestedContext = context.addData((Object)"cosmosCallDepth", (Object)"nested");
        CosmosQueryRequestOptions qryOptions = new CosmosQueryRequestOptions();
        Mono<ThroughputResponse> responseMono = this.readThroughputInternal(this.readInternal(new CosmosDatabaseRequestOptions(), nestedContext), qryOptions);
        return this.client.getDiagnosticsProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.getId(), null, this.client, null, OperationType.Read, ResourceType.Offer, ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor().toRequestOptions(qryOptions));
    }

    private Mono<ThroughputResponse> readThroughputInternal(Mono<CosmosDatabaseResponse> responseMono, CosmosQueryRequestOptions qryOptions) {
        QueryFeedOperationState state = new QueryFeedOperationState(this.getClient(), "readThroughputInternal", this.getId(), null, ResourceType.Offer, OperationType.Query, null, new CosmosQueryRequestOptions(), new CosmosPagedFluxOptions());
        return responseMono.flatMap(response -> this.getDocClientWrapper().queryOffers(this.getOfferQuerySpecFromResourceId(response.getProperties().getResourceId()), state).single().flatMap(offerFeedResponse -> {
            if (offerFeedResponse.getResults().isEmpty()) {
                return Mono.error((Throwable)((Object)BridgeInternal.createCosmosException(400, "No offers found for the resource " + this.getId()).setDiagnostics(offerFeedResponse.getCosmosDiagnostics())));
            }
            return this.getDocClientWrapper().readOffer(((Offer)offerFeedResponse.getResults().get(0)).getSelfLink()).single();
        }).map(ModelBridgeInternal::createThroughputRespose));
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosAsyncDatabaseHelper.setCosmosAsyncDatabaseAccessor(new ImplementationBridgeHelpers.CosmosAsyncDatabaseHelper.CosmosAsyncDatabaseAccessor(){

            @Override
            public CosmosAsyncClient getCosmosAsyncClient(CosmosAsyncDatabase cosmosAsyncDatabase) {
                return cosmosAsyncDatabase.getClient();
            }

            @Override
            public String getLink(CosmosAsyncDatabase cosmosAsyncDatabase) {
                return cosmosAsyncDatabase.getLink();
            }
        });
    }

    static {
        CosmosAsyncDatabase.initialize();
    }
}

