/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.GlobalEndpointManager;
import com.azure.cosmos.implementation.ISessionContainer;
import com.azure.cosmos.implementation.ISessionToken;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.PartitionKeyBasedBloomFilter;
import com.azure.cosmos.implementation.PartitionScopedRegionLevelProgress;
import com.azure.cosmos.implementation.PathInfo;
import com.azure.cosmos.implementation.PathsHelper;
import com.azure.cosmos.implementation.ResourceId;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.SessionContainerUtil;
import com.azure.cosmos.implementation.SessionTokenHelper;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.NotImplementedException;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.apachecommons.math.util.Pair;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.implementation.routing.PartitionKeyInternalHelper;
import com.azure.cosmos.models.PartitionKeyDefinition;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionScopedSessionContainer
implements ISessionContainer {
    private final Logger logger = LoggerFactory.getLogger(RegionScopedSessionContainer.class);
    private final ConcurrentHashMap<Long, PartitionScopedRegionLevelProgress> collectionResourceIdToPartitionScopedRegionLevelProgress = new ConcurrentHashMap();
    private final PartitionKeyBasedBloomFilter partitionKeyBasedBloomFilter;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
    private final ConcurrentHashMap<String, Long> collectionNameToCollectionResourceId = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, String> collectionResourceIdToCollectionName = new ConcurrentHashMap();
    private final String hostName;
    private boolean disableSessionCapturing;
    private final GlobalEndpointManager globalEndpointManager;
    private final AtomicReference<String> firstPreferredReadableRegionCached;
    private final String regionScopedSessionCapturingOptionsAsString;

    public RegionScopedSessionContainer(String hostName, boolean disableSessionCapturing, GlobalEndpointManager globalEndpointManager) {
        this.hostName = hostName;
        this.disableSessionCapturing = disableSessionCapturing;
        this.globalEndpointManager = globalEndpointManager;
        this.firstPreferredReadableRegionCached = new AtomicReference<String>("");
        this.partitionKeyBasedBloomFilter = new PartitionKeyBasedBloomFilter();
        this.regionScopedSessionCapturingOptionsAsString = RegionScopedSessionContainer.stringifyConfig();
    }

    public RegionScopedSessionContainer(String hostName, boolean disableSessionCapturing) {
        this(hostName, disableSessionCapturing, null);
    }

    public RegionScopedSessionContainer(String hostName) {
        this(hostName, false, null);
    }

    public String getHostName() {
        return this.hostName;
    }

    @Override
    public void setDisableSessionCapturing(boolean value) {
        this.disableSessionCapturing = value;
    }

    @Override
    public boolean getDisableSessionCapturing() {
        return this.disableSessionCapturing;
    }

    @Override
    public String getSessionToken(String collectionLink) {
        PathInfo pathInfo = new PathInfo(false, null, null, false);
        PartitionScopedRegionLevelProgress partitionScopedRegionLevelProgress = null;
        if (PathsHelper.tryParsePathSegments(collectionLink, pathInfo, null)) {
            Long uniqueDocumentCollectionId = null;
            if (pathInfo.isNameBased) {
                String collectionName = PathsHelper.getCollectionPath(pathInfo.resourceIdOrFullName);
                uniqueDocumentCollectionId = this.collectionNameToCollectionResourceId.get(collectionName);
            } else {
                ResourceId resourceId = ResourceId.parse(pathInfo.resourceIdOrFullName);
                if (resourceId.getDocumentCollection() != 0) {
                    uniqueDocumentCollectionId = resourceId.getUniqueDocumentCollectionId();
                }
            }
            if (uniqueDocumentCollectionId != null) {
                partitionScopedRegionLevelProgress = this.collectionResourceIdToPartitionScopedRegionLevelProgress.get(uniqueDocumentCollectionId);
            }
        }
        if (partitionScopedRegionLevelProgress == null) {
            return "";
        }
        return this.getCombinedSessionToken(partitionScopedRegionLevelProgress);
    }

    private Pair<Long, PartitionScopedRegionLevelProgress> getCollectionRidToPartitionScopedRegionLevelProgress(RxDocumentServiceRequest request) {
        return this.getCollectionRidToPartitionScopedRegionLevelProgress(request.getIsNameBased(), request.getResourceId(), request.getResourceAddress());
    }

    private Pair<Long, PartitionScopedRegionLevelProgress> getCollectionRidToPartitionScopedRegionLevelProgress(boolean isNameBased, String rId, String resourceAddress) {
        PartitionScopedRegionLevelProgress partitionScopedRegionLevelProgress = null;
        Long collectionResourceId = null;
        if (!isNameBased) {
            ResourceId resourceId;
            if (!StringUtils.isEmpty(rId) && (resourceId = ResourceId.parse(rId)).getDocumentCollection() != 0) {
                collectionResourceId = resourceId.getUniqueDocumentCollectionId();
                partitionScopedRegionLevelProgress = this.collectionResourceIdToPartitionScopedRegionLevelProgress.get(collectionResourceId);
            }
        } else {
            String collectionName = Utils.getCollectionName(resourceAddress);
            if (!StringUtils.isEmpty(collectionName) && this.collectionNameToCollectionResourceId.containsKey(collectionName)) {
                collectionResourceId = this.collectionNameToCollectionResourceId.get(collectionName);
                partitionScopedRegionLevelProgress = this.collectionResourceIdToPartitionScopedRegionLevelProgress.get(collectionResourceId);
            }
        }
        if (partitionScopedRegionLevelProgress != null && collectionResourceId != null) {
            return new Pair<Object, Object>(collectionResourceId, partitionScopedRegionLevelProgress);
        }
        return null;
    }

    @Override
    public String resolveGlobalSessionToken(RxDocumentServiceRequest request) {
        Pair<Long, PartitionScopedRegionLevelProgress> collectionRidToPartitionScopedRegionLevelProgress = this.getCollectionRidToPartitionScopedRegionLevelProgress(request);
        if (collectionRidToPartitionScopedRegionLevelProgress == null) {
            return "";
        }
        Preconditions.checkNotNull(collectionRidToPartitionScopedRegionLevelProgress.getKey(), "collectionRid cannot be null!");
        Preconditions.checkNotNull(collectionRidToPartitionScopedRegionLevelProgress.getValue(), "partitionScopedRegionLevelProgress cannot be null!");
        return this.getCombinedSessionToken(collectionRidToPartitionScopedRegionLevelProgress.getValue());
    }

    @Override
    public ISessionToken resolvePartitionLocalSessionToken(RxDocumentServiceRequest request, String partitionKeyRangeId) {
        Pair<Long, PartitionScopedRegionLevelProgress> collectionRidToPartitionScopedRegionLevelProgress = this.getCollectionRidToPartitionScopedRegionLevelProgress(request);
        if (collectionRidToPartitionScopedRegionLevelProgress == null) {
            return null;
        }
        Long collectionRid = collectionRidToPartitionScopedRegionLevelProgress.getKey();
        PartitionScopedRegionLevelProgress partitionScopedRegionLevelProgress = collectionRidToPartitionScopedRegionLevelProgress.getValue();
        Utils.ValueHolder<Object> partitionKeyInternal = Utils.ValueHolder.initialize(null);
        Utils.ValueHolder<Object> partitionKeyDefinition = Utils.ValueHolder.initialize(null);
        if (this.firstPreferredReadableRegionCached.get().equals("")) {
            this.firstPreferredReadableRegionCached.set(this.extractFirstEffectivePreferredReadableRegion());
        }
        boolean shouldUseBloomFilter = this.shouldUseBloomFilter(request, partitionKeyRangeId, partitionKeyInternal, partitionKeyDefinition, partitionScopedRegionLevelProgress);
        return SessionTokenHelper.resolvePartitionLocalSessionToken(request, this.partitionKeyBasedBloomFilter, partitionScopedRegionLevelProgress, (PartitionKeyInternal)partitionKeyInternal.v, (PartitionKeyDefinition)partitionKeyDefinition.v, collectionRid, partitionKeyRangeId, this.firstPreferredReadableRegionCached.get(), shouldUseBloomFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearTokenByCollectionFullName(String collectionFullName) {
        if (!Strings.isNullOrEmpty(collectionFullName)) {
            String collectionName = PathsHelper.getCollectionPath(collectionFullName);
            this.writeLock.lock();
            try {
                if (this.collectionNameToCollectionResourceId.containsKey(collectionName)) {
                    Long rid = this.collectionNameToCollectionResourceId.get(collectionName);
                    this.collectionResourceIdToCollectionName.remove(rid);
                    this.collectionNameToCollectionResourceId.remove(collectionName);
                    this.collectionResourceIdToPartitionScopedRegionLevelProgress.remove(rid);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearTokenByResourceId(String resourceId) {
        ResourceId resource;
        if (!StringUtils.isEmpty(resourceId) && (resource = ResourceId.parse(resourceId)).getDocumentCollection() != 0) {
            Long rid = resource.getUniqueDocumentCollectionId();
            this.writeLock.lock();
            try {
                if (this.collectionResourceIdToCollectionName.containsKey(rid)) {
                    String collectionName = this.collectionResourceIdToCollectionName.get(rid);
                    this.collectionResourceIdToCollectionName.remove(rid);
                    this.collectionNameToCollectionResourceId.remove(collectionName);
                    this.collectionResourceIdToPartitionScopedRegionLevelProgress.remove(rid);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    @Override
    public void setSessionToken(RxDocumentServiceRequest request, Map<String, String> responseHeaders) {
        Utils.ValueHolder<Object> collectionName;
        Utils.ValueHolder<Object> resourceId;
        if (this.disableSessionCapturing) {
            return;
        }
        String token = responseHeaders.get("x-ms-session-token");
        if (!Strings.isNullOrEmpty(token) && SessionContainerUtil.shouldUpdateSessionToken(request, responseHeaders, resourceId = Utils.ValueHolder.initialize(null), collectionName = Utils.ValueHolder.initialize(null))) {
            this.setSessionToken(request, (ResourceId)resourceId.v, (String)collectionName.v, token);
        }
    }

    @Override
    public void setSessionToken(RxDocumentServiceRequest request, String collectionRid, String collectionFullName, Map<String, String> responseHeaders) {
        if (this.disableSessionCapturing) {
            return;
        }
        ResourceId resourceId = ResourceId.parse(collectionRid);
        String collectionName = PathsHelper.getCollectionPath(collectionFullName);
        String token = responseHeaders.get("x-ms-session-token");
        if (!Strings.isNullOrEmpty(token)) {
            this.setSessionToken(request, resourceId, collectionName, token);
        }
    }

    @Override
    public void setSessionToken(String collectionRid, String collectionFullName, Map<String, String> responseHeaders) {
        throw new NotImplementedException("setSessionToken(String collectionRid, String collectionFullName, Map<String, String> responseHeaders) not implemented for RegionScopedSessionContainer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSessionToken(RxDocumentServiceRequest request, ResourceId resourceId, String collectionName, String token) {
        boolean isKnownCollection;
        String[] tokenParts = StringUtils.split(token, ':');
        String partitionKeyRangeId = tokenParts[0];
        ISessionToken parsedSessionToken = SessionTokenHelper.parse(tokenParts[1]);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("UPDATE SESSION token {} {} {}", new Object[]{resourceId.getUniqueDocumentCollectionId(), collectionName, tokenParts[1]});
        }
        this.readLock.lock();
        try {
            boolean bl = isKnownCollection = collectionName != null && this.collectionNameToCollectionResourceId.containsKey(collectionName) && this.collectionResourceIdToCollectionName.containsKey(resourceId.getUniqueDocumentCollectionId()) && this.collectionNameToCollectionResourceId.get(collectionName).longValue() == resourceId.getUniqueDocumentCollectionId() && this.collectionResourceIdToCollectionName.get(resourceId.getUniqueDocumentCollectionId()).equals(collectionName);
            if (isKnownCollection) {
                this.addSessionTokenAndTryRecordEpkInBloomFilter(request, resourceId, partitionKeyRangeId, parsedSessionToken);
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (!isKnownCollection) {
            this.writeLock.lock();
            try {
                if (resourceId.getUniqueDocumentCollectionId() != 0L) {
                    this.collectionNameToCollectionResourceId.compute(collectionName, (k, v) -> resourceId.getUniqueDocumentCollectionId());
                    this.collectionResourceIdToCollectionName.compute(resourceId.getUniqueDocumentCollectionId(), (k, v) -> collectionName);
                }
                this.addSessionTokenAndTryRecordEpkInBloomFilter(request, resourceId, partitionKeyRangeId, parsedSessionToken);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    private void recordPartitionKeyInBloomFilter(RxDocumentServiceRequest request, Long collectionRid, String regionRoutedTo, PartitionKeyInternal partitionKeyInternal, PartitionKeyDefinition partitionKeyDefinition) {
        if (Strings.isNullOrEmpty(this.firstPreferredReadableRegionCached.get())) {
            this.firstPreferredReadableRegionCached.set(this.extractFirstEffectivePreferredReadableRegion());
        }
        this.partitionKeyBasedBloomFilter.tryRecordPartitionKey(request, collectionRid, this.firstPreferredReadableRegionCached.get(), regionRoutedTo, partitionKeyInternal, partitionKeyDefinition);
    }

    private void recordRegionScopedSessionToken(RxDocumentServiceRequest request, PartitionScopedRegionLevelProgress partitionScopedRegionLevelProgress, ISessionToken parsedSessionToken, String partitionKeyRangeId, String regionRoutedTo) {
        partitionScopedRegionLevelProgress.tryRecordSessionToken(request, parsedSessionToken, partitionKeyRangeId, this.firstPreferredReadableRegionCached.get(), regionRoutedTo);
    }

    private void addSessionTokenAndTryRecordEpkInBloomFilter(RxDocumentServiceRequest request, ResourceId resourceId, String partitionKeyRangeId, ISessionToken parsedSessionToken) {
        Long collectionResourceId = resourceId.getUniqueDocumentCollectionId();
        PartitionScopedRegionLevelProgress partitionScopedRegionLevelProgress = this.collectionResourceIdToPartitionScopedRegionLevelProgress.get(collectionResourceId);
        if (this.firstPreferredReadableRegionCached.get().equals("")) {
            this.firstPreferredReadableRegionCached.set(this.extractFirstEffectivePreferredReadableRegion());
        }
        String regionRoutedTo = null;
        if (request.requestContext != null) {
            URI regionEndpointRoutedTo = request.requestContext.locationEndpointToRoute;
            regionRoutedTo = this.globalEndpointManager.getRegionName(regionEndpointRoutedTo, request.getOperationType());
        }
        Utils.ValueHolder<Object> partitionKeyInternal = Utils.ValueHolder.initialize(null);
        Utils.ValueHolder<Object> partitionKeyDefinition = Utils.ValueHolder.initialize(null);
        if (partitionScopedRegionLevelProgress != null) {
            if (this.shouldUseBloomFilter(request, partitionKeyRangeId, partitionKeyInternal, partitionKeyDefinition, partitionScopedRegionLevelProgress)) {
                this.recordPartitionKeyInBloomFilter(request, collectionResourceId, regionRoutedTo, (PartitionKeyInternal)partitionKeyInternal.v, (PartitionKeyDefinition)partitionKeyDefinition.v);
            }
            this.recordRegionScopedSessionToken(request, partitionScopedRegionLevelProgress, parsedSessionToken, partitionKeyRangeId, regionRoutedTo);
        } else {
            this.collectionResourceIdToPartitionScopedRegionLevelProgress.compute(resourceId.getUniqueDocumentCollectionId(), (k, partitionScopedRegionLevelProgressAsVal) -> {
                if (partitionScopedRegionLevelProgressAsVal == null) {
                    this.logger.info("Registering a new collection resourceId [{}] in RegionScopedSessionContainer", (Object)resourceId);
                    partitionScopedRegionLevelProgressAsVal = new PartitionScopedRegionLevelProgress();
                }
                return partitionScopedRegionLevelProgressAsVal;
            });
            partitionScopedRegionLevelProgress = this.collectionResourceIdToPartitionScopedRegionLevelProgress.get(resourceId.getUniqueDocumentCollectionId());
            if (partitionScopedRegionLevelProgress != null) {
                this.recordRegionScopedSessionToken(request, partitionScopedRegionLevelProgress, parsedSessionToken, partitionKeyRangeId, regionRoutedTo);
            }
            if (this.shouldUseBloomFilter(request, partitionKeyRangeId, partitionKeyInternal, partitionKeyDefinition, partitionScopedRegionLevelProgress)) {
                this.recordPartitionKeyInBloomFilter(request, collectionResourceId, regionRoutedTo, (PartitionKeyInternal)partitionKeyInternal.v, (PartitionKeyDefinition)partitionKeyDefinition.v);
            }
        }
    }

    private String getCombinedSessionToken(PartitionScopedRegionLevelProgress partitionScopedRegionLevelProgress) {
        ConcurrentHashMap<String, ConcurrentHashMap<String, PartitionScopedRegionLevelProgress.RegionLevelProgress>> tokens = partitionScopedRegionLevelProgress.getPartitionKeyRangeIdToRegionLevelProgress();
        StringBuilder result = new StringBuilder();
        if (tokens != null) {
            Iterator<Map.Entry<String, ConcurrentHashMap<String, PartitionScopedRegionLevelProgress.RegionLevelProgress>>> iterator = tokens.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, ConcurrentHashMap<String, PartitionScopedRegionLevelProgress.RegionLevelProgress>> entry = iterator.next();
                String partitionKeyRangeId = entry.getKey();
                String sessionTokenAsString = entry.getValue().get("global").getSessionToken().convertToString();
                result = result.append(partitionKeyRangeId).append(":").append(sessionTokenAsString);
                if (!iterator.hasNext()) continue;
                result = result.append(",");
            }
        }
        return result.toString();
    }

    private boolean shouldUseBloomFilter(RxDocumentServiceRequest request, String partitionKeyRangeId, Utils.ValueHolder<PartitionKeyInternal> partitionKeyInternal, Utils.ValueHolder<PartitionKeyDefinition> partitionKeyDefinition, PartitionScopedRegionLevelProgress partitionScopedRegionLevelProgress) {
        Preconditions.checkNotNull(request, "request cannot be null!");
        Preconditions.checkNotNull(this.globalEndpointManager, "globalEndpointManager cannot be nulL!");
        Preconditions.checkNotNull(partitionScopedRegionLevelProgress, "partitionScopedRegionLevelProgress cannot be null!");
        partitionKeyInternal.v = request.getPartitionKeyInternal();
        if (partitionKeyInternal.v == null) {
            return false;
        }
        partitionKeyDefinition.v = request.getPartitionKeyDefinition();
        if (partitionKeyDefinition.v == null) {
            return false;
        }
        if (partitionScopedRegionLevelProgress.getHasPartitionSeenNonPointRequestsForDocuments(partitionKeyRangeId)) {
            return false;
        }
        return this.globalEndpointManager.canUseMultipleWriteLocations(request);
    }

    private String extractFirstEffectivePreferredReadableRegion() {
        Preconditions.checkNotNull(this.globalEndpointManager, "globalEndpointManager cannot be null!");
        List regionNamesForRead = this.globalEndpointManager.getReadEndpoints().stream().map(endpoint -> this.globalEndpointManager.getRegionName((URI)endpoint, OperationType.Read)).collect(Collectors.toList());
        Preconditions.checkNotNull(regionNamesForRead, "regionNamesForRead cannot be null!");
        if (!regionNamesForRead.isEmpty()) {
            return ((String)regionNamesForRead.get(0)).toLowerCase(Locale.ROOT).trim().replace(" ", "");
        }
        throw new IllegalStateException("regionNamesForRead cannot be empty!");
    }

    public boolean isPartitionKeyResolvedToARegion(PartitionKeyInternal internalPartitionKey, PartitionKeyDefinition partitionKeyDefinition, String collectionId, String normalizedRegion) {
        String effectivePartitionKeyString = PartitionKeyInternalHelper.getEffectivePartitionKeyString(internalPartitionKey, partitionKeyDefinition);
        Long collectionRid = this.collectionNameToCollectionResourceId.get(collectionId);
        Preconditions.checkNotNull(collectionRid, "collectionRid cannot be null!");
        return this.partitionKeyBasedBloomFilter.isPartitionKeyResolvedToARegion(effectivePartitionKeyString, normalizedRegion, collectionRid);
    }

    public String getRegionScopedSessionCapturingOptionsAsString() {
        return this.regionScopedSessionCapturingOptionsAsString;
    }

    private static String stringifyConfig() {
        return "(rssc: true, expins: " + Configs.getPkBasedBloomFilterExpectedInsertionCount() + ", ffprate: " + Configs.getPkBasedBloomFilterExpectedFfpRate() + ")";
    }
}

