/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.CosmosDiagnosticsThresholds;
import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.CosmosChangeFeedRequestOptionsImpl;
import com.azure.cosmos.implementation.CosmosPagedFluxOptions;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedMode;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedStartFromInternal;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedState;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedStateV1;
import com.azure.cosmos.implementation.feedranges.FeedRangeContinuation;
import com.azure.cosmos.implementation.feedranges.FeedRangeEpkImpl;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.query.CompositeContinuationToken;
import com.azure.cosmos.implementation.routing.Range;
import com.azure.cosmos.implementation.spark.OperationContextAndListenerTuple;
import com.azure.cosmos.models.FeedRange;
import com.azure.cosmos.util.Beta;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class CosmosChangeFeedRequestOptions {
    private final CosmosChangeFeedRequestOptionsImpl actualRequestOptions;

    CosmosChangeFeedRequestOptions(CosmosChangeFeedRequestOptions topBeCloned) {
        this.actualRequestOptions = new CosmosChangeFeedRequestOptionsImpl(topBeCloned.actualRequestOptions);
    }

    private CosmosChangeFeedRequestOptions(FeedRangeInternal feedRange, ChangeFeedStartFromInternal startFromInternal, ChangeFeedMode mode, ChangeFeedState continuationState) {
        this.actualRequestOptions = new CosmosChangeFeedRequestOptionsImpl(feedRange, startFromInternal, mode, continuationState);
    }

    ChangeFeedState getContinuation() {
        return this.actualRequestOptions.getContinuation();
    }

    public FeedRange getFeedRange() {
        return this.actualRequestOptions.getFeedRange();
    }

    public int getMaxItemCount() {
        return this.actualRequestOptions.getMaxItemCount();
    }

    public CosmosChangeFeedRequestOptions setMaxItemCount(int maxItemCount) {
        this.actualRequestOptions.setMaxItemCount(maxItemCount);
        return this;
    }

    public int getMaxPrefetchPageCount() {
        return this.actualRequestOptions.getMaxPrefetchPageCount();
    }

    public CosmosChangeFeedRequestOptions setMaxPrefetchPageCount(int maxPrefetchPageCount) {
        this.actualRequestOptions.setMaxPrefetchPageCount(maxPrefetchPageCount);
        return this;
    }

    public boolean isQuotaInfoEnabled() {
        return this.actualRequestOptions.isQuotaInfoEnabled();
    }

    public void setQuotaInfoEnabled(boolean quotaInfoEnabled) {
        this.actualRequestOptions.setQuotaInfoEnabled(quotaInfoEnabled);
    }

    public CosmosChangeFeedRequestOptions setDiagnosticsThresholds(CosmosDiagnosticsThresholds operationSpecificThresholds) {
        this.actualRequestOptions.setDiagnosticsThresholds(operationSpecificThresholds);
        return this;
    }

    public CosmosDiagnosticsThresholds getDiagnosticsThresholds() {
        return this.actualRequestOptions.getDiagnosticsThresholds();
    }

    public CosmosItemSerializer getCustomItemSerializer() {
        return this.actualRequestOptions.getCustomItemSerializer();
    }

    public CosmosChangeFeedRequestOptions setCustomItemSerializer(CosmosItemSerializer customItemSerializer) {
        this.actualRequestOptions.setCustomItemSerializer(customItemSerializer);
        return this;
    }

    boolean isSplitHandlingDisabled() {
        return this.actualRequestOptions.isSplitHandlingDisabled();
    }

    CosmosChangeFeedRequestOptions disableSplitHandling() {
        this.actualRequestOptions.disableSplitHandling();
        return this;
    }

    ChangeFeedMode getMode() {
        return this.actualRequestOptions.getMode();
    }

    Map<String, Object> getProperties() {
        return this.actualRequestOptions.getProperties();
    }

    ChangeFeedStartFromInternal getStartFromSettings() {
        return this.actualRequestOptions.getStartFromSettings();
    }

    public static CosmosChangeFeedRequestOptions createForProcessingFromBeginning(FeedRange feedRange) {
        Preconditions.checkNotNull(feedRange, "Argument 'feedRange' must not be null.");
        return new CosmosChangeFeedRequestOptions(FeedRangeInternal.convert(feedRange), ChangeFeedStartFromInternal.createFromBeginning(), ChangeFeedMode.INCREMENTAL, null);
    }

    public static CosmosChangeFeedRequestOptions createForProcessingFromContinuation(String continuation) {
        ChangeFeedState changeFeedState = ChangeFeedState.fromString(continuation);
        return CosmosChangeFeedRequestOptions.createForProcessingFromContinuation(changeFeedState);
    }

    static CosmosChangeFeedRequestOptions createForProcessingFromContinuation(String continuation, FeedRange targetRange, String continuationLsn) {
        if (targetRange instanceof FeedRangeEpkImpl) {
            Range<String> normalizedRange = FeedRangeInternal.normalizeRange(((FeedRangeEpkImpl)targetRange).getRange());
            ChangeFeedState changeFeedState = ChangeFeedState.fromString(continuation);
            if (StringUtils.isEmpty(continuationLsn)) {
                continuationLsn = changeFeedState.getContinuation().getCurrentContinuationToken().getToken();
            }
            ChangeFeedStateV1 targetChangeFeedState = new ChangeFeedStateV1(changeFeedState.getContainerRid(), (FeedRangeEpkImpl)targetRange, changeFeedState.getMode(), changeFeedState.getStartFromSettings(), FeedRangeContinuation.create(changeFeedState.getContainerRid(), (FeedRangeInternal)((FeedRangeEpkImpl)targetRange), Arrays.asList(new CompositeContinuationToken(continuationLsn, normalizedRange))));
            return CosmosChangeFeedRequestOptions.createForProcessingFromContinuation(targetChangeFeedState);
        }
        throw new IllegalStateException("createForProcessingFromContinuation does not support feedRange type " + targetRange.getClass());
    }

    static CosmosChangeFeedRequestOptions createForProcessingFromContinuation(ChangeFeedState changeFeedState) {
        FeedRangeInternal feedRange = changeFeedState.getFeedRange();
        FeedRangeContinuation continuation = changeFeedState.getContinuation();
        ChangeFeedMode mode = changeFeedState.getMode();
        if (continuation != null) {
            CompositeContinuationToken continuationToken = continuation.getCurrentContinuationToken();
            if (continuationToken != null) {
                String etag = continuationToken.getToken();
                return new CosmosChangeFeedRequestOptions(feedRange, ChangeFeedStartFromInternal.createFromETagAndFeedRange(etag, feedRange), mode, changeFeedState);
            }
            return new CosmosChangeFeedRequestOptions(feedRange, ChangeFeedStartFromInternal.createFromBeginning(), mode, changeFeedState);
        }
        return new CosmosChangeFeedRequestOptions(feedRange, changeFeedState.getStartFromSettings(), mode, changeFeedState);
    }

    public static CosmosChangeFeedRequestOptions createForProcessingFromNow(FeedRange feedRange) {
        if (feedRange == null) {
            throw new NullPointerException("feedRange");
        }
        return new CosmosChangeFeedRequestOptions(FeedRangeInternal.convert(feedRange), ChangeFeedStartFromInternal.createFromNow(), ChangeFeedMode.INCREMENTAL, null);
    }

    public static CosmosChangeFeedRequestOptions createForProcessingFromPointInTime(Instant pointInTime, FeedRange feedRange) {
        if (pointInTime == null) {
            throw new NullPointerException("pointInTime");
        }
        if (feedRange == null) {
            throw new NullPointerException("feedRange");
        }
        return new CosmosChangeFeedRequestOptions(FeedRangeInternal.convert(feedRange), ChangeFeedStartFromInternal.createFromPointInTime(pointInTime), ChangeFeedMode.INCREMENTAL, null);
    }

    void setRequestContinuation(String etag) {
        this.actualRequestOptions.setRequestContinuation(etag);
    }

    CosmosChangeFeedRequestOptions withCosmosPagedFluxOptions(CosmosPagedFluxOptions pagedFluxOptions) {
        if (pagedFluxOptions == null) {
            return this;
        }
        CosmosChangeFeedRequestOptions effectiveRequestOptions = this;
        if (pagedFluxOptions.getRequestContinuation() != null) {
            effectiveRequestOptions = CosmosChangeFeedRequestOptions.createForProcessingFromContinuation(pagedFluxOptions.getRequestContinuation());
            effectiveRequestOptions.setMaxPrefetchPageCount(this.getMaxPrefetchPageCount());
            effectiveRequestOptions.setThroughputControlGroupName(this.getThroughputControlGroupName());
        }
        if (pagedFluxOptions.getMaxItemCount() != null) {
            effectiveRequestOptions.setMaxItemCount(pagedFluxOptions.getMaxItemCount());
        }
        return effectiveRequestOptions;
    }

    @Deprecated
    @Beta(value=Beta.SinceVersion.V4_12_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosChangeFeedRequestOptions fullFidelity() {
        this.actualRequestOptions.fullFidelity();
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_37_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosChangeFeedRequestOptions allVersionsAndDeletes() {
        this.actualRequestOptions.allVersionsAndDeletes();
        return this;
    }

    public String getThroughputControlGroupName() {
        return this.actualRequestOptions.getThroughputControlGroupName();
    }

    public CosmosChangeFeedRequestOptions setThroughputControlGroupName(String throughputControlGroupName) {
        this.actualRequestOptions.setThroughputControlGroupName(throughputControlGroupName);
        return this;
    }

    public CosmosChangeFeedRequestOptions setExcludedRegions(List<String> excludeRegions) {
        this.actualRequestOptions.setExcludedRegions(excludeRegions);
        return this;
    }

    public List<String> getExcludedRegions() {
        return this.actualRequestOptions.getExcludedRegions();
    }

    CosmosChangeFeedRequestOptions setHeader(String name, String value) {
        this.actualRequestOptions.setHeader(name, value);
        return this;
    }

    Map<String, String> getHeaders() {
        return this.actualRequestOptions.getHeaders();
    }

    void setOperationContextAndListenerTuple(OperationContextAndListenerTuple operationContextAndListenerTuple) {
        this.actualRequestOptions.setOperationContextAndListenerTuple(operationContextAndListenerTuple);
    }

    OperationContextAndListenerTuple getOperationContextAndListenerTuple() {
        return this.actualRequestOptions.getOperationContextAndListenerTuple();
    }

    private void addCustomOptionsForFullFidelityMode() {
        this.setHeader("x-ms-cosmos-changefeed-wire-format-version", "2021-09-15");
    }

    CosmosChangeFeedRequestOptionsImpl getImpl() {
        return this.actualRequestOptions;
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosChangeFeedRequestOptionsHelper.setCosmosChangeFeedRequestOptionsAccessor(new ImplementationBridgeHelpers.CosmosChangeFeedRequestOptionsHelper.CosmosChangeFeedRequestOptionsAccessor(){

            @Override
            public CosmosChangeFeedRequestOptions setHeader(CosmosChangeFeedRequestOptions changeFeedRequestOptions, String name, String value) {
                return changeFeedRequestOptions.setHeader(name, value);
            }

            @Override
            public Map<String, String> getHeader(CosmosChangeFeedRequestOptions changeFeedRequestOptions) {
                return changeFeedRequestOptions.getHeaders();
            }

            @Override
            public CosmosChangeFeedRequestOptionsImpl getImpl(CosmosChangeFeedRequestOptions changeFeedRequestOptions) {
                return changeFeedRequestOptions.getImpl();
            }

            @Override
            public void setOperationContext(CosmosChangeFeedRequestOptions changeFeedRequestOptions, OperationContextAndListenerTuple operationContextAndListenerTuple) {
                changeFeedRequestOptions.setOperationContextAndListenerTuple(operationContextAndListenerTuple);
            }

            @Override
            public OperationContextAndListenerTuple getOperationContext(CosmosChangeFeedRequestOptions changeFeedRequestOptions) {
                return changeFeedRequestOptions.getOperationContextAndListenerTuple();
            }

            @Override
            public CosmosDiagnosticsThresholds getDiagnosticsThresholds(CosmosChangeFeedRequestOptions options) {
                return options.getDiagnosticsThresholds();
            }

            @Override
            public CosmosChangeFeedRequestOptions createForProcessingFromContinuation(String continuation, FeedRange targetRange, String continuationLsn) {
                return CosmosChangeFeedRequestOptions.createForProcessingFromContinuation(continuation, targetRange, continuationLsn);
            }

            @Override
            public CosmosChangeFeedRequestOptions clone(CosmosChangeFeedRequestOptions toBeCloned) {
                return new CosmosChangeFeedRequestOptions(toBeCloned);
            }
        });
    }

    static {
        CosmosChangeFeedRequestOptions.initialize();
    }
}

