/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.caches.SerializableWrapper;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.ChangeFeedPolicy;
import com.azure.cosmos.models.ClientEncryptionPolicy;
import com.azure.cosmos.models.ComputedProperty;
import com.azure.cosmos.models.ConflictResolutionPolicy;
import com.azure.cosmos.models.CosmosVectorEmbeddingPolicy;
import com.azure.cosmos.models.IndexingPolicy;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.PartitionKeyDefinition;
import com.azure.cosmos.models.UniqueKeyPolicy;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class DocumentCollection
extends Resource {
    private static final String COLLECTIONS_ROOT_PROPERTY_NAME = "col";
    private static final String ALT_LINK_PROPERTY_NAME = "altLink";
    private IndexingPolicy indexingPolicy;
    private UniqueKeyPolicy uniqueKeyPolicy;
    private PartitionKeyDefinition partitionKeyDefinition;
    private ClientEncryptionPolicy clientEncryptionPolicyInternal;
    private CosmosVectorEmbeddingPolicy cosmosVectorEmbeddingPolicy;

    public DocumentCollection(ObjectNode objectNode) {
        super(objectNode);
    }

    public DocumentCollection() {
    }

    @Override
    public DocumentCollection setId(String id) {
        super.setId(id);
        return this;
    }

    public DocumentCollection(String jsonString) {
        super(jsonString);
    }

    public IndexingPolicy getIndexingPolicy() {
        if (this.indexingPolicy == null) {
            this.indexingPolicy = super.has("indexingPolicy") ? super.getObject("indexingPolicy", IndexingPolicy.class, new boolean[0]) : new IndexingPolicy();
        }
        return this.indexingPolicy;
    }

    public void setIndexingPolicy(IndexingPolicy indexingPolicy) {
        if (indexingPolicy == null) {
            throw new IllegalArgumentException("IndexingPolicy cannot be null.");
        }
        this.indexingPolicy = indexingPolicy;
    }

    public PartitionKeyDefinition getPartitionKey() {
        if (this.partitionKeyDefinition == null) {
            this.partitionKeyDefinition = super.has("partitionKey") ? super.getObject("partitionKey", PartitionKeyDefinition.class, new boolean[0]) : new PartitionKeyDefinition();
        }
        return this.partitionKeyDefinition;
    }

    public void setPartitionKey(PartitionKeyDefinition partitionKey) {
        if (partitionKey == null) {
            throw new IllegalArgumentException("partitionKeyDefinition cannot be null.");
        }
        this.partitionKeyDefinition = partitionKey;
    }

    public Integer getDefaultTimeToLive() {
        if (super.has("defaultTtl")) {
            return super.getInt("defaultTtl");
        }
        return null;
    }

    public void setDefaultTimeToLive(Integer timeToLive) {
        if (timeToLive != null) {
            this.set("defaultTtl", timeToLive, CosmosItemSerializer.DEFAULT_SERIALIZER);
        } else if (super.has("defaultTtl")) {
            this.remove("defaultTtl");
        }
    }

    public void setAnalyticalStoreTimeToLiveInSeconds(Integer timeToLive) {
        if (timeToLive != null) {
            super.set("analyticalStorageTtl", timeToLive, CosmosItemSerializer.DEFAULT_SERIALIZER);
        } else if (super.has("analyticalStorageTtl")) {
            super.remove("analyticalStorageTtl");
        }
    }

    public Integer getAnalyticalStoreTimeToLiveInSeconds() {
        if (super.has("analyticalStorageTtl")) {
            return super.getInt("analyticalStorageTtl");
        }
        return null;
    }

    public UniqueKeyPolicy getUniqueKeyPolicy() {
        if (this.uniqueKeyPolicy == null) {
            this.uniqueKeyPolicy = super.getObject("uniqueKeyPolicy", UniqueKeyPolicy.class, new boolean[0]);
            if (this.uniqueKeyPolicy == null) {
                this.uniqueKeyPolicy = new UniqueKeyPolicy();
            }
        }
        return this.uniqueKeyPolicy;
    }

    public void setUniqueKeyPolicy(UniqueKeyPolicy uniqueKeyPolicy) {
        if (uniqueKeyPolicy == null) {
            throw new IllegalArgumentException("uniqueKeyPolicy cannot be null.");
        }
        this.uniqueKeyPolicy = uniqueKeyPolicy;
        this.set("uniqueKeyPolicy", uniqueKeyPolicy, CosmosItemSerializer.DEFAULT_SERIALIZER);
    }

    public ConflictResolutionPolicy getConflictResolutionPolicy() {
        return super.getObject("conflictResolutionPolicy", ConflictResolutionPolicy.class, new boolean[0]);
    }

    public void setConflictResolutionPolicy(ConflictResolutionPolicy value) {
        if (value == null) {
            throw new IllegalArgumentException("CONFLICT_RESOLUTION_POLICY cannot be null.");
        }
        this.set("conflictResolutionPolicy", value, CosmosItemSerializer.DEFAULT_SERIALIZER);
    }

    public ChangeFeedPolicy getChangeFeedPolicy() {
        ChangeFeedPolicy policy = super.getObject("changeFeedPolicy", ChangeFeedPolicy.class, new boolean[0]);
        if (policy == null) {
            return ChangeFeedPolicy.createLatestVersionPolicy();
        }
        return policy;
    }

    public void setChangeFeedPolicy(ChangeFeedPolicy value) {
        if (value == null) {
            throw new IllegalArgumentException("CHANGE_FEED_POLICY cannot be null.");
        }
        this.set("changeFeedPolicy", value, CosmosItemSerializer.DEFAULT_SERIALIZER);
    }

    public Collection<ComputedProperty> getComputedProperties() {
        List<ComputedProperty> computedProperties = super.getList("computedProperties", ComputedProperty.class, new boolean[0]);
        if (computedProperties == null) {
            return Collections.emptyList();
        }
        return computedProperties;
    }

    public void setComputedProperties(Collection<ComputedProperty> computedProperties) {
        if (computedProperties == null || computedProperties.isEmpty()) {
            throw new IllegalArgumentException("COMPUTED_PROPERTIES cannot be null or empty.");
        }
        computedProperties.forEach(computedProperty -> {
            if (computedProperty == null) {
                throw new IllegalArgumentException("COMPUTED_PROPERTIES cannot have null values.");
            }
        });
        this.set("computedProperties", computedProperties, CosmosItemSerializer.DEFAULT_SERIALIZER);
    }

    public String getDocumentsLink() {
        return String.format("%s/%s", StringUtils.stripEnd(super.getSelfLink(), "/"), super.getString("_docs"));
    }

    public String getStoredProceduresLink() {
        return String.format("%s/%s", StringUtils.stripEnd(super.getSelfLink(), "/"), super.getString("_sprocs"));
    }

    public String getTriggersLink() {
        return StringUtils.removeEnd(this.getSelfLink(), "/") + "/" + super.getString("_triggers");
    }

    public String getUserDefinedFunctionsLink() {
        return StringUtils.removeEnd(this.getSelfLink(), "/") + "/" + super.getString("_udfs");
    }

    public String getConflictsLink() {
        return StringUtils.removeEnd(this.getSelfLink(), "/") + "/" + super.getString("_conflicts");
    }

    public ClientEncryptionPolicy getClientEncryptionPolicy() {
        if (this.clientEncryptionPolicyInternal == null && super.has("clientEncryptionPolicy")) {
            this.clientEncryptionPolicyInternal = super.getObject("clientEncryptionPolicy", ClientEncryptionPolicy.class, new boolean[0]);
        }
        return this.clientEncryptionPolicyInternal;
    }

    public void setClientEncryptionPolicy(ClientEncryptionPolicy value) {
        if (value == null) {
            throw new IllegalArgumentException("ClientEncryptionPolicy cannot be null.");
        }
        this.set("clientEncryptionPolicy", value, CosmosItemSerializer.DEFAULT_SERIALIZER);
    }

    public CosmosVectorEmbeddingPolicy getVectorEmbeddingPolicy() {
        if (this.cosmosVectorEmbeddingPolicy == null && super.has("vectorEmbeddingPolicy")) {
            this.cosmosVectorEmbeddingPolicy = super.getObject("vectorEmbeddingPolicy", CosmosVectorEmbeddingPolicy.class, new boolean[0]);
        }
        return this.cosmosVectorEmbeddingPolicy;
    }

    public void setVectorEmbeddingPolicy(CosmosVectorEmbeddingPolicy value) {
        Preconditions.checkNotNull(value, "cosmosVectorEmbeddingPolicy cannot be null");
        this.set("vectorEmbeddingPolicy", value, CosmosItemSerializer.DEFAULT_SERIALIZER);
    }

    @Override
    public void populatePropertyBag() {
        super.populatePropertyBag();
        if (this.indexingPolicy == null) {
            this.getIndexingPolicy();
        }
        if (this.uniqueKeyPolicy == null) {
            this.getUniqueKeyPolicy();
        }
        if (this.partitionKeyDefinition != null) {
            ModelBridgeInternal.populatePropertyBag(this.partitionKeyDefinition);
            this.set("partitionKey", this.partitionKeyDefinition, CosmosItemSerializer.DEFAULT_SERIALIZER);
        }
        ModelBridgeInternal.populatePropertyBag(this.indexingPolicy);
        ModelBridgeInternal.populatePropertyBag(this.uniqueKeyPolicy);
        this.set("indexingPolicy", this.indexingPolicy, CosmosItemSerializer.DEFAULT_SERIALIZER);
        this.set("uniqueKeyPolicy", this.uniqueKeyPolicy, CosmosItemSerializer.DEFAULT_SERIALIZER);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !DocumentCollection.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        DocumentCollection typedObj = (DocumentCollection)obj;
        return typedObj.getResourceId().equals(this.getResourceId());
    }

    @Override
    public int hashCode() {
        return this.getResourceId().hashCode();
    }

    @Override
    public String toJson() {
        this.populatePropertyBag();
        return super.toJson();
    }

    public static class SerializableDocumentCollection
    implements SerializableWrapper<DocumentCollection> {
        private static final long serialVersionUID = 2L;
        private static final ObjectMapper OBJECT_MAPPER = Utils.getSimpleObjectMapperWithAllowDuplicates();
        transient DocumentCollection documentCollection;

        public static SerializableDocumentCollection from(DocumentCollection documentCollection) {
            SerializableDocumentCollection serializableDocumentCollection = new SerializableDocumentCollection();
            serializableDocumentCollection.documentCollection = documentCollection;
            return serializableDocumentCollection;
        }

        @Override
        public DocumentCollection getWrappedItem() {
            return this.documentCollection;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            this.documentCollection.populatePropertyBag();
            ObjectNode docCollectionNode = OBJECT_MAPPER.createObjectNode();
            docCollectionNode.set(DocumentCollection.COLLECTIONS_ROOT_PROPERTY_NAME, (JsonNode)this.documentCollection.getPropertyBag());
            docCollectionNode.set(DocumentCollection.ALT_LINK_PROPERTY_NAME, (JsonNode)TextNode.valueOf((String)this.documentCollection.getAltLink()));
            objectOutputStream.writeObject(docCollectionNode);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            ObjectNode objectNode = (ObjectNode)objectInputStream.readObject();
            ObjectNode collectionNode = (ObjectNode)objectNode.get(DocumentCollection.COLLECTIONS_ROOT_PROPERTY_NAME);
            String altLink = objectNode.get(DocumentCollection.ALT_LINK_PROPERTY_NAME).asText();
            this.documentCollection = new DocumentCollection(collectionNode);
            this.documentCollection.setAltLink(altLink);
        }
    }
}

