/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.circuitBreaker.PartitionKeyRangeWrapper;
import java.util.Map;

public class FeedOperationContextForCircuitBreaker {
    private final Map<PartitionKeyRangeWrapper, PartitionKeyRangeWrapper> partitionKeyRangesWithSuccess;
    private final boolean isThresholdBasedAvailabilityStrategyEnabled;
    private final String collectionLink;
    private boolean isRequestHedged;

    public FeedOperationContextForCircuitBreaker(Map<PartitionKeyRangeWrapper, PartitionKeyRangeWrapper> partitionKeyRangesWithSuccess, boolean isThresholdBasedAvailabilityStrategyEnabled, String collectionLink) {
        this.partitionKeyRangesWithSuccess = partitionKeyRangesWithSuccess;
        this.isThresholdBasedAvailabilityStrategyEnabled = isThresholdBasedAvailabilityStrategyEnabled;
        this.collectionLink = collectionLink;
    }

    public void setIsRequestHedged(boolean isRequestHedged) {
        this.isRequestHedged = isRequestHedged;
    }

    public boolean getIsRequestHedged() {
        return this.isRequestHedged;
    }

    public void addPartitionKeyRangeWithSuccess(PartitionKeyRange partitionKeyRange, String resourceId) {
        PartitionKeyRangeWrapper partitionKeyRangeWrapper = new PartitionKeyRangeWrapper(partitionKeyRange, resourceId);
        this.partitionKeyRangesWithSuccess.put(partitionKeyRangeWrapper, partitionKeyRangeWrapper);
    }

    public boolean hasPartitionKeyRangeSeenSuccess(PartitionKeyRange partitionKeyRange, String resourceId) {
        PartitionKeyRangeWrapper partitionKeyRangeWrapper = new PartitionKeyRangeWrapper(partitionKeyRange, resourceId);
        return this.partitionKeyRangesWithSuccess.containsKey(partitionKeyRangeWrapper);
    }

    public boolean isThresholdBasedAvailabilityStrategyEnabled() {
        return this.isThresholdBasedAvailabilityStrategyEnabled;
    }

    public String getCollectionLink() {
        return this.collectionLink;
    }
}

