/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.circuitBreaker;

import com.azure.cosmos.implementation.circuitBreaker.LocationHealthStatus;
import com.azure.cosmos.implementation.circuitBreaker.LocationSpecificHealthContext;
import com.azure.cosmos.implementation.circuitBreaker.PartitionKeyRangeWrapper;
import com.azure.cosmos.implementation.circuitBreaker.PartitionLevelCircuitBreakerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsecutiveExceptionBasedCircuitBreaker {
    private static final Logger logger = LoggerFactory.getLogger(ConsecutiveExceptionBasedCircuitBreaker.class);
    private final PartitionLevelCircuitBreakerConfig partitionLevelCircuitBreakerConfig;

    public ConsecutiveExceptionBasedCircuitBreaker(PartitionLevelCircuitBreakerConfig partitionLevelCircuitBreakerConfig) {
        this.partitionLevelCircuitBreakerConfig = partitionLevelCircuitBreakerConfig;
    }

    public LocationSpecificHealthContext handleException(LocationSpecificHealthContext locationSpecificHealthContext, PartitionKeyRangeWrapper partitionKeyRangeWrapper, String regionWithException, boolean isReadOnlyRequest) {
        int exceptionCountAfterHandling = isReadOnlyRequest ? locationSpecificHealthContext.getExceptionCountForReadForCircuitBreaking() : locationSpecificHealthContext.getExceptionCountForWriteForCircuitBreaking();
        LocationHealthStatus locationHealthStatus = locationSpecificHealthContext.getLocationHealthStatus();
        switch (locationHealthStatus) {
            case Healthy: {
                return locationSpecificHealthContext;
            }
            case HealthyWithFailures: 
            case HealthyTentative: {
                ++exceptionCountAfterHandling;
                int successCountAfterHandling = 0;
                LocationSpecificHealthContext.Builder builder = new LocationSpecificHealthContext.Builder().withUnavailableSince(locationSpecificHealthContext.getUnavailableSince()).withLocationHealthStatus(locationSpecificHealthContext.getLocationHealthStatus()).withExceptionThresholdBreached(locationSpecificHealthContext.isExceptionThresholdBreached());
                if (isReadOnlyRequest) {
                    return builder.withSuccessCountForWriteForRecovery(locationSpecificHealthContext.getSuccessCountForWriteForRecovery()).withExceptionCountForWriteForCircuitBreaking(locationSpecificHealthContext.getExceptionCountForWriteForCircuitBreaking()).withSuccessCountForReadForRecovery(successCountAfterHandling).withExceptionCountForReadForCircuitBreaking(exceptionCountAfterHandling).build();
                }
                return builder.withSuccessCountForWriteForRecovery(successCountAfterHandling).withExceptionCountForWriteForCircuitBreaking(exceptionCountAfterHandling).withSuccessCountForReadForRecovery(locationSpecificHealthContext.getSuccessCountForReadForRecovery()).withExceptionCountForReadForCircuitBreaking(locationSpecificHealthContext.getExceptionCountForReadForCircuitBreaking()).build();
            }
            case Unavailable: {
                logger.warn("Region {} should not be handling failures in {} health status for partition key range : {} and collection RID : {}", new Object[]{regionWithException, locationHealthStatus.getStringifiedLocationHealthStatus(), partitionKeyRangeWrapper.getPartitionKeyRange().getMinInclusive() + "-" + partitionKeyRangeWrapper.getPartitionKeyRange().getMinInclusive(), partitionKeyRangeWrapper.getCollectionResourceId()});
                return locationSpecificHealthContext;
            }
        }
        throw new IllegalArgumentException("Unsupported health status : " + (Object)((Object)locationHealthStatus));
    }

    public LocationSpecificHealthContext handleSuccess(LocationSpecificHealthContext locationSpecificHealthContext, PartitionKeyRangeWrapper partitionKeyRangeWrapper, String regionWithSuccess, boolean isReadOnlyRequest) {
        int exceptionCountAfterHandling = isReadOnlyRequest ? locationSpecificHealthContext.getExceptionCountForReadForCircuitBreaking() : locationSpecificHealthContext.getExceptionCountForWriteForCircuitBreaking();
        int successCountAfterHandling = isReadOnlyRequest ? locationSpecificHealthContext.getSuccessCountForReadForRecovery() : locationSpecificHealthContext.getSuccessCountForWriteForRecovery();
        LocationHealthStatus locationHealthStatus = locationSpecificHealthContext.getLocationHealthStatus();
        switch (locationHealthStatus) {
            case Healthy: {
                return locationSpecificHealthContext;
            }
            case HealthyWithFailures: {
                exceptionCountAfterHandling = 0;
                LocationSpecificHealthContext.Builder builder = new LocationSpecificHealthContext.Builder().withUnavailableSince(locationSpecificHealthContext.getUnavailableSince()).withLocationHealthStatus(locationSpecificHealthContext.getLocationHealthStatus()).withExceptionThresholdBreached(locationSpecificHealthContext.isExceptionThresholdBreached());
                if (isReadOnlyRequest) {
                    return builder.withSuccessCountForWriteForRecovery(locationSpecificHealthContext.getSuccessCountForWriteForRecovery()).withExceptionCountForWriteForCircuitBreaking(locationSpecificHealthContext.getExceptionCountForWriteForCircuitBreaking()).withSuccessCountForReadForRecovery(locationSpecificHealthContext.getSuccessCountForReadForRecovery()).withExceptionCountForReadForCircuitBreaking(exceptionCountAfterHandling).build();
                }
                return builder.withSuccessCountForWriteForRecovery(locationSpecificHealthContext.getSuccessCountForWriteForRecovery()).withExceptionCountForWriteForCircuitBreaking(exceptionCountAfterHandling).withSuccessCountForReadForRecovery(locationSpecificHealthContext.getSuccessCountForReadForRecovery()).withExceptionCountForReadForCircuitBreaking(locationSpecificHealthContext.getExceptionCountForReadForCircuitBreaking()).build();
            }
            case HealthyTentative: {
                ++successCountAfterHandling;
                LocationSpecificHealthContext.Builder builder = new LocationSpecificHealthContext.Builder().withUnavailableSince(locationSpecificHealthContext.getUnavailableSince()).withLocationHealthStatus(locationSpecificHealthContext.getLocationHealthStatus()).withExceptionThresholdBreached(locationSpecificHealthContext.isExceptionThresholdBreached());
                if (isReadOnlyRequest) {
                    return builder.withSuccessCountForWriteForRecovery(locationSpecificHealthContext.getSuccessCountForWriteForRecovery()).withExceptionCountForWriteForCircuitBreaking(locationSpecificHealthContext.getExceptionCountForWriteForCircuitBreaking()).withSuccessCountForReadForRecovery(successCountAfterHandling).withExceptionCountForReadForCircuitBreaking(exceptionCountAfterHandling).build();
                }
                return builder.withSuccessCountForWriteForRecovery(successCountAfterHandling).withExceptionCountForWriteForCircuitBreaking(exceptionCountAfterHandling).withSuccessCountForReadForRecovery(locationSpecificHealthContext.getSuccessCountForReadForRecovery()).withExceptionCountForReadForCircuitBreaking(locationSpecificHealthContext.getExceptionCountForReadForCircuitBreaking()).build();
            }
            case Unavailable: {
                logger.warn("Region {} should not be handling successes in {} health status for partition key range : {} and collection RID : {}", new Object[]{regionWithSuccess, locationHealthStatus.getStringifiedLocationHealthStatus(), partitionKeyRangeWrapper.getPartitionKeyRange().getMinInclusive() + "-" + partitionKeyRangeWrapper.getPartitionKeyRange().getMinInclusive(), partitionKeyRangeWrapper.getCollectionResourceId()});
                return locationSpecificHealthContext;
            }
        }
        throw new IllegalArgumentException("Unsupported health status : " + (Object)((Object)locationHealthStatus));
    }

    public boolean shouldHealthStatusBeDowngraded(LocationSpecificHealthContext locationSpecificHealthContext, boolean isReadOnlyRequest) {
        int exceptionCountActual = isReadOnlyRequest ? locationSpecificHealthContext.getExceptionCountForReadForCircuitBreaking() : locationSpecificHealthContext.getExceptionCountForWriteForCircuitBreaking();
        return exceptionCountActual >= this.getAllowedExceptionCountToMaintainStatus(locationSpecificHealthContext.getLocationHealthStatus(), isReadOnlyRequest);
    }

    public boolean canHealthStatusBeUpgraded(LocationSpecificHealthContext locationSpecificHealthContext, boolean isReadOnlyRequest) {
        int successCountActual = isReadOnlyRequest ? locationSpecificHealthContext.getSuccessCountForReadForRecovery() : locationSpecificHealthContext.getSuccessCountForWriteForRecovery();
        LocationHealthStatus locationHealthStatus = locationSpecificHealthContext.getLocationHealthStatus();
        return successCountActual >= this.getMinimumSuccessCountForStatusUpgrade(locationHealthStatus, isReadOnlyRequest);
    }

    public int getAllowedExceptionCountToMaintainStatus(LocationHealthStatus status, boolean isReadOnlyRequest) {
        if (isReadOnlyRequest) {
            switch (status) {
                case HealthyWithFailures: {
                    return this.partitionLevelCircuitBreakerConfig.getConsecutiveExceptionCountToleratedForReads();
                }
                case HealthyTentative: {
                    return this.partitionLevelCircuitBreakerConfig.getConsecutiveExceptionCountToleratedForReads() / 2;
                }
                case Healthy: 
                case Unavailable: {
                    return 0;
                }
            }
            throw new IllegalArgumentException("Unsupported health status: " + (Object)((Object)status));
        }
        switch (status) {
            case HealthyWithFailures: {
                return this.partitionLevelCircuitBreakerConfig.getConsecutiveExceptionCountToleratedForWrites();
            }
            case HealthyTentative: {
                return this.partitionLevelCircuitBreakerConfig.getConsecutiveExceptionCountToleratedForWrites() / 2;
            }
            case Healthy: 
            case Unavailable: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Unsupported health status: " + (Object)((Object)status));
    }

    public int getMinimumSuccessCountForStatusUpgrade(LocationHealthStatus status, boolean isReadOnlyRequest) {
        if (isReadOnlyRequest) {
            switch (status) {
                case HealthyTentative: {
                    return this.partitionLevelCircuitBreakerConfig.getConsecutiveExceptionCountToleratedForReads();
                }
                case Healthy: 
                case HealthyWithFailures: 
                case Unavailable: {
                    return 0;
                }
            }
            throw new IllegalArgumentException("Unsupported health status: " + (Object)((Object)status));
        }
        switch (status) {
            case HealthyTentative: {
                return this.partitionLevelCircuitBreakerConfig.getConsecutiveExceptionCountToleratedForWrites();
            }
            case Healthy: 
            case HealthyWithFailures: 
            case Unavailable: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Unsupported health status: " + (Object)((Object)status));
    }

    public boolean isPartitionLevelCircuitBreakerEnabled() {
        return this.partitionLevelCircuitBreakerConfig.isPartitionLevelCircuitBreakerEnabled();
    }

    public PartitionLevelCircuitBreakerConfig getPartitionLevelCircuitBreakerConfig() {
        return this.partitionLevelCircuitBreakerConfig;
    }
}

