/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.circuitBreaker;

import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.GlobalEndpointManager;
import com.azure.cosmos.implementation.circuitBreaker.ConsecutiveExceptionBasedCircuitBreaker;
import com.azure.cosmos.implementation.circuitBreaker.LocationHealthStatus;
import com.azure.cosmos.implementation.circuitBreaker.LocationSpecificHealthContext;
import com.azure.cosmos.implementation.circuitBreaker.PartitionKeyRangeWrapper;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationSpecificHealthContextTransitionHandler {
    private static final Logger logger = LoggerFactory.getLogger(LocationSpecificHealthContextTransitionHandler.class);
    private final GlobalEndpointManager globalEndpointManager;
    private final ConsecutiveExceptionBasedCircuitBreaker consecutiveExceptionBasedCircuitBreaker;

    public LocationSpecificHealthContextTransitionHandler(GlobalEndpointManager globalEndpointManager, ConsecutiveExceptionBasedCircuitBreaker consecutiveExceptionBasedCircuitBreaker) {
        this.globalEndpointManager = globalEndpointManager;
        this.consecutiveExceptionBasedCircuitBreaker = consecutiveExceptionBasedCircuitBreaker;
    }

    public LocationSpecificHealthContext handleSuccess(LocationSpecificHealthContext locationSpecificHealthContext, PartitionKeyRangeWrapper partitionKeyRangeWrapper, String regionWithSuccess, boolean forceStatusChange, boolean isReadOnlyRequest) {
        LocationHealthStatus currentLocationHealthStatusSnapshot = locationSpecificHealthContext.getLocationHealthStatus();
        int exceptionCountActual = isReadOnlyRequest ? locationSpecificHealthContext.getExceptionCountForReadForCircuitBreaking() : locationSpecificHealthContext.getExceptionCountForWriteForCircuitBreaking();
        switch (currentLocationHealthStatusSnapshot) {
            case Healthy: {
                break;
            }
            case HealthyWithFailures: {
                if (forceStatusChange || exceptionCountActual <= 0) break;
                return this.consecutiveExceptionBasedCircuitBreaker.handleSuccess(locationSpecificHealthContext, partitionKeyRangeWrapper, regionWithSuccess, isReadOnlyRequest);
            }
            case HealthyTentative: {
                if (forceStatusChange) break;
                LocationSpecificHealthContext locationSpecificHealthContextInner = this.consecutiveExceptionBasedCircuitBreaker.handleSuccess(locationSpecificHealthContext, partitionKeyRangeWrapper, regionWithSuccess, isReadOnlyRequest);
                if (this.consecutiveExceptionBasedCircuitBreaker.canHealthStatusBeUpgraded(locationSpecificHealthContextInner, isReadOnlyRequest)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Partition {}-{} of collection : {} marked as Healthy from HealthyTentative for region : {}", new Object[]{partitionKeyRangeWrapper.getPartitionKeyRange().getMinInclusive(), partitionKeyRangeWrapper.getPartitionKeyRange().getMaxExclusive(), partitionKeyRangeWrapper.getCollectionResourceId(), regionWithSuccess});
                    }
                    return this.transitionHealthStatus(locationSpecificHealthContext, LocationHealthStatus.Healthy);
                }
                return locationSpecificHealthContextInner;
            }
            case Unavailable: {
                Instant unavailableSinceActual = locationSpecificHealthContext.getUnavailableSince();
                if (!forceStatusChange) {
                    if (Duration.between(unavailableSinceActual, Instant.now()).compareTo(Duration.ofSeconds(Configs.getAllowedPartitionUnavailabilityDurationInSeconds())) <= 0) break;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Partition {}-{} of collection : {} marked as HealthyTentative from Unavailable for region : {}", new Object[]{partitionKeyRangeWrapper.getPartitionKeyRange().getMinInclusive(), partitionKeyRangeWrapper.getPartitionKeyRange().getMaxExclusive(), partitionKeyRangeWrapper.getCollectionResourceId(), regionWithSuccess});
                    }
                    return this.transitionHealthStatus(locationSpecificHealthContext, LocationHealthStatus.HealthyTentative);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Partition {}-{} of collection : {} marked as HealthyTentative from Unavailable for region : {}", new Object[]{partitionKeyRangeWrapper.getPartitionKeyRange().getMinInclusive(), partitionKeyRangeWrapper.getPartitionKeyRange().getMaxExclusive(), partitionKeyRangeWrapper.getCollectionResourceId(), regionWithSuccess});
                }
                return this.transitionHealthStatus(locationSpecificHealthContext, LocationHealthStatus.HealthyTentative);
            }
            default: {
                throw new IllegalStateException("Unsupported health status: " + (Object)((Object)currentLocationHealthStatusSnapshot));
            }
        }
        return locationSpecificHealthContext;
    }

    public LocationSpecificHealthContext handleException(LocationSpecificHealthContext locationSpecificHealthContext, PartitionKeyRangeWrapper partitionKeyRangeWrapper, ConcurrentHashMap<PartitionKeyRangeWrapper, PartitionKeyRangeWrapper> partitionKeyRangesWithPossibleUnavailableRegions, String regionWithException, boolean isReadOnlyRequest) {
        LocationHealthStatus currentLocationHealthStatusSnapshot = locationSpecificHealthContext.getLocationHealthStatus();
        switch (currentLocationHealthStatusSnapshot) {
            case Healthy: {
                if (logger.isDebugEnabled()) {
                    logger.debug("Partition {}-{} of collection : {} marked as HealthyWithFailures from Healthy for region : {}", new Object[]{partitionKeyRangeWrapper.getPartitionKeyRange().getMinInclusive(), partitionKeyRangeWrapper.getPartitionKeyRange().getMaxExclusive(), partitionKeyRangeWrapper.getCollectionResourceId(), regionWithException});
                }
                return this.transitionHealthStatus(locationSpecificHealthContext, LocationHealthStatus.HealthyWithFailures);
            }
            case HealthyWithFailures: {
                if (!this.consecutiveExceptionBasedCircuitBreaker.shouldHealthStatusBeDowngraded(locationSpecificHealthContext, isReadOnlyRequest)) {
                    LocationSpecificHealthContext locationSpecificHealthContextInner = this.consecutiveExceptionBasedCircuitBreaker.handleException(locationSpecificHealthContext, partitionKeyRangeWrapper, regionWithException, isReadOnlyRequest);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Partition {}-{} of collection : {} has exception count of {} for region : {}", new Object[]{partitionKeyRangeWrapper.getPartitionKeyRange().getMinInclusive(), partitionKeyRangeWrapper.getPartitionKeyRange().getMaxExclusive(), partitionKeyRangeWrapper.getCollectionResourceId(), isReadOnlyRequest ? locationSpecificHealthContextInner.getExceptionCountForReadForCircuitBreaking() : locationSpecificHealthContextInner.getExceptionCountForWriteForCircuitBreaking(), regionWithException});
                    }
                    return locationSpecificHealthContextInner;
                }
                partitionKeyRangesWithPossibleUnavailableRegions.put(partitionKeyRangeWrapper, partitionKeyRangeWrapper);
                if (logger.isDebugEnabled()) {
                    logger.info("Partition {}-{} of collection : {} marked as Unavailable from HealthyWithFailures for region : {}", new Object[]{partitionKeyRangeWrapper.getPartitionKeyRange().getMinInclusive(), partitionKeyRangeWrapper.getPartitionKeyRange().getMaxExclusive(), partitionKeyRangeWrapper.getPartitionKeyRange(), regionWithException});
                }
                return this.transitionHealthStatus(locationSpecificHealthContext, LocationHealthStatus.Unavailable);
            }
            case HealthyTentative: {
                if (!this.consecutiveExceptionBasedCircuitBreaker.shouldHealthStatusBeDowngraded(locationSpecificHealthContext, isReadOnlyRequest)) {
                    return this.consecutiveExceptionBasedCircuitBreaker.handleException(locationSpecificHealthContext, partitionKeyRangeWrapper, regionWithException, isReadOnlyRequest);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Partition {}-{} of collection : {} marked as Unavailable from HealthyTentative for region : {}", new Object[]{partitionKeyRangeWrapper.getPartitionKeyRange().getMinInclusive(), partitionKeyRangeWrapper.getPartitionKeyRange().getMaxExclusive(), partitionKeyRangeWrapper.getCollectionResourceId(), regionWithException});
                }
                return this.transitionHealthStatus(locationSpecificHealthContext, LocationHealthStatus.Unavailable);
            }
        }
        throw new IllegalStateException("Unsupported health status: " + (Object)((Object)currentLocationHealthStatusSnapshot));
    }

    public LocationSpecificHealthContext transitionHealthStatus(LocationSpecificHealthContext locationSpecificHealthContext, LocationHealthStatus newStatus) {
        LocationSpecificHealthContext.Builder builder = new LocationSpecificHealthContext.Builder().withSuccessCountForWriteForRecovery(0).withExceptionCountForWriteForCircuitBreaking(0).withSuccessCountForReadForRecovery(0).withExceptionCountForReadForCircuitBreaking(0);
        switch (newStatus) {
            case Healthy: {
                return builder.withUnavailableSince(Instant.MAX).withLocationHealthStatus(LocationHealthStatus.Healthy).withExceptionThresholdBreached(false).build();
            }
            case HealthyWithFailures: {
                return builder.withUnavailableSince(Instant.MAX).withLocationHealthStatus(LocationHealthStatus.HealthyWithFailures).withExceptionThresholdBreached(false).build();
            }
            case Unavailable: {
                return builder.withUnavailableSince(Instant.now()).withLocationHealthStatus(LocationHealthStatus.Unavailable).withExceptionThresholdBreached(true).build();
            }
            case HealthyTentative: {
                return builder.withUnavailableSince(Instant.now()).withLocationHealthStatus(LocationHealthStatus.HealthyTentative).withExceptionThresholdBreached(false).build();
            }
        }
        throw new IllegalStateException("Unsupported health status: " + (Object)((Object)newStatus));
    }
}

