/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.clienttelemetry;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.CosmosDiagnosticsContext;
import com.azure.cosmos.implementation.ClientSideRequestStatistics;
import com.azure.cosmos.implementation.FeedResponseDiagnostics;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.RequestTimeline;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.clienttelemetry.CosmosMeterOptions;
import com.azure.cosmos.implementation.clienttelemetry.MetricCategory;
import com.azure.cosmos.implementation.clienttelemetry.TagName;
import com.azure.cosmos.implementation.directconnectivity.RntbdTransportClient;
import com.azure.cosmos.implementation.directconnectivity.StoreResponseDiagnostics;
import com.azure.cosmos.implementation.directconnectivity.StoreResultDiagnostics;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdDurableEndpointMetrics;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdEndpoint;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdEndpointStatistics;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdMetricsCompletionRecorder;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestRecord;
import com.azure.cosmos.implementation.guava25.net.PercentEscaper;
import com.azure.cosmos.implementation.query.QueryInfo;
import com.azure.cosmos.models.CosmosMetricName;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientTelemetryMetrics {
    private static final Logger logger = LoggerFactory.getLogger(ClientTelemetryMetrics.class);
    private static final ImplementationBridgeHelpers.CosmosAsyncClientHelper.CosmosAsyncClientAccessor clientAccessor = ImplementationBridgeHelpers.CosmosAsyncClientHelper.getCosmosAsyncClientAccessor();
    private static final ImplementationBridgeHelpers.CosmosDiagnosticsHelper.CosmosDiagnosticsAccessor diagnosticsAccessor = ImplementationBridgeHelpers.CosmosDiagnosticsHelper.getCosmosDiagnosticsAccessor();
    private static final PercentEscaper PERCENT_ESCAPER = new PercentEscaper("_-/.", false);
    private static CompositeMeterRegistry compositeRegistry = ClientTelemetryMetrics.createFreshRegistry();
    private static final ConcurrentHashMap<MeterRegistry, AtomicLong> registryRefCount = new ConcurrentHashMap();
    private static CosmosMeterOptions cpuOptions;
    private static CosmosMeterOptions memoryOptions;
    private static volatile DescendantValidationResult lastDescendantValidation;
    private static final Object lockObject;
    private static final Tag QUERYPLAN_TAG;

    /*
     * Enabled aggressive exception aggregation
     */
    private static String convertStackTraceToString(Throwable throwable) {
        try (StringWriter sw = new StringWriter();){
            PrintWriter pw = new PrintWriter(sw);
            try {
                throwable.printStackTrace(pw);
                String string = sw.toString();
                pw.close();
                return string;
            }
            catch (Throwable throwable2) {
                try {
                    pw.close();
                }
                catch (Throwable throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    private static CompositeMeterRegistry createFreshRegistry() {
        CompositeMeterRegistry registry = new CompositeMeterRegistry();
        if (logger.isTraceEnabled()) {
            registry.config().onMeterAdded(meter -> logger.trace("Meter '{}' added. Callstack: {}", (Object)meter.getId().getName(), (Object)ClientTelemetryMetrics.convertStackTraceToString(new IllegalStateException("Dummy"))));
        }
        return registry;
    }

    public static void recordSystemUsage(float averageSystemCpuUsage, float freeMemoryAvailableInMB) {
        if (compositeRegistry.getRegistries().isEmpty() || cpuOptions == null || memoryOptions == null) {
            return;
        }
        if (cpuOptions.isEnabled()) {
            DistributionSummary averageSystemCpuUsageMeter = DistributionSummary.builder((String)CosmosMetricName.SYSTEM_CPU.toString()).baseUnit("%").description("Avg. System CPU load").maximumExpectedValue(Double.valueOf(100.0)).publishPercentiles(cpuOptions.getPercentiles()).publishPercentileHistogram(Boolean.valueOf(cpuOptions.isHistogramPublishingEnabled())).register((MeterRegistry)compositeRegistry);
            averageSystemCpuUsageMeter.record((double)averageSystemCpuUsage);
        }
        if (memoryOptions.isEnabled()) {
            DistributionSummary freeMemoryAvailableInMBMeter = DistributionSummary.builder((String)CosmosMetricName.SYSTEM_MEMORY_FREE.toString()).baseUnit("MB").description("Free memory available").publishPercentiles(new double[0]).publishPercentileHistogram(Boolean.valueOf(false)).register((MeterRegistry)compositeRegistry);
            freeMemoryAvailableInMBMeter.record((double)freeMemoryAvailableInMB);
        }
    }

    public static void recordOperation(CosmosAsyncClient client, CosmosDiagnosticsContext diagnosticsContext) {
        ClientTelemetryMetrics.recordOperation(client, diagnosticsContext, diagnosticsContext.getStatusCode(), diagnosticsContext.getSubStatusCode(), diagnosticsContext.getMaxItemCount(), diagnosticsContext.getActualItemCount(), diagnosticsContext.getContainerName(), diagnosticsContext.getDatabaseName(), diagnosticsContext.getOperationType(), diagnosticsContext.isPointOperation(), diagnosticsContext.getResourceType(), diagnosticsContext.getEffectiveConsistencyLevel(), diagnosticsContext.getOperationId(), diagnosticsContext.getTotalRequestCharge(), diagnosticsContext.getDuration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasAnyActualMeterRegistry() {
        DescendantValidationResult snapshot;
        Instant nowSnapshot = Instant.now();
        if (nowSnapshot.isBefore((snapshot = lastDescendantValidation).getExpiration())) {
            return snapshot.getResult();
        }
        Object object = lockObject;
        synchronized (object) {
            DescendantValidationResult newResult;
            snapshot = lastDescendantValidation;
            if (nowSnapshot.isBefore(snapshot.getExpiration())) {
                return snapshot.getResult();
            }
            lastDescendantValidation = newResult = new DescendantValidationResult(nowSnapshot.plus(10L, ChronoUnit.SECONDS), ClientTelemetryMetrics.hasAnyActualMeterRegistryCore(compositeRegistry, 1));
            return newResult.getResult();
        }
    }

    private static boolean hasAnyActualMeterRegistryCore(CompositeMeterRegistry compositeMeterRegistry, int depth) {
        if (depth > 100) {
            return true;
        }
        for (MeterRegistry registry : compositeMeterRegistry.getRegistries()) {
            if (registry instanceof CompositeMeterRegistry) {
                if (!ClientTelemetryMetrics.hasAnyActualMeterRegistryCore((CompositeMeterRegistry)registry, depth + 1)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private static void recordOperation(CosmosAsyncClient client, CosmosDiagnosticsContext diagnosticsContext, int statusCode, int subStatusCode, Integer maxItemCount, Integer actualItemCount, String containerId, String databaseId, String operationType, boolean isPointOperation, String resourceType, ConsistencyLevel consistencyLevel, String operationId, float requestCharge, Duration latency) {
        boolean isClientTelemetryMetricsEnabled = clientAccessor.shouldEnableEmptyPageDiagnostics(client);
        if (!ClientTelemetryMetrics.hasAnyActualMeterRegistry() || !isClientTelemetryMetricsEnabled) {
            return;
        }
        Tag clientCorrelationTag = clientAccessor.getClientCorrelationTag(client);
        String accountTagValue = clientAccessor.getAccountTagValue(client);
        EnumSet<TagName> metricTagNames = clientAccessor.getMetricTagNames(client);
        EnumSet<MetricCategory> metricCategories = clientAccessor.getMetricCategories(client);
        Set<String> contactedRegions = Collections.emptySet();
        if (metricCategories.contains((Object)MetricCategory.OperationDetails)) {
            contactedRegions = diagnosticsContext.getContactedRegionNames();
        }
        Tags operationTags = ClientTelemetryMetrics.createOperationTags(metricTagNames, statusCode, subStatusCode, containerId, databaseId, operationType, resourceType, consistencyLevel, operationId, isPointOperation, contactedRegions, clientCorrelationTag, accountTagValue);
        OperationMetricProducer metricProducer = new OperationMetricProducer(metricCategories, metricTagNames, operationTags);
        metricProducer.recordOperation(client, requestCharge, latency, maxItemCount == null ? -1 : maxItemCount, actualItemCount == null ? -1 : actualItemCount, diagnosticsContext, contactedRegions);
    }

    public static RntbdMetricsCompletionRecorder createRntbdMetrics(RntbdTransportClient client, RntbdEndpoint endpoint) {
        return new RntbdMetricsV2((MeterRegistry)compositeRegistry, client, endpoint);
    }

    public static synchronized void add(MeterRegistry registry, CosmosMeterOptions cpuOptions, CosmosMeterOptions memoryOptions) {
        if (registryRefCount.computeIfAbsent(registry, meterRegistry -> new AtomicLong(0L)).incrementAndGet() == 1L) {
            compositeRegistry.add(registry);
            ClientTelemetryMetrics.cpuOptions = cpuOptions;
            ClientTelemetryMetrics.memoryOptions = memoryOptions;
            lastDescendantValidation = new DescendantValidationResult(Instant.MIN, true);
        }
    }

    public static synchronized void remove(MeterRegistry registry) {
        if (registryRefCount.get(registry).decrementAndGet() == 0L) {
            registry.clear();
            registry.close();
            compositeRegistry.remove(registry);
            if (compositeRegistry.getRegistries().isEmpty()) {
                compositeRegistry = ClientTelemetryMetrics.createFreshRegistry();
            }
            lastDescendantValidation = new DescendantValidationResult(Instant.MIN, true);
        }
    }

    public static String escape(String value) {
        return PERCENT_ESCAPER.escape(value);
    }

    private static Tags createOperationTags(EnumSet<TagName> metricTagNames, int statusCode, int subStatusCode, String containerId, String databaseId, String operationType, String resourceType, ConsistencyLevel consistencyLevel, String operationId, boolean isPointOperation, Set<String> contactedRegions, Tag clientCorrelationTag, String accountTagValue) {
        ArrayList<Tag> effectiveTags = new ArrayList<Tag>();
        if (metricTagNames.contains((Object)TagName.ClientCorrelationId)) {
            effectiveTags.add(clientCorrelationTag);
        }
        if (metricTagNames.contains((Object)TagName.Container)) {
            String containerTagValue = ClientTelemetryMetrics.escape(accountTagValue) + "/" + (databaseId != null ? ClientTelemetryMetrics.escape(databaseId) : "NONE") + "/" + (containerId != null ? ClientTelemetryMetrics.escape(containerId) : "NONE");
            effectiveTags.add(Tag.of((String)TagName.Container.toString(), (String)containerTagValue));
        }
        if (metricTagNames.contains((Object)TagName.Operation)) {
            String operationTagValue = !isPointOperation && !Strings.isNullOrWhiteSpace(operationId) ? resourceType + "/" + operationType + "/" + ClientTelemetryMetrics.escape(operationId) : resourceType + "/" + operationType;
            effectiveTags.add(Tag.of((String)TagName.Operation.toString(), (String)operationTagValue));
        }
        if (metricTagNames.contains((Object)TagName.OperationStatusCode)) {
            effectiveTags.add(Tag.of((String)TagName.OperationStatusCode.toString(), (String)String.valueOf(statusCode)));
        }
        if (metricTagNames.contains((Object)TagName.OperationSubStatusCode)) {
            effectiveTags.add(Tag.of((String)TagName.OperationSubStatusCode.toString(), (String)String.valueOf(subStatusCode)));
        }
        if (metricTagNames.contains((Object)TagName.ConsistencyLevel)) {
            assert (consistencyLevel != null) : "ConsistencyLevel must never be null here.";
            effectiveTags.add(Tag.of((String)TagName.ConsistencyLevel.toString(), (String)consistencyLevel.toString()));
        }
        if (metricTagNames.contains((Object)TagName.RegionName)) {
            effectiveTags.add(Tag.of((String)TagName.RegionName.toString(), (String)(contactedRegions != null && !contactedRegions.isEmpty() ? String.join((CharSequence)", ", contactedRegions) : "NONE")));
        }
        return Tags.of(effectiveTags);
    }

    private static Tags getEffectiveTags(Tags tags, CosmosMeterOptions meterOptions) {
        EnumSet<TagName> suppressedTags = meterOptions.getSuppressedTagNames();
        if (suppressedTags == null || suppressedTags.isEmpty()) {
            return tags;
        }
        HashSet<String> suppressedNames = new HashSet<String>();
        for (TagName t : suppressedTags) {
            suppressedNames.add(t.name());
        }
        ArrayList<Tag> result = new ArrayList<Tag>();
        for (Tag t : tags) {
            if (suppressedNames.contains(t.getKey())) continue;
            result.add(t);
        }
        return Tags.of(result);
    }

    static {
        lastDescendantValidation = new DescendantValidationResult(Instant.MIN, true);
        lockObject = new Object();
        QUERYPLAN_TAG = Tag.of((String)TagName.RequestOperationType.toString(), (String)((Object)((Object)ResourceType.DocumentCollection) + "/" + (Object)((Object)OperationType.QueryPlan)));
    }

    static class DescendantValidationResult {
        private final Instant expiration;
        private final boolean result;

        public DescendantValidationResult(Instant expiration, boolean result) {
            this.expiration = expiration;
            this.result = result;
        }

        public Instant getExpiration() {
            return this.expiration;
        }

        public boolean getResult() {
            return this.result;
        }
    }

    private static class OperationMetricProducer {
        private final EnumSet<TagName> metricTagNames;
        private final EnumSet<MetricCategory> metricCategories;
        private final Tags operationTags;

        public OperationMetricProducer(EnumSet<MetricCategory> metricCategories, EnumSet<TagName> metricTagNames, Tags operationTags) {
            this.metricCategories = metricCategories;
            this.metricTagNames = metricTagNames;
            this.operationTags = operationTags;
        }

        public void recordOperation(CosmosAsyncClient cosmosAsyncClient, float requestCharge, Duration latency, int maxItemCount, int actualItemCount, CosmosDiagnosticsContext diagnosticsContext, Set<String> contactedRegions) {
            CosmosMeterOptions latencyOptions;
            CosmosMeterOptions requestChargeOptions;
            CosmosMeterOptions callsOptions = clientAccessor.getMeterOptions(cosmosAsyncClient, CosmosMetricName.OPERATION_SUMMARY_CALLS);
            if (callsOptions.isEnabled()) {
                Counter operationsCounter = Counter.builder((String)callsOptions.getMeterName().toString()).baseUnit("calls").description("Operation calls").tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(this.operationTags, callsOptions)).register((MeterRegistry)compositeRegistry);
                operationsCounter.increment();
            }
            if ((requestChargeOptions = clientAccessor.getMeterOptions(cosmosAsyncClient, CosmosMetricName.OPERATION_SUMMARY_REQUEST_CHARGE)).isEnabled()) {
                DistributionSummary requestChargeMeter = DistributionSummary.builder((String)requestChargeOptions.getMeterName().toString()).baseUnit("RU (request unit)").description("Operation RU charge").maximumExpectedValue(Double.valueOf(100000.0)).publishPercentiles(requestChargeOptions.getPercentiles()).publishPercentileHistogram(Boolean.valueOf(requestChargeOptions.isHistogramPublishingEnabled())).tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(this.operationTags, requestChargeOptions)).register((MeterRegistry)compositeRegistry);
                requestChargeMeter.record(Math.min((double)requestCharge, 100000.0));
            }
            if (this.metricCategories.contains((Object)MetricCategory.OperationDetails)) {
                CosmosMeterOptions regionsOptions = clientAccessor.getMeterOptions(cosmosAsyncClient, CosmosMetricName.OPERATION_DETAILS_REGIONS_CONTACTED);
                if (regionsOptions.isEnabled()) {
                    DistributionSummary regionsContactedMeter = DistributionSummary.builder((String)regionsOptions.getMeterName().toString()).baseUnit("Regions contacted").description("Operation - regions contacted").maximumExpectedValue(Double.valueOf(100.0)).publishPercentiles(new double[0]).publishPercentileHistogram(Boolean.valueOf(false)).tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(this.operationTags, regionsOptions)).register((MeterRegistry)compositeRegistry);
                    if (contactedRegions != null && contactedRegions.size() > 0) {
                        regionsContactedMeter.record(Math.min((double)contactedRegions.size(), 100.0));
                    }
                }
                this.recordItemCounts(cosmosAsyncClient, maxItemCount, actualItemCount);
            }
            if ((latencyOptions = clientAccessor.getMeterOptions(cosmosAsyncClient, CosmosMetricName.OPERATION_SUMMARY_LATENCY)).isEnabled()) {
                Timer latencyMeter = Timer.builder((String)latencyOptions.getMeterName().toString()).description("Operation latency").maximumExpectedValue(Duration.ofSeconds(300L)).publishPercentiles(latencyOptions.getPercentiles()).publishPercentileHistogram(Boolean.valueOf(latencyOptions.isHistogramPublishingEnabled())).tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(this.operationTags, latencyOptions)).register((MeterRegistry)compositeRegistry);
                latencyMeter.record(latency);
            }
            for (CosmosDiagnostics diagnostics : diagnosticsContext.getDiagnostics()) {
                FeedResponseDiagnostics feedDiagnostics;
                Collection<ClientSideRequestStatistics> clientSideRequestStatistics = diagnosticsAccessor.getClientSideRequestStatistics(diagnostics);
                if (clientSideRequestStatistics != null) {
                    for (ClientSideRequestStatistics requestStatistics : clientSideRequestStatistics) {
                        this.recordStoreResponseStatistics(diagnosticsContext, cosmosAsyncClient, requestStatistics.getResponseStatisticsList(), actualItemCount);
                        this.recordStoreResponseStatistics(diagnosticsContext, cosmosAsyncClient, requestStatistics.getSupplementalResponseStatisticsList(), -1);
                        this.recordGatewayStatistics(diagnosticsContext, cosmosAsyncClient, requestStatistics.getDuration(), requestStatistics.getGatewayStatisticsList(), requestStatistics.getRequestPayloadSizeInBytes(), actualItemCount);
                        this.recordAddressResolutionStatistics(diagnosticsContext, cosmosAsyncClient, requestStatistics.getAddressResolutionStatistics());
                    }
                }
                if ((feedDiagnostics = diagnosticsAccessor.getFeedResponseDiagnostics(diagnostics)) == null) continue;
                QueryInfo.QueryPlanDiagnosticsContext queryPlanDiagnostics = feedDiagnostics.getQueryPlanDiagnosticsContext();
                this.recordQueryPlanDiagnostics(diagnosticsContext, cosmosAsyncClient, queryPlanDiagnostics);
            }
        }

        private void recordQueryPlanDiagnostics(CosmosDiagnosticsContext ctx, CosmosAsyncClient cosmosAsyncClient, QueryInfo.QueryPlanDiagnosticsContext queryPlanDiagnostics) {
            CosmosMeterOptions latencyOptions;
            Duration latency;
            if (queryPlanDiagnostics == null || !this.metricCategories.contains((Object)MetricCategory.RequestSummary)) {
                return;
            }
            Tags requestTags = this.operationTags.and((Iterable)this.createQueryPlanTags(this.metricTagNames));
            CosmosMeterOptions requestsOptions = clientAccessor.getMeterOptions(cosmosAsyncClient, CosmosMetricName.REQUEST_SUMMARY_GATEWAY_REQUESTS);
            if (requestsOptions.isEnabled() && (!requestsOptions.isDiagnosticThresholdsFilteringEnabled() || ctx.isThresholdViolated())) {
                Counter requestCounter = Counter.builder((String)requestsOptions.getMeterName().toString()).baseUnit("requests").description("Gateway requests").tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(requestTags, requestsOptions)).register((MeterRegistry)compositeRegistry);
                requestCounter.increment();
            }
            if ((latency = queryPlanDiagnostics.getDuration()) != null && (latencyOptions = clientAccessor.getMeterOptions(cosmosAsyncClient, CosmosMetricName.REQUEST_SUMMARY_GATEWAY_LATENCY)).isEnabled() && (!latencyOptions.isDiagnosticThresholdsFilteringEnabled() || ctx.isThresholdViolated())) {
                Timer requestLatencyMeter = Timer.builder((String)latencyOptions.getMeterName().toString()).description("Gateway Request latency").maximumExpectedValue(Duration.ofSeconds(300L)).publishPercentiles(latencyOptions.getPercentiles()).publishPercentileHistogram(Boolean.valueOf(latencyOptions.isHistogramPublishingEnabled())).tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(requestTags, latencyOptions)).register((MeterRegistry)compositeRegistry);
                requestLatencyMeter.record(latency);
            }
            this.recordRequestTimeline(ctx, cosmosAsyncClient, CosmosMetricName.REQUEST_DETAILS_GATEWAY_TIMELINE, queryPlanDiagnostics.getRequestTimeline(), requestTags);
        }

        private void recordRequestPayloadSizes(CosmosDiagnosticsContext ctx, CosmosAsyncClient client, int requestPayloadSizeInBytes, int responsePayloadSizeInBytes) {
            CosmosMeterOptions rspSizeOptions;
            CosmosMeterOptions reqSizeOptions = clientAccessor.getMeterOptions(client, CosmosMetricName.REQUEST_SUMMARY_SIZE_REQUEST);
            if (reqSizeOptions.isEnabled() && (!reqSizeOptions.isDiagnosticThresholdsFilteringEnabled() || ctx.isThresholdViolated())) {
                DistributionSummary requestPayloadSizeMeter = DistributionSummary.builder((String)reqSizeOptions.getMeterName().toString()).baseUnit("bytes").description("Request payload size in bytes").maximumExpectedValue(Double.valueOf(16384.0)).publishPercentiles(new double[0]).publishPercentileHistogram(Boolean.valueOf(false)).tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(this.operationTags, reqSizeOptions)).register((MeterRegistry)compositeRegistry);
                requestPayloadSizeMeter.record((double)requestPayloadSizeInBytes);
            }
            if ((rspSizeOptions = clientAccessor.getMeterOptions(client, CosmosMetricName.REQUEST_SUMMARY_SIZE_RESPONSE)).isEnabled() && (!rspSizeOptions.isDiagnosticThresholdsFilteringEnabled() || ctx.isThresholdViolated())) {
                DistributionSummary responsePayloadSizeMeter = DistributionSummary.builder((String)rspSizeOptions.getMeterName().toString()).baseUnit("bytes").description("Response payload size in bytes").maximumExpectedValue(Double.valueOf(16384.0)).publishPercentiles(new double[0]).publishPercentileHistogram(Boolean.valueOf(false)).tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(this.operationTags, rspSizeOptions)).register((MeterRegistry)compositeRegistry);
                responsePayloadSizeMeter.record((double)responsePayloadSizeInBytes);
            }
        }

        private void recordItemCounts(CosmosAsyncClient client, int maxItemCount, int actualItemCount) {
            if (maxItemCount > 0 && this.metricCategories.contains((Object)MetricCategory.OperationDetails)) {
                CosmosMeterOptions actualItemCountOptions;
                CosmosMeterOptions maxItemCountOptions = clientAccessor.getMeterOptions(client, CosmosMetricName.OPERATION_DETAILS_MAX_ITEM_COUNT);
                if (maxItemCountOptions.isEnabled()) {
                    DistributionSummary maxItemCountMeter = DistributionSummary.builder((String)maxItemCountOptions.getMeterName().toString()).baseUnit("item count").description("Request max. item count").maximumExpectedValue(Double.valueOf(100000.0)).publishPercentiles(new double[0]).publishPercentileHistogram(Boolean.valueOf(false)).tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(this.operationTags, maxItemCountOptions)).register((MeterRegistry)compositeRegistry);
                    maxItemCountMeter.record(Math.max(0.0, Math.min((double)maxItemCount, 100000.0)));
                }
                if ((actualItemCountOptions = clientAccessor.getMeterOptions(client, CosmosMetricName.OPERATION_DETAILS_ACTUAL_ITEM_COUNT)).isEnabled()) {
                    DistributionSummary actualItemCountMeter = DistributionSummary.builder((String)actualItemCountOptions.getMeterName().toString()).baseUnit("item count").description("Response actual item count").maximumExpectedValue(Double.valueOf(100000.0)).publishPercentiles(new double[0]).publishPercentileHistogram(Boolean.valueOf(false)).tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(this.operationTags, actualItemCountOptions)).register((MeterRegistry)compositeRegistry);
                    actualItemCountMeter.record(Math.max(0.0, Math.min((double)actualItemCount, 100000.0)));
                }
            }
        }

        private Tags createRequestTags(EnumSet<TagName> metricTagNames, String pkRangeId, int statusCode, int subStatusCode, String resourceType, String operationType, String regionName, String serviceEndpoint, String serviceAddress) {
            String effectiveServiceAddress;
            ArrayList<Tag> effectiveTags = new ArrayList<Tag>();
            if (metricTagNames.contains((Object)TagName.PartitionKeyRangeId)) {
                effectiveTags.add(Tag.of((String)TagName.PartitionKeyRangeId.toString(), (String)(Strings.isNullOrWhiteSpace(pkRangeId) ? "NONE" : ClientTelemetryMetrics.escape(pkRangeId))));
            }
            if (metricTagNames.contains((Object)TagName.RequestStatusCode)) {
                effectiveTags.add(Tag.of((String)TagName.RequestStatusCode.toString(), (String)(statusCode + "/" + subStatusCode)));
            }
            if (metricTagNames.contains((Object)TagName.RequestOperationType)) {
                effectiveTags.add(Tag.of((String)TagName.RequestOperationType.toString(), (String)(resourceType + "/" + operationType)));
            }
            if (metricTagNames.contains((Object)TagName.RegionName)) {
                effectiveTags.add(Tag.of((String)TagName.RegionName.toString(), (String)(regionName != null ? regionName : "NONE")));
            }
            if (metricTagNames.contains((Object)TagName.ServiceEndpoint)) {
                effectiveTags.add(Tag.of((String)TagName.ServiceEndpoint.toString(), (String)(serviceEndpoint != null ? ClientTelemetryMetrics.escape(serviceEndpoint) : "NONE")));
            }
            String string = effectiveServiceAddress = serviceAddress != null ? ClientTelemetryMetrics.escape(serviceAddress) : "NONE";
            if (metricTagNames.contains((Object)TagName.ServiceAddress)) {
                effectiveTags.add(Tag.of((String)TagName.ServiceAddress.toString(), (String)effectiveServiceAddress));
            }
            boolean containsPartitionId = metricTagNames.contains((Object)TagName.PartitionId);
            boolean containsReplicaId = metricTagNames.contains((Object)TagName.ReplicaId);
            if (containsPartitionId || containsReplicaId) {
                String partitionId = "NONE";
                String replicaId = "NONE";
                String[] partitionAndReplicaId = StoreResultDiagnostics.getPartitionAndReplicaId(effectiveServiceAddress);
                if (partitionAndReplicaId.length == 2) {
                    partitionId = partitionAndReplicaId[0];
                    replicaId = partitionAndReplicaId[1];
                }
                if (containsPartitionId) {
                    effectiveTags.add(Tag.of((String)TagName.PartitionId.toString(), (String)partitionId));
                }
                if (containsReplicaId) {
                    effectiveTags.add(Tag.of((String)TagName.ReplicaId.toString(), (String)replicaId));
                }
            }
            return Tags.of(effectiveTags);
        }

        private Tags createQueryPlanTags(EnumSet<TagName> metricTagNames) {
            ArrayList<Tag> effectiveTags = new ArrayList<Tag>();
            if (metricTagNames.contains((Object)TagName.RequestOperationType)) {
                effectiveTags.add(QUERYPLAN_TAG);
            }
            if (metricTagNames.contains((Object)TagName.RequestStatusCode)) {
                effectiveTags.add(Tag.of((String)TagName.RequestStatusCode.toString(), (String)"NONE"));
            }
            if (metricTagNames.contains((Object)TagName.PartitionKeyRangeId)) {
                effectiveTags.add(Tag.of((String)TagName.PartitionKeyRangeId.toString(), (String)"NONE"));
            }
            return Tags.of(effectiveTags);
        }

        private Tags createAddressResolutionTags(EnumSet<TagName> metricTagNames, String serviceEndpoint, boolean isForceRefresh, boolean isForceCollectionRoutingMapRefresh) {
            ArrayList<Tag> effectiveTags = new ArrayList<Tag>();
            if (metricTagNames.contains((Object)TagName.ServiceEndpoint)) {
                effectiveTags.add(Tag.of((String)TagName.ServiceEndpoint.toString(), (String)(serviceEndpoint != null ? ClientTelemetryMetrics.escape(serviceEndpoint) : "NONE")));
            }
            if (metricTagNames.contains((Object)TagName.IsForceRefresh)) {
                effectiveTags.add(Tag.of((String)TagName.IsForceRefresh.toString(), (String)(isForceRefresh ? "True" : "False")));
            }
            if (metricTagNames.contains((Object)TagName.IsForceCollectionRoutingMapRefresh)) {
                effectiveTags.add(Tag.of((String)TagName.IsForceCollectionRoutingMapRefresh.toString(), (String)(isForceCollectionRoutingMapRefresh ? "True" : "False")));
            }
            return Tags.of(effectiveTags);
        }

        private void recordRntbdEndpointStatistics(CosmosAsyncClient client, RntbdEndpointStatistics endpointStatistics, Tags requestTags) {
            CosmosMeterOptions inflightOptions;
            CosmosMeterOptions availableOptions;
            if (endpointStatistics == null || !this.metricCategories.contains((Object)MetricCategory.Legacy)) {
                return;
            }
            CosmosMeterOptions acquiredOptions = clientAccessor.getMeterOptions(client, CosmosMetricName.LEGACY_DIRECT_ENDPOINT_STATISTICS_ACQUIRED);
            if (acquiredOptions.isEnabled()) {
                DistributionSummary acquiredChannelsMeter = DistributionSummary.builder((String)acquiredOptions.getMeterName().toString()).baseUnit("#").description("Endpoint statistics(acquired channels)").maximumExpectedValue(Double.valueOf(100000.0)).publishPercentiles(new double[0]).publishPercentileHistogram(Boolean.valueOf(false)).tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(requestTags, acquiredOptions)).register((MeterRegistry)compositeRegistry);
                acquiredChannelsMeter.record((double)endpointStatistics.getAcquiredChannels());
            }
            if ((availableOptions = clientAccessor.getMeterOptions(client, CosmosMetricName.LEGACY_DIRECT_ENDPOINT_STATISTICS_AVAILABLE)).isEnabled()) {
                DistributionSummary availableChannelsMeter = DistributionSummary.builder((String)availableOptions.getMeterName().toString()).baseUnit("#").description("Endpoint statistics(available channels)").maximumExpectedValue(Double.valueOf(100000.0)).publishPercentiles(new double[0]).publishPercentileHistogram(Boolean.valueOf(false)).tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(requestTags, availableOptions)).register((MeterRegistry)compositeRegistry);
                availableChannelsMeter.record((double)endpointStatistics.getAvailableChannels());
            }
            if ((inflightOptions = clientAccessor.getMeterOptions(client, CosmosMetricName.LEGACY_DIRECT_ENDPOINT_STATISTICS_INFLIGHT)).isEnabled()) {
                DistributionSummary inflightRequestsMeter = DistributionSummary.builder((String)inflightOptions.getMeterName().toString()).baseUnit("#").description("Endpoint statistics(inflight requests)").tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(requestTags, inflightOptions)).maximumExpectedValue(Double.valueOf(1000000.0)).publishPercentiles(inflightOptions.getPercentiles()).publishPercentileHistogram(Boolean.valueOf(inflightOptions.isHistogramPublishingEnabled())).register((MeterRegistry)compositeRegistry);
                inflightRequestsMeter.record((double)endpointStatistics.getInflightRequests());
            }
        }

        private void recordRequestTimeline(CosmosDiagnosticsContext ctx, CosmosAsyncClient client, CosmosMetricName name, RequestTimeline requestTimeline, Tags requestTags) {
            if (requestTimeline == null || !this.metricCategories.contains((Object)MetricCategory.RequestDetails)) {
                return;
            }
            CosmosMeterOptions timelineOptions = clientAccessor.getMeterOptions(client, name);
            if (!timelineOptions.isEnabled() || timelineOptions.isDiagnosticThresholdsFilteringEnabled() && !ctx.isThresholdViolated()) {
                return;
            }
            for (RequestTimeline.Event event : requestTimeline) {
                Duration duration = event.getDuration();
                if (duration == null || duration == Duration.ZERO) continue;
                Timer eventMeter = Timer.builder((String)(timelineOptions.getMeterName().toString() + "." + ClientTelemetryMetrics.escape(event.getName()))).description("Request timeline (" + event.getName() + ")").maximumExpectedValue(Duration.ofSeconds(300L)).publishPercentiles(timelineOptions.getPercentiles()).publishPercentileHistogram(Boolean.valueOf(timelineOptions.isHistogramPublishingEnabled())).tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(requestTags, timelineOptions)).register((MeterRegistry)compositeRegistry);
                eventMeter.record(duration);
            }
        }

        private void recordStoreResponseStatistics(CosmosDiagnosticsContext ctx, CosmosAsyncClient client, Collection<ClientSideRequestStatistics.StoreResponseStatistics> storeResponseStatistics, int actualItemCount) {
            if (!this.metricCategories.contains((Object)MetricCategory.RequestSummary)) {
                return;
            }
            for (ClientSideRequestStatistics.StoreResponseStatistics responseStatistics : storeResponseStatistics) {
                CosmosMeterOptions actualItemCountOptions;
                CosmosMeterOptions reqOptions;
                Duration latency;
                CosmosMeterOptions latencyOptions;
                CosmosMeterOptions ruOptions;
                CosmosMeterOptions beLatencyOptions;
                StoreResultDiagnostics storeResultDiagnostics = responseStatistics.getStoreResult();
                StoreResponseDiagnostics storeResponseDiagnostics = storeResultDiagnostics.getStoreResponseDiagnostics();
                Tags requestTags = this.operationTags.and((Iterable)this.createRequestTags(this.metricTagNames, storeResponseDiagnostics.getPartitionKeyRangeId(), storeResponseDiagnostics.getStatusCode(), storeResponseDiagnostics.getSubStatusCode(), responseStatistics.getRequestResourceType().toString(), responseStatistics.getRequestOperationType().toString(), responseStatistics.getRegionName(), storeResultDiagnostics.getStorePhysicalAddressEscapedAuthority(), storeResultDiagnostics.getStorePhysicalAddressEscapedPath()));
                Double backendLatency = storeResultDiagnostics.getBackendLatencyInMs();
                if (backendLatency != null && (beLatencyOptions = clientAccessor.getMeterOptions(client, CosmosMetricName.REQUEST_SUMMARY_DIRECT_BACKEND_LATENCY)).isEnabled() && (!beLatencyOptions.isDiagnosticThresholdsFilteringEnabled() || ctx.isThresholdViolated())) {
                    DistributionSummary backendRequestLatencyMeter = DistributionSummary.builder((String)beLatencyOptions.getMeterName().toString()).baseUnit("ms").description("Backend service latency").maximumExpectedValue(Double.valueOf(6000.0)).publishPercentiles(beLatencyOptions.getPercentiles()).publishPercentileHistogram(Boolean.valueOf(beLatencyOptions.isHistogramPublishingEnabled())).tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(requestTags, beLatencyOptions)).register((MeterRegistry)compositeRegistry);
                    backendRequestLatencyMeter.record(storeResultDiagnostics.getBackendLatencyInMs().doubleValue());
                }
                if ((ruOptions = clientAccessor.getMeterOptions(client, CosmosMetricName.REQUEST_SUMMARY_DIRECT_REQUEST_CHARGE)).isEnabled() && (!ruOptions.isDiagnosticThresholdsFilteringEnabled() || ctx.isThresholdViolated())) {
                    double requestCharge = storeResponseDiagnostics.getRequestCharge();
                    DistributionSummary requestChargeMeter = DistributionSummary.builder((String)ruOptions.getMeterName().toString()).baseUnit("RU (request unit)").description("RNTBD Request RU charge").maximumExpectedValue(Double.valueOf(100000.0)).publishPercentiles(ruOptions.getPercentiles()).publishPercentileHistogram(Boolean.valueOf(ruOptions.isHistogramPublishingEnabled())).tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(requestTags, ruOptions)).register((MeterRegistry)compositeRegistry);
                    requestChargeMeter.record(Math.min(requestCharge, 100000.0));
                }
                if ((latencyOptions = clientAccessor.getMeterOptions(client, CosmosMetricName.REQUEST_SUMMARY_DIRECT_LATENCY)).isEnabled() && (!latencyOptions.isDiagnosticThresholdsFilteringEnabled() || ctx.isThresholdViolated()) && (latency = responseStatistics.getDuration()) != null) {
                    Timer requestLatencyMeter = Timer.builder((String)latencyOptions.getMeterName().toString()).description("RNTBD Request latency").maximumExpectedValue(Duration.ofSeconds(6L)).publishPercentiles(latencyOptions.getPercentiles()).publishPercentileHistogram(Boolean.valueOf(latencyOptions.isHistogramPublishingEnabled())).tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(requestTags, latencyOptions)).register((MeterRegistry)compositeRegistry);
                    requestLatencyMeter.record(latency);
                }
                if ((reqOptions = clientAccessor.getMeterOptions(client, CosmosMetricName.REQUEST_SUMMARY_DIRECT_REQUESTS)).isEnabled() && (!reqOptions.isDiagnosticThresholdsFilteringEnabled() || ctx.isThresholdViolated())) {
                    Counter requestCounter = Counter.builder((String)reqOptions.getMeterName().toString()).baseUnit("requests").description("RNTBD requests").tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(requestTags, reqOptions)).register((MeterRegistry)compositeRegistry);
                    requestCounter.increment();
                }
                if ((actualItemCountOptions = clientAccessor.getMeterOptions(client, CosmosMetricName.REQUEST_SUMMARY_DIRECT_ACTUAL_ITEM_COUNT)).isEnabled() && (!actualItemCountOptions.isDiagnosticThresholdsFilteringEnabled() || ctx.isThresholdViolated())) {
                    DistributionSummary actualItemCountMeter = DistributionSummary.builder((String)actualItemCountOptions.getMeterName().toString()).baseUnit("item count").description("Rntbd response actual item count").maximumExpectedValue(Double.valueOf(100000.0)).publishPercentiles(new double[0]).publishPercentileHistogram(Boolean.valueOf(false)).tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(requestTags, actualItemCountOptions)).register((MeterRegistry)compositeRegistry);
                    actualItemCountMeter.record(Math.max(0.0, Math.min((double)actualItemCount, 100000.0)));
                }
                if (this.metricCategories.contains((Object)MetricCategory.RequestDetails)) {
                    this.recordRequestTimeline(ctx, client, CosmosMetricName.REQUEST_DETAILS_DIRECT_TIMELINE, storeResponseDiagnostics.getRequestTimeline(), requestTags);
                }
                this.recordRequestPayloadSizes(ctx, client, storeResponseDiagnostics.getRequestPayloadLength(), storeResponseDiagnostics.getResponsePayloadLength());
                this.recordRntbdEndpointStatistics(client, storeResponseDiagnostics.getRntbdEndpointStatistics(), requestTags);
            }
        }

        private void recordGatewayStatistics(CosmosDiagnosticsContext ctx, CosmosAsyncClient client, Duration latency, List<ClientSideRequestStatistics.GatewayStatistics> gatewayStatisticsList, int requestPayloadSizeInBytes, int actualItemCount) {
            if (gatewayStatisticsList == null || gatewayStatisticsList.size() == 0 || !this.metricCategories.contains((Object)MetricCategory.RequestSummary)) {
                return;
            }
            Object metricTagNamesForGateway = this.metricTagNames.clone();
            ((AbstractCollection)metricTagNamesForGateway).remove((Object)TagName.RegionName);
            ((AbstractCollection)metricTagNamesForGateway).remove((Object)TagName.ServiceAddress);
            ((AbstractCollection)metricTagNamesForGateway).remove((Object)TagName.ServiceEndpoint);
            ((AbstractCollection)metricTagNamesForGateway).remove((Object)TagName.PartitionId);
            ((AbstractCollection)metricTagNamesForGateway).remove((Object)TagName.ReplicaId);
            for (ClientSideRequestStatistics.GatewayStatistics gatewayStats : gatewayStatisticsList) {
                CosmosMeterOptions actualItemCountOptions;
                CosmosMeterOptions latencyOptions;
                CosmosMeterOptions ruOptions;
                Tags requestTags = this.operationTags.and((Iterable)this.createRequestTags((EnumSet<TagName>)metricTagNamesForGateway, gatewayStats.getPartitionKeyRangeId(), gatewayStats.getStatusCode(), gatewayStats.getSubStatusCode(), gatewayStats.getResourceType().toString(), gatewayStats.getOperationType().toString(), null, null, null));
                this.recordRequestPayloadSizes(ctx, client, requestPayloadSizeInBytes, gatewayStats.getResponsePayloadSizeInBytes());
                CosmosMeterOptions reqOptions = clientAccessor.getMeterOptions(client, CosmosMetricName.REQUEST_SUMMARY_GATEWAY_REQUESTS);
                if (reqOptions.isEnabled() && (!reqOptions.isDiagnosticThresholdsFilteringEnabled() || ctx.isThresholdViolated())) {
                    Counter requestCounter = Counter.builder((String)reqOptions.getMeterName().toString()).baseUnit("requests").description("Gateway requests").tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(requestTags, reqOptions)).register((MeterRegistry)compositeRegistry);
                    requestCounter.increment();
                }
                if ((ruOptions = clientAccessor.getMeterOptions(client, CosmosMetricName.REQUEST_SUMMARY_GATEWAY_REQUEST_CHARGE)).isEnabled() && (!ruOptions.isDiagnosticThresholdsFilteringEnabled() || ctx.isThresholdViolated())) {
                    double requestCharge = gatewayStats.getRequestCharge();
                    DistributionSummary requestChargeMeter = DistributionSummary.builder((String)ruOptions.getMeterName().toString()).baseUnit("RU (request unit)").description("Gateway Request RU charge").maximumExpectedValue(Double.valueOf(100000.0)).publishPercentiles(ruOptions.getPercentiles()).publishPercentileHistogram(Boolean.valueOf(ruOptions.isHistogramPublishingEnabled())).tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(requestTags, ruOptions)).register((MeterRegistry)compositeRegistry);
                    requestChargeMeter.record(Math.min(requestCharge, 100000.0));
                }
                if (latency != null && (latencyOptions = clientAccessor.getMeterOptions(client, CosmosMetricName.REQUEST_SUMMARY_GATEWAY_LATENCY)).isEnabled() && (!latencyOptions.isDiagnosticThresholdsFilteringEnabled() || ctx.isThresholdViolated())) {
                    Timer requestLatencyMeter = Timer.builder((String)latencyOptions.getMeterName().toString()).description("Gateway Request latency").maximumExpectedValue(Duration.ofSeconds(300L)).publishPercentiles(latencyOptions.getPercentiles()).publishPercentileHistogram(Boolean.valueOf(latencyOptions.isHistogramPublishingEnabled())).tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(requestTags, latencyOptions)).register((MeterRegistry)compositeRegistry);
                    requestLatencyMeter.record(latency);
                }
                if ((actualItemCountOptions = clientAccessor.getMeterOptions(client, CosmosMetricName.REQUEST_SUMMARY_GATEWAY_ACTUAL_ITEM_COUNT)).isEnabled() && (!actualItemCountOptions.isDiagnosticThresholdsFilteringEnabled() || ctx.isThresholdViolated())) {
                    DistributionSummary actualItemCountMeter = DistributionSummary.builder((String)actualItemCountOptions.getMeterName().toString()).baseUnit("item count").description("Gateway response actual item count").maximumExpectedValue(Double.valueOf(100000.0)).publishPercentiles(new double[0]).publishPercentileHistogram(Boolean.valueOf(false)).tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(requestTags, actualItemCountOptions)).register((MeterRegistry)compositeRegistry);
                    actualItemCountMeter.record(Math.max(0.0, Math.min((double)actualItemCount, 100000.0)));
                }
                this.recordRequestTimeline(ctx, client, CosmosMetricName.REQUEST_DETAILS_GATEWAY_TIMELINE, gatewayStats.getRequestTimeline(), requestTags);
            }
        }

        private void recordAddressResolutionStatistics(CosmosDiagnosticsContext ctx, CosmosAsyncClient client, Map<String, ClientSideRequestStatistics.AddressResolutionStatistics> addressResolutionStatisticsMap) {
            if (addressResolutionStatisticsMap == null || addressResolutionStatisticsMap.size() == 0 || !this.metricCategories.contains((Object)MetricCategory.AddressResolutions)) {
                return;
            }
            for (ClientSideRequestStatistics.AddressResolutionStatistics addressResolutionStatistics : addressResolutionStatisticsMap.values()) {
                CosmosMeterOptions reqOptions;
                if (addressResolutionStatistics.isInflightRequest() || addressResolutionStatistics.getEndTimeUTC() == null) continue;
                Tags addressResolutionTags = this.operationTags.and((Iterable)this.createAddressResolutionTags(this.metricTagNames, addressResolutionStatistics.getTargetEndpoint(), addressResolutionStatistics.isForceRefresh(), addressResolutionStatistics.isForceCollectionRoutingMapRefresh()));
                Duration latency = Duration.between(addressResolutionStatistics.getStartTimeUTC(), addressResolutionStatistics.getEndTimeUTC());
                CosmosMeterOptions latencyOptions = clientAccessor.getMeterOptions(client, CosmosMetricName.DIRECT_ADDRESS_RESOLUTION_LATENCY);
                if (latencyOptions.isEnabled() && (!latencyOptions.isDiagnosticThresholdsFilteringEnabled() || ctx.isThresholdViolated())) {
                    Timer addressResolutionLatencyMeter = Timer.builder((String)latencyOptions.getMeterName().toString()).description("Address resolution latency").maximumExpectedValue(Duration.ofSeconds(6L)).publishPercentiles(latencyOptions.getPercentiles()).publishPercentileHistogram(Boolean.valueOf(latencyOptions.isHistogramPublishingEnabled())).tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(addressResolutionTags, latencyOptions)).register((MeterRegistry)compositeRegistry);
                    addressResolutionLatencyMeter.record(latency);
                }
                if (!(reqOptions = clientAccessor.getMeterOptions(client, CosmosMetricName.DIRECT_ADDRESS_RESOLUTION_REQUESTS)).isEnabled() || reqOptions.isDiagnosticThresholdsFilteringEnabled() && !ctx.isThresholdViolated()) continue;
                Counter requestCounter = Counter.builder((String)reqOptions.getMeterName().toString()).baseUnit("requests").description("Address resolution requests").tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(addressResolutionTags, reqOptions)).register((MeterRegistry)compositeRegistry);
                requestCounter.increment();
            }
        }
    }

    private static class RntbdMetricsV2
    implements RntbdMetricsCompletionRecorder {
        private final RntbdTransportClient client;
        private final Tags tags;
        private final MeterRegistry registry;

        private RntbdMetricsV2(MeterRegistry registry, RntbdTransportClient client, RntbdEndpoint endpoint) {
            CosmosMeterOptions options;
            this.tags = Tags.of((Tag[])new Tag[]{endpoint.clientMetricTag()});
            this.client = client;
            this.registry = registry;
            if (this.client.getMetricCategories().contains((Object)MetricCategory.DirectRequests)) {
                options = client.getMeterOptions(CosmosMetricName.DIRECT_REQUEST_CONCURRENT_COUNT);
                if (options.isEnabled()) {
                    Gauge.builder((String)options.getMeterName().toString(), (Object)endpoint, RntbdEndpoint::concurrentRequests).description("RNTBD concurrent requests (executing or queued request count)").tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(this.tags, options)).register(registry);
                }
                if ((options = client.getMeterOptions(CosmosMetricName.DIRECT_REQUEST_QUEUED_COUNT)).isEnabled()) {
                    Gauge.builder((String)options.getMeterName().toString(), (Object)endpoint, RntbdEndpoint::requestQueueLength).description("RNTBD queued request count").tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(this.tags, options)).register(registry);
                }
            }
            if (this.client.getMetricCategories().contains((Object)MetricCategory.DirectEndpoints)) {
                options = client.getMeterOptions(CosmosMetricName.DIRECT_ENDPOINTS_COUNT);
                if (options.isEnabled()) {
                    Gauge.builder((String)options.getMeterName().toString(), (Object)client, RntbdTransportClient::endpointCount).description("RNTBD endpoint count").register(registry);
                }
                if ((options = client.getMeterOptions(CosmosMetricName.DIRECT_ENDPOINTS_EVICTED)).isEnabled()) {
                    FunctionCounter.builder((String)options.getMeterName().toString(), (Object)client, RntbdTransportClient::endpointEvictionCount).description("RNTBD endpoint eviction count").register(registry);
                }
            }
            if (this.client.getMetricCategories().contains((Object)MetricCategory.DirectChannels)) {
                options = client.getMeterOptions(CosmosMetricName.DIRECT_CHANNELS_ACQUIRED_COUNT);
                if (options.isEnabled()) {
                    FunctionCounter.builder((String)options.getMeterName().toString(), (Object)endpoint.durableEndpointMetrics(), RntbdDurableEndpointMetrics::totalChannelsAcquiredMetric).description("RNTBD acquired channel count").tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(this.tags, options)).register(registry);
                }
                if ((options = client.getMeterOptions(CosmosMetricName.DIRECT_CHANNELS_CLOSED_COUNT)).isEnabled()) {
                    FunctionCounter.builder((String)options.getMeterName().toString(), (Object)endpoint.durableEndpointMetrics(), RntbdDurableEndpointMetrics::totalChannelsClosedMetric).description("RNTBD closed channel count").tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(this.tags, options)).register(registry);
                }
                if ((options = client.getMeterOptions(CosmosMetricName.DIRECT_CHANNELS_AVAILABLE_COUNT)).isEnabled()) {
                    Gauge.builder((String)options.getMeterName().toString(), (Object)endpoint.durableEndpointMetrics(), RntbdDurableEndpointMetrics::channelsAvailableMetric).description("RNTBD available channel count").tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(this.tags, options)).register(registry);
                }
            }
        }

        @Override
        public void markComplete(RntbdRequestRecord requestRecord) {
            if (this.client.getMetricCategories().contains((Object)MetricCategory.DirectRequests)) {
                Timer requests = null;
                Timer requestsSuccess = null;
                Timer requestsFailed = null;
                CosmosMeterOptions options = this.client.getMeterOptions(CosmosMetricName.DIRECT_REQUEST_LATENCY);
                if (options.isEnabled()) {
                    requests = Timer.builder((String)options.getMeterName().toString()).description("RNTBD request latency").maximumExpectedValue(Duration.ofSeconds(300L)).publishPercentiles(options.getPercentiles()).publishPercentileHistogram(Boolean.valueOf(options.isHistogramPublishingEnabled())).tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(this.tags, options)).register(this.registry);
                }
                if ((options = this.client.getMeterOptions(CosmosMetricName.DIRECT_REQUEST_LATENCY_FAILED)).isEnabled()) {
                    requestsFailed = Timer.builder((String)options.getMeterName().toString()).description("RNTBD failed request latency").maximumExpectedValue(Duration.ofSeconds(300L)).publishPercentiles(options.getPercentiles()).publishPercentileHistogram(Boolean.valueOf(options.isHistogramPublishingEnabled())).tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(this.tags, options)).register(this.registry);
                }
                if ((options = this.client.getMeterOptions(CosmosMetricName.DIRECT_REQUEST_LATENCY_SUCCESS)).isEnabled()) {
                    requestsSuccess = Timer.builder((String)options.getMeterName().toString()).description("RNTBD successful request latency").maximumExpectedValue(Duration.ofSeconds(300L)).publishPercentiles(options.getPercentiles()).publishPercentileHistogram(Boolean.valueOf(options.isHistogramPublishingEnabled())).tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(this.tags, options)).register(this.registry);
                }
                requestRecord.stop(requests, requestRecord.isCompletedExceptionally() ? requestsFailed : requestsSuccess);
                options = this.client.getMeterOptions(CosmosMetricName.DIRECT_REQUEST_SIZE_REQUEST);
                if (options.isEnabled()) {
                    DistributionSummary requestSize = DistributionSummary.builder((String)options.getMeterName().toString()).description("RNTBD request size (bytes)").baseUnit("bytes").tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(this.tags, options)).maximumExpectedValue(Double.valueOf(1.6E7)).publishPercentileHistogram(Boolean.valueOf(false)).publishPercentiles(new double[0]).register(this.registry);
                    requestSize.record((double)requestRecord.requestLength());
                }
                if ((options = this.client.getMeterOptions(CosmosMetricName.DIRECT_REQUEST_SIZE_RESPONSE)).isEnabled()) {
                    DistributionSummary responseSize = DistributionSummary.builder((String)options.getMeterName().toString()).description("RNTBD response size (bytes)").baseUnit("bytes").tags((Iterable)ClientTelemetryMetrics.getEffectiveTags(this.tags, options)).maximumExpectedValue(Double.valueOf(1.6E7)).publishPercentileHistogram(Boolean.valueOf(false)).publishPercentiles(new double[0]).register(this.registry);
                    responseSize.record((double)requestRecord.responseLength());
                }
            } else {
                requestRecord.stop();
            }
        }
    }
}

