/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncStoredProcedure;
import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.models.CosmosStoredProcedureProperties;
import com.azure.cosmos.models.CosmosStoredProcedureRequestOptions;
import com.azure.cosmos.models.CosmosStoredProcedureResponse;
import java.util.List;

public class CosmosStoredProcedure {
    private final String id;
    private final CosmosContainer container;
    private final CosmosAsyncStoredProcedure storedProcedure;

    public CosmosStoredProcedure(String id, CosmosContainer container, CosmosAsyncStoredProcedure storedProcedure) {
        this.id = id;
        this.container = container;
        this.storedProcedure = storedProcedure;
    }

    public String getId() {
        return this.id;
    }

    public CosmosStoredProcedureResponse read() {
        return this.container.getScripts().blockStoredProcedureResponse(this.storedProcedure.read());
    }

    public CosmosStoredProcedureResponse read(CosmosStoredProcedureRequestOptions options) {
        return this.container.getScripts().blockStoredProcedureResponse(this.storedProcedure.read(options));
    }

    public CosmosStoredProcedureResponse delete() {
        return this.container.getScripts().blockStoredProcedureResponse(this.storedProcedure.delete());
    }

    CosmosStoredProcedureResponse delete(CosmosStoredProcedureRequestOptions options) {
        return this.container.getScripts().blockStoredProcedureResponse(this.storedProcedure.delete(options));
    }

    public CosmosStoredProcedureResponse execute(List<Object> procedureParams, CosmosStoredProcedureRequestOptions options) {
        return this.container.getScripts().blockStoredProcedureResponse(this.storedProcedure.execute(procedureParams, options));
    }

    public CosmosStoredProcedureResponse replace(CosmosStoredProcedureProperties storedProcedureProperties) {
        return this.container.getScripts().blockStoredProcedureResponse(this.storedProcedure.replace(storedProcedureProperties));
    }

    public CosmosStoredProcedureResponse replace(CosmosStoredProcedureProperties storedProcedureProperties, CosmosStoredProcedureRequestOptions options) {
        return this.container.getScripts().blockStoredProcedureResponse(this.storedProcedure.replace(storedProcedureProperties, options));
    }
}

