/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.feedranges;

import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.GoneException;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.RxDocumentClientImpl;
import com.azure.cosmos.implementation.ShouldRetryResult;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.caches.RxPartitionKeyRangeCache;
import com.azure.cosmos.implementation.feedranges.FeedRangeContinuation;
import com.azure.cosmos.implementation.feedranges.FeedRangeEpkImpl;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.query.CompositeContinuationToken;
import com.azure.cosmos.implementation.routing.Range;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

final class FeedRangeCompositeContinuationImpl
extends FeedRangeContinuation {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeedRangeCompositeContinuationImpl.class);
    private final Queue<CompositeContinuationToken> compositeContinuationTokens;
    private CompositeContinuationToken currentToken;
    private String initialNoResultsRange;
    private final AtomicLong continuousNotModifiedSinceInitialNoResultsRangeCaptured = new AtomicLong(0L);

    public FeedRangeCompositeContinuationImpl(String containerRid, FeedRangeInternal feedRange, List<Range<String>> ranges, String continuation) {
        this(containerRid, feedRange);
        Preconditions.checkNotNull(ranges, "'ranges' must not be null");
        if (ranges.size() == 0) {
            throw new IllegalArgumentException("'ranges' must not be empty");
        }
        for (Range<String> range : ranges) {
            this.compositeContinuationTokens.add(FeedRangeCompositeContinuationImpl.createCompositeContinuationTokenForRange(range.getMin(), range.getMax(), continuation));
        }
        this.currentToken = this.getCompositeContinuationTokens().peek();
    }

    public FeedRangeCompositeContinuationImpl(String containerRid, FeedRangeInternal feedRange, List<CompositeContinuationToken> continuationTokens) {
        this(containerRid, feedRange);
        Preconditions.checkNotNull(continuationTokens, "'continuationTokens' must not be null");
        if (continuationTokens.size() == 0) {
            throw new IllegalArgumentException("'continuationTokens' must not be empty");
        }
        for (CompositeContinuationToken continuationToken : continuationTokens) {
            this.compositeContinuationTokens.add(FeedRangeCompositeContinuationImpl.createCompositeContinuationTokenForRange(continuationToken.getRange().getMin(), continuationToken.getRange().getMax(), continuationToken.getToken()));
        }
        this.currentToken = this.getCompositeContinuationTokens().peek();
    }

    @Override
    public void populatePropertyBag() {
        super.populatePropertyBag();
        this.set("V", 1, CosmosItemSerializer.DEFAULT_SERIALIZER);
        this.set("Rid", this.getContainerRid(), CosmosItemSerializer.DEFAULT_SERIALIZER);
        if (this.compositeContinuationTokens.size() > 0) {
            for (CompositeContinuationToken token : this.compositeContinuationTokens) {
                ModelBridgeInternal.populatePropertyBag(token);
            }
            this.set("Continuation", this.compositeContinuationTokens, CosmosItemSerializer.DEFAULT_SERIALIZER);
        }
        if (this.feedRange != null) {
            this.feedRange.setProperties(this, true);
        }
    }

    private FeedRangeCompositeContinuationImpl(String containerRid, FeedRangeInternal feedRange) {
        super(containerRid, feedRange);
        this.compositeContinuationTokens = new LinkedList<CompositeContinuationToken>();
    }

    @Override
    public Queue<CompositeContinuationToken> getCompositeContinuationTokens() {
        return this.compositeContinuationTokens;
    }

    public CompositeContinuationToken getCurrentToken() {
        return this.currentToken;
    }

    @Override
    public FeedRangeInternal getFeedRange() {
        if (!(this.feedRange instanceof FeedRangeEpkImpl)) {
            return this.feedRange;
        }
        if (this.currentToken != null) {
            return new FeedRangeEpkImpl(this.currentToken.getRange());
        }
        return null;
    }

    @Override
    public CompositeContinuationToken getCurrentContinuationToken() {
        CompositeContinuationToken tokenSnapshot = this.currentToken;
        if (tokenSnapshot == null) {
            return null;
        }
        return tokenSnapshot;
    }

    @Override
    public CompositeContinuationToken[] getCurrentContinuationTokens() {
        CompositeContinuationToken[] snapshot = new CompositeContinuationToken[this.compositeContinuationTokens.size()];
        this.compositeContinuationTokens.toArray(snapshot);
        return snapshot;
    }

    @Override
    public int getContinuationTokenCount() {
        return this.compositeContinuationTokens.size();
    }

    @Override
    public void replaceContinuation(String continuationToken, boolean shouldMoveToNextTokenOnETagReplace) {
        CompositeContinuationToken continuationTokenSnapshot = this.currentToken;
        if (continuationTokenSnapshot == null) {
            return;
        }
        continuationTokenSnapshot.setToken(continuationToken);
        if (shouldMoveToNextTokenOnETagReplace) {
            this.moveToNextToken();
        }
    }

    @Override
    public boolean isDone() {
        return this.compositeContinuationTokens.size() == 0;
    }

    @Override
    public void validateContainer(String containerRid) throws IllegalArgumentException {
        if (Strings.isNullOrEmpty(containerRid) || !containerRid.equals(this.getContainerRid())) {
            String message = String.format("The continuation was generated for container %s but current container is %s.", this.getContainerRid(), containerRid);
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public <T> ShouldRetryResult handleChangeFeedNotModified(FeedResponse<T> response) {
        Preconditions.checkNotNull(response, "Argument 'response' must not be null");
        if (!ModelBridgeInternal.noChanges(response)) {
            this.initialNoResultsRange = null;
            this.continuousNotModifiedSinceInitialNoResultsRangeCaptured.set(0L);
        } else if (this.compositeContinuationTokens.size() > 1) {
            if (this.initialNoResultsRange == null) {
                this.initialNoResultsRange = this.currentToken.getRange().getMin();
                this.continuousNotModifiedSinceInitialNoResultsRangeCaptured.set(0L);
                this.moveToNextToken();
                return ShouldRetryResult.RETRY_NOW;
            }
            if (!this.initialNoResultsRange.equalsIgnoreCase(this.currentToken.getRange().getMin())) {
                this.continuousNotModifiedSinceInitialNoResultsRangeCaptured.incrementAndGet();
                this.moveToNextToken();
                long consecutiveNotModifiedResponsesSnapshot = this.continuousNotModifiedSinceInitialNoResultsRangeCaptured.get();
                if (consecutiveNotModifiedResponsesSnapshot > 4L * (long)(this.compositeContinuationTokens.size() + 1)) {
                    LOGGER.warn("Preempting change feed query early due to {} consecutive 304.", (Object)consecutiveNotModifiedResponsesSnapshot);
                    return ShouldRetryResult.NO_RETRY;
                }
                return ShouldRetryResult.RETRY_NOW;
            }
        }
        return ShouldRetryResult.NO_RETRY;
    }

    @Override
    public Mono<ShouldRetryResult> handleFeedRangeGone(RxDocumentClientImpl client, GoneException goneException) {
        boolean partitionSplitOrMerge;
        Preconditions.checkNotNull(client, "Argument 'client' must not be null");
        Preconditions.checkNotNull(goneException, "Argument 'goeException' must not be null");
        Integer nSubStatus = goneException.getSubStatusCode();
        boolean bl = partitionSplitOrMerge = goneException.getStatusCode() == 410 && nSubStatus != null && (nSubStatus == 1002 || nSubStatus == 1007);
        if (!partitionSplitOrMerge) {
            return Mono.just((Object)ShouldRetryResult.NO_RETRY);
        }
        RxPartitionKeyRangeCache partitionKeyRangeCache = client.getPartitionKeyRangeCache();
        Range<String> effectiveTokenRange = this.currentToken.getRange();
        Mono<Utils.ValueHolder<List<PartitionKeyRange>>> resolvedRangesTask = this.tryGetOverlappingRanges(partitionKeyRangeCache, effectiveTokenRange, true);
        return resolvedRangesTask.flatMap(resolvedRanges -> {
            if (resolvedRanges.v != null) {
                if (((List)resolvedRanges.v).size() == 1) {
                    LOGGER.debug("ChangeFeedFetcher detected feed range gone due to merge for range [{}]", (Object)effectiveTokenRange);
                } else {
                    this.createChildRanges((List)resolvedRanges.v, effectiveTokenRange);
                    LOGGER.debug("ChangeFeedFetcher detected feed range gone due to split for range [{}]", (Object)effectiveTokenRange);
                }
            }
            return Mono.just((Object)ShouldRetryResult.RETRY_NOW);
        });
    }

    public static FeedRangeCompositeContinuationImpl createFromDeserializedTokens(String containerRid, FeedRangeInternal feedRange, List<CompositeContinuationToken> deserializedTokens) {
        FeedRangeCompositeContinuationImpl thisPtr = new FeedRangeCompositeContinuationImpl(containerRid, feedRange);
        Preconditions.checkNotNull(deserializedTokens, "'deserializedTokens' must not be null");
        if (deserializedTokens.size() == 0) {
            throw new IllegalArgumentException("'deserializedTokens' must not be empty");
        }
        thisPtr.compositeContinuationTokens.addAll(deserializedTokens);
        thisPtr.currentToken = thisPtr.getCompositeContinuationTokens().peek();
        return thisPtr;
    }

    public static FeedRangeContinuation parse(String jsonString) throws IOException {
        Preconditions.checkNotNull(jsonString, "Argument 'jsonString' must not be null");
        ObjectMapper mapper = Utils.getSimpleObjectMapper();
        return (FeedRangeContinuation)mapper.readValue(jsonString, FeedRangeContinuation.class);
    }

    @Override
    public String toString() {
        try {
            return Utils.getSimpleObjectMapper().writeValueAsString((Object)this);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable serialize the composite FeedRange continuation token into a JSON string", e);
        }
    }

    private static String getMinString(String left, String right) {
        Preconditions.checkNotNull(left, "Argument 'left' must not be null.");
        Preconditions.checkNotNull(right, "Argument 'right' must not be null.");
        if (left.compareTo(right) < 0) {
            return left;
        }
        return right;
    }

    private static String getMaxString(String left, String right) {
        Preconditions.checkNotNull(left, "Argument 'left' must not be null.");
        Preconditions.checkNotNull(right, "Argument 'right' must not be null.");
        if (left.compareTo(right) > 0) {
            return left;
        }
        return right;
    }

    private void createChildRanges(List<PartitionKeyRange> keyRanges, Range<String> effectiveTokenRange) {
        keyRanges.sort(PartitionKeyRangeMinInclusiveComparator.SingletonInstance);
        PartitionKeyRange firstRange = keyRanges.get(0);
        this.currentToken.setRange(new Range<String>(FeedRangeCompositeContinuationImpl.getMaxString(effectiveTokenRange.getMin(), firstRange.getMinInclusive()), FeedRangeCompositeContinuationImpl.getMinString(effectiveTokenRange.getMax(), firstRange.getMaxExclusive()), true, false));
        CompositeContinuationToken continuationAsComposite = FeedRangeCompositeContinuationImpl.tryParseAsCompositeContinuationToken(this.currentToken.getToken());
        if (continuationAsComposite != null) {
            continuationAsComposite.setRange(this.currentToken.getRange());
            this.currentToken.setToken(continuationAsComposite.toJson());
            int size = keyRanges.size();
            for (int i = 1; i < size; ++i) {
                PartitionKeyRange keyRange = keyRanges.get(i);
                Range<String> newRange = new Range<String>(FeedRangeCompositeContinuationImpl.getMaxString(effectiveTokenRange.getMin(), keyRange.getMinInclusive()), FeedRangeCompositeContinuationImpl.getMinString(effectiveTokenRange.getMax(), keyRange.getMaxExclusive()), true, false);
                continuationAsComposite.setRange(newRange);
                this.compositeContinuationTokens.add(FeedRangeCompositeContinuationImpl.createCompositeContinuationTokenForRange(newRange.getMin(), newRange.getMax(), continuationAsComposite.toJson()));
            }
        } else {
            int size = keyRanges.size();
            for (int i = 1; i < size; ++i) {
                PartitionKeyRange keyRange = keyRanges.get(i);
                Range<String> newRange = new Range<String>(FeedRangeCompositeContinuationImpl.getMaxString(effectiveTokenRange.getMin(), keyRange.getMinInclusive()), FeedRangeCompositeContinuationImpl.getMinString(effectiveTokenRange.getMax(), keyRange.getMaxExclusive()), true, false);
                this.compositeContinuationTokens.add(FeedRangeCompositeContinuationImpl.createCompositeContinuationTokenForRange(newRange.getMin(), newRange.getMax(), this.currentToken.getToken()));
            }
        }
    }

    private static CompositeContinuationToken createCompositeContinuationTokenForRange(String minInclusive, String maxExclusive, String token) {
        return new CompositeContinuationToken(token, new Range<String>(minInclusive, maxExclusive, true, false));
    }

    private void moveToNextToken() {
        CompositeContinuationToken recentToken = this.compositeContinuationTokens.poll();
        this.compositeContinuationTokens.add(recentToken);
        this.currentToken = this.compositeContinuationTokens.size() > 0 ? this.compositeContinuationTokens.peek() : null;
    }

    private Mono<Utils.ValueHolder<List<PartitionKeyRange>>> tryGetOverlappingRanges(RxPartitionKeyRangeCache partitionKeyRangeCache, Range<String> effectiveRange, Boolean forceRefresh) {
        return partitionKeyRangeCache.tryGetOverlappingRangesAsync(null, this.getContainerRid(), effectiveRange, forceRefresh, null);
    }

    private static CompositeContinuationToken tryParseAsCompositeContinuationToken(String providedContinuation) {
        try {
            ObjectMapper mapper = Utils.getSimpleObjectMapper();
            if (providedContinuation == null) {
                return null;
            }
            if (providedContinuation.trim().startsWith("[")) {
                List<CompositeContinuationToken> compositeContinuationTokens = Arrays.asList((CompositeContinuationToken[])mapper.readValue(providedContinuation, CompositeContinuationToken[].class));
                if (compositeContinuationTokens.size() > 0) {
                    return compositeContinuationTokens.get(0);
                }
                return null;
            }
            if (providedContinuation.trim().startsWith("{")) {
                return (CompositeContinuationToken)mapper.readValue(providedContinuation, CompositeContinuationToken.class);
            }
            return null;
        }
        catch (IOException ioError) {
            LOGGER.debug("Failed to parse as composite continuation token JSON {}", (Object)providedContinuation, (Object)ioError);
            return null;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof FeedRangeCompositeContinuationImpl)) {
            return false;
        }
        FeedRangeCompositeContinuationImpl other = (FeedRangeCompositeContinuationImpl)o;
        return Objects.equals(this.feedRange, other.feedRange) && Objects.equals(this.getContainerRid(), other.getContainerRid()) && Objects.equals(this.initialNoResultsRange, other.initialNoResultsRange) && Objects.equals(this.currentToken, other.currentToken) && Objects.equals(this.compositeContinuationTokens, other.compositeContinuationTokens);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.feedRange, this.getContainerRid(), this.initialNoResultsRange, this.currentToken, this.compositeContinuationTokens);
    }

    static class PartitionKeyRangeMinInclusiveComparator
    implements Comparator<PartitionKeyRange>,
    Serializable {
        private static final long serialVersionUID = 1L;
        static final Comparator<PartitionKeyRange> SingletonInstance = new PartitionKeyRangeMinInclusiveComparator();

        private PartitionKeyRangeMinInclusiveComparator() {
        }

        @Override
        public int compare(PartitionKeyRange o1, PartitionKeyRange o2) {
            return o1.getMinInclusive().compareTo(o2.getMinInclusive());
        }
    }
}

