/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.DataType;
import com.azure.cosmos.implementation.Index;
import com.azure.cosmos.implementation.IndexKind;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.fasterxml.jackson.databind.node.ObjectNode;

public final class HashIndex
extends Index {
    HashIndex(DataType dataType) {
        super(IndexKind.HASH);
        this.setDataType(dataType);
    }

    HashIndex(DataType dataType, int precision) {
        super(IndexKind.HASH);
        this.setDataType(dataType);
        this.setPrecision(precision);
    }

    public HashIndex(String jsonString) {
        super(jsonString, IndexKind.HASH);
        if (this.getDataType() == null) {
            throw new IllegalArgumentException("The jsonString doesn't contain a valid 'dataType'.");
        }
    }

    HashIndex(ObjectNode objectNode) {
        super(objectNode, IndexKind.HASH);
        if (this.getDataType() == null) {
            throw new IllegalArgumentException("The jsonString doesn't contain a valid 'dataType'.");
        }
    }

    public DataType getDataType() {
        DataType result = null;
        try {
            result = DataType.valueOf(StringUtils.upperCase(super.getString("dataType")));
        }
        catch (IllegalArgumentException e) {
            super.getLogger().warn("INVALID index dataType value {}.", (Object)super.getString("dataType"));
        }
        return result;
    }

    public HashIndex setDataType(DataType dataType) {
        super.set("dataType", dataType.toString(), CosmosItemSerializer.DEFAULT_SERIALIZER);
        return this;
    }

    public int getPrecision() {
        return super.getInt("precision");
    }

    public HashIndex setPrecision(int precision) {
        super.set("precision", precision, CosmosItemSerializer.DEFAULT_SERIALIZER);
        return this;
    }

    boolean hasPrecision() {
        return super.has("precision");
    }
}

