/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.feedranges;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.IRoutingMapProvider;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.MetadataDiagnosticsContext;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.collections.list.UnmodifiableList;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.implementation.routing.Range;
import com.azure.cosmos.models.PartitionKeyDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import reactor.core.publisher.Mono;

public final class FeedRangePartitionKeyImpl
extends FeedRangeInternal {
    private final PartitionKeyInternal partitionKey;

    public FeedRangePartitionKeyImpl(PartitionKeyInternal partitionKey) {
        Preconditions.checkNotNull(partitionKey, "Argument 'partitionKey' must not be null");
        this.partitionKey = partitionKey;
    }

    public PartitionKeyInternal getPartitionKeyInternal() {
        return this.partitionKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeedRangePartitionKeyImpl that = (FeedRangePartitionKeyImpl)o;
        return Objects.equals(this.partitionKey, that.partitionKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.partitionKey);
    }

    @Override
    public Mono<Range<String>> getEffectiveRange(IRoutingMapProvider routingMapProvider, MetadataDiagnosticsContext metadataDiagnosticsCtx, Mono<Utils.ValueHolder<DocumentCollection>> collectionResolutionMono) {
        Preconditions.checkNotNull(collectionResolutionMono, "Argument 'collectionResolutionMono' must not be null");
        return collectionResolutionMono.flatMap(documentCollectionResourceResponse -> {
            DocumentCollection collection = (DocumentCollection)documentCollectionResourceResponse.v;
            if (collection == null) {
                throw new IllegalStateException("Collection cannot be null");
            }
            Range<String> range = this.getEffectiveRange(collection.getPartitionKey());
            return Mono.just(range);
        });
    }

    public Range<String> getEffectiveRange(PartitionKeyDefinition pkDefinition) {
        Preconditions.checkNotNull(pkDefinition, "Argument 'pkDefinition' must not be null");
        String effectivePartitionKey = this.partitionKey.getEffectivePartitionKeyString(this.partitionKey, pkDefinition);
        return Range.getPointRange(effectivePartitionKey);
    }

    @Override
    public Mono<List<String>> getPartitionKeyRanges(IRoutingMapProvider routingMapProvider, RxDocumentServiceRequest request, Mono<Utils.ValueHolder<DocumentCollection>> collectionResolutionMono) {
        Preconditions.checkNotNull(routingMapProvider, "Argument 'routingMapProvider' must not be null");
        Preconditions.checkNotNull(request, "Argument 'request' must not be null");
        Preconditions.checkNotNull(collectionResolutionMono, "Argument 'collectionResolutionMono' must not be null");
        MetadataDiagnosticsContext metadataDiagnosticsCtx = BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics);
        return collectionResolutionMono.flatMap(documentCollectionResourceResponse -> {
            DocumentCollection collection = (DocumentCollection)documentCollectionResourceResponse.v;
            if (collection == null) {
                throw new IllegalStateException("Collection cannot be null");
            }
            String containerRid = collection.getResourceId();
            String effectivePartitionKey = this.partitionKey.getEffectivePartitionKeyString(this.partitionKey, collection.getPartitionKey());
            return routingMapProvider.tryGetOverlappingRangesAsync(metadataDiagnosticsCtx, containerRid, Range.getPointRange(effectivePartitionKey), false, null).flatMap(pkRangeHolder -> {
                ArrayList<String> rangeList = new ArrayList<String>(1);
                if (pkRangeHolder.v != null) {
                    String rangeId = ((PartitionKeyRange)((List)pkRangeHolder.v).get(0)).getId();
                    rangeList.add(rangeId);
                }
                return Mono.just((Object)((UnmodifiableList)UnmodifiableList.unmodifiableList(rangeList)));
            });
        });
    }

    @Override
    public Mono<RxDocumentServiceRequest> populateFeedRangeFilteringHeaders(IRoutingMapProvider routingMapProvider, RxDocumentServiceRequest request, Mono<Utils.ValueHolder<DocumentCollection>> collectionResolutionMono) {
        Preconditions.checkNotNull(request, "Argument 'request' must not be null");
        request.getHeaders().put("x-ms-documentdb-partitionkey", this.partitionKey.toJson());
        request.setPartitionKeyInternal(this.partitionKey);
        MetadataDiagnosticsContext metadataDiagnosticsCtx = BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics);
        return this.getNormalizedEffectiveRange(routingMapProvider, metadataDiagnosticsCtx, collectionResolutionMono).map(effectiveRange -> {
            request.setEffectiveRange((Range<String>)effectiveRange);
            request.setHasFeedRangeFilteringBeenApplied(true);
            return request;
        });
    }

    @Override
    public void populatePropertyBag() {
        super.populatePropertyBag();
        this.setProperties(this, false);
    }

    @Override
    public void removeProperties(JsonSerializable serializable) {
        Preconditions.checkNotNull(serializable, "Argument 'serializable' must not be null.");
        serializable.remove("PK");
    }

    @Override
    public void setProperties(JsonSerializable serializable, boolean populateProperties) {
        Preconditions.checkNotNull(serializable, "Argument 'serializable' must not be null.");
        if (populateProperties) {
            super.populatePropertyBag();
        }
        if (this.partitionKey != null) {
            serializable.set("PK", this.partitionKey, CosmosItemSerializer.DEFAULT_SERIALIZER);
        }
    }
}

