/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.SessionRetryOptions;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.ConnectionPolicy;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.GlobalEndpointManager;
import com.azure.cosmos.implementation.IAuthorizationTokenProvider;
import com.azure.cosmos.implementation.ISessionContainer;
import com.azure.cosmos.implementation.UserAgentContainer;
import com.azure.cosmos.implementation.clienttelemetry.ClientTelemetry;
import com.azure.cosmos.implementation.directconnectivity.GatewayServiceConfigurationReader;
import com.azure.cosmos.implementation.directconnectivity.HttpTransportClient;
import com.azure.cosmos.implementation.directconnectivity.IAddressResolver;
import com.azure.cosmos.implementation.directconnectivity.Protocol;
import com.azure.cosmos.implementation.directconnectivity.RntbdTransportClient;
import com.azure.cosmos.implementation.directconnectivity.SharedTransportClient;
import com.azure.cosmos.implementation.directconnectivity.StoreClient;
import com.azure.cosmos.implementation.directconnectivity.TransportClient;

public class StoreClientFactory
implements AutoCloseable {
    private final Configs configs;
    private final TransportClient transportClient;
    private volatile boolean isClosed;

    public StoreClientFactory(IAddressResolver addressResolver, DiagnosticsClientContext.DiagnosticsClientConfig diagnosticsClientConfig, Configs configs, ConnectionPolicy connectionPolicy, UserAgentContainer userAgent, boolean enableTransportClientSharing, ClientTelemetry clientTelemetry, GlobalEndpointManager globalEndpointManager) {
        this.configs = configs;
        Protocol protocol = configs.getProtocol();
        if (enableTransportClientSharing) {
            this.transportClient = SharedTransportClient.getOrCreateInstance(protocol, configs, connectionPolicy, userAgent, diagnosticsClientConfig, addressResolver, clientTelemetry, globalEndpointManager);
        } else if (protocol == Protocol.HTTPS) {
            this.transportClient = new HttpTransportClient(configs, connectionPolicy, userAgent, globalEndpointManager);
        } else if (protocol == Protocol.TCP) {
            RntbdTransportClient.Options rntbdOptions = new RntbdTransportClient.Options.Builder(connectionPolicy).userAgent(userAgent).build();
            this.transportClient = new RntbdTransportClient(rntbdOptions, configs.getSslContext(connectionPolicy.isServerCertValidationDisabled()), addressResolver, clientTelemetry, globalEndpointManager);
            diagnosticsClientConfig.withRntbdOptions(rntbdOptions.toDiagnosticsString());
        } else {
            throw new IllegalArgumentException(String.format("protocol: %s", new Object[]{protocol}));
        }
    }

    @Override
    public void close() throws Exception {
        this.transportClient.close();
        this.isClosed = true;
    }

    public StoreClient createStoreClient(DiagnosticsClientContext diagnosticsClientContext, IAddressResolver addressResolver, ISessionContainer sessionContainer, GatewayServiceConfigurationReader serviceConfigurationReader, IAuthorizationTokenProvider authorizationTokenProvider, boolean useMultipleWriteLocations, SessionRetryOptions sessionRetryOptions) {
        this.throwIfClosed();
        return new StoreClient(diagnosticsClientContext, this.configs, addressResolver, sessionContainer, serviceConfigurationReader, authorizationTokenProvider, this.transportClient, useMultipleWriteLocations, sessionRetryOptions);
    }

    private void throwIfClosed() {
        if (this.isClosed) {
            throw new IllegalStateException("storeClient already closed!");
        }
    }
}

